/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.awt.Window;
import java.lang.reflect.Method;
import javax.swing.JFrame;
import net.runelite.client.util.OSType;
import net.runelite.client.util.OSXFullScreenAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSXUtil {
    private static final Logger log = LoggerFactory.getLogger(OSXUtil.class);

    public static void tryEnableFullscreen(JFrame gui) {
        if (OSType.getOSType() == OSType.MacOS) {
            try {
                Class<?> fullScreenUtilitiesClass = Class.forName("com.apple.eawt.FullScreenUtilities");
                Method setWindowCanFullScreen = fullScreenUtilitiesClass.getMethod("setWindowCanFullScreen", Window.class, Boolean.TYPE);
                OSXFullScreenAdapter.install(gui);
                setWindowCanFullScreen.invoke(null, gui, true);
                log.debug("Enabled fullscreen on macOS");
            }
            catch (ClassNotFoundException e) {
                log.debug("FullScreenUtilities not available (not running on Apple JDK)");
            }
            catch (Exception e) {
                log.warn("Failed to enable macOS fullscreen", e);
            }
        }
    }

    public static void requestUserAttention() {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Method getApplication = applicationClass.getMethod("getApplication", new Class[0]);
            Object app = getApplication.invoke(null, new Object[0]);
            Method requestUserAttention = applicationClass.getMethod("requestUserAttention", Boolean.TYPE);
            requestUserAttention.invoke(app, true);
            log.debug("Requested user attention on macOS");
        }
        catch (ClassNotFoundException e) {
            log.debug("Apple Application class not available");
        }
        catch (Exception e) {
            log.warn("Failed to request user attention on macOS", e);
        }
    }

    public static void requestForeground() {
        try {
            Class<?> applicationClass = Class.forName("com.apple.eawt.Application");
            Method getApplication = applicationClass.getMethod("getApplication", new Class[0]);
            Object app = getApplication.invoke(null, new Object[0]);
            Method requestForeground = applicationClass.getMethod("requestForeground", Boolean.TYPE);
            requestForeground.invoke(app, true);
            log.debug("Forced focus on macOS");
        }
        catch (ClassNotFoundException e) {
            log.debug("Apple Application class not available");
        }
        catch (Exception e) {
            log.warn("Failed to request foreground on macOS", e);
        }
    }
}

