/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.util;

import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OSXFullScreenAdapter
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(OSXFullScreenAdapter.class);
    private final Frame frame;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if ("windowEnteredFullScreen".equals(methodName)) {
            log.debug("Window entered fullscreen mode--setting extended state to {}", (Object)6);
            this.frame.setExtendedState(6);
        } else if ("windowExitedFullScreen".equals(methodName)) {
            log.debug("Window exited fullscreen mode--setting extended state to {}", (Object)0);
            this.frame.setExtendedState(0);
        }
        return null;
    }

    public static void install(Frame frame) {
        try {
            Class<?> fullScreenListenerClass = Class.forName("com.apple.eawt.FullScreenListener");
            Class<?> fullScreenUtilitiesClass = Class.forName("com.apple.eawt.FullScreenUtilities");
            Object listenerProxy = Proxy.newProxyInstance(fullScreenListenerClass.getClassLoader(), new Class[]{fullScreenListenerClass}, (InvocationHandler)new OSXFullScreenAdapter(frame));
            Method addListenerMethod = fullScreenUtilitiesClass.getMethod("addFullScreenListenerTo", Window.class, fullScreenListenerClass);
            addListenerMethod.invoke(null, frame, listenerProxy);
            log.debug("Installed OSX fullscreen adapter");
        }
        catch (ClassNotFoundException e) {
            log.debug("Apple fullscreen classes not available (not running on Apple JDK)");
        }
        catch (Exception e) {
            log.warn("Failed to install OSX fullscreen adapter", e);
        }
    }

    public OSXFullScreenAdapter(Frame frame) {
        this.frame = frame;
    }
}

