/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.rs;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Supplier;
import net.runelite.client.game.WorldClient;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldResult;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorldSupplier
implements Supplier<World> {
    private static final Logger log = LoggerFactory.getLogger(WorldSupplier.class);
    private final Queue<World> worlds = new ArrayDeque<World>();
    private final WorldClient worldClient;

    WorldSupplier(OkHttpClient okHttpClient, HttpUrl apiBase) {
        this.worldClient = new WorldClient(okHttpClient, apiBase);
    }

    @Override
    public World get() {
        if (!this.worlds.isEmpty()) {
            return this.worlds.poll();
        }
        try {
            WorldResult result = this.worldClient.lookupWorlds();
            if (result != null && result.getWorlds() != null) {
                this.worlds.addAll(result.getWorlds());
            }
        }
        catch (IOException e) {
            log.warn("Error looking up worlds", e);
        }
        return this.worlds.poll();
    }
}

