/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.utils.buffer;

import java.nio.FloatBuffer;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import org.lwjgl.system.MemoryUtil;

public class GpuFloatBuffer {
    private FloatBuffer buffer;

    public GpuFloatBuffer() {
        this(65536);
    }

    public GpuFloatBuffer(int initialCapacity) {
        try {
            this.buffer = MemoryUtil.memAllocFloat(initialCapacity);
        }
        catch (OutOfMemoryError oom) {
            System.gc();
            this.buffer = MemoryUtil.memAllocFloat(initialCapacity);
        }
    }

    public void destroy() {
        if (this.buffer != null) {
            MemoryUtil.memFree(this.buffer);
        }
        this.buffer = null;
    }

    protected void finalize() {
        this.destroy();
    }

    public void put(float x, float y, float z, float w) {
        this.buffer.put(x).put(y).put(z).put(w);
    }

    public void put(float[] floats) {
        this.buffer.put(floats);
    }

    public void put(FloatBuffer buffer) {
        this.buffer.put(buffer);
    }

    public int position() {
        return this.buffer.position();
    }

    public void flip() {
        this.buffer.flip();
    }

    public GpuFloatBuffer clear() {
        this.buffer.clear();
        return this;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public void ensureCapacity(int size) {
        int position;
        int capacity = this.buffer.capacity();
        if (capacity - (position = this.buffer.position()) < size) {
            while ((capacity = (int)((float)capacity * HdPlugin.BUFFER_GROWTH_MULTIPLIER)) - position < size) {
            }
            FloatBuffer newB = MemoryUtil.memAllocFloat(capacity);
            this.buffer.flip();
            newB.put(this.buffer);
            MemoryUtil.memFree(this.buffer);
            this.buffer = newB;
        }
    }

    public FloatBuffer getBuffer() {
        return this.buffer;
    }
}

