/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.utils;

import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.DynamicObject;
import net.runelite.api.GraphicsObject;
import net.runelite.api.IndexedObjectSet;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Projectile;
import net.runelite.api.Renderable;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;

public class ModelHash {
    public static final int TYPE_PLAYER = 0;
    public static final int TYPE_NPC = 1;
    public static final int TYPE_OBJECT = 2;
    public static final int TYPE_GROUND_ITEM = 3;
    public static final int TYPE_PROJECTILE = 4;
    public static final int TYPE_GRAPHICS_OBJECT = 5;
    public static final int TYPE_UNKNOWN = 15;
    public static final int TYPE_WALL_OBJECT = 18;
    public static final int TYPE_GROUND_OBJECT = 34;
    public static final int TYPE_DECORATIVE_OBJECT = 50;
    public static final int TYPE_GAME_OBJECT = 66;
    public static final int UNKNOWN_ID = 0xFFFFFF;
    private static final String[] TYPE_NAMES = new String[]{"Player", "NPC", "Game Object", "Ground item", "Projectile", "Graphics object", "Unknown"};
    private static final String[] TYPE_NAMES_SHORT = new String[]{"PLR", "NPC", "OBJ", "ITM", "PRJ", "GFX", "N/A"};

    public static String getTypeName(int type) {
        return TYPE_NAMES[HDUtils.clamp(type, 0, TYPE_NAMES.length - 1)];
    }

    public static String getTypeNameShort(int type) {
        return TYPE_NAMES_SHORT[HDUtils.clamp(type, 0, TYPE_NAMES_SHORT.length - 1)];
    }

    public static int getSceneX(long hash) {
        return (int)(hash & 0x7FL);
    }

    public static int getSceneY(long hash) {
        return (int)(hash >> 7 & 0x7FL);
    }

    public static int getPlane(long hash) {
        return (int)(hash >> 60 & 3L);
    }

    public static int getType(long hash) {
        return (int)(hash >> 16 & 7L);
    }

    public static int getIdOrIndex(long hash) {
        return (int)(hash >> 20);
    }

    public static int generateUuid(Client client2, long hash, @Nullable Renderable renderable) {
        int type = 15;
        int id = 0xFFFFFF;
        if (hash == -1L) {
            if (renderable instanceof Projectile) {
                type = 4;
                id = ((Projectile)renderable).getId();
            } else if (renderable instanceof GraphicsObject) {
                type = 5;
                id = ((GraphicsObject)renderable).getId();
            }
        } else {
            type = ModelHash.getType(hash);
            id = ModelHash.getIdOrIndex(hash);
            if (renderable instanceof DynamicObject) {
                ObjectComposition impostor;
                ObjectComposition def = client2.getObjectDefinition(id);
                if (def.getImpostorIds() != null && (impostor = def.getImpostor()) != null) {
                    id = impostor.getId();
                }
            } else if (type == 1) {
                NPC npc;
                int index = id;
                id = 0xFFFFFF;
                IndexedObjectSet<? extends NPC> npcs = client2.getTopLevelWorldView().npcs();
                if (index >= 0 && index < 65536 && (npc = npcs.byIndex(index)) != null) {
                    id = npc.getId();
                }
            }
        }
        return ModelHash.packUuid(type, id);
    }

    public static int packUuid(int type, int id) {
        return type << 24 | id;
    }

    public static int getUuidType(int uuid) {
        return uuid >> 24 & 0xF;
    }

    public static int getUuidSubType(int uuid) {
        return uuid >> 24;
    }

    public static int getUuidWithoutSubType(int uuid) {
        return uuid & 0xFFFFFFF;
    }

    public static int getUuidId(int uuid) {
        return uuid & 0xFFFFFF;
    }
}

