/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.utils;

import java.text.DecimalFormat;
import java.util.Arrays;

public class Matrix {
    public static float[] copy(float[] m) {
        return Arrays.copyOf(m, m.length);
    }

    public static void solve(float[] m, int rows, int columns) {
        int square = Math.min(columns, rows);
        block0: for (int j = 0; j < square; ++j) {
            for (int i = j; i < rows; ++i) {
                int k;
                float f = m[j * rows + i];
                if (f == 0.0f) continue;
                if (i != j) {
                    for (k = 0; k < rows * columns; k += rows) {
                        float tmp = m[k + j];
                        m[k + j] = m[k + i];
                        m[k + i] = tmp;
                    }
                }
                f = 1.0f / f;
                for (k = 0; k < rows * columns; k += rows) {
                    int n = k + j;
                    m[n] = m[n] * f;
                }
                for (int r = 0; r < rows; ++r) {
                    float g;
                    if (r == j || (g = m[j * rows + r]) == 0.0f) continue;
                    for (int k2 = 0; k2 < rows * columns; k2 += rows) {
                        int n = k2 + r;
                        m[n] = m[n] + -g * m[k2 + j];
                    }
                }
                continue block0;
            }
            throw new IllegalArgumentException("Linear system does not have a solution");
        }
    }

    public static String format(float[] m, int rows, int columns) {
        String[] f = new String[m.length];
        DecimalFormat format = new DecimalFormat("0.##");
        int maxdigits = 0;
        int maxfractions = 0;
        for (int i = 0; i < rows * columns; ++i) {
            float v = m[i];
            if ((double)Math.abs(v) < 0.01) {
                v = 0.0f;
            }
            f[i] = format.format(v);
            int j = f[i].indexOf(46);
            if (j == -1) {
                maxdigits = Math.max(maxdigits, f[i].length());
                continue;
            }
            maxdigits = Math.max(maxdigits, j);
            maxfractions = Math.max(maxfractions, f[i].length() - j);
        }
        StringBuilder str = new StringBuilder();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                int padLeft;
                int idx = col * rows + row;
                int dot = f[idx].indexOf(46);
                if (dot == -1) {
                    padLeft = maxdigits - f[idx].length();
                    if (padLeft > 0) {
                        f[idx] = " ".repeat(padLeft) + f[idx];
                    }
                    int n = idx;
                    f[n] = f[n] + " ".repeat(maxfractions);
                } else {
                    int padRight;
                    padLeft = maxdigits - dot;
                    if (padLeft > 0) {
                        f[idx] = " ".repeat(padLeft) + f[idx];
                    }
                    if ((padRight = maxfractions - (f[idx].length() - dot)) > 0) {
                        int n = idx;
                        f[n] = f[n] + " ".repeat(padRight);
                    }
                }
                if (col == 0) {
                    str.append("[ ");
                }
                str.append(f[idx]).append(" ");
                if (col != columns - 1) continue;
                str.append("]");
                if (idx == m.length - 1) continue;
                str.append("\n");
            }
        }
        return str.toString();
    }
}

