/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonUtils {
    private static final Logger log = LoggerFactory.getLogger(GsonUtils.class);
    @VisibleForTesting
    public static boolean THROW_WHEN_PARSING_FAILS = false;

    public static String location(JsonReader in) {
        String str = in.toString();
        int i = str.indexOf(" at ");
        if (i != -1) {
            str = str.substring(i + 4);
        }
        return str;
    }

    public static HashSet<Integer> parseIDArray(JsonReader in) throws IOException {
        HashSet<Integer> ids = new HashSet<Integer>();
        in.beginArray();
        while (in.hasNext()) {
            if (in.peek() == JsonToken.NUMBER) {
                try {
                    ids.add(in.nextInt());
                }
                catch (NumberFormatException ex) {
                    String message = "Failed to parse int at " + GsonUtils.location(in);
                    if (THROW_WHEN_PARSING_FAILS) {
                        throw new RuntimeException(message, ex);
                    }
                    log.error(message, ex);
                }
                continue;
            }
            throw new RuntimeException("Unable to parse ID: " + in.peek() + " at " + GsonUtils.location(in));
        }
        in.endArray();
        return ids;
    }

    public static void writeIDArray(JsonWriter out, HashSet<Integer> listToWrite) throws IOException {
        if (listToWrite.isEmpty()) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (int id : listToWrite) {
            out.value(id);
        }
        out.endArray();
    }

    public static class DegreesToRadians
    extends TypeAdapter<Object> {
        private static final Logger log = LoggerFactory.getLogger(DegreesToRadians.class);

        @Override
        public Object read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                return null;
            }
            if (token == JsonToken.NUMBER) {
                float angle = (float)in.nextDouble();
                return Float.valueOf((float)Math.toRadians(angle));
            }
            if (token == JsonToken.BEGIN_ARRAY) {
                ArrayList<Float> list = new ArrayList<Float>();
                in.beginArray();
                while (in.hasNext() && in.peek() != JsonToken.END_ARRAY) {
                    if (in.peek() == JsonToken.BEGIN_ARRAY) {
                        throw new IOException("Expected an array of numbers. Got nested arrays.");
                    }
                    list.add(Float.valueOf(((Float)this.read(in)).floatValue()));
                }
                in.endArray();
                float[] result = new float[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    result[i] = ((Float)list.get(i)).floatValue();
                }
                return result;
            }
            throw new IOException("Expected a number or array of numbers. Got " + token);
        }

        @Override
        public void write(JsonWriter out, Object src) throws IOException {
            if (src == null) {
                out.nullValue();
                return;
            }
            if (src instanceof float[]) {
                out.beginArray();
                for (float f : (float[])src) {
                    out.value(Math.toDegrees(f));
                }
                out.endArray();
                return;
            }
            if (src instanceof Float) {
                out.value(Math.toDegrees(((Float)src).floatValue()));
            }
            throw new IOException("Expected a float or float array. Got " + src);
        }
    }

    public static class IntegerSetAdapter
    extends TypeAdapter<HashSet<Integer>> {
        @Override
        public HashSet<Integer> read(JsonReader in) throws IOException {
            return GsonUtils.parseIDArray(in);
        }

        @Override
        public void write(JsonWriter out, HashSet<Integer> value) throws IOException {
            GsonUtils.writeIDArray(out, value);
        }
    }
}

