/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.client.plugins.rs117.hd.utils.VariableSupplier;

public class ExpressionParser {
    public static Predicate<VariableSupplier> parsePredicate(String expression) {
        return ExpressionParser.parsePredicate(expression, null);
    }

    public static Predicate<VariableSupplier> parsePredicate(String expression, @Nullable Map<String, Object> constants) {
        return ExpressionParser.asExpression(ExpressionParser.parseExpression(expression, constants)).toPredicate();
    }

    public static Function<VariableSupplier, Object> parseFunction(String expression) {
        return ExpressionParser.parseFunction(expression, null);
    }

    public static Function<VariableSupplier, Object> parseFunction(String expression, @Nullable Map<String, Object> constants) {
        return ExpressionParser.asFunction(ExpressionParser.parseExpression(expression, constants));
    }

    public static Object parseExpression(String expression) {
        return ExpressionParser.parseExpression(expression, null);
    }

    public static Object parseExpression(String expression, @Nullable Map<String, Object> constants) {
        return ExpressionParser.asExpression(ExpressionParser.parseExpression(expression, 0, expression.length())).simplify(constants == null ? Collections.emptyMap() : constants);
    }

    public static Expression asExpression(Object object) {
        if (object instanceof Expression) {
            return (Expression)object;
        }
        return new Expression(object);
    }

    static Function<VariableSupplier, Object> asFunction(Object object) {
        if (object instanceof Expression) {
            return ((Expression)object).toFunction();
        }
        if (object instanceof String) {
            return vars -> vars.get((String)object);
        }
        return vars -> object;
    }

    private static Object parseExpression(String expression, int startIndex, int endIndex) {
        return ExpressionParser.parseExpression(new ParserContext(expression, startIndex, endIndex, true, 0));
    }

    private static Object parseExpression(ParserContext ctx) {
        ctx.trimWhitespace();
        if (ctx.done()) {
            throw new SyntaxError(ctx, "Empty expression");
        }
        ctx.trimParentheses();
        boolean wasInParentheses = ctx.isInParentheses;
        boolean wasTopLevelParser = ctx.isTopLevelParser;
        ctx.isTopLevelParser = false;
        ctx.operands[0] = ctx.parseOperand();
        block0: while (!ctx.done()) {
            ctx.skipWhitespace();
            ctx.op = null;
            for (Operator op : Operator.values()) {
                if (op.precedence < ctx.minPrecedence || !ctx.expr.startsWith(op.symbol, ctx.index)) continue;
                if (op == Operator.TERNARY) {
                    Object condition = ctx.operands[0];
                    if (condition == null) {
                        throw new SyntaxError(ctx, "Unexpected operator '" + op.symbol + "' without preceding condition");
                    }
                    ctx.index += op.symbol.length();
                    Object ifTrue = ExpressionParser.parseExpression(ctx);
                    ctx.trim();
                    if (ctx.c != ':') {
                        throw new SyntaxError(ctx, "Expected ':' in ternary expression");
                    }
                    ctx.advance();
                    Object ifFalse = ExpressionParser.parseExpression(ctx);
                    ctx.operands[0] = new Expression(op, ifTrue, ifFalse, condition, wasInParentheses);
                    continue block0;
                }
                if (ctx.operands[0] == null) {
                    if (op.numOperands > 1) {
                        throw new SyntaxError(ctx, "Missing left operand for operator '" + op.symbol + "'");
                    }
                } else if (op.numOperands == 1) {
                    throw new SyntaxError(ctx, "Unexpected left operand before '" + op.symbol + "'");
                }
                ctx.op = op;
                ctx.index += op.symbol.length();
                break;
            }
            if (ctx.op == null) break;
            if (ctx.op != Operator.NOT && ctx.operands[0] == null) {
                throw new SyntaxError(ctx, "Missing left operand for operator '" + ctx.op.symbol + "'");
            }
            ctx.operands[1] = ctx.parseOperand();
            if (ctx.operands[1] == null) {
                throw new SyntaxError(ctx, "Missing right operand for operator '" + ctx.op.symbol + "'");
            }
            ctx.operands[0] = ctx.createExpression(ctx.operands[0], ctx.op, ctx.operands[1]);
        }
        if (wasTopLevelParser && !ctx.done()) {
            throw new SyntaxError(ctx, "Unexpected character '" + ctx.c + "'");
        }
        if (ctx.operands[0] instanceof Expression) {
            ((Expression)ctx.operands[0]).isInParentheses = wasInParentheses;
        }
        return ctx.operands[0];
    }

    public static class Expression {
        Operator op;
        Object left;
        Object right;
        Object ternary;
        boolean isInParentheses;
        public final HashSet<String> variables = new HashSet();

        Expression(Object value) {
            this(null, value, null, null, false);
        }

        Expression(Operator op, Object left, Object right, Object ternary, boolean isInParentheses) {
            this.op = op;
            this.left = left;
            this.right = right;
            this.ternary = ternary;
            this.isInParentheses = isInParentheses;
            this.registerVariables(left);
            this.registerVariables(right);
            this.registerVariables(ternary);
        }

        private Object simplify(@Nonnull Map<String, Object> constants) {
            Object r;
            Object l = this.left instanceof Expression ? ((Expression)this.left).simplify(constants) : this.left;
            Object object = r = this.right instanceof Expression ? ((Expression)this.right).simplify(constants) : this.right;
            if (l instanceof String) {
                l = Expression.sanitizeValue(constants.getOrDefault(l, l));
            }
            if (r instanceof String) {
                r = Expression.sanitizeValue(constants.getOrDefault(r, r));
            }
            if (this.op == Operator.TERNARY) {
                Object t = ExpressionParser.asExpression(this.ternary).simplify(constants);
                if (t instanceof Boolean) {
                    return (Boolean)t != false ? l : r;
                }
                return new Expression(this.op, l, r, ExpressionParser.asExpression(t), this.isInParentheses);
            }
            Expression expr = this;
            if (l != this.left || r != this.right) {
                expr = new Expression(this.op, l, r, null, this.isInParentheses);
            }
            if (this.isPrimitive(l) && this.isPrimitive(r)) {
                return expr.toFunctionInternal().apply(null);
            }
            return expr;
        }

        public Function<VariableSupplier, Object> toFunction() {
            Function<VariableSupplier, Object> func = this.toFunctionInternal();
            return vars -> func.apply(key -> Expression.sanitizeValue(vars.get(key)));
        }

        static Object sanitizeValue(Object value) {
            if (value instanceof Integer) {
                return Float.valueOf(((Integer)value).floatValue());
            }
            return value;
        }

        private Function<VariableSupplier, Object> toFunctionInternal() {
            if (this.op == null) {
                return ExpressionParser.asFunction(this.left);
            }
            if (this.op == Operator.TERNARY) {
                Predicate<VariableSupplier> condition = ExpressionParser.asExpression(this.ternary).toPredicate();
                if (this.left instanceof Expression) {
                    Function<VariableSupplier, Object> ifTrue = ((Expression)this.left).toFunction();
                    if (this.right instanceof Expression) {
                        Function<VariableSupplier, Object> ifFalse = ((Expression)this.right).toFunction();
                        return vars -> condition.test((VariableSupplier)vars) ? ifTrue.apply((VariableSupplier)vars) : ifFalse.apply((VariableSupplier)vars);
                    }
                    return vars -> condition.test((VariableSupplier)vars) ? ifTrue.apply((VariableSupplier)vars) : this.right;
                }
                if (this.right instanceof Expression) {
                    Function<VariableSupplier, Object> ifFalse = ((Expression)this.right).toFunction();
                    return vars -> condition.test((VariableSupplier)vars) ? this.left : ifFalse.apply((VariableSupplier)vars);
                }
                return vars -> condition.test((VariableSupplier)vars) ? this.left : this.right;
            }
            Function<VariableSupplier, Object> l = ExpressionParser.asFunction(this.left);
            Function<VariableSupplier, Object> r = ExpressionParser.asFunction(this.right);
            switch (this.op) {
                case AND: {
                    return vars -> (Boolean)l.apply((VariableSupplier)vars) != false && (Boolean)r.apply((VariableSupplier)vars) != false;
                }
                case OR: {
                    return vars -> (Boolean)l.apply((VariableSupplier)vars) != false || (Boolean)r.apply((VariableSupplier)vars) != false;
                }
                case NOTEQUAL: 
                case EQUAL: {
                    boolean isBoolean;
                    boolean bl = isBoolean = this.left instanceof Boolean || this.left instanceof Expression && ((Expression)this.left).isBoolean() || this.right instanceof Boolean || this.right instanceof Expression && ((Expression)this.right).isBoolean();
                    if (isBoolean) {
                        return this.op == Operator.EQUAL ? vars -> ((Boolean)l.apply((VariableSupplier)vars)).booleanValue() == ((Boolean)r.apply((VariableSupplier)vars)).booleanValue() : vars -> ((Boolean)l.apply((VariableSupplier)vars)).booleanValue() != ((Boolean)r.apply((VariableSupplier)vars)).booleanValue();
                    }
                    return this.op == Operator.EQUAL ? vars -> ((Float)l.apply((VariableSupplier)vars)).floatValue() == ((Float)r.apply((VariableSupplier)vars)).floatValue() : vars -> ((Float)l.apply((VariableSupplier)vars)).floatValue() != ((Float)r.apply((VariableSupplier)vars)).floatValue();
                }
                case GEQUAL: {
                    return vars -> ((Float)l.apply((VariableSupplier)vars)).floatValue() >= ((Float)r.apply((VariableSupplier)vars)).floatValue();
                }
                case GREATER: {
                    return vars -> ((Float)l.apply((VariableSupplier)vars)).floatValue() > ((Float)r.apply((VariableSupplier)vars)).floatValue();
                }
                case LEQUAL: {
                    return vars -> ((Float)l.apply((VariableSupplier)vars)).floatValue() <= ((Float)r.apply((VariableSupplier)vars)).floatValue();
                }
                case LESS: {
                    return vars -> ((Float)l.apply((VariableSupplier)vars)).floatValue() < ((Float)r.apply((VariableSupplier)vars)).floatValue();
                }
                case ADD: {
                    return vars -> Float.valueOf(((Float)l.apply((VariableSupplier)vars)).floatValue() + ((Float)r.apply((VariableSupplier)vars)).floatValue());
                }
                case SUB: {
                    return vars -> Float.valueOf(((Float)l.apply((VariableSupplier)vars)).floatValue() - ((Float)r.apply((VariableSupplier)vars)).floatValue());
                }
                case MUL: {
                    return vars -> Float.valueOf(((Float)l.apply((VariableSupplier)vars)).floatValue() * ((Float)r.apply((VariableSupplier)vars)).floatValue());
                }
                case DIV: {
                    return vars -> Float.valueOf(((Float)l.apply((VariableSupplier)vars)).floatValue() / ((Float)r.apply((VariableSupplier)vars)).floatValue());
                }
                case MOD: {
                    return vars -> Float.valueOf(((Float)l.apply((VariableSupplier)vars)).floatValue() % ((Float)r.apply((VariableSupplier)vars)).floatValue());
                }
                case NOT: {
                    return vars -> (Boolean)r.apply((VariableSupplier)vars) == false;
                }
            }
            throw new UnsupportedOperationException("Unsupported operands: " + l + " " + this.op + " " + r);
        }

        public Predicate<VariableSupplier> toPredicate() {
            if (!this.isBoolean()) {
                throw new IllegalArgumentException("Expression does not result in a boolean");
            }
            Function<VariableSupplier, Object> func = this.toFunction();
            return vars -> (Boolean)func.apply((VariableSupplier)vars);
        }

        boolean isBoolean() {
            if (this.op == null) {
                return Expression.isPossiblyBoolean(this.left);
            }
            switch (this.op) {
                case TERNARY: {
                    return Expression.isPossiblyBoolean(this.left) || Expression.isPossiblyBoolean(this.right);
                }
                case AND: 
                case OR: 
                case NOTEQUAL: 
                case EQUAL: 
                case GEQUAL: 
                case GREATER: 
                case LEQUAL: 
                case LESS: 
                case NOT: {
                    return true;
                }
            }
            return false;
        }

        static boolean isPossiblyBoolean(Object obj) {
            return obj instanceof Boolean || obj instanceof String || obj instanceof Expression && ((Expression)obj).isBoolean();
        }

        private boolean isPrimitive(Object obj) {
            return obj == null || obj instanceof Float || obj instanceof Boolean;
        }

        private void registerVariables(@Nullable Object dependency) {
            if (dependency instanceof String) {
                this.variables.add((String)dependency);
            } else if (dependency instanceof Expression) {
                this.variables.addAll(((Expression)dependency).variables);
            }
        }
    }

    public static class ParserContext {
        final String expr;
        int index;
        int endIndex;
        char c;
        Operator op;
        Object[] operands = new Object[2];
        boolean isInParentheses;
        boolean isTopLevelParser;
        int minPrecedence;

        ParserContext(String expression, int startIndex, int endIndex, boolean isTopLevelParser, int minPrecedence) {
            this.expr = expression;
            this.index = startIndex;
            this.endIndex = endIndex;
            this.isTopLevelParser = isTopLevelParser;
            this.minPrecedence = minPrecedence;
        }

        boolean done() {
            return this.index >= this.endIndex;
        }

        void read() {
            if (this.done()) {
                throw new SyntaxError(this, "Unexpected end of expression");
            }
            this.c = this.expr.charAt(this.index);
        }

        void readSafe() {
            this.c = this.done() ? (char)'\u0000' : this.expr.charAt(this.index);
        }

        char readEnd() {
            return this.expr.charAt(this.endIndex - 1);
        }

        void readIgnoringWhitespace() {
            this.skipWhitespace();
            this.read();
        }

        void advance() {
            ++this.index;
            this.readSafe();
        }

        void advanceIgnoringWhitespace() {
            this.advance();
            this.skipWhitespace();
        }

        void trim() {
            int remaining;
            do {
                remaining = this.remaining();
                this.trimWhitespace();
                this.trimParentheses();
            } while (remaining != this.remaining());
        }

        void trimParentheses() {
            this.isInParentheses = false;
            while (!this.done() && this.c == '(' && this.readEnd() == ')') {
                int i = this.index + 1;
                int levels = 1;
                while (i < this.endIndex - 2) {
                    char c;
                    if ((c = this.expr.charAt(i++)) == '(') {
                        ++levels;
                        continue;
                    }
                    if (c != ')' || --levels != 0) continue;
                    return;
                }
                this.advance();
                --this.endIndex;
                this.isInParentheses = true;
            }
        }

        void skipWhitespace() {
            while (!this.done()) {
                this.readSafe();
                if (this.c != ' ') break;
                ++this.index;
            }
        }

        void trimWhitespaceEnd() {
            char end;
            while (!this.done() && (end = this.expr.charAt(this.endIndex - 1)) == ' ') {
                --this.endIndex;
            }
        }

        void trimWhitespace() {
            this.skipWhitespace();
            this.trimWhitespaceEnd();
        }

        int remaining() {
            return this.endIndex - this.index;
        }

        int indexOfClosingParenthesis(int openingParenthesis) {
            int i = openingParenthesis;
            int levels = 1;
            while (++i < this.endIndex) {
                char c = this.expr.charAt(i);
                if (c == '(') {
                    ++levels;
                    continue;
                }
                if (c != ')' || --levels != 0) continue;
                return i;
            }
            throw new SyntaxError(this, "Missing closing parenthesis");
        }

        Object parseOperand() {
            if (!this.done()) {
                ParserContext higherPrecedenceParser;
                Object expr;
                this.skipWhitespace();
                if (this.c == '(') {
                    int end = this.indexOfClosingParenthesis(this.index);
                    Object exprInParentheses = ExpressionParser.parseExpression(this.expr, this.index, end + 1);
                    this.index = end + 1;
                    this.readSafe();
                    return exprInParentheses;
                }
                if (this.op != null && (expr = ExpressionParser.parseExpression(higherPrecedenceParser = new ParserContext(this.expr, this.index, this.endIndex, false, this.op.precedence + 1))) != null) {
                    this.index = higherPrecedenceParser.index;
                    this.endIndex = higherPrecedenceParser.endIndex;
                    return expr;
                }
                if (this.c == '+' || this.c == '-' || this.c == '.' || '0' <= this.c && this.c <= '9') {
                    return Float.valueOf(this.readNumber());
                }
                if ('A' <= this.c && this.c <= 'Z' || 'a' <= this.c && this.c <= 'z' || this.c == '_') {
                    return this.readIdentifier();
                }
            }
            return null;
        }

        float readNumber() {
            int sign = 1;
            while (!this.done()) {
                if (this.c == '-') {
                    sign *= -1;
                } else if (this.c != '+') break;
                this.advanceIgnoringWhitespace();
            }
            int wholePart = 0;
            int numDigits = 0;
            while (!this.done() && '0' <= this.c && this.c <= '9') {
                wholePart *= 10;
                wholePart += this.c - 48;
                ++numDigits;
                this.advance();
            }
            if (!this.done() && this.c == '.') {
                this.advance();
                int fractionalPart = 0;
                int divisor = 1;
                while (!this.done() && '0' <= this.c && this.c <= '9') {
                    fractionalPart += this.c - 48;
                    divisor *= 10;
                    this.advance();
                }
                if (divisor > 1) {
                    return (float)sign * ((float)fractionalPart / (float)divisor + (float)wholePart);
                }
            }
            if (numDigits == 0) {
                throw new SyntaxError(this, "Expected a number");
            }
            return sign * wholePart;
        }

        Object readIdentifier() {
            StringBuilder sb = new StringBuilder();
            while (!this.done() && ('A' <= this.c && this.c <= 'Z' || 'a' <= this.c && this.c <= 'z' || '0' <= this.c && this.c <= '9' || this.c == '_')) {
                sb.append(this.c);
                this.advance();
            }
            assert (sb.length() > 0);
            String str = sb.toString();
            if (str.equalsIgnoreCase("true")) {
                return true;
            }
            if (str.equalsIgnoreCase("false")) {
                return false;
            }
            return str;
        }

        Expression createExpression(Object leftOperand, Operator op, Object rightOperand) {
            if (!(leftOperand instanceof Expression)) {
                return new Expression(op, leftOperand, rightOperand, null, false);
            }
            Expression left = (Expression)leftOperand;
            if (left.isInParentheses || left.op.precedence >= op.precedence) {
                return new Expression(op, left, rightOperand, null, false);
            }
            left.right = this.createExpression(left.right, op, rightOperand);
            return left;
        }

        public ParserContext(String expr, int index, int endIndex, char c, Operator op, Object[] operands, boolean isInParentheses, boolean isTopLevelParser, int minPrecedence) {
            this.expr = expr;
            this.index = index;
            this.endIndex = endIndex;
            this.c = c;
            this.op = op;
            this.operands = operands;
            this.isInParentheses = isInParentheses;
            this.isTopLevelParser = isTopLevelParser;
            this.minPrecedence = minPrecedence;
        }
    }

    public static class SyntaxError
    extends IllegalArgumentException {
        SyntaxError(ParserContext ctx, String message) {
            super("Error at index " + ctx.index + " while parsing " + (String)(ctx.op == null ? "expression" : "operator '" + ctx.op + "' in") + " '" + ctx.expr + "': " + message);
        }
    }

    private static enum Operator {
        MOD("%", 6, 2),
        MUL("*", 6, 2),
        DIV("/", 6, 2),
        ADD("+", 5, 2),
        SUB("-", 5, 2),
        LEQUAL("<=", 4, 2),
        LESS("<", 4, 2),
        GEQUAL(">=", 4, 2),
        GREATER(">", 4, 2),
        NOTEQUAL("!=", 3, 2),
        NOT("!", 7, 1),
        EQUAL("==", 3, 2),
        AND("&&", 2, 2),
        OR("||", 1, 2),
        TERNARY("?", 0, 3);

        final String symbol;
        final int precedence;
        final int numOperands;

        private Operator(String symbol, int precedence, int numOperands) {
            this.symbol = symbol;
            this.precedence = precedence;
            this.numOperands = numOperands;
        }
    }
}

