/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.utils;

import java.awt.event.KeyEvent;
import javax.inject.Inject;
import net.runelite.api.events.CommandExecuted;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.Keybind;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.overlays.FrameTimerOverlay;
import net.runelite.client.plugins.rs117.hd.overlays.LightGizmoOverlay;
import net.runelite.client.plugins.rs117.hd.overlays.ShadowMapOverlay;
import net.runelite.client.plugins.rs117.hd.overlays.TileInfoOverlay;
import net.runelite.client.plugins.rs117.hd.scene.AreaManager;
import net.runelite.client.plugins.rs117.hd.scene.areas.AABB;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeveloperTools
implements KeyListener {
    private static final Logger log = LoggerFactory.getLogger(DeveloperTools.class);
    private static final Keybind KEY_TOGGLE_TILE_INFO = new Keybind(114, 128);
    private static final Keybind KEY_TOGGLE_FRAME_TIMINGS = new Keybind(115, 128);
    private static final Keybind KEY_TOGGLE_SHADOW_MAP_OVERLAY = new Keybind(116, 128);
    private static final Keybind KEY_TOGGLE_LIGHT_GIZMO_OVERLAY = new Keybind(117, 128);
    private static final Keybind KEY_TOGGLE_FREEZE_FRAME = new Keybind(27, 64);
    private static final Keybind KEY_TOGGLE_ORTHOGRAPHIC = new Keybind(9, 64);
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    @Inject
    private KeyManager keyManager;
    @Inject
    private HdPlugin plugin;
    @Inject
    private TileInfoOverlay tileInfoOverlay;
    @Inject
    private FrameTimerOverlay frameTimerOverlay;
    @Inject
    private ShadowMapOverlay shadowMapOverlay;
    @Inject
    private LightGizmoOverlay lightGizmoOverlay;
    private boolean keyBindingsEnabled = false;
    private boolean tileInfoOverlayEnabled = false;
    private boolean frameTimingsOverlayEnabled = false;
    private boolean shadowMapOverlayEnabled = false;
    private boolean lightGizmoOverlayEnabled = false;

    public void activate() {
        this.eventBus.register(this);
        if (!Props.DEVELOPMENT) {
            return;
        }
        this.keyBindingsEnabled = true;
        this.keyManager.registerKeyListener(this);
        this.clientThread.invokeLater(() -> {
            this.tileInfoOverlay.setActive(this.tileInfoOverlayEnabled);
            this.frameTimerOverlay.setActive(this.frameTimingsOverlayEnabled);
            this.shadowMapOverlay.setActive(this.shadowMapOverlayEnabled);
            this.lightGizmoOverlay.setActive(this.lightGizmoOverlayEnabled);
        });
        for (Area area : AreaManager.AREAS) {
            if (area == Area.ALL || area == Area.NONE) continue;
            for (AABB aabb : area.aabbs) {
                if (aabb.minX >= -128 && aabb.minY >= 1000 && aabb.maxX <= 5000 && aabb.maxY <= 13000) continue;
                throw new IllegalArgumentException("Your definition for the area " + area + " has an incorrect AABB: " + aabb);
            }
        }
    }

    public void deactivate() {
        this.eventBus.unregister(this);
        this.keyManager.unregisterKeyListener(this);
        this.tileInfoOverlay.setActive(false);
        this.frameTimerOverlay.setActive(false);
        this.shadowMapOverlay.setActive(false);
        this.lightGizmoOverlay.setActive(false);
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted commandExecuted) {
        String action;
        if (!commandExecuted.getCommand().equalsIgnoreCase("117hd")) {
            return;
        }
        String[] args = commandExecuted.getArguments();
        if (args.length < 1) {
            return;
        }
        switch (action = args[0].toLowerCase()) {
            case "tileinfo": {
                this.tileInfoOverlayEnabled = !this.tileInfoOverlayEnabled;
                this.tileInfoOverlay.setActive(this.tileInfoOverlayEnabled);
                break;
            }
            case "timers": {
                this.frameTimingsOverlayEnabled = !this.frameTimingsOverlayEnabled;
                this.frameTimerOverlay.setActive(this.frameTimingsOverlayEnabled);
                break;
            }
            case "shadowmap": {
                this.shadowMapOverlayEnabled = !this.shadowMapOverlayEnabled;
                this.shadowMapOverlay.setActive(this.shadowMapOverlayEnabled);
                break;
            }
            case "lights": {
                this.lightGizmoOverlayEnabled = !this.lightGizmoOverlayEnabled;
                this.lightGizmoOverlay.setActive(this.lightGizmoOverlayEnabled);
                break;
            }
            case "keybindings": {
                boolean bl = this.keyBindingsEnabled = !this.keyBindingsEnabled;
                if (this.keyBindingsEnabled) {
                    this.keyManager.registerKeyListener(this);
                    break;
                }
                this.keyManager.unregisterKeyListener(this);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (KEY_TOGGLE_TILE_INFO.matches(e)) {
            this.tileInfoOverlayEnabled = !this.tileInfoOverlayEnabled;
            this.tileInfoOverlay.setActive(this.tileInfoOverlayEnabled);
        } else if (KEY_TOGGLE_FRAME_TIMINGS.matches(e)) {
            this.frameTimingsOverlayEnabled = !this.frameTimingsOverlayEnabled;
            this.frameTimerOverlay.setActive(this.frameTimingsOverlayEnabled);
        } else if (KEY_TOGGLE_SHADOW_MAP_OVERLAY.matches(e)) {
            this.shadowMapOverlayEnabled = !this.shadowMapOverlayEnabled;
            this.shadowMapOverlay.setActive(this.shadowMapOverlayEnabled);
        } else if (KEY_TOGGLE_LIGHT_GIZMO_OVERLAY.matches(e)) {
            this.lightGizmoOverlayEnabled = !this.lightGizmoOverlayEnabled;
            this.lightGizmoOverlay.setActive(this.lightGizmoOverlayEnabled);
        } else if (KEY_TOGGLE_FREEZE_FRAME.matches(e)) {
            this.plugin.toggleFreezeFrame();
        } else if (KEY_TOGGLE_ORTHOGRAPHIC.matches(e)) {
            this.plugin.orthographicProjection = !this.plugin.orthographicProjection;
        } else {
            return;
        }
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

