/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene.tile_overrides;

import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.runelite.client.plugins.rs117.hd.data.WaterType;
import net.runelite.client.plugins.rs117.hd.data.materials.GroundMaterial;
import net.runelite.client.plugins.rs117.hd.scene.AreaManager;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.scene.tile_overrides.ExpressionBasedReplacement;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TileOverride {
    private static final Logger log = LoggerFactory.getLogger(TileOverride.class);
    public static final int OVERLAY_FLAG = Integer.MIN_VALUE;
    public static final TileOverride NONE = new TileOverride("NONE", GroundMaterial.DIRT);
    @Nullable
    public String name;
    public String description;
    @JsonAdapter(value=AreaManager.JsonAdapter.class)
    public Area area = Area.NONE;
    public int[] overlayIds;
    public int[] underlayIds;
    @JsonAdapter(value=GroundMaterial.JsonAdapter.class)
    public GroundMaterial groundMaterial = GroundMaterial.NONE;
    public WaterType waterType = WaterType.NONE;
    public boolean blended = true;
    public boolean blendedAsOpposite;
    public boolean forced;
    public boolean depthTested;
    private int setHue = -1;
    private int shiftHue;
    private int minHue;
    private int maxHue = 63;
    private int setSaturation = -1;
    private int shiftSaturation;
    private int minSaturation;
    private int maxSaturation = 7;
    private int setLightness = -1;
    private int shiftLightness;
    private int minLightness;
    private int maxLightness = 127;
    public int uvOrientation;
    public float uvScale = 1.0f;
    public int heightOffset;
    @SerializedName(value="replacements")
    public LinkedHashMap<String, JsonElement> rawReplacements;
    public transient int index;
    public transient int[] ids;
    public transient List<ExpressionBasedReplacement> replacements;
    public transient boolean queriedAsOverlay;

    private TileOverride(@Nullable String name, GroundMaterial groundMaterial) {
        this.name = name;
        this.groundMaterial = groundMaterial;
        this.index = Integer.MAX_VALUE;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        if (this.description != null) {
            return this.description;
        }
        if (this.area != null) {
            return this.area.name;
        }
        return "Unnamed";
    }

    public void normalize(TileOverride[] allOverrides, Map<String, Object> constants) {
        int numUnderlays;
        int numOverlays = this.overlayIds == null ? 0 : this.overlayIds.length;
        int numIds = numOverlays + (numUnderlays = this.underlayIds == null ? 0 : this.underlayIds.length);
        if (numIds > 0) {
            int id;
            int j;
            this.ids = new int[numOverlays + numUnderlays];
            int i = 0;
            for (j = 0; j < numOverlays; ++j) {
                id = this.overlayIds[j];
                this.ids[i++] = Integer.MIN_VALUE | id;
            }
            for (j = 0; j < numUnderlays; ++j) {
                id = this.underlayIds[j];
                this.ids[i++] = id;
            }
        }
        if (this.area == null) {
            log.warn("Undefined area in tile override: {}", (Object)this);
            this.area = Area.NONE;
        }
        if (this.groundMaterial == null) {
            log.warn("Undefined ground material in tile override: {}", (Object)this);
            this.groundMaterial = GroundMaterial.NONE;
        }
        if (this.waterType == null) {
            log.warn("Undefined water type in tile override: {}", (Object)this);
            this.waterType = WaterType.NONE;
        }
        if (this.forced) {
            this.maxSaturation = 0;
            this.minSaturation = 0;
            this.maxHue = 0;
            this.minHue = 0;
            this.maxLightness = 127;
            this.minLightness = 127;
        }
        if (this.setHue != -1) {
            this.minHue = this.maxHue = this.setHue;
        }
        if (this.setSaturation != -1) {
            this.minSaturation = this.maxSaturation = this.setSaturation;
        }
        if (this.setLightness != -1) {
            this.minLightness = this.maxLightness = this.setLightness;
        }
        this.uvScale = 1.0f / this.uvScale;
        if (this.rawReplacements != null) {
            this.replacements = new ArrayList<ExpressionBasedReplacement>();
            for (Map.Entry<String, JsonElement> entry : this.rawReplacements.entrySet()) {
                ExpressionBasedReplacement expr = TileOverride.parseReplacementExpressions(entry, allOverrides, constants);
                if (expr.isConstant()) {
                    if (!expr.predicate.test(null)) continue;
                    this.replacements.add(expr);
                    if (!Props.DEVELOPMENT) break;
                }
                this.replacements.add(expr);
            }
        }
    }

    @NonNull
    private static ExpressionBasedReplacement parseReplacementExpressions(Map.Entry<String, JsonElement> expressions, TileOverride[] allOverrides, Map<String, Object> constants) {
        String name = expressions.getKey();
        TileOverride replacement = null;
        if (name == null) {
            log.warn("Null is reserved for future use");
            replacement = NONE;
        } else if (name.equals(TileOverride.NONE.name)) {
            replacement = NONE;
        } else {
            for (TileOverride other : allOverrides) {
                if (!name.equals(other.name)) continue;
                replacement = other;
                break;
            }
            if (replacement == null) {
                replacement = NONE;
                if (Props.DEVELOPMENT) {
                    throw new IllegalStateException("Unknown tile override: '" + name + "'");
                }
            }
        }
        return new ExpressionBasedReplacement(replacement, constants, expressions.getValue());
    }

    public TileOverride resolveConstantReplacements() {
        if (this.replacements != null) {
            for (ExpressionBasedReplacement replacement : this.replacements) {
                if (!replacement.isConstant()) break;
                if (!replacement.predicate.test(null)) continue;
                return replacement.replacement;
            }
        }
        return this;
    }

    public int modifyColor(int jagexHsl) {
        int h = jagexHsl >> 10 & 0x3F;
        h += this.shiftHue;
        h = HDUtils.clamp(h, this.minHue, this.maxHue);
        int s = jagexHsl >> 7 & 7;
        s += this.shiftSaturation;
        s = HDUtils.clamp(s, this.minSaturation, this.maxSaturation);
        int l = jagexHsl & 0x7F;
        l += this.shiftLightness;
        l = HDUtils.clamp(l, this.minLightness, this.maxLightness);
        return h << 10 | s << 7 | l;
    }

    public TileOverride() {
    }

    public TileOverride(@Nullable String name, String description, Area area, int[] overlayIds, int[] underlayIds, GroundMaterial groundMaterial, WaterType waterType, boolean blended, boolean blendedAsOpposite, boolean forced, boolean depthTested, int setHue, int shiftHue, int minHue, int maxHue, int setSaturation, int shiftSaturation, int minSaturation, int maxSaturation, int setLightness, int shiftLightness, int minLightness, int maxLightness, int uvOrientation, float uvScale, int heightOffset, LinkedHashMap<String, JsonElement> rawReplacements, int index, int[] ids, List<ExpressionBasedReplacement> replacements, boolean queriedAsOverlay) {
        this.name = name;
        this.description = description;
        this.area = area;
        this.overlayIds = overlayIds;
        this.underlayIds = underlayIds;
        this.groundMaterial = groundMaterial;
        this.waterType = waterType;
        this.blended = blended;
        this.blendedAsOpposite = blendedAsOpposite;
        this.forced = forced;
        this.depthTested = depthTested;
        this.setHue = setHue;
        this.shiftHue = shiftHue;
        this.minHue = minHue;
        this.maxHue = maxHue;
        this.setSaturation = setSaturation;
        this.shiftSaturation = shiftSaturation;
        this.minSaturation = minSaturation;
        this.maxSaturation = maxSaturation;
        this.setLightness = setLightness;
        this.shiftLightness = shiftLightness;
        this.minLightness = minLightness;
        this.maxLightness = maxLightness;
        this.uvOrientation = uvOrientation;
        this.uvScale = uvScale;
        this.heightOffset = heightOffset;
        this.rawReplacements = rawReplacements;
        this.index = index;
        this.ids = ids;
        this.replacements = replacements;
        this.queriedAsOverlay = queriedAsOverlay;
    }
}

