/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene.tile_overrides;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.runelite.client.plugins.rs117.hd.scene.tile_overrides.TileOverride;
import net.runelite.client.plugins.rs117.hd.utils.ExpressionParser;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.VariableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionBasedReplacement {
    private static final Logger log = LoggerFactory.getLogger(ExpressionBasedReplacement.class);
    public final TileOverride replacement;
    public final transient Predicate<VariableSupplier> predicate;
    private transient boolean isConstant;

    public boolean isConstant() {
        return this.isConstant;
    }

    public ExpressionBasedReplacement(@Nullable TileOverride replacement, @Nullable Map<String, Object> constants, JsonElement jsonExpressions) {
        this(replacement, constants, ExpressionBasedReplacement.jsonToStringExpressions(jsonExpressions));
    }

    public ExpressionBasedReplacement(@Nullable TileOverride replacement, @Nullable Map<String, Object> constants, String ... cases) {
        this.replacement = replacement;
        this.predicate = this.parse(constants, cases);
    }

    private static String[] jsonToStringExpressions(JsonElement jsonExpressions) {
        if (jsonExpressions == null || jsonExpressions.isJsonNull()) {
            return new String[0];
        }
        if (jsonExpressions.isJsonPrimitive()) {
            return new String[]{jsonExpressions.getAsJsonPrimitive().getAsString()};
        }
        if (jsonExpressions.isJsonArray()) {
            JsonArray array = jsonExpressions.getAsJsonArray();
            String[] expressions = new String[array.size()];
            int i = 0;
            for (JsonElement primitive : array) {
                expressions[i++] = primitive.getAsString();
            }
            return expressions;
        }
        throw new IllegalStateException("Unsupported expression format: '" + jsonExpressions + "'");
    }

    private Predicate<VariableSupplier> parse(@Nullable Map<String, Object> constants, String ... expressions) {
        if (expressions.length == 0) {
            this.isConstant = true;
            return vars -> false;
        }
        Predicate<VariableSupplier> predicate = null;
        for (String expression : expressions) {
            Object result = ExpressionParser.parseExpression(expression, constants);
            if (result instanceof Boolean) {
                this.isConstant = true;
                return vars -> (Boolean)result;
            }
            ExpressionParser.Expression expr = ExpressionParser.asExpression(result);
            Predicate<VariableSupplier> p = expr.toPredicate();
            Predicate<VariableSupplier> predicate2 = predicate = predicate == null ? p : predicate.or(p);
            if (!Props.DEVELOPMENT) continue;
            Set<String> knownVariables = Set.of("h", "s", "l");
            for (String variable : expr.variables) {
                if (knownVariables.contains(variable)) continue;
                throw new IllegalStateException("Expression '" + expression + "' contains unknown variable '" + variable + "'");
            }
        }
        return predicate;
    }
}

