/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene.model_overrides;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.runelite.api.Model;
import net.runelite.client.plugins.rs117.hd.config.SeasonalTheme;
import net.runelite.client.plugins.rs117.hd.config.VanillaShadowMode;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.data.materials.UvType;
import net.runelite.client.plugins.rs117.hd.scene.areas.AABB;
import net.runelite.client.plugins.rs117.hd.scene.model_overrides.InheritTileColorType;
import net.runelite.client.plugins.rs117.hd.scene.model_overrides.TzHaarRecolorType;
import net.runelite.client.plugins.rs117.hd.utils.ExpressionParser;
import net.runelite.client.plugins.rs117.hd.utils.GsonUtils;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.VariableSupplier;
import net.runelite.client.plugins.rs117.hd.utils.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelOverride {
    private static final Logger log = LoggerFactory.getLogger(ModelOverride.class);
    public static final ModelOverride NONE = new ModelOverride(true);
    private static final Set<Integer> EMPTY = new HashSet<Integer>();
    public String description = "UNKNOWN";
    public SeasonalTheme seasonalTheme;
    @JsonAdapter(value=AABB.JsonAdapter.class)
    public AABB[] areas = new AABB[0];
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    public Set<Integer> npcIds = EMPTY;
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    public Set<Integer> objectIds = EMPTY;
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    public Set<Integer> projectileIds = EMPTY;
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    public Set<Integer> graphicsObjectIds = EMPTY;
    public Material baseMaterial = Material.NONE;
    public Material textureMaterial = Material.NONE;
    public UvType uvType = UvType.VANILLA;
    public float uvScale = 1.0f;
    public int uvOrientation = 0;
    public int uvOrientationX = 0;
    public int uvOrientationY = 0;
    public int uvOrientationZ = 0;
    public int rotate = 0;
    public boolean hide = false;
    public boolean retainVanillaUvs = true;
    public boolean forceMaterialChanges = false;
    public boolean flatNormals = false;
    public boolean upwardsNormals = false;
    public boolean hideVanillaShadows = false;
    public boolean retainVanillaShadowsInPvm = false;
    public boolean hideHdShadowsInPvm = false;
    public boolean castShadows = true;
    public boolean receiveShadows = true;
    public float shadowOpacityThreshold = 0.0f;
    public TzHaarRecolorType tzHaarRecolorType = TzHaarRecolorType.NONE;
    public InheritTileColorType inheritTileColorType = InheritTileColorType.NONE;
    @JsonAdapter(value=AABB.JsonAdapter.class)
    public AABB[] hideInAreas = new AABB[0];
    public Map<Material, ModelOverride> materialOverrides;
    public ModelOverride[] colorOverrides;
    private JsonElement colors;
    public transient boolean isDummy;
    public transient Map<AABB, ModelOverride> areaOverrides;
    public transient HslPredicate hslCondition;

    public void normalize(VanillaShadowMode vanillaShadowMode) {
        if (this.baseMaterial == null) {
            if (Props.DEVELOPMENT) {
                throw new IllegalStateException("Invalid baseMaterial");
            }
            this.baseMaterial = ModelOverride.NONE.baseMaterial;
        }
        if (this.textureMaterial == null) {
            if (Props.DEVELOPMENT) {
                throw new IllegalStateException("Invalid textureMaterial");
            }
            this.textureMaterial = ModelOverride.NONE.textureMaterial;
        }
        if (this.uvType == null) {
            if (Props.DEVELOPMENT) {
                throw new IllegalStateException("Invalid uvType");
            }
            this.uvType = ModelOverride.NONE.uvType;
        }
        if (this.tzHaarRecolorType == null) {
            if (Props.DEVELOPMENT) {
                throw new IllegalStateException("Invalid tzHaarRecolorType");
            }
            this.tzHaarRecolorType = ModelOverride.NONE.tzHaarRecolorType;
        }
        if (this.inheritTileColorType == null) {
            if (Props.DEVELOPMENT) {
                throw new IllegalStateException("Invalid inheritTileColorType");
            }
            this.inheritTileColorType = ModelOverride.NONE.inheritTileColorType;
        }
        if (this.areas == null) {
            this.areas = new AABB[0];
        }
        if (this.hideInAreas == null) {
            this.hideInAreas = new AABB[0];
        }
        this.baseMaterial = this.baseMaterial.resolveReplacements();
        this.textureMaterial = this.textureMaterial.resolveReplacements();
        if (this.materialOverrides != null) {
            HashMap<Material, ModelOverride> normalized = new HashMap<Material, ModelOverride>();
            for (Map.Entry<Material, ModelOverride> entry : this.materialOverrides.entrySet()) {
                ModelOverride override = entry.getValue();
                override.normalize(vanillaShadowMode);
                normalized.put(entry.getKey().resolveReplacements(), override);
            }
            this.materialOverrides = normalized;
        }
        if (this.colorOverrides != null) {
            for (ModelOverride override : this.colorOverrides) {
                override.normalize(vanillaShadowMode);
                override.hslCondition = this.parseHslConditions(override.colors);
            }
        }
        if (this.uvOrientationX == 0) {
            this.uvOrientationX = this.uvOrientation;
        }
        if (this.uvOrientationY == 0) {
            this.uvOrientationY = this.uvOrientation;
        }
        if (this.uvOrientationZ == 0) {
            this.uvOrientationZ = this.uvOrientation;
        }
        if (this.retainVanillaShadowsInPvm) {
            if (vanillaShadowMode.retainInPvm) {
                this.hideVanillaShadows = false;
            }
            if (vanillaShadowMode == VanillaShadowMode.PREFER_IN_PVM && this.hideHdShadowsInPvm) {
                this.castShadows = false;
            }
        }
        if (!this.castShadows && this.shadowOpacityThreshold == 0.0f) {
            this.shadowOpacityThreshold = 1.0f;
        }
    }

    public ModelOverride copy() {
        return new ModelOverride(this.description, this.seasonalTheme, this.areas, this.npcIds, this.objectIds, this.projectileIds, this.graphicsObjectIds, this.baseMaterial, this.textureMaterial, this.uvType, this.uvScale, this.uvOrientation, this.uvOrientationX, this.uvOrientationY, this.uvOrientationZ, this.rotate, this.hide, this.retainVanillaUvs, this.forceMaterialChanges, this.flatNormals, this.upwardsNormals, this.hideVanillaShadows, this.retainVanillaShadowsInPvm, this.hideHdShadowsInPvm, this.castShadows, this.receiveShadows, this.shadowOpacityThreshold, this.tzHaarRecolorType, this.inheritTileColorType, this.hideInAreas, this.materialOverrides, this.colorOverrides, this.colors, this.isDummy, this.areaOverrides, this.hslCondition);
    }

    private ModelOverride(boolean isDummy) {
        this();
        this.isDummy = isDummy;
    }

    private HslPredicate parseHslConditions(JsonElement element) {
        JsonArray arr;
        if (element == null) {
            return hsl -> false;
        }
        if (element.isJsonArray()) {
            arr = element.getAsJsonArray();
        } else {
            arr = new JsonArray();
            arr.add(element);
        }
        HslPredicate combinedPredicate = null;
        for (JsonElement el : arr) {
            HslPredicate condition;
            block16: {
                if (el.isJsonNull()) continue;
                if (!el.isJsonPrimitive()) {
                    log.warn("Skipping unexpected HSL condition '{}' in override '{}'", (Object)el, (Object)this.description);
                    continue;
                }
                JsonPrimitive prim = el.getAsJsonPrimitive();
                if (prim.isBoolean()) {
                    boolean bool = prim.getAsBoolean();
                    condition = hsl -> bool;
                } else {
                    if (prim.isNumber()) {
                        try {
                            int targetHsl = prim.getAsInt();
                            condition = hsl -> hsl == targetHsl;
                            break block16;
                        }
                        catch (Exception ex) {
                            log.warn("Expected integer, but got {} in override '{}'", (Object)el, (Object)this.description);
                            continue;
                        }
                    }
                    if (prim.isString()) {
                        ExpressionParser.Expression expr = ExpressionParser.asExpression(ExpressionParser.parseExpression(prim.getAsString()));
                        if (Props.DEVELOPMENT) {
                            Set<String> knownVariables = Set.of("h", "s", "l", "hsl");
                            for (String variable : expr.variables) {
                                if (knownVariables.contains(variable)) continue;
                                throw new IllegalStateException("Expression '" + prim.getAsString() + "' contains unknown variable '" + variable + "'");
                            }
                        }
                        Predicate<VariableSupplier> predicate = expr.toPredicate();
                        condition = hsl -> predicate.test(key -> {
                            switch (key) {
                                default: {
                                    return hsl;
                                }
                                case "h": {
                                    return hsl >>> 10 & 0x3F;
                                }
                                case "s": {
                                    return hsl >>> 7 & 7;
                                }
                                case "l": 
                            }
                            return hsl & 0x7F;
                        });
                    } else {
                        log.warn("Skipping unexpected HSL condition primitive '{}' in override '{}'", (Object)el, (Object)this.description);
                        continue;
                    }
                }
            }
            if (combinedPredicate == null) {
                combinedPredicate = condition;
                continue;
            }
            HslPredicate prev = combinedPredicate;
            combinedPredicate = hsl -> prev.test(hsl) || condition.test(hsl);
        }
        if (combinedPredicate == null) {
            return hsl -> false;
        }
        return combinedPredicate;
    }

    public void computeModelUvw(float[] out, int i, float x, float y, float z, int orientation) {
        float temp;
        double sin;
        double cos;
        double rad;
        if (orientation % 2048 != 0) {
            rad = (double)orientation * 0.0030679615757712823;
            cos = Math.cos(rad);
            sin = Math.sin(rad);
            temp = (float)((double)x * sin + (double)z * cos);
            x = (float)((double)x * cos - (double)z * sin);
            z = temp;
        }
        x = (x / 128.0f + 0.5f) / this.uvScale;
        y = (y / 128.0f + 0.5f) / this.uvScale;
        z = (z / 128.0f + 0.5f) / this.uvScale;
        this.uvType.computeModelUvw(out, i, x, y, z);
        if (this.uvOrientation % 2048 != 0) {
            rad = (double)this.uvOrientation * 0.0030679615757712823;
            cos = Math.cos(rad);
            sin = Math.sin(rad);
            x = out[i] - 0.5f;
            z = out[i + 1] - 0.5f;
            temp = (float)((double)x * sin + (double)z * cos);
            x = (float)((double)x * cos - (double)z * sin);
            z = temp;
            out[i] = x + 0.5f;
            out[i + 1] = z + 0.5f;
        }
    }

    public void fillUvsForFace(float[] out, Model model, int orientation, UvType uvType, int face) {
        switch (uvType) {
            case WORLD_XY: 
            case WORLD_XZ: 
            case WORLD_YZ: {
                uvType.computeWorldUvw(out, 0, this.uvScale);
                uvType.computeWorldUvw(out, 4, this.uvScale);
                uvType.computeWorldUvw(out, 8, this.uvScale);
                break;
            }
            case MODEL_XY: 
            case MODEL_XY_MIRROR_A: 
            case MODEL_XY_MIRROR_B: 
            case MODEL_XZ: 
            case MODEL_XZ_MIRROR_A: 
            case MODEL_XZ_MIRROR_B: 
            case MODEL_YZ: 
            case MODEL_YZ_MIRROR_A: 
            case MODEL_YZ_MIRROR_B: {
                float[] vertexX = model.getVerticesX();
                float[] vertexY = model.getVerticesY();
                float[] vertexZ = model.getVerticesZ();
                int triA = model.getFaceIndices1()[face];
                int triB = model.getFaceIndices2()[face];
                int triC = model.getFaceIndices3()[face];
                this.computeModelUvw(out, 0, vertexX[triA], vertexY[triA], vertexZ[triA], orientation);
                this.computeModelUvw(out, 4, vertexX[triB], vertexY[triB], vertexZ[triB], orientation);
                this.computeModelUvw(out, 8, vertexX[triC], vertexY[triC], vertexZ[triC], orientation);
                break;
            }
            case BOX: {
                this.computeBoxUvw(out, model, orientation, face);
                break;
            }
            case VANILLA: {
                int texFace;
                byte[] textureFaces = model.getTextureFaces();
                int n = texFace = textureFaces == null ? -1 : textureFaces[face];
                if (texFace == -1) break;
                float[] vertexX = model.getVerticesX();
                float[] vertexY = model.getVerticesY();
                float[] vertexZ = model.getVerticesZ();
                int texA = model.getTexIndices1()[texFace &= 0xFF];
                int texB = model.getTexIndices2()[texFace];
                int texC = model.getTexIndices3()[texFace];
                out[0] = vertexX[texA];
                out[1] = vertexY[texA];
                out[2] = vertexZ[texA];
                out[4] = vertexX[texB];
                out[5] = vertexY[texB];
                out[6] = vertexZ[texB];
                out[8] = vertexX[texC];
                out[9] = vertexY[texC];
                out[10] = vertexZ[texC];
                break;
            }
            default: {
                out[0] = 0.0f;
                out[1] = 0.0f;
                out[2] = 0.0f;
                out[4] = 1.0f;
                out[5] = 0.0f;
                out[6] = 0.0f;
                out[8] = 0.0f;
                out[9] = 1.0f;
                out[10] = 0.0f;
            }
        }
    }

    private void computeBoxUvw(float[] out, Model model, int modelOrientation, int face) {
        block13: {
            float[] n;
            float temp;
            double sin;
            double cos;
            float[][] v;
            block14: {
                float[] absN;
                block12: {
                    int i;
                    float[][] vertexXYZ = new float[][]{model.getVerticesX(), model.getVerticesY(), model.getVerticesZ()};
                    int[] triABC = new int[]{model.getFaceIndices1()[face], model.getFaceIndices2()[face], model.getFaceIndices3()[face]};
                    v = new float[3][3];
                    for (int tri = 0; tri < 3; ++tri) {
                        for (int i2 = 0; i2 < 3; ++i2) {
                            v[tri][i2] = vertexXYZ[i2][triABC[tri]];
                        }
                    }
                    if (modelOrientation % 2048 != 0) {
                        double rad = (double)modelOrientation * 0.0030679615757712823;
                        cos = Math.cos(rad);
                        sin = Math.sin(rad);
                        for (i = 0; i < 3; ++i) {
                            temp = (float)((double)v[i][0] * sin + (double)v[i][2] * cos);
                            v[i][0] = (float)((double)v[i][0] * cos - (double)v[i][2] * sin);
                            v[i][2] = temp;
                        }
                    }
                    for (i = 0; i < 3; ++i) {
                        v[i][0] = (v[i][0] / 128.0f + 0.5f) / this.uvScale;
                        v[i][1] = (v[i][1] / 128.0f + 0.5f) / this.uvScale;
                        v[i][2] = (v[i][2] / 128.0f + 0.5f) / this.uvScale;
                    }
                    float[] a = new float[3];
                    float[] b = new float[3];
                    Vector.subtract(a, v[1], v[0]);
                    Vector.subtract(b, v[2], v[0]);
                    n = new float[3];
                    Vector.cross(n, a, b);
                    absN = new float[3];
                    Vector.abs(absN, n);
                    out[10] = 0.0f;
                    out[6] = 0.0f;
                    out[2] = 0.0f;
                    if (!(absN[0] > absN[1]) || !(absN[0] > absN[2])) break block12;
                    float flip = Math.signum(n[0]);
                    for (int tri = 0; tri < 3; ++tri) {
                        out[tri * 4] = flip * -v[tri][2];
                        out[tri * 4 + 1] = v[tri][1];
                    }
                    if (this.uvOrientationX % 2048 == 0) break block13;
                    double rad = (double)this.uvOrientationX * 0.0030679615757712823;
                    cos = Math.cos(rad);
                    sin = Math.sin(rad);
                    for (int i3 = 0; i3 < 3; ++i3) {
                        int j = i3 * 4;
                        v[i3][0] = out[j] - 0.5f;
                        v[i3][2] = out[j + 1] - 0.5f;
                        temp = (float)((double)v[i3][0] * sin + (double)v[i3][2] * cos);
                        v[i3][0] = (float)((double)v[i3][0] * cos - (double)v[i3][2] * sin);
                        v[i3][2] = temp;
                        out[j] = v[i3][0] + 0.5f;
                        out[j + 1] = v[i3][2] + 0.5f;
                    }
                    break block13;
                }
                if (!(absN[1] > absN[0]) || !(absN[1] > absN[2])) break block14;
                float flip = Math.signum(n[1]);
                for (int tri = 0; tri < 3; ++tri) {
                    out[tri * 4] = flip * -v[tri][0];
                    out[tri * 4 + 1] = v[tri][2];
                }
                if (this.uvOrientationY % 2048 == 0) break block13;
                double rad = (double)this.uvOrientationY * 0.0030679615757712823;
                cos = Math.cos(rad);
                sin = Math.sin(rad);
                for (int i = 0; i < 3; ++i) {
                    int j = i * 4;
                    v[i][0] = out[j] - 0.5f;
                    v[i][2] = out[j + 1] - 0.5f;
                    temp = (float)((double)v[i][0] * sin + (double)v[i][2] * cos);
                    v[i][0] = (float)((double)v[i][0] * cos - (double)v[i][2] * sin);
                    v[i][2] = temp;
                    out[j] = v[i][0] + 0.5f;
                    out[j + 1] = v[i][2] + 0.5f;
                }
                break block13;
            }
            float flip = Math.signum(n[2]);
            for (int tri = 0; tri < 3; ++tri) {
                out[tri * 4] = flip * v[tri][0];
                out[tri * 4 + 1] = v[tri][1];
            }
            if (this.uvOrientationZ % 2048 != 0) {
                double rad = (double)this.uvOrientationZ * 0.0030679615757712823;
                cos = Math.cos(rad);
                sin = Math.sin(rad);
                for (int i = 0; i < 3; ++i) {
                    int j = i * 4;
                    v[i][0] = out[j] - 0.5f;
                    v[i][2] = out[j + 1] - 0.5f;
                    temp = (float)((double)v[i][0] * sin + (double)v[i][2] * cos);
                    v[i][0] = (float)((double)v[i][0] * cos - (double)v[i][2] * sin);
                    v[i][2] = temp;
                    out[j] = v[i][0] + 0.5f;
                    out[j + 1] = v[i][2] + 0.5f;
                }
            }
        }
    }

    public void applyRotation(Model model) {
        switch (this.rotate) {
            case 0: {
                break;
            }
            case 90: {
                model.rotateY90Ccw();
                break;
            }
            case 180: {
                model.rotateY180Ccw();
                break;
            }
            case 270: {
                model.rotateY270Ccw();
                break;
            }
            default: {
                log.debug("Unsupported rotation of {} degrees in model override: '{}'", (Object)this.rotate, (Object)this.description);
            }
        }
    }

    public void revertRotation(Model model) {
        switch (this.rotate) {
            case 90: {
                model.rotateY270Ccw();
                break;
            }
            case 180: {
                model.rotateY180Ccw();
                break;
            }
            case 270: {
                model.rotateY90Ccw();
            }
        }
    }

    public ModelOverride() {
    }

    public ModelOverride(String description, SeasonalTheme seasonalTheme, AABB[] areas, Set<Integer> npcIds, Set<Integer> objectIds, Set<Integer> projectileIds, Set<Integer> graphicsObjectIds, Material baseMaterial, Material textureMaterial, UvType uvType, float uvScale, int uvOrientation, int uvOrientationX, int uvOrientationY, int uvOrientationZ, int rotate, boolean hide, boolean retainVanillaUvs, boolean forceMaterialChanges, boolean flatNormals, boolean upwardsNormals, boolean hideVanillaShadows, boolean retainVanillaShadowsInPvm, boolean hideHdShadowsInPvm, boolean castShadows, boolean receiveShadows, float shadowOpacityThreshold, TzHaarRecolorType tzHaarRecolorType, InheritTileColorType inheritTileColorType, AABB[] hideInAreas, Map<Material, ModelOverride> materialOverrides, ModelOverride[] colorOverrides, JsonElement colors, boolean isDummy, Map<AABB, ModelOverride> areaOverrides, HslPredicate hslCondition) {
        this.description = description;
        this.seasonalTheme = seasonalTheme;
        this.areas = areas;
        this.npcIds = npcIds;
        this.objectIds = objectIds;
        this.projectileIds = projectileIds;
        this.graphicsObjectIds = graphicsObjectIds;
        this.baseMaterial = baseMaterial;
        this.textureMaterial = textureMaterial;
        this.uvType = uvType;
        this.uvScale = uvScale;
        this.uvOrientation = uvOrientation;
        this.uvOrientationX = uvOrientationX;
        this.uvOrientationY = uvOrientationY;
        this.uvOrientationZ = uvOrientationZ;
        this.rotate = rotate;
        this.hide = hide;
        this.retainVanillaUvs = retainVanillaUvs;
        this.forceMaterialChanges = forceMaterialChanges;
        this.flatNormals = flatNormals;
        this.upwardsNormals = upwardsNormals;
        this.hideVanillaShadows = hideVanillaShadows;
        this.retainVanillaShadowsInPvm = retainVanillaShadowsInPvm;
        this.hideHdShadowsInPvm = hideHdShadowsInPvm;
        this.castShadows = castShadows;
        this.receiveShadows = receiveShadows;
        this.shadowOpacityThreshold = shadowOpacityThreshold;
        this.tzHaarRecolorType = tzHaarRecolorType;
        this.inheritTileColorType = inheritTileColorType;
        this.hideInAreas = hideInAreas;
        this.materialOverrides = materialOverrides;
        this.colorOverrides = colorOverrides;
        this.colors = colors;
        this.isDummy = isDummy;
        this.areaOverrides = areaOverrides;
        this.hslCondition = hslCondition;
    }

    @FunctionalInterface
    public static interface HslPredicate {
        public boolean test(int var1);
    }
}

