/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene.lights;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.runelite.client.plugins.rs117.hd.scene.areas.AABB;
import net.runelite.client.plugins.rs117.hd.scene.lights.Alignment;
import net.runelite.client.plugins.rs117.hd.scene.lights.LightType;
import net.runelite.client.plugins.rs117.hd.utils.ColorUtils;
import net.runelite.client.plugins.rs117.hd.utils.GsonUtils;

public class LightDefinition {
    public String description;
    @Nullable
    public Integer worldX;
    @Nullable
    public Integer worldY;
    public int plane;
    public Alignment alignment = Alignment.CUSTOM;
    public int[] offset = new int[3];
    public int height;
    public int radius = 300;
    public float strength = 5.0f;
    @JsonAdapter(value=ColorUtils.SrgbToLinearAdapter.class)
    public float[] color;
    public LightType type = LightType.STATIC;
    public float duration;
    public float range;
    public int fadeInDuration = 50;
    public int fadeOutDuration = 50;
    public int spawnDelay;
    public int despawnDelay;
    public boolean fixedDespawnTime;
    public boolean visibleFromOtherPlanes;
    public boolean ignoreActorHiding;
    public int renderableIndex = -1;
    @JsonAdapter(value=AABB.JsonAdapter.class)
    public AABB[] areas = new AABB[0];
    @JsonAdapter(value=AABB.JsonAdapter.class)
    public AABB[] excludeAreas = new AABB[0];
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    public HashSet<Integer> npcIds = new HashSet();
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    public HashSet<Integer> objectIds = new HashSet();
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    public HashSet<Integer> projectileIds = new HashSet();
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    @SerializedName(value="graphicsObjectIds")
    public HashSet<Integer> spotAnimIds = new HashSet();
    @JsonAdapter(value=GsonUtils.IntegerSetAdapter.class)
    public HashSet<Integer> animationIds = new HashSet();

    public void normalize() {
        if (this.description == null) {
            this.description = "N/A";
        }
        if (this.alignment == null || this.alignment == Alignment.CENTER) {
            this.alignment = Alignment.CUSTOM;
        }
        if (this.offset == null || this.offset.length != 3) {
            this.offset = new int[3];
        } else {
            this.offset[1] = this.offset[1] * -1;
        }
        if (this.color == null || this.color.length != 3) {
            this.color = new float[3];
        }
        if (this.type == null) {
            this.type = LightType.STATIC;
        }
    }
}

