/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene.lights;

import net.runelite.api.Actor;
import net.runelite.api.GraphicsObject;
import net.runelite.api.Projectile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.rs117.hd.scene.lights.Alignment;
import net.runelite.client.plugins.rs117.hd.scene.lights.LightDefinition;
import net.runelite.client.plugins.rs117.hd.scene.lights.LightType;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;

public class Light {
    public static final float VISIBILITY_FADE = 0.1f;
    public final float randomOffset = HDUtils.rand.nextFloat();
    public final LightDefinition def;
    public int radius;
    public float strength;
    public float[] color;
    public float animation = 0.5f;
    public float duration;
    public float fadeInDuration;
    public float fadeOutDuration;
    public float spawnDelay;
    public float despawnDelay;
    public boolean visible;
    public boolean parentExists;
    public boolean withinViewingDistance = true;
    public boolean hiddenTemporarily;
    public boolean markedForRemoval;
    public boolean persistent;
    public boolean replayable;
    public final boolean animationSpecific;
    public final boolean dynamicLifetime;
    public float elapsedTime;
    public float changedVisibilityAt = -1.0f;
    public float lifetime = -1.0f;
    public WorldPoint worldPoint;
    public boolean belowFloor;
    public boolean aboveFloor;
    public int plane;
    public int prevPlane = -1;
    public int prevTileX = -1;
    public int prevTileY = -1;
    public Alignment alignment;
    public int[] origin = new int[3];
    public int[] offset = new int[3];
    public int[] pos = new int[3];
    public int orientation;
    public int distanceSquared;
    public Actor actor;
    public Projectile projectile;
    public TileObject tileObject;
    public GraphicsObject graphicsObject;
    public int spotAnimId = -1;
    public int preOrientation;
    public int[] projectileRefCounter;
    public long hash;
    public int sizeX = 1;
    public int sizeY = 1;

    public Light(LightDefinition def) {
        this.def = def;
        System.arraycopy(def.offset, 0, this.offset, 0, 3);
        this.duration = Math.max(0.0f, def.duration) / 1000.0f;
        this.fadeInDuration = (float)Math.max(0, def.fadeInDuration) / 1000.0f;
        this.fadeOutDuration = (float)Math.max(0, def.fadeOutDuration) / 1000.0f;
        this.spawnDelay = (float)Math.max(0, def.spawnDelay) / 1000.0f;
        this.despawnDelay = (float)Math.max(0, def.despawnDelay) / 1000.0f;
        this.color = def.color;
        this.radius = def.radius;
        this.strength = def.strength;
        this.alignment = def.alignment;
        this.plane = def.plane;
        if (def.type == LightType.PULSE) {
            this.animation = (float)Math.random();
        }
        if (def.fixedDespawnTime) {
            this.lifetime = this.spawnDelay + this.despawnDelay;
        }
        if (this.lifetime == -1.0f) {
            this.dynamicLifetime = true;
            this.despawnDelay = Math.max(this.despawnDelay, this.fadeOutDuration);
        } else {
            this.dynamicLifetime = false;
        }
        boolean bl = this.animationSpecific = !def.animationIds.isEmpty();
        if (this.animationSpecific) {
            this.replayable = true;
            this.persistent = true;
            if (this.dynamicLifetime) {
                this.lifetime = 0.0f;
            } else {
                this.elapsedTime = this.lifetime;
            }
        }
    }

    public void toggleTemporaryVisibility(boolean changedPlanes) {
        boolean bl = this.hiddenTemporarily = !this.hiddenTemporarily;
        if (!changedPlanes) {
            float beginFadeAt = this.elapsedTime;
            if (this.changedVisibilityAt != -1.0f) {
                beginFadeAt -= Math.max(0.0f, 0.1f - (this.elapsedTime - this.changedVisibilityAt));
            }
            this.changedVisibilityAt = beginFadeAt;
        }
    }

    public float getTemporaryVisibilityFade() {
        float fade = 1.0f;
        if (this.changedVisibilityAt != -1.0f) {
            fade = HDUtils.clamp((this.elapsedTime - this.changedVisibilityAt) / 0.1f, 0.0f, 1.0f);
        }
        if (this.hiddenTemporarily) {
            fade = 1.0f - fade;
        }
        return fade;
    }

    public void applyTemporaryVisibilityFade() {
        this.strength *= this.getTemporaryVisibilityFade();
    }
}

