/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene.areas;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.runelite.client.plugins.rs117.hd.scene.areas.AABB;
import net.runelite.client.plugins.rs117.hd.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionBox {
    public final int from;
    public final int to;
    public final int fromPlane;
    public final int toPlane;

    public RegionBox(int regionId) {
        this(regionId, regionId);
    }

    public RegionBox(int from, int to) {
        this(from, to, 0, 3);
    }

    public RegionBox(int from, int to, int plane) {
        this(from, to, plane, plane);
    }

    public AABB toAabb() {
        int temp;
        int x1 = this.from >>> 8;
        int y1 = this.from & 0xFF;
        int x2 = this.to >>> 8;
        int y2 = this.to & 0xFF;
        if (x1 > x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 > y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        return new AABB(x1 << 6, y1 << 6, this.fromPlane, (x2 + 1 << 6) - 1, (y2 + 1 << 6) - 1, this.toPlane);
    }

    public RegionBox(int from, int to, int fromPlane, int toPlane) {
        this.from = from;
        this.to = to;
        this.fromPlane = fromPlane;
        this.toPlane = toPlane;
    }

    public static class JsonAdapter
    extends TypeAdapter<RegionBox[]> {
        private static final Logger log = LoggerFactory.getLogger(JsonAdapter.class);

        @Override
        public RegionBox[] read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<RegionBox> list = new ArrayList<RegionBox>();
            while (in.hasNext() && in.peek() != JsonToken.END_ARRAY) {
                if (in.peek() == JsonToken.NULL) {
                    in.skipValue();
                    continue;
                }
                in.beginArray();
                int[] ints = new int[4];
                int i = 0;
                block12: while (in.hasNext()) {
                    switch (in.peek()) {
                        case NUMBER: {
                            if (i >= ints.length) {
                                throw new IOException("Too many numbers in RegionBox entry (> " + ints.length + ") at " + GsonUtils.location(in));
                            }
                            ints[i++] = in.nextInt();
                        }
                        case END_ARRAY: {
                            continue block12;
                        }
                        case NULL: {
                            in.skipValue();
                            continue block12;
                        }
                    }
                    throw new IOException("Malformed RegionBox entry. Unexpected token: " + in.peek() + " at " + GsonUtils.location(in));
                }
                in.endArray();
                switch (i) {
                    case 1: {
                        list.add(new RegionBox(ints[0]));
                        break;
                    }
                    case 2: {
                        list.add(new RegionBox(ints[0], ints[1]));
                        break;
                    }
                    case 3: {
                        list.add(new RegionBox(ints[0], ints[1], ints[2]));
                        break;
                    }
                    case 4: {
                        list.add(new RegionBox(ints[0], ints[1], ints[2], ints[3]));
                    }
                }
            }
            in.endArray();
            return list.toArray(new RegionBox[0]);
        }

        @Override
        public void write(JsonWriter out, RegionBox[] aabbs) throws IOException {
            if (aabbs == null || aabbs.length == 0) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (RegionBox box : aabbs) {
                if (box.fromPlane == 0 && box.toPlane == 3) {
                    if (box.from == box.to) {
                        out.jsonValue(String.format("[ %d ]", box.from));
                        continue;
                    }
                    out.jsonValue(String.format("[ %d, %d ]", box.from, box.to));
                    continue;
                }
                if (box.fromPlane == box.toPlane) {
                    out.jsonValue(String.format("[ %d, %d, %d ]", box.from, box.to, box.fromPlane));
                    continue;
                }
                out.jsonValue(String.format("[ %d, %d, %d, %d ]", box.from, box.to, box.fromPlane, box.toPlane));
            }
            out.endArray();
        }
    }
}

