/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene.areas;

import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import net.runelite.client.plugins.rs117.hd.scene.AreaManager;
import net.runelite.client.plugins.rs117.hd.scene.areas.AABB;
import net.runelite.client.plugins.rs117.hd.scene.areas.RegionBox;

public class Area {
    public static final Area NONE = new Area("NONE", 0, 0, 0, 0);
    public static final Area ALL = new Area("ALL", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static Area OVERWORLD = NONE;
    public String name;
    public boolean hideOtherAreas;
    public boolean fillGaps = true;
    public String[] areas;
    public int[] regions;
    @JsonAdapter(value=RegionBox.JsonAdapter.class)
    public RegionBox[] regionBoxes;
    @JsonAdapter(value=AABB.JsonAdapter.class)
    @SerializedName(value="aabbs")
    public AABB[] rawAabbs;
    public transient AABB[] aabbs;
    private transient boolean normalized;

    public Area(String name) {
        this.name = name;
    }

    public Area(String name, int x1, int y1, int x2, int y2) {
        this(name);
        this.aabbs = new AABB[]{new AABB(x1, y1, x2, y2)};
    }

    public void normalize() {
        if (this.normalized) {
            return;
        }
        this.normalized = true;
        ArrayList<AABB> aabbs = new ArrayList<AABB>();
        if (this.rawAabbs != null) {
            Collections.addAll(aabbs, this.rawAabbs);
        }
        if (this.regions != null) {
            for (int regionId : this.regions) {
                aabbs.add(new AABB(regionId));
            }
        }
        if (this.regionBoxes != null) {
            for (RegionBox box : this.regionBoxes) {
                aabbs.add(box.toAabb());
            }
        }
        if (this.areas != null) {
            block2: for (String area : this.areas) {
                for (Area other : AreaManager.AREAS) {
                    if (!area.equals(other.name)) continue;
                    other.normalize();
                    Collections.addAll(aabbs, other.aabbs);
                    continue block2;
                }
            }
        }
        this.aabbs = (AABB[])aabbs.toArray(AABB[]::new);
    }

    public boolean containsPoint(int worldX, int worldY, int plane) {
        for (AABB aabb : this.aabbs) {
            if (!aabb.contains(worldX, worldY, plane)) continue;
            return true;
        }
        return false;
    }

    public boolean containsPoint(int[] worldPoint) {
        return this.containsPoint(worldPoint[0], worldPoint[1], worldPoint[2]);
    }

    public boolean intersects(Area otherArea) {
        if (otherArea == null) {
            return false;
        }
        return this.intersects(otherArea.aabbs);
    }

    public boolean intersects(AABB ... otherAabbs) {
        for (AABB aabb : this.aabbs) {
            if (!aabb.intersects(otherAabbs)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }
}

