/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene.areas;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.rs117.hd.scene.AreaManager;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AABB {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public AABB(int regionId) {
        this.minX = regionId >>> 8 << 6;
        this.minY = (regionId & 0xFF) << 6;
        this.maxX = this.minX + 64 - 1;
        this.maxY = this.minY + 64 - 1;
        this.minZ = Integer.MIN_VALUE;
        this.maxZ = Integer.MAX_VALUE;
    }

    public AABB(int x, int y) {
        this.minX = this.maxX = x;
        this.minY = this.maxY = y;
        this.minZ = Integer.MIN_VALUE;
        this.maxZ = Integer.MAX_VALUE;
    }

    public AABB(int x, int y, int z) {
        this.minX = this.maxX = x;
        this.minY = this.maxY = y;
        this.minZ = this.maxZ = z;
    }

    public AABB(int x1, int y1, int x2, int y2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Integer.MIN_VALUE;
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Integer.MAX_VALUE;
    }

    public AABB(int x1, int y1, int x2, int y2, int z1) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.minZ = this.maxZ = z1;
    }

    public AABB(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
    }

    public AABB(int[] point) {
        this(point[0], point[1], point[2]);
    }

    public AABB(int[] from, int[] to) {
        this(from[0], from[1], from[2], to[0], to[1], to[2]);
    }

    public AABB onPlane(int plane) {
        return new AABB(this.minX, this.minY, plane, this.maxX, this.maxY, plane);
    }

    public AABB expandTo(int[] point) {
        return new AABB(Math.min(this.minX, point[0]), Math.min(this.minY, point[1]), Math.min(this.minZ, point[2]), Math.max(this.maxX, point[0]), Math.max(this.maxY, point[1]), Math.max(this.maxZ, point[2]));
    }

    public boolean hasZ() {
        return this.minZ != Integer.MIN_VALUE || this.maxZ != Integer.MAX_VALUE;
    }

    public boolean isPoint() {
        return this.minX == this.maxX && this.minY == this.maxY && (!this.hasZ() || this.minZ == this.maxZ);
    }

    public boolean isVolume() {
        return !this.isPoint();
    }

    public boolean contains(int ... worldPos) {
        return this.minX <= worldPos[0] && worldPos[0] <= this.maxX && this.minY <= worldPos[1] && worldPos[1] <= this.maxY && (worldPos.length < 3 || this.minZ <= worldPos[2] && worldPos[2] <= this.maxZ);
    }

    public boolean contains(WorldPoint location) {
        return this.contains(location.getX(), location.getY(), location.getPlane());
    }

    public boolean contains(AABB other) {
        return this.contains(other.minX, other.minY, other.minZ) && this.contains(other.maxX, other.maxY, other.maxZ);
    }

    public boolean intersects(int minX, int minY, int maxX, int maxY) {
        return minX <= this.maxX && maxX >= this.minX && minY <= this.maxY && maxY >= this.minY;
    }

    public boolean intersects(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return minX <= this.maxX && maxX >= this.minX && minY <= this.maxY && maxY >= this.minY && minZ <= this.maxZ && maxZ >= this.minZ;
    }

    public boolean intersects(AABB other) {
        return this.intersects(other.minX, other.minY, other.minZ, other.maxX, other.maxY, other.maxZ);
    }

    public boolean intersects(AABB ... aabbs) {
        for (AABB aabb : aabbs) {
            if (!this.intersects(aabb)) continue;
            return true;
        }
        return false;
    }

    public float[] getCenter() {
        return new float[]{(float)(this.minX + this.maxX) / 2.0f, (float)(this.minY + this.maxY) / 2.0f, (float)(this.minZ + this.maxZ) / 2.0f};
    }

    public String toString() {
        if (this.hasZ()) {
            return String.format("AABB{min=(%d,%d,%d), max=(%d,%d,%d)}", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        return String.format("AABB{min=(%d,%d), max=(%d,%d)}", this.minX, this.minY, this.maxX, this.maxY);
    }

    public String toArgs() {
        if (this.hasZ()) {
            if (this.isPoint()) {
                return String.format("[ %d, %d, %d ]", this.minX, this.minY, this.minZ);
            }
            if (this.minZ == this.maxZ) {
                return String.format("[ %d, %d, %d, %d, %d ]", this.minX, this.minY, this.maxX, this.maxY, this.minZ);
            }
            return String.format("[ %d, %d, %d, %d, %d, %d ]", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
        }
        if (this.isPoint()) {
            return String.format("[ %d, %d ]", this.minX, this.minY);
        }
        return String.format("[ %d, %d, %d, %d ]", this.minX, this.minY, this.maxX, this.maxY);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AABB)) {
            return false;
        }
        AABB other = (AABB)obj;
        return other.minX == this.minX && other.maxX == this.maxX && other.minY == this.minY && other.maxY == this.maxY && other.minZ == this.minZ && other.maxZ == this.maxZ;
    }

    public static class JsonAdapter
    extends TypeAdapter<AABB[]> {
        private static final Logger log = LoggerFactory.getLogger(JsonAdapter.class);

        @Override
        public AABB[] read(JsonReader in) throws IOException {
            in.beginArray();
            ArrayList<AABB> list = new ArrayList<AABB>();
            block13: while (in.hasNext() && in.peek() != JsonToken.END_ARRAY) {
                if (in.peek() == JsonToken.NULL) {
                    in.skipValue();
                    continue;
                }
                if (in.peek() == JsonToken.NUMBER) {
                    list.add(new AABB(in.nextInt()));
                    continue;
                }
                if (in.peek() == JsonToken.STRING) {
                    String name = in.nextString();
                    for (Area area : AreaManager.AREAS) {
                        if (!name.equals(area.name)) continue;
                        Collections.addAll(list, area.aabbs);
                        continue block13;
                    }
                    log.warn("No area exists with the name '{}' at {}", name, GsonUtils.location(in), new Throwable());
                }
                in.beginArray();
                int[] ints = new int[6];
                int i = 0;
                block15: while (in.hasNext()) {
                    switch (in.peek()) {
                        case NUMBER: {
                            if (i >= ints.length) {
                                throw new IOException("Too many numbers in AABB entry (> " + ints.length + ") at " + GsonUtils.location(in));
                            }
                            ints[i++] = in.nextInt();
                        }
                        case END_ARRAY: {
                            continue block15;
                        }
                        case NULL: {
                            in.skipValue();
                            continue block15;
                        }
                    }
                    throw new IOException("Malformed AABB entry. Unexpected token: " + in.peek() + " at " + GsonUtils.location(in));
                }
                in.endArray();
                switch (i) {
                    case 1: {
                        list.add(new AABB(ints[0]));
                        break;
                    }
                    case 2: {
                        list.add(new AABB(ints[0], ints[1]));
                        break;
                    }
                    case 3: {
                        list.add(new AABB(ints[0], ints[1], ints[2]));
                        break;
                    }
                    case 4: {
                        list.add(new AABB(ints[0], ints[1], ints[2], ints[3]));
                        break;
                    }
                    case 5: {
                        list.add(new AABB(ints[0], ints[1], ints[2], ints[3], ints[4]));
                        break;
                    }
                    case 6: {
                        list.add(new AABB(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5]));
                    }
                }
            }
            in.endArray();
            return (AABB[])list.toArray(AABB[]::new);
        }

        @Override
        public void write(JsonWriter out, AABB[] aabbs) throws IOException {
            if (aabbs == null || aabbs.length == 0) {
                out.nullValue();
                return;
            }
            out.beginArray();
            for (AABB aabb : aabbs) {
                StringBuilder sb = new StringBuilder();
                sb.append("[ ").append(aabb.minX);
                sb.append(", ").append(aabb.minY);
                if (aabb.hasZ()) {
                    sb.append(", ").append(aabb.minZ);
                }
                if (aabb.isVolume()) {
                    sb.append(", ").append(aabb.maxX);
                    sb.append(", ").append(aabb.maxY);
                    if (aabb.hasZ()) {
                        sb.append(", ").append(aabb.maxZ);
                    }
                }
                sb.append(" ]");
                out.jsonValue(sb.toString());
            }
            out.endArray();
        }
    }
}

