/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import lombok.NonNull;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.config.SeasonalTheme;
import net.runelite.client.plugins.rs117.hd.model.ModelPusher;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.scene.tile_overrides.ExpressionBasedReplacement;
import net.runelite.client.plugins.rs117.hd.scene.tile_overrides.TileOverride;
import net.runelite.client.plugins.rs117.hd.utils.FileWatcher;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.ResourcePath;
import net.runelite.client.plugins.rs117.hd.utils.VariableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TileOverrideManager {
    private static final Logger log = LoggerFactory.getLogger(TileOverrideManager.class);
    private static final ResourcePath TILE_OVERRIDES_PATH = Props.getPathOrDefault("rlhd.tile-overrides-path", () -> ResourcePath.path(TileOverrideManager.class, "tile_overrides.json"));
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPlugin plugin;
    @Inject
    private ModelPusher modelPusher;
    private FileWatcher.UnregisterCallback fileWatcher;
    private ResourcePath tileOverridesPath;
    private boolean trackReplacements;
    private List<Map.Entry<Area, TileOverride>> anyMatchOverrides;
    private ListMultimap<Integer, Map.Entry<Area, TileOverride>> idMatchOverrides;
    private final HslVariables hslVars = new HslVariables();

    public void startUp() {
        this.fileWatcher = TILE_OVERRIDES_PATH.watch((path, first) -> {
            this.tileOverridesPath = path;
            this.reload(first == false);
        });
    }

    public void shutDown() {
        if (this.fileWatcher != null) {
            this.fileWatcher.unregister();
        }
        this.fileWatcher = null;
        this.anyMatchOverrides = null;
        this.idMatchOverrides = null;
    }

    /*
     * WARNING - void declaration
     */
    public void reload(boolean reloadScene) {
        if (this.tileOverridesPath == null) {
            return;
        }
        try {
            void var7_13;
            TileOverride[] allOverrides = this.tileOverridesPath.loadJson(this.plugin.getGson(), TileOverride[].class);
            if (allOverrides == null) {
                throw new IOException("Empty or invalid: " + this.tileOverridesPath);
            }
            HashSet<String> names = new HashSet<String>();
            for (TileOverride tileOverride : allOverrides) {
                if (tileOverride.name == null || names.add(tileOverride.name)) continue;
                log.warn("Removing duplicate tile override name: {}", (Object)tileOverride.name);
                tileOverride.name = null;
            }
            this.checkForReplacementLoops(allOverrides);
            ArrayList<Map.Entry<Area, TileOverride>> anyMatch = new ArrayList<Map.Entry<Area, TileOverride>>();
            ArrayListMultimap<Integer, Map.Entry<Area, TileOverride>> idMatch = ArrayListMultimap.create();
            HashMap<String, Object> constants = new HashMap<String, Object>();
            for (SeasonalTheme season : SeasonalTheme.values()) {
                constants.put(season.name(), season.ordinal());
            }
            constants.put("season", this.plugin.configSeasonalTheme.ordinal());
            constants.put("blending", this.plugin.configGroundBlending);
            constants.put("textures", this.plugin.configGroundTextures);
            boolean bl = false;
            while (var7_13 < allOverrides.length) {
                block14: {
                    TileOverride override = allOverrides[var7_13];
                    try {
                        override.index = var7_13;
                        override.normalize(allOverrides, constants);
                    }
                    catch (Exception ex) {
                        log.warn("Skipping invalid tile override '{}':", (Object)override.name, (Object)ex);
                        break block14;
                    }
                    if (override.area != Area.NONE) {
                        TileOverride replacement = this.trackReplacements ? override : override.resolveConstantReplacements();
                        Map.Entry<Area, TileOverride> entry = Map.entry(override.area, replacement);
                        if (override.ids != null) {
                            for (int id : override.ids) {
                                idMatch.put(id, entry);
                            }
                        } else {
                            anyMatch.add(entry);
                        }
                    }
                }
                ++var7_13;
            }
            this.anyMatchOverrides = anyMatch;
            this.idMatchOverrides = idMatch;
            log.debug("Loaded {} tile overrides", (Object)allOverrides.length);
        }
        catch (IOException ex) {
            log.error("Failed to load tile overrides:", ex);
        }
        if (reloadScene) {
            this.clientThread.invoke(() -> {
                this.modelPusher.clearModelCache();
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    this.client.setGameState(GameState.LOADING);
                }
            });
        }
    }

    private void checkForReplacementLoops(TileOverride[] allOverrides) {
        HashMap<String, TileOverride> relevantOverrides = new HashMap<String, TileOverride>();
        for (TileOverride override : allOverrides) {
            if (override.name == null || override.rawReplacements == null) continue;
            relevantOverrides.put(override.name, override);
        }
        HashSet<String> alreadyChecked = new HashSet<String>();
        for (TileOverride override : relevantOverrides.values()) {
            TileOverrideManager.checkForReplacementLoops(relevantOverrides, alreadyChecked, override);
        }
    }

    private static void checkForReplacementLoops(Map<String, TileOverride> map, Set<String> alreadyChecked, TileOverride topLevelOverride) {
        String name = topLevelOverride.name;
        if (alreadyChecked.add(name)) {
            TileOverrideManager.checkForReplacementLoops(map, alreadyChecked, new ArrayDeque<String>(), name, topLevelOverride);
        }
    }

    private static void checkForReplacementLoops(Map<String, TileOverride> map, Set<String> alreadyChecked, ArrayDeque<String> loop, String topLevelOverrideName, TileOverride overrideToCheck) {
        loop.addLast(overrideToCheck.name);
        for (String replacementName : overrideToCheck.rawReplacements.keySet()) {
            if (topLevelOverrideName.equals(replacementName)) {
                log.warn("Tile override contains replacement loop: {} -> {}", (Object)String.join((CharSequence)" -> ", loop), (Object)replacementName);
                overrideToCheck.rawReplacements.put(replacementName, null);
                continue;
            }
            TileOverride replacement = map.get(replacementName);
            if (replacement == null) continue;
            TileOverrideManager.checkForReplacementLoops(map, alreadyChecked, replacement);
            if (overrideToCheck.rawReplacements.get(replacementName) == null) continue;
            TileOverrideManager.checkForReplacementLoops(map, alreadyChecked, loop, topLevelOverrideName, replacement);
        }
        loop.removeLast();
    }

    public void setTrackReplacements(boolean shouldTrackReplacements) {
        this.trackReplacements = shouldTrackReplacements;
        if (this.plugin.isActive()) {
            this.reload(true);
        }
    }

    @NonNull
    public TileOverride getOverride(Scene scene, Tile tile) {
        return this.getOverride(scene, tile, null, new int[0]);
    }

    @NonNull
    public TileOverride getOverride(Scene scene, Tile tile, @Nullable int[] worldPos, int ... ids) {
        if (worldPos == null) {
            LocalPoint lp = tile.getLocalLocation();
            worldPos = HDUtils.localToWorld(scene, lp.getX(), lp.getY(), tile.getRenderLevel());
        }
        if (ids.length == 0) {
            Point pos = tile.getSceneLocation();
            int x = pos.getX() + 40;
            int y = pos.getY() + 40;
            int z = tile.getRenderLevel();
            int overlayId = Integer.MIN_VALUE | scene.getOverlayIds()[z][x][y];
            int underlayId = scene.getUnderlayIds()[z][x][y];
            ids = new int[]{overlayId, underlayId};
        }
        TileOverride override = this.getOverrideBeforeReplacements(worldPos, ids);
        return this.resolveReplacements(override, tile);
    }

    @NonNull
    public TileOverride getOverrideBeforeReplacements(@Nonnull int[] worldPos, int ... ids) {
        TileOverride match = TileOverride.NONE;
        block0: for (int id : ids) {
            Collection entries = this.idMatchOverrides.get((Object)id);
            for (Map.Entry entry : entries) {
                Area area = (Area)entry.getKey();
                if (!area.containsPoint(worldPos)) continue;
                match = (TileOverride)entry.getValue();
                match.queriedAsOverlay = (id & Integer.MIN_VALUE) != 0;
                break block0;
            }
        }
        Object object = this.anyMatchOverrides.iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            TileOverride override = (TileOverride)entry.getValue();
            if (override.index > match.index) break;
            Area area = (Area)entry.getKey();
            if (!area.containsPoint(worldPos)) continue;
            match = override;
            break;
        }
        return match;
    }

    public TileOverride resolveReplacements(TileOverride override, Tile tile) {
        TileOverride replacement = this.resolveNextReplacement(override, tile);
        if (replacement != override) {
            replacement = this.resolveReplacements(replacement, tile);
        }
        return replacement;
    }

    public TileOverride resolveNextReplacement(TileOverride override, Tile tile) {
        if (override.replacements != null) {
            this.hslVars.setTile(tile);
            for (ExpressionBasedReplacement exprReplacement : override.replacements) {
                TileOverride replacement = override;
                if (exprReplacement.predicate.test(this.hslVars)) {
                    replacement = exprReplacement.replacement;
                }
                if (replacement == null) {
                    return TileOverride.NONE;
                }
                if (replacement == override) continue;
                replacement.queriedAsOverlay = override.queriedAsOverlay;
                return replacement;
            }
            this.hslVars.setTile(null);
        }
        return override;
    }

    private static class HslVariables
    implements VariableSupplier {
        private final String[] HSL_VARS = new String[]{"h", "s", "l"};
        private final int[] hsl = new int[3];
        private Tile tile;
        private boolean requiresHslUpdate;

        private HslVariables() {
        }

        public void setTile(Tile tile) {
            if (tile == this.tile) {
                return;
            }
            this.tile = tile;
            this.requiresHslUpdate = true;
        }

        @Override
        public Object get(String variableName) {
            for (int i = 0; i < this.HSL_VARS.length; ++i) {
                if (!this.HSL_VARS[i].equals(variableName)) continue;
                if (this.requiresHslUpdate) {
                    HDUtils.getSouthWesternMostTileColor(this.hsl, this.tile);
                    this.requiresHslUpdate = false;
                }
                return this.hsl[i];
            }
            throw new IllegalArgumentException("Undefined variable '" + variableName + "'");
        }
    }
}

