/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.HdPluginConfig;
import net.runelite.client.plugins.rs117.hd.data.WaterType;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.scene.ModelOverrideManager;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.ResourcePath;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TextureManager {
    private static final Logger log = LoggerFactory.getLogger(TextureManager.class);
    private static final String[] SUPPORTED_IMAGE_EXTENSIONS = new String[]{"png", "jpg"};
    private static final ResourcePath TEXTURE_PATH = Props.getPathOrDefault("rlhd.texture-path", () -> ResourcePath.path(TextureManager.class, "textures"));
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ScheduledExecutorService executorService;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private ModelOverrideManager modelOverrideManager;
    private int textureArray;
    private int textureSize;
    private IntBuffer pixelBuffer;
    private BufferedImage scaledImage;
    private BufferedImage vanillaImage;
    private float[] vanillaTextureAnimations;
    private ArrayList<MaterialEntry> materialUniformEntries;
    private int[] materialOrdinalToTextureLayer;
    private int[] vanillaTextureIndexToTextureLayer;
    private ScheduledFuture<?> pendingReload;
    private final int[] materialOrdinalToMaterialUniformIndex = new int[Material.values().length];
    private int[] vanillaTextureIndexToMaterialUniformIndex = new int[0];

    public void startUp() {
        this.clientThread.invoke(this::ensureMaterialsAreLoaded);
        TEXTURE_PATH.watch((path, first) -> {
            if (first.booleanValue()) {
                return;
            }
            log.debug("Texture changed: {}", path);
            if (this.pendingReload == null || this.pendingReload.cancel(false) || this.pendingReload.isDone()) {
                this.pendingReload = this.executorService.schedule(this::reloadTextures, 100L, TimeUnit.MILLISECONDS);
            }
        });
    }

    public void shutDown() {
        this.clientThread.invoke(this::freeTextures);
    }

    public void reloadTextures() {
        this.clientThread.invoke(() -> {
            this.freeTextures();
            this.ensureMaterialsAreLoaded();
            this.modelOverrideManager.reload();
        });
    }

    private void freeTextures() {
        if (this.textureArray != 0) {
            GL43C.glDeleteTextures(this.textureArray);
        }
        this.textureArray = 0;
    }

    public int getMaterialIndex(@Nonnull Material material, int vanillaTextureIndex) {
        if (material == Material.VANILLA && vanillaTextureIndex >= 0 && vanillaTextureIndex < this.vanillaTextureIndexToMaterialUniformIndex.length) {
            return this.vanillaTextureIndexToMaterialUniformIndex[vanillaTextureIndex];
        }
        return this.materialOrdinalToMaterialUniformIndex[material.ordinal()];
    }

    public boolean vanillaTexturesAvailable() {
        TextureProvider textureProvider = this.client.getTextureProvider();
        if (textureProvider == null) {
            return false;
        }
        Texture[] vanillaTextures = textureProvider.getTextures();
        if (vanillaTextures == null || vanillaTextures.length == 0) {
            return false;
        }
        for (int i = 0; i < vanillaTextures.length; ++i) {
            int[] pixels;
            Texture texture = vanillaTextures[i];
            if (texture == null || (pixels = textureProvider.load(i)) != null) continue;
            return false;
        }
        return true;
    }

    private void ensureMaterialsAreLoaded() {
        if (this.textureArray != 0) {
            return;
        }
        assert (this.vanillaTexturesAvailable());
        TextureProvider textureProvider = this.client.getTextureProvider();
        Texture[] vanillaTextures = textureProvider.getTextures();
        Material.updateMappings(vanillaTextures, this.plugin);
        this.materialUniformEntries = new ArrayList();
        for (Material material : Material.getActiveMaterials()) {
            this.materialUniformEntries.add(new MaterialEntry(material, material.vanillaTextureIndex));
        }
        ArrayList<TextureLayer> textureLayers = new ArrayList<TextureLayer>();
        this.materialOrdinalToTextureLayer = new int[Material.values().length];
        Arrays.fill(this.materialOrdinalToTextureLayer, -1);
        for (Material textureMaterial : Material.getTextureMaterials()) {
            int layerIndex = textureLayers.size();
            textureLayers.add(new TextureLayer(textureMaterial, textureMaterial.vanillaTextureIndex, layerIndex));
            this.materialOrdinalToTextureLayer[textureMaterial.ordinal()] = layerIndex;
        }
        for (Material material : Material.values()) {
            if (this.materialOrdinalToTextureLayer[material.ordinal()] != -1) continue;
            this.materialOrdinalToTextureLayer[material.ordinal()] = this.materialOrdinalToTextureLayer[material.resolveTextureMaterial().ordinal()];
        }
        this.vanillaTextureIndexToTextureLayer = new int[vanillaTextures.length];
        Arrays.fill(this.vanillaTextureIndexToTextureLayer, -1);
        for (int i = 0; i < vanillaTextures.length; ++i) {
            if (Material.fromVanillaTexture(i) != Material.VANILLA) continue;
            this.materialUniformEntries.add(new MaterialEntry(Material.VANILLA, i));
            int layerIndex = textureLayers.size();
            textureLayers.add(new TextureLayer(Material.VANILLA, i, layerIndex));
            this.vanillaTextureIndexToTextureLayer[i] = layerIndex;
        }
        this.textureSize = this.config.textureResolution().getSize();
        this.textureArray = GL43C.glGenTextures();
        GL43C.glActiveTexture(33985);
        GL43C.glBindTexture(35866, this.textureArray);
        int mipLevels = 1 + (int)Math.floor(HDUtils.log2(this.textureSize));
        int format = 35907;
        if (this.plugin.glCaps.glTexStorage3D != 0L) {
            GL43C.glTexStorage3D(35866, mipLevels, format, this.textureSize, this.textureSize, textureLayers.size());
        } else {
            for (int i = 0; i < mipLevels; ++i) {
                int size = this.textureSize >> i;
                GL43C.glTexImage3D(35866, i, format, size, size, textureLayers.size(), 0, 6408, 5121, 0L);
            }
        }
        GL43C.glTexParameteri(35866, 10242, 10497);
        GL43C.glTexParameteri(35866, 10243, 10497);
        this.setAnisotropicFilteringLevel();
        log.debug("Allocated {}x{} texture array with {} layers", this.textureSize, this.textureSize, textureLayers.size());
        double vanillaBrightness = textureProvider.getBrightness();
        textureProvider.setBrightness(1.0);
        this.pixelBuffer = BufferUtils.createIntBuffer(this.textureSize * this.textureSize);
        this.scaledImage = new BufferedImage(this.textureSize, this.textureSize, 2);
        this.vanillaImage = new BufferedImage(128, 128, 2);
        this.vanillaTextureAnimations = new float[vanillaTextures.length * 2];
        int vanillaTextureCount = 0;
        int hdTextureCount = 0;
        for (TextureLayer textureLayer : textureLayers) {
            Material material = textureLayer.material;
            BufferedImage image = null;
            if (material != Material.VANILLA && (image = this.loadTextureImage(material)) == null && material.vanillaTextureIndex == -1) {
                log.warn("No texture found for material: {}", (Object)material);
                continue;
            }
            if (image == null) {
                int vanillaIndex = textureLayer.vanillaIndex;
                Texture texture = vanillaTextures[vanillaIndex];
                if (texture == null) continue;
                int[] pixels = textureProvider.load(vanillaIndex);
                if (pixels == null) {
                    log.warn("No pixels for vanilla texture at index {}", (Object)vanillaIndex);
                    continue;
                }
                int resolution = (int)Math.round(Math.sqrt(pixels.length));
                if (resolution * resolution != pixels.length) {
                    log.warn("Unknown dimensions for vanilla texture at index {} ({} pixels)", (Object)vanillaIndex, (Object)pixels.length);
                    continue;
                }
                for (int j = 0; j < pixels.length; ++j) {
                    int rgb = pixels[j];
                    int alpha = rgb == 0 ? 0 : 255;
                    this.vanillaImage.setRGB(j % 128, j / 128, alpha << 24 | rgb & 0xFFFFFF);
                }
                image = this.vanillaImage;
                ++vanillaTextureCount;
            } else {
                ++hdTextureCount;
            }
            try {
                this.uploadTexture(textureLayer, image);
            }
            catch (Exception ex) {
                log.error("Failed to load texture {}:", (Object)textureLayer.material, (Object)ex);
            }
        }
        for (int i = 0; i < vanillaTextures.length; ++i) {
            int direction;
            Texture texture = vanillaTextures[i];
            if (texture == null || (direction = texture.getAnimationDirection()) == 0) continue;
            float speed = (float)(texture.getAnimationSpeed() * 50) / 128.0f;
            float radians = (float)direction * -1.5707964f;
            this.vanillaTextureAnimations[i * 2] = (float)Math.cos(radians) * speed;
            this.vanillaTextureAnimations[i * 2 + 1] = (float)Math.sin(radians) * speed;
        }
        log.debug("Loaded {} HD & {} vanilla textures", (Object)hdTextureCount, (Object)vanillaTextureCount);
        GL43C.glGenerateMipmap(35866);
        this.vanillaTextureIndexToMaterialUniformIndex = new int[vanillaTextures.length];
        this.plugin.updateMaterialUniformBuffer(this.generateMaterialUniformBuffer());
        this.plugin.updateWaterTypeUniformBuffer(this.generateWaterTypeUniformBuffer());
        this.pixelBuffer = null;
        this.scaledImage = null;
        this.vanillaImage = null;
        this.vanillaTextureAnimations = null;
        this.materialUniformEntries = null;
        this.materialOrdinalToTextureLayer = null;
        this.vanillaTextureIndexToTextureLayer = null;
        textureProvider.setBrightness(vanillaBrightness);
        GL43C.glActiveTexture(33984);
    }

    private BufferedImage loadTextureImage(Material material) {
        String textureName = material.name().toLowerCase();
        for (String ext : SUPPORTED_IMAGE_EXTENSIONS) {
            ResourcePath path = TEXTURE_PATH.resolve(textureName + "." + ext);
            try {
                return path.loadImage();
            }
            catch (Exception ex) {
                log.trace("Unable to load texture: {}", (Object)path, (Object)ex);
            }
        }
        return null;
    }

    private void uploadTexture(TextureLayer layer, BufferedImage image) {
        AffineTransform t = new AffineTransform();
        if (image != this.vanillaImage) {
            t.translate(this.textureSize, 0.0);
            t.scale(-1.0, 1.0);
        }
        t.scale((double)this.textureSize / (double)image.getWidth(), (double)this.textureSize / (double)image.getHeight());
        AffineTransformOp scaleOp = new AffineTransformOp(t, 3);
        scaleOp.filter(image, this.scaledImage);
        int[] pixels = ((DataBufferInt)this.scaledImage.getRaster().getDataBuffer()).getData();
        this.pixelBuffer.put(pixels).flip();
        GL43C.glTexSubImage3D(35866, 0, 0, 0, layer.index, this.textureSize, this.textureSize, 1, 32993, 33639, this.pixelBuffer);
    }

    private void setAnisotropicFilteringLevel() {
        int level = this.config.anisotropicFilteringLevel();
        if (level == 0) {
            GL43C.glTexParameteri(35866, 10241, 9728);
            GL43C.glTexParameteri(35866, 10240, 9728);
        } else {
            GL43C.glTexParameteri(35866, 10241, 9987);
            GL43C.glTexParameteri(35866, 10240, 9729);
        }
        if (GL.getCapabilities().GL_EXT_texture_filter_anisotropic) {
            float maxSamples = GL43C.glGetFloat(34047);
            float anisoLevel = Math.max(1.0f, Math.min(maxSamples, (float)level));
            GL43C.glTexParameterf(35866, 34046, anisoLevel);
        }
    }

    private ByteBuffer generateMaterialUniformBuffer() {
        int materialBytes = 80;
        ByteBuffer buffer = BufferUtils.createByteBuffer(this.materialUniformEntries.size() * 80);
        for (int i = 0; i < this.materialUniformEntries.size(); ++i) {
            MaterialEntry entry = this.materialUniformEntries.get(i);
            this.materialOrdinalToMaterialUniformIndex[entry.material.ordinal()] = i;
            if (entry.vanillaIndex != -1) {
                this.vanillaTextureIndexToMaterialUniformIndex[entry.vanillaIndex] = i;
            }
            this.writeMaterialData(buffer, entry);
        }
        for (Material material : Material.values()) {
            this.materialOrdinalToMaterialUniformIndex[material.ordinal()] = this.materialOrdinalToMaterialUniformIndex[material.resolveReplacements().ordinal()];
        }
        return buffer.flip();
    }

    private int getTextureLayer(@Nullable Material material) {
        if (material == null) {
            return -1;
        }
        material = material.resolveTextureMaterial();
        return this.materialOrdinalToTextureLayer[material.ordinal()];
    }

    private void writeMaterialData(ByteBuffer buffer, MaterialEntry entry) {
        Material m = entry.material;
        int vanillaIndex = entry.vanillaIndex;
        float scrollSpeedX = m.scrollSpeed[0];
        float scrollSpeedY = m.scrollSpeed[1];
        if (vanillaIndex != -1) {
            scrollSpeedX += this.vanillaTextureAnimations[vanillaIndex * 2];
            scrollSpeedY += this.vanillaTextureAnimations[vanillaIndex * 2 + 1];
        }
        int baseColorTextureIndex = -1;
        if (m == Material.VANILLA) {
            baseColorTextureIndex = this.vanillaTextureIndexToTextureLayer[vanillaIndex];
        } else if (m != Material.NONE) {
            baseColorTextureIndex = this.materialOrdinalToTextureLayer[m.ordinal()];
        }
        buffer.putInt(baseColorTextureIndex).putInt(this.getTextureLayer(m.normalMap)).putInt(this.getTextureLayer(m.displacementMap)).putInt(this.getTextureLayer(m.roughnessMap)).putInt(this.getTextureLayer(m.ambientOcclusionMap)).putInt(this.getTextureLayer(m.flowMap)).putInt((m.overrideBaseColor ? 1 : 0) << 2 | (m.unlit ? 1 : 0) << 1 | (m.hasTransparency ? 1 : 0)).putFloat(m.brightness).putFloat(m.displacementScale).putFloat(m.specularStrength).putFloat(m.specularGloss).putFloat(m.flowMapStrength).putFloat(m.flowMapDuration[0]).putFloat(m.flowMapDuration[1]).putFloat(scrollSpeedX).putFloat(scrollSpeedY).putFloat(1.0f / m.textureScale[0]).putFloat(1.0f / m.textureScale[1]).putFloat(1.0f / m.textureScale[2]).putFloat(0.0f);
    }

    private ByteBuffer generateWaterTypeUniformBuffer() {
        ByteBuffer buffer = BufferUtils.createByteBuffer(WaterType.values().length * 28 * 4);
        for (WaterType type : WaterType.values()) {
            buffer.putInt(type.flat ? 1 : 0).putFloat(type.specularStrength).putFloat(type.specularGloss).putFloat(type.normalStrength).putFloat(type.baseOpacity).putInt(type.hasFoam ? 1 : 0).putFloat(type.duration).putFloat(type.fresnelAmount).putFloat(type.surfaceColor[0]).putFloat(type.surfaceColor[1]).putFloat(type.surfaceColor[2]).putFloat(0.0f).putFloat(type.foamColor[0]).putFloat(type.foamColor[1]).putFloat(type.foamColor[2]).putFloat(0.0f).putFloat(type.depthColor[0]).putFloat(type.depthColor[1]).putFloat(type.depthColor[2]).putFloat(0.0f).putFloat(type.causticsStrength).putInt(this.getTextureLayer(type.normalMap)).putInt(this.getTextureLayer(Material.WATER_FOAM)).putInt(this.getTextureLayer(Material.WATER_FLOW_MAP)).putInt(this.getTextureLayer(Material.UNDERWATER_FLOW_MAP)).putFloat(0.0f).putFloat(0.0f).putFloat(0.0f);
        }
        return buffer.flip();
    }

    private static class MaterialEntry {
        final Material material;
        final int vanillaIndex;

        public MaterialEntry(Material material, int vanillaIndex) {
            this.material = material;
            this.vanillaIndex = vanillaIndex;
        }
    }

    private static class TextureLayer {
        final Material material;
        final int vanillaIndex;
        final int index;

        public TextureLayer(Material material, int vanillaIndex, int index) {
            this.material = material;
            this.vanillaIndex = vanillaIndex;
            this.index = index;
        }
    }
}

