/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import com.google.common.base.Stopwatch;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.HdPluginConfig;
import net.runelite.client.plugins.rs117.hd.data.WaterType;
import net.runelite.client.plugins.rs117.hd.data.materials.GroundMaterial;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.data.materials.UvType;
import net.runelite.client.plugins.rs117.hd.model.ModelPusher;
import net.runelite.client.plugins.rs117.hd.scene.AreaManager;
import net.runelite.client.plugins.rs117.hd.scene.ModelOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.ProceduralGenerator;
import net.runelite.client.plugins.rs117.hd.scene.SceneContext;
import net.runelite.client.plugins.rs117.hd.scene.TileOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.areas.AABB;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.rs117.hd.scene.tile_overrides.TileOverride;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.ModelHash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SceneUploader {
    private static final Logger log = LoggerFactory.getLogger(SceneUploader.class);
    public static final int SCENE_ID_MASK = 65535;
    public static final int EXCLUDED_FROM_SCENE_BUFFER = -1;
    private static final float[] UP_NORMAL = new float[]{0.0f, -1.0f, 0.0f};
    @Inject
    private Client client;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private AreaManager areaManager;
    @Inject
    private TileOverrideManager tileOverrideManager;
    @Inject
    private ModelOverrideManager modelOverrideManager;
    @Inject
    public ProceduralGenerator proceduralGenerator;
    @Inject
    private ModelPusher modelPusher;

    public void upload(SceneContext sceneContext) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Scene scene = sceneContext.scene;
        sceneContext.enableAreaHiding = this.config.hideUnrelatedAreas() && !scene.isInstance();
        sceneContext.fillGaps = this.config.fillGapsInTerrain();
        if (sceneContext.enableAreaHiding) {
            AABB sceneBounds = sceneContext.getNonInstancedSceneBounds();
            sceneContext.possibleAreas = (Area[])Arrays.stream(this.areaManager.areasWithAreaHiding).filter(area -> sceneBounds.intersects(area.aabbs)).toArray(Area[]::new);
            if (log.isDebugEnabled() && sceneContext.possibleAreas.length > 0) {
                log.debug("Hiding areas outside of {}", (Object)Arrays.stream(sceneContext.possibleAreas).distinct().map(Area::toString).collect(Collectors.joining(", ")));
            }
        }
        if (this.client.isClientThread()) {
            this.prepareBeforeSwap(sceneContext);
        }
        sceneContext.staticCustomTilesOffset = sceneContext.staticVertexCount;
        Tile[][][] tiles = scene.getExtendedTiles();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 184; ++x) {
                for (int y = 0; y < 184; ++y) {
                    Tile tile = tiles[z][x][y];
                    if (tile == null) continue;
                    this.upload(sceneContext, tile, x, y);
                }
            }
        }
        sceneContext.staticCustomTilesVertexCount = sceneContext.staticVertexCount - sceneContext.staticCustomTilesOffset;
        stopwatch.stop();
        log.debug("Scene upload time: {}, unique models: {}, size: {} MB", stopwatch, sceneContext.uniqueModels, String.format("%.2f", (double)(sceneContext.getVertexOffset() * 8 * 4 + sceneContext.getUvOffset() * 4 * 4) / 1000000.0));
    }

    public void prepareBeforeSwap(SceneContext sceneContext) {
        assert (this.client.isClientThread());
        if (sceneContext.isPrepared) {
            return;
        }
        sceneContext.isPrepared = true;
        if (sceneContext.enableAreaHiding) {
            this.removeTilesOutsideCurrentArea(sceneContext);
        }
        if (sceneContext.fillGaps) {
            sceneContext.staticGapFillerTilesOffset = sceneContext.staticVertexCount;
            this.fillGaps(sceneContext);
            sceneContext.staticGapFillerTilesVertexCount = sceneContext.staticVertexCount - sceneContext.staticGapFillerTilesOffset;
        }
    }

    public void updatePlayerArea(SceneContext sceneContext) {
        if (!sceneContext.enableAreaHiding) {
            sceneContext.currentArea = null;
            return;
        }
        LocalPoint lp = this.client.getLocalPlayer().getLocalLocation();
        int[] worldPos = new int[]{sceneContext.scene.getBaseX() + lp.getSceneX(), sceneContext.scene.getBaseY() + lp.getSceneY(), this.client.getPlane()};
        if (sceneContext.currentArea == null || !sceneContext.currentArea.containsPoint(worldPos)) {
            sceneContext.currentArea = null;
            for (Area area : sceneContext.possibleAreas) {
                if (!area.containsPoint(worldPos)) continue;
                sceneContext.currentArea = area;
                break;
            }
        }
    }

    private void removeTilesOutsideCurrentArea(SceneContext sceneContext) {
        this.updatePlayerArea(sceneContext);
        if (sceneContext.currentArea == null) {
            return;
        }
        Tile[][][] tiles = sceneContext.scene.getExtendedTiles();
        int baseExX = sceneContext.getBaseExX();
        int baseExY = sceneContext.getBaseExY();
        for (int z = 0; z < 4; ++z) {
            for (int x = 0; x < 184; ++x) {
                for (int y = 0; y < 184; ++y) {
                    Tile tile = tiles[z][x][y];
                    if (tile == null || sceneContext.currentArea.containsPoint(baseExX + x, baseExY + y, z)) continue;
                    sceneContext.scene.removeTile(tile);
                }
            }
        }
    }

    private void fillGaps(SceneContext sceneContext) {
        if (sceneContext.currentArea != null && !sceneContext.currentArea.fillGaps) {
            return;
        }
        int sceneMin = -sceneContext.expandedMapLoadingChunks * 8;
        int sceneMax = 104 + sceneContext.expandedMapLoadingChunks * 8;
        int baseExX = sceneContext.getBaseExX();
        int baseExY = sceneContext.getBaseExY();
        Tile[][][] extendedTiles = sceneContext.scene.getExtendedTiles();
        for (int tileZ = 0; tileZ < 4; ++tileZ) {
            for (int tileExX = 0; tileExX < 184; ++tileExX) {
                for (int tileExY = 0; tileExY < 184; ++tileExY) {
                    int vertexCount;
                    boolean fillGaps;
                    if (sceneContext.currentArea != null && !sceneContext.currentArea.containsPoint(baseExX + tileExX, baseExY + tileExY, tileZ)) continue;
                    int tileX = tileExX - 40;
                    int tileY = tileExY - 40;
                    Tile tile = extendedTiles[tileZ][tileExX][tileExY];
                    SceneTileModel model = null;
                    int renderLevel = tileZ;
                    if (tile != null) {
                        renderLevel = tile.getRenderLevel();
                        SceneTilePaint paint = tile.getSceneTilePaint();
                        model = tile.getSceneTileModel();
                        if (model == null) {
                            boolean hasTilePaint;
                            boolean bl = hasTilePaint = paint != null && paint.getNeColor() != 12345678;
                            if (!hasTilePaint && (tile = tile.getBridge()) != null) {
                                renderLevel = tile.getRenderLevel();
                                paint = tile.getSceneTilePaint();
                                model = tile.getSceneTileModel();
                                boolean bl2 = hasTilePaint = paint != null && paint.getNeColor() != 12345678;
                            }
                            if (hasTilePaint) continue;
                        }
                    }
                    int[] worldPoint = sceneContext.sceneToWorld(tileX, tileY, tileZ);
                    boolean bl = fillGaps = tileZ == 0 && tileX > sceneMin && tileY > sceneMin && tileX < sceneMax - 1 && tileY < sceneMax - 1 && Area.OVERWORLD.containsPoint(worldPoint);
                    if (fillGaps) {
                        int tileRegionID = HDUtils.worldToRegionID(worldPoint);
                        int[] regions = this.client.getMapRegions();
                        fillGaps = false;
                        for (int region : regions) {
                            if (region != tileRegionID) continue;
                            fillGaps = true;
                            break;
                        }
                    }
                    if (!fillGaps) continue;
                    int vertexOffset = sceneContext.getVertexOffset();
                    int uvOffset = sceneContext.getUvOffset();
                    if (model == null) {
                        this.uploadBlackTile(sceneContext, tileExX, tileExY, renderLevel);
                        vertexCount = 6;
                    } else {
                        int[] worldPos = sceneContext.sceneToWorld(tileX, tileY, tileZ);
                        int[] uploadedTileModelData = this.uploadHDTileModelSurface(sceneContext, tile, worldPos, model, true);
                        vertexCount = uploadedTileModelData[0];
                    }
                    if (vertexCount <= 0) continue;
                    sceneContext.staticUnorderedModelBuffer.ensureCapacity(8).getBuffer().put(vertexOffset).put(uvOffset).put(vertexCount / 3).put(sceneContext.staticVertexCount).put(0).put(tileX * 128).put(0).put(tileY * 128);
                    sceneContext.staticVertexCount += vertexCount;
                }
            }
        }
    }

    private void uploadModel(SceneContext sceneContext, Tile tile, int uuid, Model model, int orientation) {
        if (model.getUnskewedModel() != null) {
            model = model.getUnskewedModel();
        }
        if (model.getSceneId() == -1) {
            return;
        }
        int[] worldPos = sceneContext.localToWorld(tile.getLocalLocation(), tile.getPlane());
        ModelOverride modelOverride = this.modelOverrideManager.getOverride(uuid, worldPos);
        int sceneId = modelOverride.hashCode() << 16 | sceneContext.id;
        if ((model.getSceneId() & 0xFFFF) == sceneContext.id) {
            if (model.getSceneId() != sceneId) {
                model.setSceneId(-1);
            }
            return;
        }
        int vertexOffset = sceneContext.getVertexOffset();
        int uvOffset = sceneContext.getUvOffset();
        if (modelOverride.hide) {
            vertexOffset = -1;
        } else {
            this.modelPusher.pushModel(sceneContext, tile, uuid, model, modelOverride, orientation, false);
            if (sceneContext.modelPusherResults[1] == 0) {
                uvOffset = -1;
            }
        }
        model.setBufferOffset(vertexOffset);
        model.setUvBufferOffset(uvOffset);
        model.setSceneId(sceneId);
        ++sceneContext.uniqueModels;
    }

    private void upload(SceneContext sceneContext, @Nonnull Tile tile, int tileExX, int tileExY) {
        GameObject[] gameObjects;
        DecorativeObject decorativeObject;
        Renderable renderable;
        GroundObject groundObject;
        WallObject wallObject;
        SceneTileModel sceneTileModel;
        Tile bridge = tile.getBridge();
        if (bridge != null) {
            this.upload(sceneContext, bridge, tileExX, tileExY);
        }
        int[] worldPos = sceneContext.localToWorld(tile.getLocalLocation(), tile.getPlane());
        TileOverride override = this.tileOverrideManager.getOverride(sceneContext.scene, tile, worldPos, new int[0]);
        SceneTilePaint sceneTilePaint = tile.getSceneTilePaint();
        if (sceneTilePaint != null || override.forced) {
            byte[] byArray = sceneContext.filledTiles[tileExX];
            int n = tileExY;
            byArray[n] = (byte)(byArray[n] | (byte)(1 << tile.getPlane()));
            boolean depthTested = override.depthTested || override.forced && (sceneTilePaint == null || sceneTilePaint.getNeColor() == 12345678);
            int vertexOffset = sceneContext.getVertexOffset();
            int uvOffset = sceneContext.getUvOffset();
            int[] uploadedTilePaintData = this.upload(sceneContext, tile, worldPos, override, sceneTilePaint);
            int vertexCount = uploadedTilePaintData[0];
            int uvCount = uploadedTilePaintData[1];
            if (vertexCount > 0 && depthTested) {
                int tileX = tileExX - 40;
                int tileY = tileExY - 40;
                sceneContext.staticUnorderedModelBuffer.ensureCapacity(8).getBuffer().put(vertexOffset).put(uvOffset).put(vertexCount / 3).put(sceneContext.staticVertexCount).put(0).put(tileX * 128).put(0).put(tileY * 128);
                sceneContext.staticVertexCount += vertexCount;
                vertexCount = 0;
                uvCount = 0;
            }
            if (uvCount <= 0) {
                uvOffset = -1;
            }
            if (sceneTilePaint != null) {
                sceneTilePaint.setBufferLen(vertexCount);
                sceneTilePaint.setBufferOffset(vertexOffset);
                sceneTilePaint.setUvBufferOffset(uvOffset);
            }
        }
        if ((sceneTileModel = tile.getSceneTileModel()) != null) {
            byte[] byArray = sceneContext.filledTiles[tileExX];
            int n = tileExY;
            byArray[n] = (byte)(byArray[n] | (byte)(1 << tile.getPlane()));
            sceneTileModel.setBufferOffset(sceneContext.getVertexOffset());
            sceneTileModel.setUvBufferOffset(sceneContext.getUvOffset());
            int[] uploadedTileModelData = this.upload(sceneContext, tile, worldPos, sceneTileModel);
            int bufferLength = uploadedTileModelData[0];
            int uvBufferLength = uploadedTileModelData[1];
            int underwaterTerrain = uploadedTileModelData[2];
            if (uvBufferLength <= 0) {
                sceneTileModel.setUvBufferOffset(-1);
            }
            int packedBufferLength = bufferLength << 1 | underwaterTerrain;
            sceneTileModel.setBufferLen(packedBufferLength);
        }
        if ((wallObject = tile.getWallObject()) != null) {
            Renderable renderable2;
            Renderable renderable1 = wallObject.getRenderable1();
            if (renderable1 instanceof Model) {
                this.uploadModel(sceneContext, tile, ModelHash.packUuid(18, wallObject.getId()), (Model)renderable1, HDUtils.convertWallObjectOrientation(wallObject.getOrientationA()));
            }
            if ((renderable2 = wallObject.getRenderable2()) instanceof Model) {
                this.uploadModel(sceneContext, tile, ModelHash.packUuid(18, wallObject.getId()), (Model)renderable2, HDUtils.convertWallObjectOrientation(wallObject.getOrientationB()));
            }
        }
        if ((groundObject = tile.getGroundObject()) != null && (renderable = groundObject.getRenderable()) instanceof Model) {
            this.uploadModel(sceneContext, tile, ModelHash.packUuid(34, groundObject.getId()), (Model)renderable, HDUtils.getBakedOrientation(groundObject.getConfig()));
        }
        if ((decorativeObject = tile.getDecorativeObject()) != null) {
            Renderable renderable2;
            Renderable renderable3 = decorativeObject.getRenderable();
            int orientation = HDUtils.getBakedOrientation(decorativeObject.getConfig());
            if (renderable3 instanceof Model) {
                this.uploadModel(sceneContext, tile, ModelHash.packUuid(50, decorativeObject.getId()), (Model)renderable3, orientation);
            }
            if ((renderable2 = decorativeObject.getRenderable2()) instanceof Model) {
                this.uploadModel(sceneContext, tile, ModelHash.packUuid(50, decorativeObject.getId()), (Model)renderable2, orientation);
            }
        }
        for (GameObject gameObject : gameObjects = tile.getGameObjects()) {
            Renderable renderable4;
            if (gameObject == null || !((renderable4 = gameObject.getRenderable()) instanceof Model)) continue;
            this.uploadModel(sceneContext, tile, ModelHash.packUuid(66, gameObject.getId()), (Model)gameObject.getRenderable(), HDUtils.getBakedOrientation(gameObject.getConfig()));
        }
    }

    private int[] upload(SceneContext sceneContext, Tile tile, int[] worldPos, TileOverride override, @Nullable SceneTilePaint paint) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        WaterType waterType = WaterType.NONE;
        if (paint != null) {
            waterType = this.proceduralGenerator.seasonalWaterType(override, paint.getTexture());
        }
        int[] bufferLengths = this.uploadHDTilePaintUnderwater(sceneContext, tile, worldPos, waterType);
        bufferLength += bufferLengths[0];
        uvBufferLength += bufferLengths[1];
        underwaterTerrain += bufferLengths[2];
        bufferLengths = this.uploadHDTilePaintSurface(sceneContext, tile, worldPos, waterType, paint, override);
        return new int[]{bufferLength += bufferLengths[0], uvBufferLength += bufferLengths[1], underwaterTerrain += bufferLengths[2]};
    }

    private int[] uploadHDTilePaintSurface(SceneContext sceneContext, Tile tile, int[] worldPos, WaterType waterType, @Nullable SceneTilePaint paint, TileOverride override) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileExX = tileX + 40;
        int tileExY = tileY + 40;
        int tileZ = tile.getRenderLevel();
        boolean localX = false;
        boolean localY = false;
        int[][][] tileHeights = scene.getTileHeights();
        int swHeight = tileHeights[tileZ][tileExX][tileExY];
        int seHeight = tileHeights[tileZ][tileExX + 1][tileExY];
        int neHeight = tileHeights[tileZ][tileExX + 1][tileExY + 1];
        int nwHeight = tileHeights[tileZ][tileExX][tileExY + 1];
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        boolean localSwVertexX = false;
        boolean localSwVertexY = false;
        int localSeVertexX = 128;
        boolean localSeVertexY = false;
        boolean localNwVertexX = false;
        int localNwVertexY = 128;
        int localNeVertexX = 128;
        int localNeVertexY = 128;
        int[] vertexKeys = ProceduralGenerator.tileVertexKeys(scene, tile);
        int swVertexKey = vertexKeys[0];
        int seVertexKey = vertexKeys[1];
        int nwVertexKey = vertexKeys[2];
        int neVertexKey = vertexKeys[3];
        int uvOrientation = 0;
        float uvScale = 1.0f;
        if (paint != null && paint.getNeColor() != 12345678 || override.forced) {
            int swColor = 0;
            int seColor = 0;
            int neColor = 0;
            int nwColor = 0;
            int textureId = -1;
            if (paint != null) {
                swColor = paint.getSwColor();
                seColor = paint.getSeColor();
                neColor = paint.getNeColor();
                nwColor = paint.getNwColor();
                textureId = paint.getTexture();
            }
            boolean neVertexIsOverlay = false;
            boolean nwVertexIsOverlay = false;
            boolean seVertexIsOverlay = false;
            boolean swVertexIsOverlay = false;
            Material swMaterial = Material.NONE;
            Material seMaterial = Material.NONE;
            Material neMaterial = Material.NONE;
            Material nwMaterial = Material.NONE;
            float[] swNormals = UP_NORMAL;
            float[] seNormals = UP_NORMAL;
            float[] neNormals = UP_NORMAL;
            float[] nwNormals = UP_NORMAL;
            if (waterType == WaterType.NONE) {
                if (textureId != -1) {
                    Material material = Material.fromVanillaTexture(textureId);
                    if (material == Material.VANILLA) {
                        override = TileOverride.NONE;
                    }
                    neMaterial = nwMaterial = material;
                    seMaterial = nwMaterial;
                    swMaterial = nwMaterial;
                }
                swNormals = sceneContext.vertexTerrainNormals.getOrDefault(swVertexKey, swNormals);
                seNormals = sceneContext.vertexTerrainNormals.getOrDefault(seVertexKey, seNormals);
                neNormals = sceneContext.vertexTerrainNormals.getOrDefault(neVertexKey, neNormals);
                nwNormals = sceneContext.vertexTerrainNormals.getOrDefault(nwVertexKey, nwNormals);
                boolean useBlendedMaterialAndColor = this.plugin.configGroundBlending && textureId == -1 && !this.proceduralGenerator.useDefaultColor(tile, override);
                GroundMaterial groundMaterial = null;
                if (override != TileOverride.NONE) {
                    groundMaterial = override.groundMaterial;
                    uvOrientation = override.uvOrientation;
                    uvScale = override.uvScale;
                    if (!useBlendedMaterialAndColor) {
                        swColor = override.modifyColor(swColor);
                        seColor = override.modifyColor(seColor);
                        nwColor = override.modifyColor(nwColor);
                        neColor = override.modifyColor(neColor);
                    }
                    swHeight -= override.heightOffset;
                    seHeight -= override.heightOffset;
                    neHeight -= override.heightOffset;
                    nwHeight -= override.heightOffset;
                } else if (textureId == -1) {
                    groundMaterial = override.groundMaterial;
                }
                if (useBlendedMaterialAndColor) {
                    swColor = sceneContext.vertexTerrainColor.getOrDefault(swVertexKey, swColor);
                    seColor = sceneContext.vertexTerrainColor.getOrDefault(seVertexKey, seColor);
                    neColor = sceneContext.vertexTerrainColor.getOrDefault(neVertexKey, neColor);
                    nwColor = sceneContext.vertexTerrainColor.getOrDefault(nwVertexKey, nwColor);
                    if (this.plugin.configGroundTextures) {
                        swMaterial = sceneContext.vertexTerrainTexture.getOrDefault(swVertexKey, swMaterial);
                        seMaterial = sceneContext.vertexTerrainTexture.getOrDefault(seVertexKey, seMaterial);
                        neMaterial = sceneContext.vertexTerrainTexture.getOrDefault(neVertexKey, neMaterial);
                        nwMaterial = sceneContext.vertexTerrainTexture.getOrDefault(nwVertexKey, nwMaterial);
                    }
                } else if (this.plugin.configGroundTextures && groundMaterial != null) {
                    swMaterial = groundMaterial.getRandomMaterial(worldPos[0], worldPos[1], worldPos[2]);
                    seMaterial = groundMaterial.getRandomMaterial(worldPos[0] + 1, worldPos[1], worldPos[2]);
                    nwMaterial = groundMaterial.getRandomMaterial(worldPos[0], worldPos[1] + 1, worldPos[2]);
                    neMaterial = groundMaterial.getRandomMaterial(worldPos[0] + 1, worldPos[1] + 1, worldPos[2]);
                }
            } else {
                neColor = 127;
                nwColor = 127;
                seColor = 127;
                swColor = 127;
                if (sceneContext.vertexIsWater.containsKey(swVertexKey) && sceneContext.vertexIsLand.containsKey(swVertexKey)) {
                    swColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(seVertexKey) && sceneContext.vertexIsLand.containsKey(seVertexKey)) {
                    seColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(nwVertexKey) && sceneContext.vertexIsLand.containsKey(nwVertexKey)) {
                    nwColor = 0;
                }
                if (sceneContext.vertexIsWater.containsKey(neVertexKey) && sceneContext.vertexIsLand.containsKey(neVertexKey)) {
                    neColor = 0;
                }
            }
            if (sceneContext.vertexIsOverlay.containsKey(neVertexKey) && sceneContext.vertexIsUnderlay.containsKey(neVertexKey)) {
                neVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(nwVertexKey) && sceneContext.vertexIsUnderlay.containsKey(nwVertexKey)) {
                nwVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(seVertexKey) && sceneContext.vertexIsUnderlay.containsKey(seVertexKey)) {
                seVertexIsOverlay = true;
            }
            if (sceneContext.vertexIsOverlay.containsKey(swVertexKey) && sceneContext.vertexIsUnderlay.containsKey(swVertexKey)) {
                swVertexIsOverlay = true;
            }
            int terrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(24);
            sceneContext.stagingBufferNormals.put(neNormals[0], neNormals[2], neNormals[1], terrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], terrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], terrainData);
            sceneContext.stagingBufferNormals.put(swNormals[0], swNormals[2], swNormals[1], terrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], terrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], terrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(24);
            sceneContext.stagingBufferVertices.put(localNeVertexX, neHeight, localNeVertexY, neColor);
            sceneContext.stagingBufferVertices.put((float)localNwVertexX, nwHeight, localNwVertexY, nwColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight, (float)localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put((float)localSwVertexX, swHeight, (float)localSwVertexY, swColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight, (float)localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put((float)localNwVertexX, nwHeight, localNwVertexY, nwColor);
            bufferLength += 6;
            int packedMaterialDataSW = this.modelPusher.packMaterialData(swMaterial, textureId, ModelOverride.NONE, UvType.GEOMETRY, swVertexIsOverlay);
            int packedMaterialDataSE = this.modelPusher.packMaterialData(seMaterial, textureId, ModelOverride.NONE, UvType.GEOMETRY, seVertexIsOverlay);
            int packedMaterialDataNW = this.modelPusher.packMaterialData(nwMaterial, textureId, ModelOverride.NONE, UvType.GEOMETRY, nwVertexIsOverlay);
            int packedMaterialDataNE = this.modelPusher.packMaterialData(neMaterial, textureId, ModelOverride.NONE, UvType.GEOMETRY, neVertexIsOverlay);
            float uvcos = -uvScale;
            float uvsin = 0.0f;
            if (uvOrientation % 2048 != 0) {
                float rad = (float)(-uvOrientation) * 0.0030679617f;
                uvcos = (float)Math.cos(rad) * -uvScale;
                uvsin = (float)Math.sin(rad) * -uvScale;
            }
            float uvx = worldPos[0];
            float uvy = worldPos[1];
            float tmp = uvx;
            uvx = uvx * uvcos - uvy * uvsin;
            uvy = tmp * uvsin + uvy * uvcos;
            sceneContext.stagingBufferUvs.ensureCapacity(24);
            sceneContext.stagingBufferUvs.put(uvx, uvy, 0.0f, packedMaterialDataNE);
            sceneContext.stagingBufferUvs.put(uvx - uvcos, uvy - uvsin, 0.0f, packedMaterialDataNW);
            sceneContext.stagingBufferUvs.put(uvx + uvsin, uvy - uvcos, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(uvx - uvcos + uvsin, uvy - uvsin - uvcos, 0.0f, packedMaterialDataSW);
            sceneContext.stagingBufferUvs.put(uvx + uvsin, uvy - uvcos, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(uvx - uvcos, uvy - uvsin, 0.0f, packedMaterialDataNW);
            uvBufferLength += 6;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] uploadHDTilePaintUnderwater(SceneContext sceneContext, Tile tile, int[] worldPos, WaterType waterType) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileExX = tileX + 40;
        int tileExY = tileY + 40;
        int tileZ = tile.getRenderLevel();
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        if (baseX >= 2816 && baseX <= 2970 && baseY <= 5375 && baseY >= 5220) {
            return new int[]{0, 0, 0};
        }
        int[][][] tileHeights = scene.getTileHeights();
        int swHeight = tileHeights[tileZ][tileExX][tileExY];
        int seHeight = tileHeights[tileZ][tileExX + 1][tileExY];
        int neHeight = tileHeights[tileZ][tileExX + 1][tileExY + 1];
        int nwHeight = tileHeights[tileZ][tileExX][tileExY + 1];
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        boolean localSwVertexX = false;
        boolean localSwVertexY = false;
        int localSeVertexX = 128;
        boolean localSeVertexY = false;
        boolean localNwVertexX = false;
        int localNwVertexY = 128;
        int localNeVertexX = 128;
        int localNeVertexY = 128;
        int[] vertexKeys = ProceduralGenerator.tileVertexKeys(scene, tile);
        int swVertexKey = vertexKeys[0];
        int seVertexKey = vertexKeys[1];
        int nwVertexKey = vertexKeys[2];
        int neVertexKey = vertexKeys[3];
        if (sceneContext.tileIsWater[tileZ][tileExX][tileExY]) {
            underwaterTerrain = 1;
            int swColor = 6676;
            int seColor = 6676;
            int neColor = 6676;
            int nwColor = 6676;
            int swDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(swVertexKey, 0);
            int seDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(seVertexKey, 0);
            int nwDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(nwVertexKey, 0);
            int neDepth = sceneContext.vertexUnderwaterDepth.getOrDefault(neVertexKey, 0);
            float[] swNormals = sceneContext.vertexTerrainNormals.getOrDefault(swVertexKey, UP_NORMAL);
            float[] seNormals = sceneContext.vertexTerrainNormals.getOrDefault(seVertexKey, UP_NORMAL);
            float[] nwNormals = sceneContext.vertexTerrainNormals.getOrDefault(nwVertexKey, UP_NORMAL);
            float[] neNormals = sceneContext.vertexTerrainNormals.getOrDefault(neVertexKey, UP_NORMAL);
            Material swMaterial = Material.NONE;
            Material seMaterial = Material.NONE;
            Material nwMaterial = Material.NONE;
            Material neMaterial = Material.NONE;
            if (this.plugin.configGroundTextures) {
                GroundMaterial groundMaterial = GroundMaterial.UNDERWATER_GENERIC;
                swMaterial = groundMaterial.getRandomMaterial(worldPos[0], worldPos[1], worldPos[2]);
                seMaterial = groundMaterial.getRandomMaterial(worldPos[0] + 1, worldPos[1], worldPos[2]);
                nwMaterial = groundMaterial.getRandomMaterial(worldPos[0], worldPos[1] + 1, worldPos[2]);
                neMaterial = groundMaterial.getRandomMaterial(worldPos[0] + 1, worldPos[1] + 1, worldPos[2]);
            }
            int swTerrainData = SceneUploader.packTerrainData(true, Math.max(1, swDepth), waterType, tileZ);
            int seTerrainData = SceneUploader.packTerrainData(true, Math.max(1, seDepth), waterType, tileZ);
            int nwTerrainData = SceneUploader.packTerrainData(true, Math.max(1, nwDepth), waterType, tileZ);
            int neTerrainData = SceneUploader.packTerrainData(true, Math.max(1, neDepth), waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(24);
            sceneContext.stagingBufferNormals.put(neNormals[0], neNormals[2], neNormals[1], neTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(swNormals[0], swNormals[2], swNormals[1], swTerrainData);
            sceneContext.stagingBufferNormals.put(seNormals[0], seNormals[2], seNormals[1], seTerrainData);
            sceneContext.stagingBufferNormals.put(nwNormals[0], nwNormals[2], nwNormals[1], nwTerrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(24);
            sceneContext.stagingBufferVertices.put(localNeVertexX, neHeight + neDepth, localNeVertexY, neColor);
            sceneContext.stagingBufferVertices.put((float)localNwVertexX, nwHeight + nwDepth, localNwVertexY, nwColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight + seDepth, (float)localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put((float)localSwVertexX, swHeight + swDepth, (float)localSwVertexY, swColor);
            sceneContext.stagingBufferVertices.put(localSeVertexX, seHeight + seDepth, (float)localSeVertexY, seColor);
            sceneContext.stagingBufferVertices.put((float)localNwVertexX, nwHeight + nwDepth, localNwVertexY, nwColor);
            bufferLength += 6;
            int packedMaterialDataSW = this.modelPusher.packMaterialData(swMaterial, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataSE = this.modelPusher.packMaterialData(seMaterial, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataNW = this.modelPusher.packMaterialData(nwMaterial, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
            int packedMaterialDataNE = this.modelPusher.packMaterialData(neMaterial, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
            sceneContext.stagingBufferUvs.ensureCapacity(24);
            sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialDataNE);
            sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialDataNW);
            sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialDataSW);
            sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialDataSE);
            sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialDataNW);
            uvBufferLength += 6;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] upload(SceneContext sceneContext, Tile tile, int[] worldPos, SceneTileModel sceneTileModel) {
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int[] bufferLengths = this.uploadHDTileModelSurface(sceneContext, tile, worldPos, sceneTileModel, false);
        bufferLength += bufferLengths[0];
        uvBufferLength += bufferLengths[1];
        underwaterTerrain += bufferLengths[2];
        bufferLengths = this.uploadHDTileModelUnderwater(sceneContext, tile, worldPos, sceneTileModel);
        assert (bufferLengths[0] == bufferLength || bufferLengths[0] == 0);
        return new int[]{bufferLength += bufferLengths[0], uvBufferLength += bufferLengths[1], underwaterTerrain += bufferLengths[2]};
    }

    private int[] uploadHDTileModelSurface(SceneContext sceneContext, Tile tile, int[] worldPos, SceneTileModel model, boolean fillGaps) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileExX = tileX + 40;
        int tileExY = tileY + 40;
        int tileZ = tile.getRenderLevel();
        if (sceneContext.skipTile[tileZ][tileExX][tileExY]) {
            return new int[3];
        }
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        int[] faceColorA = model.getTriangleColorA();
        int[] faceColorB = model.getTriangleColorB();
        int[] faceColorC = model.getTriangleColorC();
        int[] faceTextures = model.getTriangleTextureId();
        int faceCount = model.getFaceX().length;
        int overlayId = Integer.MIN_VALUE | scene.getOverlayIds()[tileZ][tileExX][tileExY];
        int underlayId = scene.getUnderlayIds()[tileZ][tileExX][tileExY];
        for (int face = 0; face < faceCount; ++face) {
            boolean isHidden;
            int colorA = faceColorA[face];
            int colorB = faceColorB[face];
            int colorC = faceColorC[face];
            int[][] localVertices = ProceduralGenerator.faceLocalVertices(tile, face);
            int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
            int vertexKeyA = vertexKeys[0];
            int vertexKeyB = vertexKeys[1];
            int vertexKeyC = vertexKeys[2];
            boolean vertexAIsOverlay = false;
            boolean vertexBIsOverlay = false;
            boolean vertexCIsOverlay = false;
            int textureId = -1;
            Material materialA = Material.NONE;
            Material materialB = Material.NONE;
            Material materialC = Material.NONE;
            int uvOrientation = 0;
            float uvScale = 1.0f;
            float[] normalsA = UP_NORMAL;
            float[] normalsB = UP_NORMAL;
            float[] normalsC = UP_NORMAL;
            WaterType waterType = WaterType.NONE;
            boolean bl = isHidden = colorA == 12345678;
            if (fillGaps) {
                if (!isHidden) continue;
                colorC = 0;
                colorB = 0;
                colorA = 0;
            } else {
                boolean isOverlay = ProceduralGenerator.isOverlayFace(tile, face);
                TileOverride override = this.tileOverrideManager.getOverride(scene, tile, worldPos, isOverlay ? overlayId : underlayId);
                if (isHidden && !override.forced) continue;
                textureId = faceTextures == null ? -1 : faceTextures[face];
                waterType = this.proceduralGenerator.seasonalWaterType(override, textureId);
                if (waterType == WaterType.NONE) {
                    boolean useBlendedMaterialAndColor;
                    if (textureId != -1) {
                        Material material = Material.fromVanillaTexture(textureId);
                        if (material == Material.VANILLA) {
                            override = TileOverride.NONE;
                        }
                        materialB = materialC = material;
                        materialA = materialC;
                    }
                    normalsA = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyA, normalsA);
                    normalsB = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyB, normalsB);
                    normalsC = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyC, normalsC);
                    GroundMaterial groundMaterial = null;
                    boolean bl2 = useBlendedMaterialAndColor = this.plugin.configGroundBlending && textureId == -1 && (!isOverlay || !this.proceduralGenerator.useDefaultColor(tile, override));
                    if (override != TileOverride.NONE) {
                        groundMaterial = override.groundMaterial;
                        uvOrientation = override.uvOrientation;
                        uvScale = override.uvScale;
                        if (!useBlendedMaterialAndColor) {
                            colorA = override.modifyColor(colorA);
                            colorB = override.modifyColor(colorB);
                            colorC = override.modifyColor(colorC);
                        }
                    } else if (textureId == -1) {
                        groundMaterial = override.groundMaterial;
                    }
                    if (useBlendedMaterialAndColor) {
                        colorA = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyA, colorA);
                        colorB = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyB, colorB);
                        colorC = sceneContext.vertexTerrainColor.getOrDefault(vertexKeyC, colorC);
                        if (this.plugin.configGroundTextures) {
                            materialA = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyA, materialA);
                            materialB = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyB, materialB);
                            materialC = sceneContext.vertexTerrainTexture.getOrDefault(vertexKeyC, materialC);
                        }
                    } else if (this.plugin.configGroundTextures && groundMaterial != null) {
                        materialA = groundMaterial.getRandomMaterial(worldPos[0] + (localVertices[0][0] >> 7), worldPos[1] + (localVertices[0][1] >> 7), worldPos[2]);
                        materialB = groundMaterial.getRandomMaterial(worldPos[0] + (localVertices[1][0] >> 7), worldPos[1] + (localVertices[1][1] >> 7), worldPos[2]);
                        materialC = groundMaterial.getRandomMaterial(worldPos[0] + (localVertices[2][0] >> 7), worldPos[1] + (localVertices[2][1] >> 7), worldPos[2]);
                    }
                } else {
                    textureId = -1;
                    colorC = 127;
                    colorB = 127;
                    colorA = 127;
                    if (sceneContext.vertexIsWater.containsKey(vertexKeyA) && sceneContext.vertexIsLand.containsKey(vertexKeyA)) {
                        colorA = 0;
                    }
                    if (sceneContext.vertexIsWater.containsKey(vertexKeyB) && sceneContext.vertexIsLand.containsKey(vertexKeyB)) {
                        colorB = 0;
                    }
                    if (sceneContext.vertexIsWater.containsKey(vertexKeyC) && sceneContext.vertexIsLand.containsKey(vertexKeyC)) {
                        colorC = 0;
                    }
                }
                if (sceneContext.vertexIsOverlay.containsKey(vertexKeyA) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyA)) {
                    vertexAIsOverlay = true;
                }
                if (sceneContext.vertexIsOverlay.containsKey(vertexKeyB) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyB)) {
                    vertexBIsOverlay = true;
                }
                if (sceneContext.vertexIsOverlay.containsKey(vertexKeyC) && sceneContext.vertexIsUnderlay.containsKey(vertexKeyC)) {
                    vertexCIsOverlay = true;
                }
                for (int i = 0; i < 3; ++i) {
                    int[] nArray = localVertices[i];
                    nArray[2] = nArray[2] - override.heightOffset;
                }
            }
            int terrainData = SceneUploader.packTerrainData(true, 0, waterType, tileZ);
            sceneContext.stagingBufferNormals.ensureCapacity(12);
            sceneContext.stagingBufferNormals.put(normalsA[0], normalsA[2], normalsA[1], terrainData);
            sceneContext.stagingBufferNormals.put(normalsB[0], normalsB[2], normalsB[1], terrainData);
            sceneContext.stagingBufferNormals.put(normalsC[0], normalsC[2], normalsC[1], terrainData);
            sceneContext.stagingBufferVertices.ensureCapacity(12);
            sceneContext.stagingBufferVertices.put(localVertices[0][0], localVertices[0][2], localVertices[0][1], colorA);
            sceneContext.stagingBufferVertices.put(localVertices[1][0], localVertices[1][2], localVertices[1][1], colorB);
            sceneContext.stagingBufferVertices.put(localVertices[2][0], localVertices[2][2], localVertices[2][1], colorC);
            bufferLength += 3;
            int[] packedMaterialData = new int[]{this.modelPusher.packMaterialData(materialA, textureId, ModelOverride.NONE, UvType.GEOMETRY, vertexAIsOverlay), this.modelPusher.packMaterialData(materialB, textureId, ModelOverride.NONE, UvType.GEOMETRY, vertexBIsOverlay), this.modelPusher.packMaterialData(materialC, textureId, ModelOverride.NONE, UvType.GEOMETRY, vertexCIsOverlay)};
            float uvcos = -uvScale;
            float uvsin = 0.0f;
            if (uvOrientation % 2048 != 0) {
                float rad = (float)(-uvOrientation) * 0.0030679617f;
                uvcos = (float)Math.cos(rad) * -uvScale;
                uvsin = (float)Math.sin(rad) * -uvScale;
            }
            sceneContext.stagingBufferUvs.ensureCapacity(12);
            for (int i = 0; i < 3; ++i) {
                float uvx = (float)worldPos[0] + (float)localVertices[i][0] / 128.0f - 1.0f;
                float uvy = (float)worldPos[1] + (float)localVertices[i][1] / 128.0f - 1.0f;
                float tmp = uvx;
                uvx = uvx * uvcos - uvy * uvsin;
                uvy = tmp * uvsin + uvy * uvcos;
                sceneContext.stagingBufferUvs.put(uvx, uvy, 0.0f, packedMaterialData[i]);
            }
            uvBufferLength += 3;
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private int[] uploadHDTileModelUnderwater(SceneContext sceneContext, Tile tile, int[] worldPos, SceneTileModel model) {
        Scene scene = sceneContext.scene;
        Point tilePoint = tile.getSceneLocation();
        int tileX = tilePoint.getX();
        int tileY = tilePoint.getY();
        int tileExX = tileX + 40;
        int tileExY = tileY + 40;
        int tileZ = tile.getRenderLevel();
        int bufferLength = 0;
        int uvBufferLength = 0;
        int underwaterTerrain = 0;
        if (sceneContext.skipTile[tileZ][tileExX][tileExY]) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        int[] faceColorA = model.getTriangleColorA();
        int faceCount = model.getFaceX().length;
        int[] faceTextures = model.getTriangleTextureId();
        int baseX = scene.getBaseX();
        int baseY = scene.getBaseY();
        if (baseX >= 2816 && baseX <= 2970 && baseY <= 5375 && baseY >= 5220) {
            return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
        }
        if (sceneContext.tileIsWater[tileZ][tileExX][tileExY]) {
            underwaterTerrain = 1;
            int overlayId = Integer.MIN_VALUE | scene.getOverlayIds()[tileZ][tileExX][tileExY];
            int underlayId = scene.getUnderlayIds()[tileZ][tileExX][tileExY];
            for (int face = 0; face < faceCount; ++face) {
                int colorA = 6676;
                int colorB = 6676;
                int colorC = 6676;
                boolean isOverlay = ProceduralGenerator.isOverlayFace(tile, face);
                TileOverride override = this.tileOverrideManager.getOverride(scene, tile, worldPos, isOverlay ? overlayId : underlayId);
                if (faceColorA[face] == 12345678 && !override.forced) continue;
                int[][] localVertices = ProceduralGenerator.faceLocalVertices(tile, face);
                Material materialA = Material.NONE;
                Material materialB = Material.NONE;
                Material materialC = Material.NONE;
                int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
                int vertexKeyA = vertexKeys[0];
                int vertexKeyB = vertexKeys[1];
                int vertexKeyC = vertexKeys[2];
                int depthA = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyA, 0);
                int depthB = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyB, 0);
                int depthC = sceneContext.vertexUnderwaterDepth.getOrDefault(vertexKeyC, 0);
                if (this.plugin.configGroundTextures) {
                    GroundMaterial groundMaterial = GroundMaterial.UNDERWATER_GENERIC;
                    materialA = groundMaterial.getRandomMaterial(worldPos[0] + (localVertices[0][0] >> 7), worldPos[1] + (localVertices[0][1] >> 7), worldPos[2]);
                    materialB = groundMaterial.getRandomMaterial(worldPos[0] + (localVertices[1][0] >> 7), worldPos[1] + (localVertices[1][1] >> 7), worldPos[2]);
                    materialC = groundMaterial.getRandomMaterial(worldPos[0] + (localVertices[2][0] >> 7), worldPos[1] + (localVertices[2][1] >> 7), worldPos[2]);
                }
                float[] normalsA = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyA, UP_NORMAL);
                float[] normalsB = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyB, UP_NORMAL);
                float[] normalsC = sceneContext.vertexTerrainNormals.getOrDefault(vertexKeyC, UP_NORMAL);
                int textureId = faceTextures == null ? -1 : faceTextures[face];
                WaterType waterType = this.proceduralGenerator.seasonalWaterType(override, textureId);
                int aTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthA), waterType, tileZ);
                int bTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthB), waterType, tileZ);
                int cTerrainData = SceneUploader.packTerrainData(true, Math.max(1, depthC), waterType, tileZ);
                sceneContext.stagingBufferNormals.ensureCapacity(12);
                sceneContext.stagingBufferNormals.put(normalsA[0], normalsA[2], normalsA[1], aTerrainData);
                sceneContext.stagingBufferNormals.put(normalsB[0], normalsB[2], normalsB[1], bTerrainData);
                sceneContext.stagingBufferNormals.put(normalsC[0], normalsC[2], normalsC[1], cTerrainData);
                sceneContext.stagingBufferVertices.ensureCapacity(12);
                sceneContext.stagingBufferVertices.put(localVertices[0][0], localVertices[0][2] + depthA, localVertices[0][1], colorA);
                sceneContext.stagingBufferVertices.put(localVertices[1][0], localVertices[1][2] + depthB, localVertices[1][1], colorB);
                sceneContext.stagingBufferVertices.put(localVertices[2][0], localVertices[2][2] + depthC, localVertices[2][1], colorC);
                bufferLength += 3;
                int packedMaterialDataA = this.modelPusher.packMaterialData(materialA, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
                int packedMaterialDataB = this.modelPusher.packMaterialData(materialB, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
                int packedMaterialDataC = this.modelPusher.packMaterialData(materialC, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
                sceneContext.stagingBufferUvs.ensureCapacity(12);
                sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[0][0] / 128.0f, 1.0f - (float)localVertices[0][1] / 128.0f, 0.0f, packedMaterialDataA);
                sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[1][0] / 128.0f, 1.0f - (float)localVertices[1][1] / 128.0f, 0.0f, packedMaterialDataB);
                sceneContext.stagingBufferUvs.put(1.0f - (float)localVertices[2][0] / 128.0f, 1.0f - (float)localVertices[2][1] / 128.0f, 0.0f, packedMaterialDataC);
                uvBufferLength += 3;
            }
        }
        return new int[]{bufferLength, uvBufferLength, underwaterTerrain};
    }

    private void uploadBlackTile(SceneContext sceneContext, int tileExX, int tileExY, int tileZ) {
        Scene scene = sceneContext.scene;
        int color = 0;
        float fromX = 0.0f;
        float fromY = 0.0f;
        float toX = 128.0f;
        float toY = 128.0f;
        int[][][] tileHeights = scene.getTileHeights();
        int swHeight = tileHeights[tileZ][tileExX][tileExY];
        int seHeight = tileHeights[tileZ][tileExX + 1][tileExY];
        int neHeight = tileHeights[tileZ][tileExX + 1][tileExY + 1];
        int nwHeight = tileHeights[tileZ][tileExX][tileExY + 1];
        int terrainData = SceneUploader.packTerrainData(true, 0, WaterType.NONE, tileZ);
        sceneContext.stagingBufferNormals.ensureCapacity(24);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferNormals.put(0.0f, -1.0f, 0.0f, terrainData);
        sceneContext.stagingBufferVertices.ensureCapacity(24);
        sceneContext.stagingBufferVertices.put(toX, neHeight, toY, color);
        sceneContext.stagingBufferVertices.put(fromX, nwHeight, toY, color);
        sceneContext.stagingBufferVertices.put(toX, seHeight, fromY, color);
        sceneContext.stagingBufferVertices.put(fromX, swHeight, fromY, color);
        sceneContext.stagingBufferVertices.put(toX, seHeight, fromY, color);
        sceneContext.stagingBufferVertices.put(fromX, nwHeight, toY, color);
        int packedMaterialData = this.modelPusher.packMaterialData(Material.BLACK, -1, ModelOverride.NONE, UvType.GEOMETRY, false);
        sceneContext.stagingBufferUvs.ensureCapacity(24);
        sceneContext.stagingBufferUvs.put(0.0f, 0.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(1.0f, 1.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(0.0f, 1.0f, 0.0f, packedMaterialData);
        sceneContext.stagingBufferUvs.put(1.0f, 0.0f, 0.0f, packedMaterialData);
    }

    public static int packTerrainData(boolean isTerrain, int waterDepth, WaterType waterType, int plane) {
        int terrainData = waterDepth << 8 | waterType.ordinal() << 3 | plane << 1 | (isTerrain ? 1 : 0);
        assert ((terrainData & 0xFF000000) == 0) : "Only the lower 24 bits are usable, since we pass this into shaders as a float";
        return terrainData;
    }
}

