/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Projectile;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.scene.areas.AABB;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.scene.environments.Environment;
import net.runelite.client.plugins.rs117.hd.scene.lights.Light;
import net.runelite.client.plugins.rs117.hd.scene.lights.TileObjectImpostorTracker;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.buffer.GpuFloatBuffer;
import net.runelite.client.plugins.rs117.hd.utils.buffer.GpuIntBuffer;

public class SceneContext {
    public static final int SCENE_OFFSET = 40;
    public final int id = HDUtils.rand.nextInt() & 0xFFFF;
    public final Client client;
    public final Scene scene;
    public final HashSet<Integer> regionIds;
    public final int expandedMapLoadingChunks;
    public boolean enableAreaHiding;
    public boolean fillGaps;
    public boolean isPrepared;
    @Nullable
    public Area currentArea;
    public Area[] possibleAreas = new Area[0];
    public final ArrayList<Environment> environments = new ArrayList();
    public byte[][] filledTiles = new byte[184][184];
    public int staticVertexCount = 0;
    public GpuIntBuffer staticUnorderedModelBuffer;
    public GpuIntBuffer stagingBufferVertices;
    public GpuFloatBuffer stagingBufferUvs;
    public GpuFloatBuffer stagingBufferNormals;
    public int staticGapFillerTilesOffset;
    public int staticGapFillerTilesVertexCount;
    public int staticCustomTilesOffset;
    public int staticCustomTilesVertexCount;
    public int uniqueModels;
    public Map<Integer, Integer> vertexTerrainColor;
    public Map<Integer, Material> vertexTerrainTexture;
    public Map<Integer, float[]> vertexTerrainNormals;
    public HashMap<Integer, Boolean> highPriorityColor;
    public boolean[][][] tileIsWater;
    public Map<Integer, Boolean> vertexIsWater;
    public Map<Integer, Boolean> vertexIsLand;
    public Map<Integer, Boolean> vertexIsOverlay;
    public Map<Integer, Boolean> vertexIsUnderlay;
    public boolean[][][] skipTile;
    public Map<Integer, Integer> vertexUnderwaterDepth;
    public int[][][] underwaterDepthLevels;
    public int numVisibleLights = 0;
    public final ArrayList<Light> lights = new ArrayList();
    public final HashSet<Projectile> knownProjectiles = new HashSet();
    public final HashMap<TileObject, TileObjectImpostorTracker> trackedTileObjects = new HashMap();
    public final ListMultimap<Integer, TileObjectImpostorTracker> trackedVarps = ArrayListMultimap.create();
    public final ListMultimap<Integer, TileObjectImpostorTracker> trackedVarbits = ArrayListMultimap.create();
    public final int[] modelFaceVertices = new int[12];
    public final float[] modelFaceNormals = new float[12];
    public final int[] modelPusherResults = new int[2];

    public SceneContext(Client client2, Scene scene, int expandedMapLoadingChunks, boolean reuseBuffers, @Nullable SceneContext previous) {
        this.client = client2;
        this.scene = scene;
        this.regionIds = HDUtils.getSceneRegionIds(scene);
        this.expandedMapLoadingChunks = expandedMapLoadingChunks;
        if (previous == null) {
            this.staticUnorderedModelBuffer = new GpuIntBuffer();
            this.stagingBufferVertices = new GpuIntBuffer();
            this.stagingBufferUvs = new GpuFloatBuffer();
            this.stagingBufferNormals = new GpuFloatBuffer();
        } else if (reuseBuffers) {
            this.staticUnorderedModelBuffer = previous.staticUnorderedModelBuffer.clear();
            this.stagingBufferVertices = previous.stagingBufferVertices.clear();
            this.stagingBufferUvs = previous.stagingBufferUvs.clear();
            this.stagingBufferNormals = previous.stagingBufferNormals.clear();
            previous.staticUnorderedModelBuffer = null;
            previous.stagingBufferVertices = null;
            previous.stagingBufferUvs = null;
            previous.stagingBufferNormals = null;
        } else {
            this.staticUnorderedModelBuffer = new GpuIntBuffer(previous.staticUnorderedModelBuffer.capacity());
            this.stagingBufferVertices = new GpuIntBuffer(previous.stagingBufferVertices.capacity());
            this.stagingBufferUvs = new GpuFloatBuffer(previous.stagingBufferUvs.capacity());
            this.stagingBufferNormals = new GpuFloatBuffer(previous.stagingBufferNormals.capacity());
        }
    }

    public synchronized void destroy() {
        if (this.staticUnorderedModelBuffer != null) {
            this.staticUnorderedModelBuffer.destroy();
        }
        this.staticUnorderedModelBuffer = null;
        if (this.stagingBufferVertices != null) {
            this.stagingBufferVertices.destroy();
        }
        this.stagingBufferVertices = null;
        if (this.stagingBufferUvs != null) {
            this.stagingBufferUvs.destroy();
        }
        this.stagingBufferUvs = null;
        if (this.stagingBufferNormals != null) {
            this.stagingBufferNormals.destroy();
        }
        this.stagingBufferNormals = null;
    }

    public int getVertexOffset() {
        return this.stagingBufferVertices.position() / 4;
    }

    public int getUvOffset() {
        return this.stagingBufferUvs.position() / 4;
    }

    public int[] localToWorld(LocalPoint localPoint, int plane) {
        return HDUtils.localToWorld(this.scene, localPoint.getX(), localPoint.getY(), plane);
    }

    public int[] localToWorld(LocalPoint localPoint) {
        return this.localToWorld(localPoint, this.client.getPlane());
    }

    public int[] localToWorld(int localX, int localY, int plane) {
        return HDUtils.localToWorld(this.scene, localX, localY, plane);
    }

    public int[] localToWorld(int localX, int localY) {
        return this.localToWorld(localX, localY, this.client.getPlane());
    }

    public int[] sceneToWorld(int sceneX, int sceneY, int plane) {
        return this.localToWorld(sceneX * 128, sceneY * 128, plane);
    }

    public int[] extendedSceneToWorld(int sceneExX, int sceneExY, int plane) {
        return this.sceneToWorld(sceneExX - 40, sceneExY - 40, plane);
    }

    public Stream<LocalPoint> worldInstanceToLocals(WorldPoint worldPoint) {
        return WorldPoint.toLocalInstance(this.scene, worldPoint).stream().map(this::worldToLocal).filter(Objects::nonNull);
    }

    @Nullable
    public LocalPoint worldToLocal(WorldPoint worldPoint) {
        return new LocalPoint((worldPoint.getX() - this.scene.getBaseX()) * 128, (worldPoint.getY() - this.scene.getBaseY()) * 128);
    }

    public int[] worldToLocal(@Nonnull int[] worldPoint) {
        return new int[]{(worldPoint[0] - this.scene.getBaseX()) * 128, (worldPoint[1] - this.scene.getBaseY()) * 128};
    }

    public boolean intersects(Area area) {
        return this.intersects(area.aabbs);
    }

    public boolean intersects(AABB ... aabbs) {
        return HDUtils.sceneIntersects(this.scene, this.expandedMapLoadingChunks, aabbs);
    }

    public AABB getNonInstancedSceneBounds() {
        return HDUtils.getNonInstancedSceneBounds(this.scene, this.expandedMapLoadingChunks);
    }

    public int getObjectConfig(Tile tile, long hash) {
        if (tile.getWallObject() != null && tile.getWallObject().getHash() == hash) {
            return tile.getWallObject().getConfig();
        }
        if (tile.getDecorativeObject() != null && tile.getDecorativeObject().getHash() == hash) {
            return tile.getDecorativeObject().getConfig();
        }
        if (tile.getGroundObject() != null && tile.getGroundObject().getHash() == hash) {
            return tile.getGroundObject().getConfig();
        }
        for (GameObject gameObject : tile.getGameObjects()) {
            if (gameObject == null || gameObject.getHash() != hash) continue;
            return gameObject.getConfig();
        }
        return -1;
    }

    public int getBaseExX() {
        return this.scene.getBaseX() - 40;
    }

    public int getBaseExY() {
        return this.scene.getBaseY() - 40;
    }
}

