/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import java.util.Arrays;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Model;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.Tile;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.config.SeasonalTheme;
import net.runelite.client.plugins.rs117.hd.data.WaterType;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.scene.SceneContext;
import net.runelite.client.plugins.rs117.hd.scene.TileOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.rs117.hd.scene.model_overrides.TzHaarRecolorType;
import net.runelite.client.plugins.rs117.hd.scene.tile_overrides.TileOverride;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.ModelHash;
import net.runelite.client.plugins.rs117.hd.utils.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProceduralGenerator {
    private static final Logger log = LoggerFactory.getLogger(ProceduralGenerator.class);
    public static final int[] DEPTH_LEVEL_SLOPE = new int[]{150, 300, 470, 610, 700, 750, 820, 920, 1080, 1300, 1350, 1380};
    public static final int VERTICES_PER_FACE = 3;
    public static final boolean[][] TILE_OVERLAY_TRIS = new boolean[][]{{true, true, true, true}, {false, true}, {false, false, true}, {false, false, true}, {false, true, true}, {false, true, true}, {false, false, true, true}, {false, false, false, true}, {false, true, true, true}, {false, false, false, true, true, true}, {true, true, true, false, false, false}, {true, true, false, false, false, false}};
    @Inject
    private HdPlugin plugin;
    @Inject
    private TileOverrideManager tileOverrideManager;
    private static final int[] tzHaarRecolored = new int[4];
    private static final int[] gradientBaseColor = new int[]{3, 4, 26};
    private static final int[] gradientDarkColor = new int[]{3, 4, 10};
    private static final int gradientBottom = 200;
    private static final int gradientTop = -200;

    public void generateSceneData(SceneContext sceneContext) {
        long timerTotal = System.currentTimeMillis();
        long startTime = System.currentTimeMillis();
        this.generateUnderwaterTerrain(sceneContext);
        long timerGenerateUnderwaterTerrain = (int)(System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        this.calculateTerrainNormals(sceneContext);
        long timerCalculateTerrainNormals = (int)(System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        this.generateTerrainData(sceneContext);
        long timerGenerateTerrainData = (int)(System.currentTimeMillis() - startTime);
        log.debug("procedural data generation took {}ms to complete", (Object)(System.currentTimeMillis() - timerTotal));
        log.debug("-- calculateTerrainNormals: {}ms", (Object)timerCalculateTerrainNormals);
        log.debug("-- generateTerrainData: {}ms", (Object)timerGenerateTerrainData);
        log.debug("-- generateUnderwaterTerrain: {}ms", (Object)timerGenerateUnderwaterTerrain);
    }

    private void generateTerrainData(SceneContext sceneContext) {
        sceneContext.vertexTerrainColor = new HashMap<Integer, Integer>();
        sceneContext.highPriorityColor = new HashMap();
        sceneContext.vertexTerrainTexture = new HashMap<Integer, Material>();
        sceneContext.vertexIsUnderlay = new HashMap<Integer, Boolean>();
        sceneContext.vertexIsOverlay = new HashMap<Integer, Boolean>();
        Tile[][][] tiles = sceneContext.scene.getExtendedTiles();
        for (int z = 0; z < 4; ++z) {
            int y;
            int x;
            for (x = 0; x < 184; ++x) {
                for (y = 0; y < 184; ++y) {
                    if (tiles[z][x][y] == null) continue;
                    this.generateDataForTile(sceneContext, tiles[z][x][y], x, y);
                }
            }
            for (x = 0; x < 184; ++x) {
                for (y = 0; y < 184; ++y) {
                    if (tiles[z][x][y] == null || tiles[z][x][y].getBridge() == null) continue;
                    this.generateDataForTile(sceneContext, tiles[z][x][y].getBridge(), x, y);
                }
            }
        }
    }

    private void generateDataForTile(SceneContext sceneContext, Tile tile, int tileExX, int tileExY) {
        int faceCount;
        if (tile.getSceneTilePaint() != null) {
            faceCount = 2;
        } else if (tile.getSceneTileModel() != null) {
            faceCount = tile.getSceneTileModel().getFaceX().length;
        } else {
            return;
        }
        int[] vertexHashes = new int[faceCount * 3];
        int[] vertexColors = new int[faceCount * 3];
        TileOverride[] vertexOverrides = new TileOverride[faceCount * 3];
        boolean[] vertexIsOverlay = new boolean[faceCount * 3];
        boolean[] vertexDefaultColor = new boolean[faceCount * 3];
        int tileX = tileExX - 40;
        int tileY = tileExY - 40;
        int tileZ = tile.getRenderLevel();
        int[] worldPos = sceneContext.sceneToWorld(tileX, tileY, tileZ);
        Scene scene = sceneContext.scene;
        if (tile.getSceneTilePaint() != null) {
            int i;
            TileOverride override = this.tileOverrideManager.getOverride(scene, tile, worldPos, new int[0]);
            if (override.waterType != WaterType.NONE) {
                return;
            }
            int swColor = tile.getSceneTilePaint().getSwColor();
            int seColor = tile.getSceneTilePaint().getSeColor();
            int nwColor = tile.getSceneTilePaint().getNwColor();
            int neColor = tile.getSceneTilePaint().getNeColor();
            vertexHashes = ProceduralGenerator.tileVertexKeys(scene, tile);
            if (tileExX >= 182 && tileExY >= 182) {
                neColor = swColor;
                nwColor = swColor;
                seColor = swColor;
            } else if (tileExY >= 182) {
                nwColor = swColor;
                neColor = seColor;
            } else if (tileExX >= 182) {
                neColor = nwColor;
                seColor = swColor;
            }
            vertexColors[0] = swColor;
            vertexColors[1] = seColor;
            vertexColors[2] = nwColor;
            vertexColors[3] = neColor;
            for (i = 0; i < 4; ++i) {
                vertexOverrides[i] = override;
                vertexIsOverlay[i] = override.queriedAsOverlay;
            }
            if (this.useDefaultColor(tile, override)) {
                for (i = 0; i < 4; ++i) {
                    vertexDefaultColor[i] = true;
                }
            }
        } else if (tile.getSceneTileModel() != null) {
            SceneTileModel sceneTileModel = tile.getSceneTileModel();
            int[] faceColorsA = sceneTileModel.getTriangleColorA();
            int[] faceColorsB = sceneTileModel.getTriangleColorB();
            int[] faceColorsC = sceneTileModel.getTriangleColorC();
            int overlayId = Integer.MIN_VALUE | scene.getOverlayIds()[tileZ][tileExX][tileExY];
            int underlayId = scene.getUnderlayIds()[tileZ][tileExX][tileExY];
            for (int face = 0; face < faceCount; ++face) {
                int[] faceColors = new int[]{faceColorsA[face], faceColorsB[face], faceColorsC[face]};
                int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
                for (int vertex = 0; vertex < 3; ++vertex) {
                    int color;
                    boolean isOverlay = ProceduralGenerator.isOverlayFace(tile, face);
                    TileOverride override = this.tileOverrideManager.getOverride(scene, tile, worldPos, isOverlay ? overlayId : underlayId);
                    if (override.waterType != WaterType.NONE) continue;
                    vertexHashes[face * 3 + vertex] = vertexKeys[vertex];
                    vertexColors[face * 3 + vertex] = color = faceColors[vertex];
                    vertexOverrides[face * 3 + vertex] = override;
                    vertexIsOverlay[face * 3 + vertex] = isOverlay;
                    if (!isOverlay || !this.useDefaultColor(tile, override)) continue;
                    vertexDefaultColor[face * 3 + vertex] = true;
                }
            }
        }
        for (int vertex = 0; vertex < vertexHashes.length; ++vertex) {
            boolean shouldWrite;
            if (vertexHashes[vertex] == 0) continue;
            int color = vertexColors[vertex];
            TileOverride override = vertexOverrides[vertex];
            if (color < 0 || color == 12345678 && !override.forced) continue;
            boolean lowPriorityColor = vertexColors[vertex] <= 2;
            float lightenMultiplier = 1.5f;
            int lightenBase = 15;
            int lightenAdd = 3;
            float darkenMultiplier = 0.5f;
            int darkenBase = 0;
            int darkenAdd = 0;
            float[] vNormals = sceneContext.vertexTerrainNormals.getOrDefault(vertexHashes[vertex], new float[]{0.0f, 0.0f, 0.0f});
            float dot = HDUtils.dotLightDirectionTile(vNormals[0], vNormals[1], vNormals[2]);
            int lightness = color & 0x7F;
            lightness = (int)HDUtils.lerp(lightness, (int)((float)Math.max(lightness - lightenAdd, 0) * lightenMultiplier) + lightenBase, Math.max(dot, 0.0f));
            lightness = (int)(1.25f * HDUtils.lerp(lightness, (int)((float)Math.max(lightness - darkenAdd, 0) * darkenMultiplier) + darkenBase, Math.abs(Math.min(dot, 0.0f))));
            int maxBrightness = 55;
            lightness = Math.min(lightness, 55);
            color = color & 0xFFFFFF80 | lightness;
            boolean isOverlay = false;
            Material material = Material.DIRT_1;
            if (override != TileOverride.NONE) {
                material = override.groundMaterial.getRandomMaterial(worldPos);
                isOverlay = vertexIsOverlay[vertex] != override.blendedAsOpposite;
                color = override.modifyColor(color);
            }
            vertexColors[vertex] = color;
            if (isOverlay) {
                sceneContext.vertexIsOverlay.put(vertexHashes[vertex], true);
            } else {
                sceneContext.vertexIsUnderlay.put(vertexHashes[vertex], true);
            }
            if (lowPriorityColor && sceneContext.highPriorityColor.containsKey(vertexHashes[vertex]) || vertexDefaultColor[vertex]) continue;
            boolean bl = shouldWrite = isOverlay || !sceneContext.vertexTerrainColor.containsKey(vertexHashes[vertex]);
            if (shouldWrite || !sceneContext.vertexTerrainColor.containsKey(vertexHashes[vertex])) {
                sceneContext.vertexTerrainColor.put(vertexHashes[vertex], vertexColors[vertex]);
            }
            if (shouldWrite || !sceneContext.vertexTerrainTexture.containsKey(vertexHashes[vertex])) {
                sceneContext.vertexTerrainTexture.put(vertexHashes[vertex], material);
            }
            if (lowPriorityColor) continue;
            sceneContext.highPriorityColor.put(vertexHashes[vertex], true);
        }
    }

    private void generateUnderwaterTerrain(SceneContext sceneContext) {
        int y;
        int x;
        int z;
        sceneContext.tileIsWater = new boolean[4][184][184];
        sceneContext.vertexIsWater = new HashMap<Integer, Boolean>();
        sceneContext.vertexIsLand = new HashMap<Integer, Boolean>();
        sceneContext.skipTile = new boolean[4][184][184];
        sceneContext.vertexUnderwaterDepth = new HashMap<Integer, Integer>();
        sceneContext.underwaterDepthLevels = new int[4][185][185];
        int[][][] underwaterDepths = new int[4][185][185];
        for (int z2 = 0; z2 < 4; ++z2) {
            for (int x2 = 0; x2 < 184; ++x2) {
                Arrays.fill(sceneContext.underwaterDepthLevels[z2][x2], 1);
            }
        }
        Scene scene = sceneContext.scene;
        Tile[][][] tiles = scene.getExtendedTiles();
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 184; ++x) {
                for (y = 0; y < 184; ++y) {
                    if (tiles[z][x][y] == null) {
                        sceneContext.underwaterDepthLevels[z][x][y] = 0;
                        sceneContext.underwaterDepthLevels[z][x + 1][y] = 0;
                        sceneContext.underwaterDepthLevels[z][x][y + 1] = 0;
                        sceneContext.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                        continue;
                    }
                    Tile tile = tiles[z][x][y];
                    if (tile.getBridge() != null) {
                        tile = tile.getBridge();
                    }
                    if (tile.getSceneTilePaint() != null) {
                        int checkZ;
                        int vertexKey;
                        int n;
                        int[] vertexKeys = ProceduralGenerator.tileVertexKeys(scene, tile);
                        int[] worldPos = sceneContext.extendedSceneToWorld(x, y, tile.getRenderLevel());
                        TileOverride override = this.tileOverrideManager.getOverride(scene, tile, worldPos, new int[0]);
                        if (this.seasonalWaterType(override, tile.getSceneTilePaint().getTexture()) == WaterType.NONE) {
                            int[] nArray = vertexKeys;
                            int n2 = nArray.length;
                            for (n = 0; n < n2; ++n) {
                                vertexKey = nArray[n];
                                if (tile.getSceneTilePaint().getNeColor() == 12345678 && !override.forced) continue;
                                sceneContext.vertexIsLand.put(vertexKey, true);
                            }
                            sceneContext.underwaterDepthLevels[z][x][y] = 0;
                            sceneContext.underwaterDepthLevels[z][x + 1][y] = 0;
                            sceneContext.underwaterDepthLevels[z][x][y + 1] = 0;
                            sceneContext.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                            continue;
                        }
                        if (z > 0) {
                            boolean continueLoop = false;
                            for (checkZ = 0; checkZ < z; ++checkZ) {
                                if (!sceneContext.tileIsWater[checkZ][x][y]) continue;
                                sceneContext.underwaterDepthLevels[z][x][y] = 0;
                                sceneContext.underwaterDepthLevels[z][x + 1][y] = 0;
                                sceneContext.underwaterDepthLevels[z][x][y + 1] = 0;
                                sceneContext.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                                sceneContext.skipTile[z][x][y] = true;
                                continueLoop = true;
                                break;
                            }
                            if (continueLoop) continue;
                        }
                        sceneContext.tileIsWater[z][x][y] = true;
                        int[] continueLoop = vertexKeys;
                        checkZ = continueLoop.length;
                        for (n = 0; n < checkZ; ++n) {
                            vertexKey = continueLoop[n];
                            sceneContext.vertexIsWater.put(vertexKey, true);
                        }
                        continue;
                    }
                    if (tile.getSceneTileModel() != null) {
                        SceneTileModel model = tile.getSceneTileModel();
                        int faceCount = model.getFaceX().length;
                        int tileZ = tile.getRenderLevel();
                        int[] worldPos = sceneContext.extendedSceneToWorld(x, y, tileZ);
                        int overlayId = Integer.MIN_VALUE | scene.getOverlayIds()[tileZ][x][y];
                        int underlayId = scene.getUnderlayIds()[tileZ][x][y];
                        if (z > 0) {
                            boolean tileIncludesWater = false;
                            for (int face = 0; face < faceCount; ++face) {
                                int textureId;
                                boolean isOverlay = ProceduralGenerator.isOverlayFace(tile, face);
                                TileOverride override = this.tileOverrideManager.getOverride(scene, tile, worldPos, isOverlay ? overlayId : underlayId);
                                int n = textureId = model.getTriangleTextureId() == null ? -1 : model.getTriangleTextureId()[face];
                                if (this.seasonalWaterType(override, textureId) == WaterType.NONE) continue;
                                tileIncludesWater = true;
                                break;
                            }
                            if (tileIncludesWater) {
                                boolean continueLoop = false;
                                for (int checkZ = 0; checkZ < z; ++checkZ) {
                                    if (!sceneContext.tileIsWater[checkZ][x][y]) continue;
                                    sceneContext.underwaterDepthLevels[z][x][y] = 0;
                                    sceneContext.underwaterDepthLevels[z][x + 1][y] = 0;
                                    sceneContext.underwaterDepthLevels[z][x][y + 1] = 0;
                                    sceneContext.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                                    sceneContext.skipTile[z][x][y] = true;
                                    continueLoop = true;
                                    break;
                                }
                                if (continueLoop) continue;
                            }
                        }
                        for (int face = 0; face < faceCount; ++face) {
                            int vertex;
                            int textureId;
                            int[][] vertices = ProceduralGenerator.faceVertices(tile, face);
                            int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
                            boolean isOverlay = ProceduralGenerator.isOverlayFace(tile, face);
                            TileOverride override = this.tileOverrideManager.getOverride(scene, tile, worldPos, isOverlay ? overlayId : underlayId);
                            int n = textureId = model.getTriangleTextureId() == null ? -1 : model.getTriangleTextureId()[face];
                            if (this.seasonalWaterType(override, textureId) == WaterType.NONE) {
                                for (vertex = 0; vertex < 3; ++vertex) {
                                    if (model.getTriangleColorA()[face] != 12345678 || override.forced) {
                                        sceneContext.vertexIsLand.put(vertexKeys[vertex], true);
                                    }
                                    if (vertices[vertex][0] % 128 != 0 || vertices[vertex][1] % 128 != 0) continue;
                                    int vX = (vertices[vertex][0] >> 7) + 40;
                                    int vY = (vertices[vertex][1] >> 7) + 40;
                                    sceneContext.underwaterDepthLevels[z][vX][vY] = 0;
                                }
                                continue;
                            }
                            sceneContext.tileIsWater[z][x][y] = true;
                            for (vertex = 0; vertex < 3; ++vertex) {
                                sceneContext.vertexIsWater.put(vertexKeys[vertex], true);
                            }
                        }
                        continue;
                    }
                    sceneContext.underwaterDepthLevels[z][x][y] = 0;
                    sceneContext.underwaterDepthLevels[z][x + 1][y] = 0;
                    sceneContext.underwaterDepthLevels[z][x][y + 1] = 0;
                    sceneContext.underwaterDepthLevels[z][x + 1][y + 1] = 0;
                }
            }
        }
        for (int level = 0; level < DEPTH_LEVEL_SLOPE.length - 1; ++level) {
            for (int z3 = 0; z3 < 4; ++z3) {
                for (int x3 = 0; x3 < sceneContext.underwaterDepthLevels[z3].length; ++x3) {
                    for (int y2 = 0; y2 < sceneContext.underwaterDepthLevels[z3][x3].length; ++y2) {
                        if (sceneContext.underwaterDepthLevels[z3][x3][y2] == 0) continue;
                        if (x3 == 0 || y2 == 0 || x3 == 184 || y2 == 184) {
                            sceneContext.underwaterDepthLevels[z3][x3][y2] = 0;
                            continue;
                        }
                        int tileHeight = sceneContext.underwaterDepthLevels[z3][x3][y2];
                        if (sceneContext.underwaterDepthLevels[z3][x3 - 1][y2] < tileHeight || x3 < sceneContext.underwaterDepthLevels[z3].length - 1 && sceneContext.underwaterDepthLevels[z3][x3 + 1][y2] < tileHeight || sceneContext.underwaterDepthLevels[z3][x3][y2 - 1] < tileHeight || y2 < sceneContext.underwaterDepthLevels[z3].length - 1 && sceneContext.underwaterDepthLevels[z3][x3][y2 + 1] < tileHeight) continue;
                        int[] nArray = sceneContext.underwaterDepthLevels[z3][x3];
                        int n = y2;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < sceneContext.underwaterDepthLevels[z].length; ++x) {
                for (y = 0; y < sceneContext.underwaterDepthLevels[z][x].length; ++y) {
                    int heightOffset;
                    if (sceneContext.underwaterDepthLevels[z][x][y] == 0) continue;
                    int depth = DEPTH_LEVEL_SLOPE[sceneContext.underwaterDepthLevels[z][x][y] - 1];
                    underwaterDepths[z][x][y] = heightOffset = (int)((float)depth * 0.55f);
                }
            }
        }
        for (z = 0; z < 4; ++z) {
            for (x = 0; x < 184; ++x) {
                for (y = 0; y < 184; ++y) {
                    Tile tile;
                    if (!sceneContext.tileIsWater[z][x][y] || (tile = tiles[z][x][y]) == null) continue;
                    if (tile.getBridge() != null) {
                        tile = tile.getBridge();
                    }
                    if (tile.getSceneTilePaint() != null) {
                        int[] vertexKeys = ProceduralGenerator.tileVertexKeys(scene, tile);
                        int swVertexKey = vertexKeys[0];
                        int seVertexKey = vertexKeys[1];
                        int nwVertexKey = vertexKeys[2];
                        int neVertexKey = vertexKeys[3];
                        sceneContext.vertexUnderwaterDepth.put(swVertexKey, underwaterDepths[z][x][y]);
                        sceneContext.vertexUnderwaterDepth.put(seVertexKey, underwaterDepths[z][x + 1][y]);
                        sceneContext.vertexUnderwaterDepth.put(nwVertexKey, underwaterDepths[z][x][y + 1]);
                        sceneContext.vertexUnderwaterDepth.put(neVertexKey, underwaterDepths[z][x + 1][y + 1]);
                        continue;
                    }
                    if (tile.getSceneTileModel() == null) continue;
                    SceneTileModel sceneTileModel = tile.getSceneTileModel();
                    int faceCount = sceneTileModel.getFaceX().length;
                    for (int face = 0; face < faceCount; ++face) {
                        int[][] vertices = ProceduralGenerator.faceVertices(tile, face);
                        int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
                        for (int vertex = 0; vertex < 3; ++vertex) {
                            if (vertices[vertex][0] % 128 == 0 && vertices[vertex][1] % 128 == 0) {
                                int vX = (vertices[vertex][0] >> 7) + 40;
                                int vY = (vertices[vertex][1] >> 7) + 40;
                                sceneContext.vertexUnderwaterDepth.put(vertexKeys[vertex], underwaterDepths[z][vX][vY]);
                                continue;
                            }
                            float lerpX = HDUtils.fract((float)vertices[vertex][0] / 128.0f);
                            float lerpY = HDUtils.fract((float)vertices[vertex][1] / 128.0f);
                            float northHeightOffset = HDUtils.lerp(underwaterDepths[z][x][y + 1], underwaterDepths[z][x + 1][y + 1], lerpX);
                            float southHeightOffset = HDUtils.lerp(underwaterDepths[z][x][y], underwaterDepths[z][x + 1][y], lerpX);
                            int heightOffset = (int)HDUtils.lerp(southHeightOffset, northHeightOffset, lerpY);
                            if (sceneContext.vertexIsLand.containsKey(vertexKeys[vertex])) continue;
                            sceneContext.vertexUnderwaterDepth.put(vertexKeys[vertex], heightOffset);
                        }
                    }
                }
            }
        }
    }

    private void calculateTerrainNormals(SceneContext sceneContext) {
        sceneContext.vertexTerrainNormals = new HashMap<Integer, float[]>();
        Tile[][][] tileArray = sceneContext.scene.getExtendedTiles();
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[][] plane;
            Tile[][] tileArray2 = plane = tileArray[i];
            int n2 = tileArray2.length;
            for (int j = 0; j < n2; ++j) {
                Tile[] column;
                for (Tile tile : column = tileArray2[j]) {
                    if (tile == null) continue;
                    boolean isBridge = false;
                    if (tile.getBridge() != null) {
                        this.calculateNormalsForTile(sceneContext, tile.getBridge(), false);
                        isBridge = true;
                    }
                    this.calculateNormalsForTile(sceneContext, tile, isBridge);
                }
            }
        }
    }

    private void calculateNormalsForTile(SceneContext sceneContext, Tile tile, boolean isBridge) {
        int[][] faceVertexKeys;
        int[][][] faceVertices;
        if (tile.getSceneTileModel() != null) {
            SceneTileModel tileModel = tile.getSceneTileModel();
            faceVertices = new int[tileModel.getFaceX().length][3][3];
            faceVertexKeys = new int[tileModel.getFaceX().length][3];
            for (int face = 0; face < tileModel.getFaceX().length; ++face) {
                int[][] vertices = ProceduralGenerator.faceVertices(tile, face);
                faceVertices[face][0] = new int[]{vertices[0][0], vertices[0][1], vertices[0][2]};
                faceVertices[face][2] = new int[]{vertices[1][0], vertices[1][1], vertices[1][2]};
                faceVertices[face][1] = new int[]{vertices[2][0], vertices[2][1], vertices[2][2]};
                int[] vertexKeys = ProceduralGenerator.faceVertexKeys(tile, face);
                faceVertexKeys[face][0] = vertexKeys[0];
                faceVertexKeys[face][2] = vertexKeys[1];
                faceVertexKeys[face][1] = vertexKeys[2];
            }
        } else {
            faceVertices = new int[2][3][3];
            faceVertexKeys = new int[3][3];
            int[][] vertices = ProceduralGenerator.tileVertices(sceneContext.scene, tile);
            faceVertices[0] = new int[][]{vertices[3], vertices[1], vertices[2]};
            faceVertices[1] = new int[][]{vertices[0], vertices[2], vertices[1]};
            int[] vertexKeys = ProceduralGenerator.tileVertexKeys(sceneContext.scene, tile);
            faceVertexKeys[0] = new int[]{vertexKeys[3], vertexKeys[1], vertexKeys[2]};
            faceVertexKeys[1] = new int[]{vertexKeys[0], vertexKeys[2], vertexKeys[1]};
        }
        for (int face = 0; face < faceVertices.length; ++face) {
            int[] vertexHeights = new int[]{faceVertices[face][0][2], faceVertices[face][1][2], faceVertices[face][2][2]};
            if (!isBridge) {
                vertexHeights[0] = vertexHeights[0] + sceneContext.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][0], 0);
                vertexHeights[1] = vertexHeights[1] + sceneContext.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][1], 0);
                vertexHeights[2] = vertexHeights[2] + sceneContext.vertexUnderwaterDepth.getOrDefault(faceVertexKeys[face][2], 0);
            }
            float[] vertexNormals = HDUtils.calculateSurfaceNormals(new float[]{faceVertices[face][0][0], faceVertices[face][0][1], vertexHeights[0]}, new float[]{faceVertices[face][1][0], faceVertices[face][1][1], vertexHeights[1]}, new float[]{faceVertices[face][2][0], faceVertices[face][2][1], vertexHeights[2]});
            for (int vertex = 0; vertex < 3; ++vertex) {
                int vertexKey = faceVertexKeys[face][vertex];
                sceneContext.vertexTerrainNormals.merge(vertexKey, vertexNormals, (a, b) -> Vector.add(a, a, b));
            }
        }
    }

    public boolean useDefaultColor(Tile tile, TileOverride override) {
        if (tile.getSceneTilePaint() != null && tile.getSceneTilePaint().getTexture() >= 0 || tile.getSceneTileModel() != null && tile.getSceneTileModel().getTriangleTextureId() != null) {
            return true;
        }
        if (override == TileOverride.NONE) {
            return false;
        }
        return !override.blended;
    }

    public WaterType seasonalWaterType(TileOverride override, int textureId) {
        WaterType waterType = override.waterType;
        if (waterType == WaterType.NONE) {
            if (textureId == Material.WATER_FLAT.vanillaTextureIndex || textureId == Material.WATER_FLAT_2.vanillaTextureIndex) {
                waterType = WaterType.WATER_FLAT;
            } else if (textureId == Material.SWAMP_WATER_FLAT.vanillaTextureIndex) {
                waterType = WaterType.SWAMP_WATER_FLAT;
            }
            return waterType;
        }
        if (waterType == WaterType.WATER && this.plugin.configSeasonalTheme == SeasonalTheme.WINTER) {
            return WaterType.ICE;
        }
        return waterType;
    }

    private static boolean[] getTileOverlayTris(int tileShapeIndex) {
        if (tileShapeIndex >= TILE_OVERLAY_TRIS.length) {
            log.debug("getTileOverlayTris(): unknown tileShapeIndex ({})", (Object)tileShapeIndex);
            return new boolean[10];
        }
        return TILE_OVERLAY_TRIS[tileShapeIndex];
    }

    public static boolean isOverlayFace(Tile tile, int face) {
        int tileShapeIndex = tile.getSceneTileModel().getShape() - 1;
        if (face >= ProceduralGenerator.getTileOverlayTris(tileShapeIndex).length) {
            return false;
        }
        return ProceduralGenerator.getTileOverlayTris(tileShapeIndex)[face];
    }

    private static int[][] tileVertices(Scene scene, Tile tile) {
        int tileX = tile.getSceneLocation().getX();
        int tileY = tile.getSceneLocation().getY();
        int tileExX = tileX + 40;
        int tileExY = tileY + 40;
        int tileZ = tile.getRenderLevel();
        int[][][] tileHeights = scene.getTileHeights();
        int[] swVertex = new int[]{tileX * 128, tileY * 128, tileHeights[tileZ][tileExX][tileExY]};
        int[] seVertex = new int[]{(tileX + 1) * 128, tileY * 128, tileHeights[tileZ][tileExX + 1][tileExY]};
        int[] nwVertex = new int[]{tileX * 128, (tileY + 1) * 128, tileHeights[tileZ][tileExX][tileExY + 1]};
        int[] neVertex = new int[]{(tileX + 1) * 128, (tileY + 1) * 128, tileHeights[tileZ][tileExX + 1][tileExY + 1]};
        return new int[][]{swVertex, seVertex, nwVertex, neVertex};
    }

    private static int[][] faceVertices(Tile tile, int face) {
        SceneTileModel sceneTileModel = tile.getSceneTileModel();
        int[] faceA = sceneTileModel.getFaceX();
        int[] faceB = sceneTileModel.getFaceY();
        int[] faceC = sceneTileModel.getFaceZ();
        int[] vertexX = sceneTileModel.getVertexX();
        int[] vertexY = sceneTileModel.getVertexY();
        int[] vertexZ = sceneTileModel.getVertexZ();
        int vertexFacesA = faceA[face];
        int vertexFacesB = faceB[face];
        int vertexFacesC = faceC[face];
        int sceneVertexXA = vertexX[vertexFacesA];
        int sceneVertexXB = vertexX[vertexFacesB];
        int sceneVertexXC = vertexX[vertexFacesC];
        int sceneVertexZA = vertexZ[vertexFacesA];
        int sceneVertexZB = vertexZ[vertexFacesB];
        int sceneVertexZC = vertexZ[vertexFacesC];
        int sceneVertexYA = vertexY[vertexFacesA];
        int sceneVertexYB = vertexY[vertexFacesB];
        int sceneVertexYC = vertexY[vertexFacesC];
        int[] vertexA = new int[]{sceneVertexXA, sceneVertexZA, sceneVertexYA};
        int[] vertexB = new int[]{sceneVertexXB, sceneVertexZB, sceneVertexYB};
        int[] vertexC = new int[]{sceneVertexXC, sceneVertexZC, sceneVertexYC};
        return new int[][]{vertexA, vertexB, vertexC};
    }

    public static int[][] faceLocalVertices(Tile tile, int face) {
        int[][] vertices;
        if (tile.getSceneTileModel() == null) {
            return new int[0][0];
        }
        int x = tile.getSceneLocation().getX();
        int y = tile.getSceneLocation().getY();
        int baseX = x * 128;
        int baseY = y * 128;
        for (int[] vertex : vertices = ProceduralGenerator.faceVertices(tile, face)) {
            vertex[0] = vertex[0] - baseX;
            vertex[1] = vertex[1] - baseY;
        }
        return vertices;
    }

    public static int[] tileVertexKeys(Scene scene, Tile tile) {
        int[][] tileVertices = ProceduralGenerator.tileVertices(scene, tile);
        int[] vertexHashes = new int[tileVertices.length];
        for (int vertex = 0; vertex < tileVertices.length; ++vertex) {
            vertexHashes[vertex] = HDUtils.vertexHash(tileVertices[vertex]);
        }
        return vertexHashes;
    }

    public static int[] faceVertexKeys(Tile tile, int face) {
        int[][] faceVertices = ProceduralGenerator.faceVertices(tile, face);
        int[] vertexHashes = new int[faceVertices.length];
        for (int vertex = 0; vertex < faceVertices.length; ++vertex) {
            vertexHashes[vertex] = HDUtils.vertexHash(faceVertices[vertex]);
        }
        return vertexHashes;
    }

    public static int[] recolorTzHaar(int uuid, ModelOverride modelOverride, Model model, int face, int packedAlphaPriority, int color1, int color2, int color3) {
        int hue;
        int color1H = hue = 7;
        int color2H = hue;
        int color3H = hue;
        int color1S = color1 >> 7 & 7;
        int color1L = color1 & 0x7F;
        int color2S = color2 >> 7 & 7;
        int color2L = color2 & 0x7F;
        int color3S = color3 >> 7 & 7;
        int color3L = color3 & 0x7F;
        if (ModelHash.getUuidSubType(uuid) == 34 && color1S <= 1) {
            packedAlphaPriority = -16777216;
        }
        if (modelOverride.tzHaarRecolorType == TzHaarRecolorType.GRADIENT) {
            float pos;
            int triA = model.getFaceIndices1()[face];
            int triB = model.getFaceIndices2()[face];
            int triC = model.getFaceIndices3()[face];
            float[] yVertices = model.getVerticesY();
            float heightA = yVertices[triA];
            float heightB = yVertices[triB];
            float heightC = yVertices[triC];
            if (color1L < 20) {
                pos = HDUtils.clamp((heightA - -200.0f) / 200.0f, 0.0f, 1.0f);
                color1H = (int)HDUtils.lerp(gradientDarkColor[0], gradientBaseColor[0], pos);
                color1S = (int)HDUtils.lerp(gradientDarkColor[1], gradientBaseColor[1], pos);
                color1L = (int)HDUtils.lerp(gradientDarkColor[2], gradientBaseColor[2], pos);
            }
            if (color2L < 20) {
                pos = HDUtils.clamp((heightB - -200.0f) / 200.0f, 0.0f, 1.0f);
                color2H = (int)HDUtils.lerp(gradientDarkColor[0], gradientBaseColor[0], pos);
                color2S = (int)HDUtils.lerp(gradientDarkColor[1], gradientBaseColor[1], pos);
                color2L = (int)HDUtils.lerp(gradientDarkColor[2], gradientBaseColor[2], pos);
            }
            if (color3L < 20) {
                pos = HDUtils.clamp((heightC - -200.0f) / 200.0f, 0.0f, 1.0f);
                color3H = (int)HDUtils.lerp(gradientDarkColor[0], gradientBaseColor[0], pos);
                color3S = (int)HDUtils.lerp(gradientDarkColor[1], gradientBaseColor[1], pos);
                color3L = (int)HDUtils.lerp(gradientDarkColor[2], gradientBaseColor[2], pos);
            }
        } else if (modelOverride.tzHaarRecolorType == TzHaarRecolorType.HUE_SHIFT) {
            ++color1L;
            ++color2L;
            ++color3L;
        }
        ProceduralGenerator.tzHaarRecolored[0] = color1H << 10 | color1S << 7 | color1L;
        ProceduralGenerator.tzHaarRecolored[1] = color2H << 10 | color2S << 7 | color2L;
        ProceduralGenerator.tzHaarRecolored[2] = color3H << 10 | color3S << 7 | color3L;
        ProceduralGenerator.tzHaarRecolored[3] = packedAlphaPriority;
        return tzHaarRecolored;
    }
}

