/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Actor;
import net.runelite.api.ActorSpotAnim;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.DecorativeObject;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.GraphicsObject;
import net.runelite.api.GroundObject;
import net.runelite.api.IndexedObjectSet;
import net.runelite.api.NPC;
import net.runelite.api.ObjectComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Projectile;
import net.runelite.api.Renderable;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GraphicChanged;
import net.runelite.api.events.GraphicsObjectCreated;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.api.events.PlayerChanged;
import net.runelite.api.events.PlayerDespawned;
import net.runelite.api.events.PlayerSpawned;
import net.runelite.api.events.ProjectileMoved;
import net.runelite.api.events.VarbitChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.entityhider.EntityHiderConfig;
import net.runelite.client.plugins.entityhider.EntityHiderPlugin;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.HdPluginConfig;
import net.runelite.client.plugins.rs117.hd.config.MaxDynamicLights;
import net.runelite.client.plugins.rs117.hd.overlays.FrameTimer;
import net.runelite.client.plugins.rs117.hd.overlays.Timer;
import net.runelite.client.plugins.rs117.hd.scene.ModelOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.SceneContext;
import net.runelite.client.plugins.rs117.hd.scene.lights.Alignment;
import net.runelite.client.plugins.rs117.hd.scene.lights.Light;
import net.runelite.client.plugins.rs117.hd.scene.lights.LightDefinition;
import net.runelite.client.plugins.rs117.hd.scene.lights.LightType;
import net.runelite.client.plugins.rs117.hd.scene.lights.TileObjectImpostorTracker;
import net.runelite.client.plugins.rs117.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.ModelHash;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LightManager {
    private static final Logger log = LoggerFactory.getLogger(LightManager.class);
    private static final ResourcePath LIGHTS_PATH = Props.getPathOrDefault("rlhd.lights-path", () -> ResourcePath.path(LightManager.class, "lights.json"));
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    @Inject
    private ModelOverrideManager modelOverrideManager;
    @Inject
    private EntityHiderPlugin entityHiderPlugin;
    @Inject
    private FrameTimer frameTimer;
    private final ArrayList<Light> WORLD_LIGHTS = new ArrayList();
    private final ListMultimap<Integer, LightDefinition> NPC_LIGHTS = ArrayListMultimap.create();
    private final ListMultimap<Integer, LightDefinition> OBJECT_LIGHTS = ArrayListMultimap.create();
    private final ListMultimap<Integer, LightDefinition> PROJECTILE_LIGHTS = ArrayListMultimap.create();
    private final ListMultimap<Integer, LightDefinition> SPOT_ANIM_LIGHTS = ArrayListMultimap.create();
    private boolean reloadLights;
    private EntityHiderConfig entityHiderConfig;
    private int currentPlane;

    public void loadConfig(Gson gson, ResourcePath path) {
        try {
            LightDefinition[] lights;
            try {
                lights = path.loadJson(gson, LightDefinition[].class);
                if (lights == null) {
                    log.warn("Skipping empty lights.json");
                    return;
                }
            }
            catch (IOException ex) {
                log.error("Failed to load lights", ex);
                return;
            }
            this.WORLD_LIGHTS.clear();
            this.NPC_LIGHTS.clear();
            this.OBJECT_LIGHTS.clear();
            this.PROJECTILE_LIGHTS.clear();
            this.SPOT_ANIM_LIGHTS.clear();
            for (LightDefinition lightDef : lights) {
                lightDef.normalize();
                if (lightDef.worldX != null && lightDef.worldY != null) {
                    Light light = new Light(lightDef);
                    light.worldPoint = new WorldPoint(lightDef.worldX, lightDef.worldY, lightDef.plane);
                    light.persistent = true;
                    this.WORLD_LIGHTS.add(light);
                }
                lightDef.npcIds.forEach(id -> this.NPC_LIGHTS.put((Integer)id, lightDef));
                lightDef.objectIds.forEach(id -> this.OBJECT_LIGHTS.put((Integer)id, lightDef));
                lightDef.projectileIds.forEach(id -> this.PROJECTILE_LIGHTS.put((Integer)id, lightDef));
                lightDef.spotAnimIds.forEach(id -> this.SPOT_ANIM_LIGHTS.put((Integer)id, lightDef));
            }
            log.debug("Loaded {} lights", (Object)lights.length);
            this.reloadLights = true;
        }
        catch (Exception ex) {
            log.error("Failed to parse light configuration", ex);
        }
    }

    public void startUp() {
        this.entityHiderConfig = this.configManager.getConfig(EntityHiderConfig.class);
        LIGHTS_PATH.watch(path -> this.loadConfig(this.plugin.getGson(), (ResourcePath)path));
        this.eventBus.register(this);
    }

    public void shutDown() {
        this.eventBus.unregister(this);
    }

    public void update(@Nonnull SceneContext sceneContext) {
        assert (this.client.isClientThread());
        if (this.client.getGameState() != GameState.LOGGED_IN || this.config.maxDynamicLights() == MaxDynamicLights.NONE) {
            sceneContext.numVisibleLights = 0;
            return;
        }
        if (this.reloadLights) {
            this.reloadLights = false;
            this.loadSceneLights(sceneContext, null);
            this.client.getNpcs().forEach(npc -> {
                this.addNpcLights((NPC)npc);
                this.addSpotAnimLights((Actor)npc);
            });
        }
        if (sceneContext.knownProjectiles.size() > 10000) {
            log.warn("Too many projectiles tracked: {}. Clearing...", (Object)sceneContext.knownProjectiles.size());
            sceneContext.knownProjectiles.clear();
        }
        if (sceneContext.lights.size() > 10000) {
            log.warn("Too many lights: {}. Clearing...", (Object)sceneContext.lights.size());
            sceneContext.lights.clear();
        }
        int drawDistance = this.plugin.getDrawDistance() * 128;
        Tile[][][] tiles = sceneContext.scene.getExtendedTiles();
        int[][][] tileHeights = sceneContext.scene.getTileHeights();
        IndexedObjectSet<? extends NPC> cachedNpcs = this.client.getTopLevelWorldView().npcs();
        IndexedObjectSet<? extends Player> cachedPlayers = this.client.getTopLevelWorldView().players();
        int plane = this.client.getPlane();
        boolean changedPlanes = false;
        if (plane != this.currentPlane) {
            this.currentPlane = plane;
            changedPlanes = true;
        }
        for (Light light : sceneContext.lights) {
            int distFromCamera;
            int tileExY;
            boolean parentExists = !light.markedForRemoval;
            boolean hiddenTemporarily = false;
            if (light.tileObject != null) {
                if (!light.markedForRemoval && light.animationSpecific && light.tileObject instanceof GameObject) {
                    Animation anim;
                    int animationId = -1;
                    Renderable renderable = ((GameObject)light.tileObject).getRenderable();
                    if (renderable instanceof DynamicObject && (anim = ((DynamicObject)renderable).getAnimation()) != null) {
                        animationId = anim.getId();
                    }
                    parentExists = light.def.animationIds.contains(animationId);
                }
            } else if (light.projectile != null) {
                light.origin[0] = (int)light.projectile.getX();
                light.origin[1] = (int)light.projectile.getZ() - light.def.height;
                light.origin[2] = (int)light.projectile.getY();
                if (light.projectile.getRemainingCycles() <= 0) {
                    light.markedForRemoval = true;
                } else {
                    boolean bl = hiddenTemporarily = !this.shouldShowProjectileLights();
                    if (light.animationSpecific) {
                        Animation animation = light.projectile.getAnimation();
                        parentExists = animation != null && light.def.animationIds.contains(animation.getId());
                    }
                    light.orientation = (int)Math.round(Math.atan2(light.projectile.getVelocityZ(), light.projectile.getVelocityX()) / 0.0030679615757712823);
                }
            } else if (light.graphicsObject != null) {
                light.origin[0] = light.graphicsObject.getLocation().getX();
                light.origin[1] = light.graphicsObject.getZ() - light.def.height;
                light.origin[2] = light.graphicsObject.getLocation().getY();
                if (light.graphicsObject.finished()) {
                    light.markedForRemoval = true;
                } else if (light.animationSpecific) {
                    Animation animation = light.graphicsObject.getAnimation();
                    parentExists = animation != null && light.def.animationIds.contains(animation.getId());
                }
            } else if (light.actor != null && !light.markedForRemoval) {
                if (light.actor instanceof NPC && light.actor != cachedNpcs.byIndex(((NPC)light.actor).getIndex()) || light.actor instanceof Player && light.actor != cachedPlayers.byIndex(((Player)light.actor).getId()) || light.spotAnimId != -1 && !light.actor.hasSpotAnim(light.spotAnimId)) {
                    parentExists = false;
                    light.markedForRemoval = true;
                } else {
                    Tile tile;
                    LocalPoint lp = light.actor.getLocalLocation();
                    light.origin[0] = lp.getX();
                    light.origin[2] = lp.getY();
                    light.plane = plane;
                    light.orientation = light.actor.getCurrentOrientation();
                    if (light.animationSpecific) {
                        parentExists = light.def.animationIds.contains(light.actor.getAnimation());
                    }
                    int tileExX = (light.origin[0] >> 7) + 40;
                    tileExY = (light.origin[2] >> 7) + 40;
                    if (tileExX >= 0 && tileExY >= 0 && tileExX < 184 && tileExY < 184 && (tile = tiles[plane][tileExX][tileExY]) != null) {
                        if (!(light.def.ignoreActorHiding || light.actor instanceof NPC && ((NPC)light.actor).getComposition().getSize() > 1)) {
                            for (GameObject gameObject : tile.getGameObjects()) {
                                if (gameObject == null || !(gameObject.getRenderable() instanceof Actor) || gameObject.getX() != light.origin[0] || gameObject.getY() != light.origin[2]) continue;
                                hiddenTemporarily = gameObject.getRenderable() != light.actor;
                                break;
                            }
                        }
                        if (!hiddenTemporarily) {
                            boolean bl = hiddenTemporarily = !this.isActorLightVisible(light.actor);
                        }
                        if (tileExX != light.prevTileX || tileExY != light.prevTileY) {
                            light.prevTileX = tileExX;
                            light.prevTileY = tileExY;
                            if (tile.getBridge() != null) {
                                ++plane;
                            }
                            float lerpX = HDUtils.fract((float)light.origin[0] / 128.0f);
                            float lerpY = HDUtils.fract((float)light.origin[2] / 128.0f);
                            int baseTileX = (light.origin[0] >> 7) + 40;
                            int baseTileY = (light.origin[2] >> 7) + 40;
                            float heightNorth = HDUtils.lerp(tileHeights[plane][baseTileX][baseTileY + 1], tileHeights[plane][baseTileX + 1][baseTileY + 1], lerpX);
                            float heightSouth = HDUtils.lerp(tileHeights[plane][baseTileX][baseTileY], tileHeights[plane][baseTileX + 1][baseTileY], lerpX);
                            float tileHeight = HDUtils.lerp(heightSouth, heightNorth, lerpY);
                            light.origin[1] = (int)tileHeight - 1 - light.def.height;
                        }
                    }
                }
            }
            light.pos[0] = light.origin[0];
            light.pos[1] = light.origin[1];
            light.pos[2] = light.origin[2];
            int orientation = 0;
            if (light.alignment.relative) {
                orientation = HDUtils.mod(light.orientation + light.preOrientation + light.alignment.orientation, 2048);
            }
            if (light.alignment == Alignment.CUSTOM) {
                int sin = Perspective.SINE[orientation];
                int cos = Perspective.COSINE[orientation];
                int x = light.offset[0];
                int z = light.offset[2];
                light.pos[0] = light.pos[0] + (-cos * x - sin * z >> 16);
                light.pos[1] = light.pos[1] + light.offset[1];
                light.pos[2] = light.pos[2] + (-cos * z + sin * x >> 16);
            } else {
                int localSizeX = light.sizeX * 128;
                int localSizeY = light.sizeY * 128;
                float radius = (float)localSizeX / 2.0f;
                if (!light.alignment.radial) {
                    radius = (float)Math.sqrt(localSizeX * localSizeX + localSizeX * localSizeX) / 2.0f;
                }
                float sine = (float)Perspective.SINE[orientation] / 65536.0f;
                float cosine = (float)Perspective.COSINE[orientation] / 65536.0f;
                int offsetX = (int)(radius * sine);
                int offsetY = (int)(radius * (cosine /= (float)localSizeX / (float)localSizeY));
                light.pos[0] = light.pos[0] + offsetX;
                light.pos[2] = light.pos[2] + offsetY;
            }
            if (light.prevPlane != light.plane) {
                light.prevPlane = light.plane;
                light.belowFloor = false;
                light.aboveFloor = false;
                int tileExX = (light.pos[0] >> 7) + 40;
                tileExY = (light.pos[2] >> 7) + 40;
                if (light.plane >= 0 && tileExX >= 0 && tileExY >= 0 && tileExX < 184 && tileExY < 184) {
                    byte hasTile = sceneContext.filledTiles[tileExX][tileExY];
                    if ((hasTile & 1 << light.plane + 1) != 0) {
                        light.belowFloor = true;
                    }
                    if ((hasTile & 1 << light.plane) != 0) {
                        light.aboveFloor = true;
                    }
                }
            }
            if (!hiddenTemporarily && !light.def.visibleFromOtherPlanes) {
                if (light.plane < plane && light.belowFloor) {
                    hiddenTemporarily = true;
                }
                if (light.plane > plane && light.aboveFloor) {
                    hiddenTemporarily = true;
                }
            }
            if (parentExists != light.parentExists) {
                light.parentExists = parentExists;
                if (parentExists) {
                    if (light.replayable) {
                        light.elapsedTime = 0.0f;
                        light.changedVisibilityAt = -1.0f;
                        if (light.dynamicLifetime) {
                            light.lifetime = -1.0f;
                        }
                    }
                } else if (light.lifetime == -1.0f) {
                    float minLifetime = light.spawnDelay + light.fadeInDuration;
                    light.lifetime = Math.max(minLifetime, light.elapsedTime) + light.despawnDelay;
                }
            }
            if (hiddenTemporarily != light.hiddenTemporarily) {
                light.toggleTemporaryVisibility(changedPlanes);
            }
            light.elapsedTime += this.plugin.deltaClientTime;
            boolean bl = light.visible = light.spawnDelay < light.elapsedTime && (light.lifetime == -1.0f || light.elapsedTime < light.lifetime);
            if (light.visible && light.hiddenTemporarily) {
                boolean bl2 = light.visible = light.changedVisibilityAt != -1.0f && light.elapsedTime - light.changedVisibilityAt < 0.1f;
            }
            if (light.visible && (distFromCamera = (int)Math.max(Math.abs(this.plugin.cameraPosition[0] - (float)light.pos[0]), Math.abs(this.plugin.cameraPosition[2] - (float)light.pos[2])) - light.radius) > drawDistance) {
                light.visible = false;
            }
            if (!light.visible) continue;
            int distX = this.plugin.cameraFocalPoint[0] - light.pos[0];
            int distZ = this.plugin.cameraFocalPoint[1] - light.pos[2];
            light.distanceSquared = distX * distX + distZ * distZ + light.pos[1] * light.pos[1];
        }
        sceneContext.lights.sort((a, b) -> {
            if (a.visible && b.visible) {
                return a.distanceSquared - b.distanceSquared;
            }
            if (!a.visible && !b.visible) {
                return 0;
            }
            return a.visible ? -1 : 1;
        });
        sceneContext.numVisibleLights = 0;
        for (Light light : sceneContext.lights) {
            if (!light.visible || sceneContext.numVisibleLights >= this.plugin.configMaxDynamicLights) break;
            ++sceneContext.numVisibleLights;
            if (!light.withinViewingDistance && light.hiddenTemporarily) {
                light.toggleTemporaryVisibility(changedPlanes);
            }
            light.withinViewingDistance = true;
            if (light.def.type == LightType.FLICKER) {
                double t = 6.2831854820251465 * (HDUtils.mod(this.plugin.elapsedTime, 60.0) / 60.0 + (double)light.randomOffset);
                float flicker = (float)(Math.pow(Math.cos(11.0 * t), 3.0) + Math.pow(Math.cos(17.0 * t), 6.0) + Math.pow(Math.cos(23.0 * t), 2.0) + Math.pow(Math.cos(31.0 * t), 6.0) + Math.pow(Math.cos(71.0 * t), 4.0) + Math.pow(Math.cos(151.0 * t), 6.0) / 2.0) / 4.335f;
                float maxFlicker = 1.0f + light.def.range / 100.0f;
                float minFlicker = 1.0f - light.def.range / 100.0f;
                flicker = minFlicker + (maxFlicker - minFlicker) * flicker;
                light.strength = light.def.strength * flicker;
                light.radius = (int)((float)light.def.radius * 1.5f);
            } else if (light.def.type == LightType.PULSE) {
                light.animation = HDUtils.fract(light.animation + this.plugin.deltaClientTime / light.duration);
                float output = 1.0f - 2.0f * Math.abs(light.animation - 0.5f);
                float range = light.def.range / 100.0f;
                float fullRange = range * 2.0f;
                float multiplier = 1.0f - range + output * fullRange;
                light.radius = (int)((float)light.def.radius * multiplier);
                light.strength = light.def.strength * multiplier;
            } else {
                light.strength = light.def.strength;
                light.radius = light.def.radius;
                light.color = light.def.color;
            }
            if (light.fadeInDuration > 0.0f) {
                light.strength *= HDUtils.clamp((light.elapsedTime - light.spawnDelay) / light.fadeInDuration, 0.0f, 1.0f);
            }
            if (light.fadeOutDuration > 0.0f && light.lifetime != -1.0f) {
                light.strength *= HDUtils.clamp((light.lifetime - light.elapsedTime) / light.fadeOutDuration, 0.0f, 1.0f);
            }
            light.applyTemporaryVisibilityFade();
        }
        for (int i = sceneContext.lights.size() - 1; i >= sceneContext.numVisibleLights; --i) {
            Light light;
            light = sceneContext.lights.get(i);
            light.withinViewingDistance = false;
            if (!light.replayable && light.lifetime != -1.0f && light.lifetime < light.elapsedTime) {
                light.markedForRemoval = true;
            }
            if (!light.markedForRemoval) continue;
            sceneContext.lights.remove(i);
            if (light.projectile == null || (light.projectileRefCounter[0] = light.projectileRefCounter[0] - 1) != 0) continue;
            sceneContext.knownProjectiles.remove(light.projectile);
        }
    }

    private boolean isActorLightVisible(@Nonnull Actor actor) {
        try {
            if (actor.getModel() == null) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        boolean entityHiderEnabled = this.pluginManager.isPluginEnabled(this.entityHiderPlugin);
        if (actor instanceof NPC) {
            if (!this.plugin.configNpcLights) {
                return false;
            }
            if (entityHiderEnabled) {
                NPC npc = (NPC)actor;
                boolean isPet = npc.getComposition().isFollower();
                if (this.client.getFollower() != null && this.client.getFollower().getIndex() == npc.getIndex()) {
                    return true;
                }
                if (this.entityHiderConfig.hideNPCs() && !isPet) {
                    return false;
                }
                return !this.entityHiderConfig.hidePets() || !isPet;
            }
        } else if (actor instanceof Player && entityHiderEnabled) {
            Player player = (Player)actor;
            Player local = this.client.getLocalPlayer();
            if (local == null || player.getName() == null) {
                return true;
            }
            if (player == local) {
                return !this.entityHiderConfig.hideLocalPlayer();
            }
            if (this.entityHiderConfig.hideAttackers() && player.getInteracting() == local) {
                return false;
            }
            if (player.isFriend()) {
                return !this.entityHiderConfig.hideFriends();
            }
            if (player.isFriendsChatMember()) {
                return !this.entityHiderConfig.hideFriendsChatMembers();
            }
            if (player.isClanMember()) {
                return !this.entityHiderConfig.hideClanChatMembers();
            }
            if (this.client.getIgnoreContainer().findByName(player.getName()) != null) {
                return !this.entityHiderConfig.hideIgnores();
            }
            return !this.entityHiderConfig.hideOthers();
        }
        return true;
    }

    private boolean shouldShowProjectileLights() {
        return this.plugin.configProjectileLights && (!this.pluginManager.isPluginEnabled(this.entityHiderPlugin) || !this.entityHiderConfig.hideProjectiles());
    }

    public void loadSceneLights(SceneContext sceneContext, @Nullable SceneContext oldSceneContext) {
        assert (this.client.isClientThread());
        if (oldSceneContext == null) {
            sceneContext.lights.clear();
            sceneContext.trackedTileObjects.clear();
            sceneContext.trackedVarps.clear();
            sceneContext.trackedVarbits.clear();
            sceneContext.knownProjectiles.clear();
        } else {
            ArrayList<Light> lightsToKeep = new ArrayList<Light>();
            for (Light light : oldSceneContext.lights) {
                if (light.actor == null && light.projectile == null) continue;
                lightsToKeep.add(light);
            }
            sceneContext.lights.addAll(lightsToKeep);
            for (Light light : lightsToKeep) {
                if (light.projectile == null || !oldSceneContext.knownProjectiles.contains(light.projectile)) continue;
                sceneContext.knownProjectiles.add(light.projectile);
            }
        }
        for (Light light : this.WORLD_LIGHTS) {
            assert (light.worldPoint != null);
            int regionId = light.worldPoint.getRegionID();
            if (!sceneContext.regionIds.contains(regionId)) continue;
            this.addWorldLight(sceneContext, light);
        }
        Tile[][][] tileArray = sceneContext.scene.getExtendedTiles();
        int n = tileArray.length;
        for (int i = 0; i < n; ++i) {
            Tile[][] plane;
            Tile[][] tileArray2 = plane = tileArray[i];
            int n2 = tileArray2.length;
            for (int j = 0; j < n2; ++j) {
                Tile[] column;
                for (Tile tile : column = tileArray2[j]) {
                    GroundObject groundObject;
                    WallObject wallObject;
                    if (tile == null) continue;
                    DecorativeObject decorativeObject = tile.getDecorativeObject();
                    if (decorativeObject != null) {
                        this.handleObjectSpawn(sceneContext, decorativeObject);
                    }
                    if ((wallObject = tile.getWallObject()) != null) {
                        this.handleObjectSpawn(sceneContext, wallObject);
                    }
                    if ((groundObject = tile.getGroundObject()) != null && groundObject.getRenderable() != null) {
                        this.handleObjectSpawn(sceneContext, groundObject);
                    }
                    for (GameObject gameObject : tile.getGameObjects()) {
                        if (gameObject == null || gameObject.getRenderable() instanceof Actor) continue;
                        this.handleObjectSpawn(sceneContext, gameObject);
                    }
                }
            }
        }
    }

    private void removeLightIf(Predicate<Light> predicate) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        this.removeLightIf(sceneContext, predicate);
    }

    private void removeLightIf(@Nonnull SceneContext sceneContext, Predicate<Light> predicate) {
        for (Light light : sceneContext.lights) {
            if (!predicate.test(light)) continue;
            light.markedForRemoval = true;
        }
    }

    private void addSpotAnimLights(Actor actor) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        int[] worldPos = sceneContext.localToWorld(actor.getLocalLocation());
        for (ActorSpotAnim spotAnim : actor.getSpotAnims()) {
            int spotAnimId = spotAnim.getId();
            for (LightDefinition def : this.SPOT_ANIM_LIGHTS.get((Object)spotAnim.getId())) {
                boolean isDuplicate;
                boolean isInArea;
                if (def.areas.length > 0 && !(isInArea = Arrays.stream(def.areas).anyMatch(aabb -> aabb.contains(worldPos))) || def.excludeAreas.length > 0 && (isInArea = Arrays.stream(def.excludeAreas).anyMatch(aabb -> aabb.contains(worldPos))) || (isDuplicate = sceneContext.lights.stream().anyMatch(light -> light.spotAnimId == spotAnimId && light.actor == actor && light.def == def))) continue;
                Light light2 = new Light(def);
                light2.plane = -1;
                light2.spotAnimId = spotAnimId;
                light2.actor = actor;
                sceneContext.lights.add(light2);
            }
        }
    }

    private void addNpcLights(NPC npc) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        int uuid = ModelHash.packUuid(1, npc.getId());
        int[] worldPos = sceneContext.localToWorld(npc.getLocalLocation());
        ModelOverride modelOverride = this.modelOverrideManager.getOverride(uuid, worldPos);
        if (modelOverride.hide) {
            return;
        }
        for (LightDefinition def : this.NPC_LIGHTS.get((Object)npc.getId())) {
            boolean isDuplicate;
            boolean isInArea;
            if (def.areas.length > 0 && !(isInArea = Arrays.stream(def.areas).anyMatch(aabb -> aabb.contains(worldPos))) || def.excludeAreas.length > 0 && (isInArea = Arrays.stream(def.excludeAreas).anyMatch(aabb -> aabb.contains(worldPos))) || (isDuplicate = sceneContext.lights.stream().anyMatch(light -> light.actor == npc && light.def == def && !light.markedForRemoval))) continue;
            Light light2 = new Light(def);
            light2.plane = -1;
            light2.actor = npc;
            sceneContext.lights.add(light2);
        }
    }

    private void handleObjectSpawn(TileObject object) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext != null) {
            this.handleObjectSpawn(sceneContext, object);
        }
    }

    private void handleObjectSpawn(@Nonnull SceneContext sceneContext, @Nonnull TileObject tileObject) {
        if (sceneContext.trackedTileObjects.containsKey(tileObject)) {
            return;
        }
        TileObjectImpostorTracker tracker = new TileObjectImpostorTracker(tileObject);
        sceneContext.trackedTileObjects.put(tileObject, tracker);
        if (tileObject.getPlane() < 0) {
            return;
        }
        ObjectComposition def = this.client.getObjectDefinition(tileObject.getId());
        tracker.impostorIds = def.getImpostorIds();
        if (tracker.impostorIds != null) {
            tracker.impostorVarbit = def.getVarbitId();
            tracker.impostorVarp = def.getVarPlayerId();
            if (tracker.impostorVarbit != -1) {
                sceneContext.trackedVarbits.put(tracker.impostorVarbit, tracker);
            }
            if (tracker.impostorVarp != -1) {
                sceneContext.trackedVarps.put(tracker.impostorVarp, tracker);
            }
        }
        this.trackImpostorChanges(sceneContext, tracker);
    }

    private void handleObjectDespawn(TileObject tileObject) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        TileObjectImpostorTracker tracker = sceneContext.trackedTileObjects.remove(tileObject);
        if (tracker == null) {
            return;
        }
        if (tracker.spawnedAnyLights) {
            long hash = tracker.lightHash(tracker.impostorId);
            this.removeLightIf(sceneContext, l -> l.hash == hash);
        }
        if (tracker.impostorVarbit != -1) {
            sceneContext.trackedVarbits.remove(tracker.impostorVarbit, tracker);
        }
        if (tracker.impostorVarp != -1) {
            sceneContext.trackedVarps.remove(tracker.impostorVarp, tracker);
        }
    }

    private void trackImpostorChanges(@Nonnull SceneContext sceneContext, TileObjectImpostorTracker tracker) {
        TileObject object;
        int impostorId = -1;
        if (tracker.impostorIds != null) {
            try {
                int impostorIndex = -1;
                if (tracker.impostorVarbit != -1) {
                    impostorIndex = this.client.getVarbitValue(tracker.impostorVarbit);
                } else if (tracker.impostorVarp != -1) {
                    impostorIndex = this.client.getVarpValue(tracker.impostorVarp);
                }
                if (impostorIndex >= 0) {
                    impostorId = tracker.impostorIds[Math.min(impostorIndex, tracker.impostorIds.length - 1)];
                }
            }
            catch (Exception ex) {
                log.debug("Error getting impostor:", ex);
            }
        }
        if (impostorId == tracker.impostorId && !tracker.justSpawned) {
            return;
        }
        int sizeX = 1;
        int sizeY = 1;
        Renderable[] renderables = new Renderable[2];
        int[] orientations = new int[2];
        TileObject tileObject = tracker.tileObject;
        if (tileObject instanceof GroundObject) {
            object = (GroundObject)tileObject;
            renderables[0] = object.getRenderable();
            orientations[0] = HDUtils.getBakedOrientation(object.getConfig());
        } else if (tileObject instanceof DecorativeObject) {
            object = (DecorativeObject)tileObject;
            renderables[0] = object.getRenderable();
            renderables[1] = object.getRenderable2();
            orientations[0] = orientations[1] = HDUtils.getBakedOrientation(object.getConfig());
        } else if (tileObject instanceof WallObject) {
            object = (WallObject)tileObject;
            renderables[0] = object.getRenderable1();
            renderables[1] = object.getRenderable2();
            orientations[0] = HDUtils.convertWallObjectOrientation(object.getOrientationA());
            orientations[1] = HDUtils.convertWallObjectOrientation(object.getOrientationB());
        } else if (tileObject instanceof GameObject) {
            object = (GameObject)tileObject;
            sizeX = object.sizeX();
            sizeY = object.sizeY();
            renderables[0] = object.getRenderable();
            orientations[0] = HDUtils.getBakedOrientation(object.getConfig());
        } else {
            log.warn("Unhandled TileObject type: id: {}, hash: {}", (Object)tileObject.getId(), (Object)tileObject.getHash());
            return;
        }
        if (tracker.spawnedAnyLights) {
            long oldHash = tracker.lightHash(tracker.impostorId);
            this.removeLightIf(sceneContext, l -> l.hash == oldHash);
            tracker.spawnedAnyLights = false;
        }
        long newHash = tracker.lightHash(impostorId);
        Collection lights = this.OBJECT_LIGHTS.get((Object)(impostorId == -1 ? tileObject.getId() : impostorId));
        HashSet<LightDefinition> onlySpawnOnce = new HashSet<LightDefinition>();
        LocalPoint lp = tileObject.getLocalLocation();
        int lightX = lp.getX();
        int lightZ = lp.getY();
        int plane = tileObject.getPlane();
        for (int i = 0; i < 2; ++i) {
            Renderable renderable = renderables[i];
            if (renderable == null) continue;
            for (LightDefinition def : lights) {
                boolean isInArea;
                int[] worldPos;
                if (def.areas.length > 0) {
                    worldPos = sceneContext.localToWorld(lightX, lightZ, plane);
                    isInArea = Arrays.stream(def.areas).anyMatch(aabb -> aabb.contains(worldPos));
                    if (!isInArea) continue;
                }
                if (def.excludeAreas.length > 0) {
                    worldPos = sceneContext.localToWorld(lightX, lightZ, plane);
                    isInArea = Arrays.stream(def.excludeAreas).anyMatch(aabb -> aabb.contains(worldPos));
                    if (isInArea) continue;
                }
                if (def.renderableIndex == -1) {
                    if (onlySpawnOnce.contains(def)) continue;
                    onlySpawnOnce.add(def);
                } else if (def.renderableIndex != i) continue;
                int tileExX = HDUtils.clamp(lp.getSceneX() + 40, 0, 182);
                int tileExY = HDUtils.clamp(lp.getSceneY() + 40, 0, 182);
                float lerpX = HDUtils.fract((float)lightX / 128.0f);
                float lerpZ = HDUtils.fract((float)lightZ / 128.0f);
                int tileZ = HDUtils.clamp(plane, 0, 3);
                Tile[][][] tiles = sceneContext.scene.getExtendedTiles();
                Tile tile = tiles[tileZ][tileExX][tileExY];
                if (tile != null && tile.getBridge() != null && tileZ < 3) {
                    ++tileZ;
                }
                int[][][] tileHeights = sceneContext.scene.getTileHeights();
                float heightNorth = HDUtils.lerp(tileHeights[tileZ][tileExX][tileExY + 1], tileHeights[tileZ][tileExX + 1][tileExY + 1], lerpX);
                float heightSouth = HDUtils.lerp(tileHeights[tileZ][tileExX][tileExY], tileHeights[tileZ][tileExX + 1][tileExY], lerpX);
                float tileHeight = HDUtils.lerp(heightSouth, heightNorth, lerpZ);
                Light light = new Light(def);
                light.hash = newHash;
                light.tileObject = tileObject;
                light.plane = plane;
                light.preOrientation = orientations[i];
                light.origin[0] = lightX;
                light.origin[1] = (int)tileHeight - light.def.height - 1;
                light.origin[2] = lightZ;
                light.sizeX = sizeX;
                light.sizeY = sizeY;
                sceneContext.lights.add(light);
                tracker.spawnedAnyLights = true;
            }
        }
        tracker.impostorId = impostorId;
        tracker.justSpawned = false;
    }

    private void addWorldLight(SceneContext sceneContext, Light light) {
        assert (light.worldPoint != null);
        Optional<LocalPoint> firstlp = sceneContext.worldInstanceToLocals(light.worldPoint).findFirst();
        if (firstlp.isEmpty()) {
            return;
        }
        LocalPoint lp = firstlp.get();
        int tileExX = lp.getSceneX() + 40;
        int tileExY = lp.getSceneY() + 40;
        if (tileExX < 0 || tileExY < 0 || tileExX >= 184 || tileExY >= 184) {
            return;
        }
        light.origin[0] = lp.getX() + 64;
        light.origin[1] = sceneContext.scene.getTileHeights()[light.plane][tileExX][tileExY] - light.def.height - 1;
        light.origin[2] = lp.getY() + 64;
        sceneContext.lights.add(light);
    }

    @Subscribe
    public void onProjectileMoved(ProjectileMoved projectileMoved) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        Projectile projectile = projectileMoved.getProjectile();
        if (!sceneContext.knownProjectiles.add(projectile)) {
            return;
        }
        int[] worldPos = sceneContext.localToWorld((int)projectile.getX(), (int)projectile.getY(), projectile.getFloor());
        int[] refCounter = new int[]{0};
        for (LightDefinition def : this.PROJECTILE_LIGHTS.get((Object)projectile.getId())) {
            boolean isInArea;
            if (def.areas.length > 0 && !(isInArea = Arrays.stream(def.areas).anyMatch(aabb -> aabb.contains(worldPos))) || def.excludeAreas.length > 0 && (isInArea = Arrays.stream(def.excludeAreas).anyMatch(aabb -> aabb.contains(worldPos)))) continue;
            Light light = new Light(def);
            light.projectile = projectile;
            light.projectileRefCounter = refCounter;
            refCounter[0] = refCounter[0] + 1;
            light.origin[0] = (int)projectile.getX();
            light.origin[1] = (int)projectile.getZ();
            light.origin[2] = (int)projectile.getY();
            light.plane = projectile.getFloor();
            sceneContext.lights.add(light);
        }
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned spawn) {
        NPC npc = spawn.getNpc();
        this.addNpcLights(npc);
        this.addSpotAnimLights(npc);
    }

    @Subscribe
    public void onNpcChanged(NpcChanged change) {
        NPC npc = change.getNpc();
        this.removeLightIf(light -> light.actor == npc && light.spotAnimId == -1);
        this.addNpcLights(change.getNpc());
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned despawn) {
        NPC npc = despawn.getNpc();
        this.removeLightIf(light -> light.actor == npc);
    }

    @Subscribe
    public void onPlayerSpawned(PlayerSpawned spawn) {
        this.addSpotAnimLights(spawn.getPlayer());
    }

    @Subscribe
    public void onPlayerChanged(PlayerChanged change) {
    }

    @Subscribe
    public void onGraphicChanged(GraphicChanged change) {
        this.addSpotAnimLights(change.getActor());
    }

    @Subscribe
    public void onPlayerDespawned(PlayerDespawned despawn) {
        Player player = despawn.getPlayer();
        this.removeLightIf(light -> light.actor == player);
    }

    @Subscribe
    public void onGraphicsObjectCreated(GraphicsObjectCreated graphicsObjectCreated) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        GraphicsObject graphicsObject = graphicsObjectCreated.getGraphicsObject();
        LocalPoint lp = graphicsObject.getLocation();
        int[] worldPos = sceneContext.localToWorld(lp, graphicsObject.getLevel());
        for (LightDefinition def : this.SPOT_ANIM_LIGHTS.get((Object)graphicsObject.getId())) {
            boolean isInArea;
            if (def.areas.length > 0 && !(isInArea = Arrays.stream(def.areas).anyMatch(aabb -> aabb.contains(worldPos))) || def.excludeAreas.length > 0 && (isInArea = Arrays.stream(def.excludeAreas).anyMatch(aabb -> aabb.contains(worldPos)))) continue;
            Light light = new Light(def);
            light.graphicsObject = graphicsObject;
            light.origin[0] = lp.getX();
            light.origin[1] = graphicsObject.getZ();
            light.origin[2] = lp.getY();
            light.plane = worldPos[2];
            sceneContext.lights.add(light);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned spawn) {
        this.handleObjectSpawn(spawn.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned despawn) {
        this.handleObjectDespawn(despawn.getGameObject());
    }

    @Subscribe
    public void onWallObjectSpawned(WallObjectSpawned spawn) {
        this.handleObjectSpawn(spawn.getWallObject());
    }

    @Subscribe
    public void onWallObjectDespawned(WallObjectDespawned despawn) {
        this.handleObjectDespawn(despawn.getWallObject());
    }

    @Subscribe
    public void onDecorativeObjectSpawned(DecorativeObjectSpawned spawn) {
        this.handleObjectSpawn(spawn.getDecorativeObject());
    }

    @Subscribe
    public void onDecorativeObjectDespawned(DecorativeObjectDespawned despawn) {
        this.handleObjectDespawn(despawn.getDecorativeObject());
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned spawn) {
        this.handleObjectSpawn(spawn.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned despawn) {
        this.handleObjectDespawn(despawn.getGroundObject());
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return;
        }
        if (this.plugin.enableDetailedTimers) {
            this.frameTimer.begin(Timer.IMPOSTOR_TRACKING);
        }
        if (event.getVarbitId() != -1) {
            for (TileObjectImpostorTracker tracker : sceneContext.trackedVarbits.get((Object)event.getVarbitId())) {
                this.trackImpostorChanges(sceneContext, tracker);
            }
        } else if (event.getVarpId() != -1) {
            for (TileObjectImpostorTracker tracker : sceneContext.trackedVarps.get((Object)event.getVarpId())) {
                this.trackImpostorChanges(sceneContext, tracker);
            }
        }
        if (this.plugin.enableDetailedTimers) {
            this.frameTimer.end(Timer.IMPOSTOR_TRACKING);
        }
    }
}

