/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import java.io.IOException;
import javax.inject.Inject;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.data.materials.GroundMaterial;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.scene.AreaManager;
import net.runelite.client.plugins.rs117.hd.scene.TileOverrideManager;
import net.runelite.client.plugins.rs117.hd.utils.FileWatcher;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroundMaterialManager {
    private static final Logger log = LoggerFactory.getLogger(GroundMaterialManager.class);
    private static final ResourcePath GROUND_MATERIALS_PATH = Props.getPathOrDefault("rlhd.ground-materials-path", () -> ResourcePath.path(AreaManager.class, "ground_materials.json"));
    @Inject
    private HdPlugin plugin;
    @Inject
    private ClientThread clientThread;
    @Inject
    private TileOverrideManager tileOverrideManager;
    private FileWatcher.UnregisterCallback fileWatcher;
    public static GroundMaterial[] GROUND_MATERIALS = new GroundMaterial[0];

    public void startUp() {
        this.fileWatcher = GROUND_MATERIALS_PATH.watch((path, first) -> {
            try {
                GroundMaterial[] groundMaterials = path.loadJson(this.plugin.getGson(), GroundMaterial[].class);
                if (groundMaterials == null) {
                    throw new IOException("Empty or invalid: " + path);
                }
                GROUND_MATERIALS = new GroundMaterial[groundMaterials.length + 2];
                GroundMaterialManager.GROUND_MATERIALS[0] = GroundMaterial.NONE;
                GroundMaterialManager.GROUND_MATERIALS[1] = GroundMaterial.DIRT;
                for (int i = 0; i < groundMaterials.length; ++i) {
                    GroundMaterial g;
                    GroundMaterialManager.GROUND_MATERIALS[i + 2] = g = groundMaterials[i];
                    for (int j = 0; j < g.materials.length; ++j) {
                        if (g.materials[j] != null) continue;
                        g.materials[j] = Material.NONE;
                        log.error("Missing material at index {} in ground material '{}'", (Object)j, (Object)g.name);
                    }
                }
                if (!first.booleanValue()) {
                    this.clientThread.invoke(() -> {
                        this.tileOverrideManager.shutDown();
                        this.tileOverrideManager.startUp();
                        this.plugin.reuploadScene();
                    });
                }
            }
            catch (IOException ex) {
                log.error("Failed to load ground materials:", ex);
            }
        });
    }

    public void shutDown() {
        if (this.fileWatcher != null) {
            this.fileWatcher.unregister();
        }
        this.fileWatcher = null;
        GROUND_MATERIALS = new GroundMaterial[0];
    }
}

