/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.Animation;
import net.runelite.api.Client;
import net.runelite.api.ModelData;
import net.runelite.api.NPC;
import net.runelite.api.RuneLiteObject;
import net.runelite.api.Scene;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.rs117.hd.HdPluginConfig;
import net.runelite.client.plugins.rs117.hd.overlays.FrameTimer;
import net.runelite.client.plugins.rs117.hd.overlays.Timer;
import net.runelite.client.plugins.rs117.hd.scene.TileOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.rs117.hd.utils.ColorUtils;

public class FishingSpotReplacer {
    private static final int FISHING_SPOT_MODEL_ID = 41238;
    private static final int FISHING_SPOT_ANIMATION_ID = 10793;
    private static final int LAVA_SPOT_MODEL_ID = 2331;
    private static final int LAVA_SPOT_ANIMATION_ID = 525;
    private static final int LAVA_SPOT_COLOR = ColorUtils.hsl("#837574");
    private static final Set<Integer> FISHING_SPOT_IDS = Set.of(394, 635, 1506, 1507, 1508, 1509, 1510, 1511, 1512, 1513, 1514, 1515, 1516, 1517, 1518, 1519, 1520, 1521, 1522, 1523, 1524, 1525, 1526, 1527, 1528, 1529, 1530, 1531, 1532, 1533, 1534, 1535, 1536, 1542, 1544, 2146, 2653, 2654, 2655, 3317, 3417, 3418, 3419, 3657, 3913, 3914, 3915, 4079, 4080, 4081, 4082, 4316, 4476, 4477, 4710, 4711, 4712, 4713, 4714, 5233, 5234, 5820, 5821, 6731, 6825, 7155, 7199, 7200, 7323, 7459, 7460, 7461, 7462, 7463, 7464, 7465, 7466, 7467, 7468, 7469, 7470, 7946, 7947, 8524, 8525, 8526, 8527, 9171, 9172, 9173, 9174, 9478, 12267);
    private static final Set<Integer> LAVA_FISHING_SPOT_IDS = Set.of(Integer.valueOf(4928));
    private static final Set<Integer> NPC_IDS = Sets.union(FISHING_SPOT_IDS, LAVA_FISHING_SPOT_IDS).immutableCopy();
    @Inject
    private Client client;
    @Inject
    private EventBus eventBus;
    @Inject
    private HdPluginConfig config;
    @Inject
    private TileOverrideManager tileOverrideManager;
    @Inject
    private FrameTimer frameTimer;
    private final Map<Integer, RuneLiteObject> npcIndexToModel = new HashMap<Integer, RuneLiteObject>();
    private Animation fishingSpotAnimation;
    private Animation lavaFishingSpotAnimation;

    public void startUp() {
        this.eventBus.register(this);
        this.fishingSpotAnimation = this.client.loadAnimation(10793);
        this.lavaFishingSpotAnimation = this.client.loadAnimation(525);
    }

    public void shutDown() {
        this.eventBus.unregister(this);
        this.despawnRuneLiteObjects();
        this.fishingSpotAnimation = null;
        this.lavaFishingSpotAnimation = null;
    }

    public void despawnRuneLiteObjects() {
        this.npcIndexToModel.values().forEach(rlobj -> rlobj.setActive(false));
        this.npcIndexToModel.clear();
    }

    public ModelOverride getModelOverride() {
        if (!this.config.replaceFishingSpots()) {
            return null;
        }
        ModelOverride override = new ModelOverride();
        override.hide = true;
        override.npcIds = NPC_IDS;
        return override;
    }

    public void update() {
        if (!this.config.replaceFishingSpots()) {
            return;
        }
        this.frameTimer.begin(Timer.REPLACE_FISHING_SPOTS);
        Set npcIndices = this.client.getNpcs().stream().map(NPC::getIndex).collect(Collectors.toSet());
        this.npcIndexToModel.entrySet().removeIf(entry -> {
            if (npcIndices.contains(entry.getKey())) {
                return false;
            }
            ((RuneLiteObject)entry.getValue()).setActive(false);
            return true;
        });
        this.client.getNpcs().forEach(this::spawnFishingSpot);
        this.npcIndexToModel.forEach((index, runeLiteObject) -> {
            NPC npc = this.client.getTopLevelWorldView().npcs().byIndex((int)index);
            if (npc != null) {
                runeLiteObject.setLocation(npc.getLocalLocation(), this.client.getTopLevelWorldView().getPlane());
            }
        });
        this.frameTimer.end(Timer.REPLACE_FISHING_SPOTS);
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        this.spawnFishingSpot(npcSpawned.getNpc());
    }

    public void spawnFishingSpot(NPC npc) {
        if (!NPC_IDS.contains(npc.getId())) {
            return;
        }
        this.npcIndexToModel.computeIfAbsent(npc.getIndex(), i -> {
            int modelId = 41238;
            Animation animation = this.fishingSpotAnimation;
            int recolor = -1;
            if (LAVA_FISHING_SPOT_IDS.contains(npc.getId())) {
                modelId = 2331;
                animation = this.lavaFishingSpotAnimation;
                recolor = LAVA_SPOT_COLOR;
            } else {
                LocalPoint lp = npc.getLocalLocation();
                if (lp.isInScene()) {
                    Tile tile = this.client.getScene().getTiles()[this.client.getPlane()][lp.getSceneX()][lp.getSceneY()];
                    recolor = this.tileOverrideManager.getOverride((Scene)this.client.getScene(), (Tile)tile).waterType.fishingSpotRecolor;
                }
            }
            ModelData modelData = this.client.loadModelData(modelId);
            if (modelData == null) {
                return null;
            }
            if (recolor != -1) {
                modelData = modelData.cloneColors();
                Arrays.fill(modelData.getFaceColors(), (short)recolor);
            }
            RuneLiteObject fishingSpot = this.client.createRuneLiteObject();
            fishingSpot.setAnimation(animation);
            fishingSpot.setDrawFrontTilesFirst(false);
            fishingSpot.setActive(true);
            fishingSpot.setShouldLoop(true);
            fishingSpot.setModel(modelData.light());
            return fishingSpot;
        });
    }
}

