/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.scene;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.model.ModelPusher;
import net.runelite.client.plugins.rs117.hd.scene.EnvironmentManager;
import net.runelite.client.plugins.rs117.hd.scene.LightManager;
import net.runelite.client.plugins.rs117.hd.scene.ModelOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.TileOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.utils.FileWatcher;
import net.runelite.client.plugins.rs117.hd.utils.GsonUtils;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.ResourcePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AreaManager {
    private static final Logger log = LoggerFactory.getLogger(AreaManager.class);
    private static final ResourcePath AREA_PATH = Props.getPathOrDefault("rlhd.area-path", () -> ResourcePath.path(AreaManager.class, "areas.json"));
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private HdPlugin plugin;
    @Inject
    private EnvironmentManager environmentManager;
    @Inject
    private TileOverrideManager tileOverrideManager;
    @Inject
    private ModelOverrideManager modelOverrideManager;
    @Inject
    private LightManager lightManager;
    @Inject
    private ModelPusher modelPusher;
    private FileWatcher.UnregisterCallback fileWatcher;
    public static Area[] AREAS = new Area[0];
    public Area[] areasWithAreaHiding = new Area[0];

    public void startUp() {
        this.fileWatcher = AREA_PATH.watch((path, first) -> {
            try {
                Area[] areas = path.loadJson(this.plugin.getGson(), Area[].class);
                if (areas == null) {
                    throw new IOException("Empty or invalid: " + path);
                }
                AREAS = Arrays.copyOf(areas, areas.length + 2);
                AreaManager.AREAS[AreaManager.AREAS.length - 2] = Area.ALL;
                AreaManager.AREAS[AreaManager.AREAS.length - 1] = Area.NONE;
                ArrayList<Area> areasWithAreaHiding = new ArrayList<Area>();
                for (Area area : areas) {
                    area.normalize();
                    if (!area.hideOtherAreas) continue;
                    areasWithAreaHiding.add(area);
                }
                this.areasWithAreaHiding = (Area[])areasWithAreaHiding.toArray(Area[]::new);
                Area.OVERWORLD = this.getArea("OVERWORLD");
                log.debug("Loaded {} areas", (Object)areas.length);
                if (!first.booleanValue()) {
                    this.clientThread.invoke(() -> {
                        this.modelPusher.clearModelCache();
                        this.tileOverrideManager.shutDown();
                        this.modelOverrideManager.shutDown();
                        this.lightManager.shutDown();
                        this.environmentManager.shutDown();
                        this.tileOverrideManager.startUp();
                        this.modelOverrideManager.startUp();
                        this.lightManager.startUp();
                        this.environmentManager.startUp();
                        if (this.client.getGameState() == GameState.LOGGED_IN) {
                            this.client.setGameState(GameState.LOADING);
                        }
                    });
                }
            }
            catch (IOException ex) {
                log.error("Failed to load areas:", ex);
            }
        });
    }

    public void shutDown() {
        if (this.fileWatcher != null) {
            this.fileWatcher.unregister();
        }
        this.fileWatcher = null;
        AREAS = new Area[0];
    }

    @Nonnull
    public Area getArea(String name) {
        for (Area area : AREAS) {
            if (!name.equals(area.name)) continue;
            return area;
        }
        return Area.NONE;
    }

    public static class JsonAdapter
    extends TypeAdapter<Area> {
        private static final Logger log = LoggerFactory.getLogger(JsonAdapter.class);

        @Override
        public Area read(JsonReader in) throws IOException {
            JsonToken token = in.peek();
            if (token == JsonToken.NULL) {
                return null;
            }
            if (token == JsonToken.BEGIN_OBJECT) {
                throw new IllegalStateException("This is only meant for mapping area names to existing areas, not parse new ones. Unexpected token " + token + " at " + GsonUtils.location(in));
            }
            if (token != JsonToken.STRING) {
                log.warn("Expected an area name instead of {} at {}", new Object[]{token, GsonUtils.location(in), new Throwable()});
                return Area.NONE;
            }
            String str = in.nextString();
            for (Area area : AREAS) {
                if (!str.equals(area.name)) continue;
                return area;
            }
            log.warn("No area exists with the name '{}' at {}", str, GsonUtils.location(in), new Throwable());
            return Area.NONE;
        }

        @Override
        public void write(JsonWriter out, Area area) throws IOException {
            if (area == null) {
                out.nullValue();
            } else {
                out.value(area.name);
            }
        }
    }
}

