/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.overlays;

import com.google.inject.Singleton;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Actor;
import net.runelite.api.Animation;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.DynamicObject;
import net.runelite.api.GameObject;
import net.runelite.api.GraphicsObject;
import net.runelite.api.GroundObject;
import net.runelite.api.Model;
import net.runelite.api.NPC;
import net.runelite.api.Perspective;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Tile;
import net.runelite.api.TileObject;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.input.MouseWheelListener;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.scene.AreaManager;
import net.runelite.client.plugins.rs117.hd.scene.ProceduralGenerator;
import net.runelite.client.plugins.rs117.hd.scene.SceneContext;
import net.runelite.client.plugins.rs117.hd.scene.TileOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.areas.AABB;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.scene.tile_overrides.TileOverride;
import net.runelite.client.plugins.rs117.hd.utils.ColorUtils;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.ModelHash;
import net.runelite.client.plugins.rs117.hd.utils.Vector;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ColorUtil;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TileInfoOverlay
extends Overlay
implements MouseListener,
MouseWheelListener {
    private static final Logger log = LoggerFactory.getLogger(TileInfoOverlay.class);
    private static final Font MONOSPACE_FONT = new Font("Courier New", 0, 12);
    private static final Color BACKDROP_COLOR = new Color(0, 0, 0, 100);
    private static final Color TRANSPARENT_YELLOW_50 = new Color(255, 255, 0, 50);
    private static final Color TRANSPARENT_YELLOW_100 = new Color(255, 255, 0, 100);
    private static final Color TRANSPARENT_WHITE_100 = new Color(255, 255, 255, 100);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private HdPlugin plugin;
    @Inject
    private TileOverrideManager tileOverrideManager;
    @Inject
    private ProceduralGenerator proceduralGenerator;
    private boolean active;
    private int[] mousePos;
    private boolean ctrlHeld;
    private boolean ctrlToggled;
    private boolean shiftHeld;
    private boolean altHeld;
    private float zoom = 1.0f;
    private static final int MODE_TILE_INFO = 0;
    private static final int MODE_MODEL_INFO = 1;
    private static final int MODE_SCENE_AABBS = 2;
    private static final int MODE_OBJECT_IDS = 3;
    private int mode;
    private int aabbMarkingStage;
    private AABB pendingSelection;
    private final ArrayList<AABB> selections = new ArrayList();
    private final int[] selectedAreaAabb = new int[]{-1, 0};
    private final int[] hoveredAreaAabb = new int[]{-1, 0};
    private final int[][] markedWorldPoints = new int[2][3];
    private int[] hoveredWorldPoint = new int[3];
    private int targetPlane = 3;
    private boolean selectionIncludeZ;
    private SceneContext currentSceneContext;
    private Area[] visibleAreas = new Area[0];
    private final AABB dummyAabb = new AABB(0, 0);
    private int[] baseEx;

    public TileInfoOverlay() {
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public void setActive(boolean activate) {
        this.active = activate;
        if (activate) {
            this.overlayManager.add(this);
            this.mouseManager.registerMouseListener(0, this);
            this.mouseManager.registerMouseWheelListener(this);
        } else {
            this.overlayManager.remove(this);
            this.mouseManager.unregisterMouseListener(this);
            this.mouseManager.unregisterMouseWheelListener(this);
        }
        this.tileOverrideManager.setTrackReplacements(activate);
    }

    @Override
    public Dimension render(Graphics2D g) {
        int i;
        boolean shiftPressed;
        boolean ctrlPressed;
        if (this.plugin.isLoadingScene()) {
            return null;
        }
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return null;
        }
        if (sceneContext != this.currentSceneContext) {
            this.currentSceneContext = sceneContext;
            this.hoveredAreaAabb[0] = -1;
            this.hoveredAreaAabb[1] = 0;
            System.arraycopy(this.hoveredAreaAabb, 0, this.selectedAreaAabb, 0, 2);
            this.baseEx = HDUtils.getSceneBaseExtended(sceneContext.scene, this.client.getPlane());
            if (sceneContext.scene.isInstance()) {
                this.visibleAreas = new Area[0];
            } else {
                AABB sceneBounds = sceneContext.getNonInstancedSceneBounds();
                this.visibleAreas = (Area[])Arrays.stream(AreaManager.AREAS).map(area -> {
                    Area copy = new Area(area.name);
                    copy.regions = area.regions;
                    copy.regionBoxes = area.regionBoxes;
                    copy.rawAabbs = area.rawAabbs;
                    copy.normalize();
                    copy.aabbs = (AABB[])Arrays.stream(copy.aabbs).map(aabb -> sceneBounds.intersects((AABB)aabb) ? aabb : this.dummyAabb).toArray(AABB[]::new);
                    return copy;
                }).filter(area -> Arrays.stream(area.aabbs).anyMatch(aabb -> aabb != this.dummyAabb)).toArray(Area[]::new);
            }
        }
        if (this.ctrlHeld != (ctrlPressed = this.client.isKeyPressed(82))) {
            this.ctrlHeld = ctrlPressed;
            if (ctrlPressed) {
                boolean bl = this.ctrlToggled = !this.ctrlToggled;
            }
        }
        if (this.shiftHeld != (shiftPressed = this.client.isKeyPressed(81))) {
            this.shiftHeld = shiftPressed;
            if (shiftPressed) {
                this.mode = (this.mode + 1) % 4;
            }
        }
        this.altHeld = this.client.isKeyPressed(86);
        Tile[][][] tiles = sceneContext.scene.getExtendedTiles();
        int[][][] templateChunks = sceneContext.scene.isInstance() ? sceneContext.scene.getInstanceTemplateChunks() : null;
        Point canvasMousePos = this.client.getMouseCanvasPosition();
        this.mousePos = null;
        if (canvasMousePos != null && canvasMousePos.getX() != -1 && canvasMousePos.getY() != -1) {
            this.mousePos = new int[]{canvasMousePos.getX(), canvasMousePos.getY()};
        }
        int maxPlane = this.client.getPlane();
        int minPlane = 0;
        if (this.ctrlHeld) {
            minPlane = maxPlane = this.targetPlane;
        }
        if (this.mousePos != null) {
            g.setFont(FontManager.getRunescapeFont());
            g.setStroke(new BasicStroke(1.0f, 0, 1));
            block4: for (int secondTry = 0; secondTry <= 1; ++secondTry) {
                for (int z = maxPlane; z >= minPlane; --z) {
                    for (int isBridge = 1; isBridge >= 0; --isBridge) {
                        for (int x = 0; x < 184; ++x) {
                            for (int y = 0; y < 184; ++y) {
                                SceneTilePaint paint;
                                boolean shouldDraw;
                                Tile tile = tiles[z][x][y];
                                boolean bl = shouldDraw = tile != null && (isBridge == 0 || tile.getBridge() != null);
                                if (!shouldDraw) continue;
                                if (templateChunks != null) {
                                    int chunk;
                                    int sx = x - 40;
                                    int sy = y - 40;
                                    if (sx < 0 || sy < 0 || sx >= 104 || sy >= 104 || (chunk = templateChunks[z][sx / 8][sy / 8]) == -1 && !this.ctrlHeld) continue;
                                }
                                if (secondTry == 0 && ((paint = tile.getSceneTilePaint()) == null || paint.getNeColor() == 12345678) && tile.getSceneTileModel() == null) continue;
                                if (this.mode == 0 || this.mode == 1) {
                                    if (!this.drawTileInfo(g, sceneContext, tile)) {
                                        continue;
                                    }
                                } else {
                                    if (this.altHeld) {
                                        g.setColor(Color.YELLOW);
                                    } else {
                                        g.setColor(Color.CYAN);
                                        if (isBridge == 1 && tile.getBridge() != null) {
                                            g.setColor(Color.MAGENTA);
                                            tile = tile.getBridge();
                                        }
                                    }
                                    Polygon poly = this.getCanvasTilePoly(this.client, sceneContext.scene, tile);
                                    if (poly == null || !poly.contains(this.mousePos[0], this.mousePos[1])) continue;
                                    g.drawPolygon(poly);
                                }
                                int tileZ = tile.getRenderLevel();
                                this.hoveredWorldPoint = sceneContext.extendedSceneToWorld(x, y, tileZ);
                                break block4;
                            }
                        }
                    }
                }
            }
        }
        switch (this.mode) {
            case 3: {
                this.drawAllIds(g, sceneContext);
                break;
            }
            case 2: {
                g.setFont(FontManager.getRunescapeSmallFont());
                this.drawLoadingLines(g);
                this.drawRegionBoxes(g, sceneContext);
                if (this.mousePos != null) {
                    this.hoveredAreaAabb[0] = -1;
                    this.hoveredAreaAabb[1] = 0;
                    int[] v = new int[2];
                    block9: for (int i2 = 0; i2 < this.visibleAreas.length; ++i2) {
                        Area area2 = this.visibleAreas[i2];
                        for (int j = 0; j < area2.aabbs.length; ++j) {
                            AABB aabb;
                            int[] p;
                            if (i2 == this.selectedAreaAabb[0] && j == this.selectedAreaAabb[1] || (p = this.getAabbCanvasCenter(aabb = this.toLocalAabb(sceneContext, this.cropAabb(sceneContext, area2.aabbs[j])))) == null) continue;
                            Vector.subtract(v, this.mousePos, p);
                            if (!(Vector.dot(v, v) < 676.0f)) continue;
                            this.hoveredAreaAabb[0] = i2;
                            this.hoveredAreaAabb[1] = j;
                            break block9;
                        }
                    }
                }
                for (i = 0; i < this.visibleAreas.length; ++i) {
                    Area area3 = this.visibleAreas[i];
                    if (area3.name.equals("ALL")) continue;
                    boolean areaHovered = i == this.hoveredAreaAabb[0];
                    boolean areaSelected = i == this.selectedAreaAabb[0];
                    for (int j = 0; j < area3.aabbs.length; ++j) {
                        boolean selected;
                        AABB aabb = area3.aabbs[j];
                        if (aabb == this.dummyAabb) continue;
                        boolean hovered = areaHovered && j == this.hoveredAreaAabb[1];
                        boolean bl = selected = areaSelected && j == this.selectedAreaAabb[1];
                        if (hovered || selected) continue;
                        Object label = aabb.toArgs();
                        if (aabb.isVolume()) {
                            label = area3.name + "[" + j + "]\n" + (String)label;
                        }
                        AABB croppedAabb = this.cropAabb(sceneContext, aabb);
                        AABB localAabb = this.toLocalAabb(sceneContext, croppedAabb);
                        g.setColor(TRANSPARENT_WHITE_100);
                        this.drawLocalAabb(g, localAabb);
                        g.setColor(Color.LIGHT_GRAY);
                        this.drawLocalAabbLabel(g, localAabb, (String)label, false);
                    }
                }
                if (this.hoveredAreaAabb[0] != -1) {
                    Area area4 = this.visibleAreas[this.hoveredAreaAabb[0]];
                    AABB aabb = area4.aabbs[this.hoveredAreaAabb[1]];
                    g.setColor(Color.WHITE);
                    AABB localAabb = this.toLocalAabb(sceneContext, aabb);
                    this.drawLocalAabb(g, localAabb);
                    this.drawLocalAabbLabel(g, localAabb, area4.name + "[" + this.hoveredAreaAabb[1] + "]\n" + aabb.toArgs(), false);
                }
                if (this.selectedAreaAabb[0] == -1) break;
                Area area5 = this.visibleAreas[this.selectedAreaAabb[0]];
                AABB aabb = area5.aabbs[this.selectedAreaAabb[1]];
                g.setColor(Color.CYAN);
                AABB localAabb = this.toLocalAabb(sceneContext, aabb);
                this.drawLocalAabb(g, localAabb);
                this.drawLocalAabbLabel(g, localAabb, area5.name + "[" + this.selectedAreaAabb[1] + "]\n" + aabb.toArgs(), true);
            }
        }
        if (this.aabbMarkingStage == 1) {
            System.arraycopy(this.hoveredWorldPoint, 0, this.markedWorldPoints[1], 0, 3);
            this.pendingSelection = this.selectionIncludeZ || this.markedWorldPoints[0][2] != this.markedWorldPoints[1][2] ? new AABB(this.markedWorldPoints[0], this.markedWorldPoints[1]) : new AABB(this.markedWorldPoints[0][0], this.markedWorldPoints[0][1], this.markedWorldPoints[1][0], this.markedWorldPoints[1][1]);
        }
        for (i = 0; i < this.selections.size(); ++i) {
            AABB aabb = this.selections.get(i);
            AABB localAabb = this.toLocalAabb(sceneContext, aabb);
            g.setColor(Color.YELLOW);
            this.drawLocalAabb(g, localAabb);
            g.setFont(FontManager.getRunescapeFont());
            this.drawLocalAabbLabel(g, localAabb, "Selection[" + i + "]\n" + aabb.toArgs(), true);
        }
        if (this.pendingSelection != null) {
            AABB localAabb = this.toLocalAabb(sceneContext, this.pendingSelection);
            g.setColor(Color.YELLOW);
            this.drawLocalAabb(g, localAabb);
            g.setFont(FontManager.getRunescapeFont());
            this.drawLocalAabbLabel(g, localAabb, "Selection[" + this.selections.size() + "]\n" + this.pendingSelection.toArgs(), true);
        }
        if (sceneContext.scene.isInstance()) {
            g.setColor(Color.RED);
            g.setFont(FontManager.getRunescapeFont());
            Rectangle b = g.getClipBounds();
            String str = "This is an instance. AABBs may not work.";
            int w = g.getFontMetrics().stringWidth(str);
            g.drawString(str, (int)((double)b.x + b.getWidth() / 2.0 - (double)((float)w / 2.0f)), 16);
        }
        return null;
    }

    private boolean drawTileInfo(Graphics2D g, SceneContext sceneContext, Tile tile) {
        boolean infoDrawn = false;
        if (tile != null) {
            Polygon poly;
            Rectangle rect = null;
            Tile bridge = tile.getBridge();
            if (bridge != null && (poly = this.getCanvasTilePoly(this.client, sceneContext.scene, bridge)) != null && poly.contains(this.mousePos[0], this.mousePos[1])) {
                rect = this.drawTileInfo(g, sceneContext, bridge, poly, null);
                infoDrawn = true;
            }
            if ((poly = this.getCanvasTilePoly(this.client, sceneContext.scene, tile)) != null && poly.contains(this.mousePos[0], this.mousePos[1])) {
                this.drawTileInfo(g, sceneContext, tile, poly, rect);
                infoDrawn = true;
            }
        }
        return infoDrawn;
    }

    /*
     * WARNING - void declaration
     */
    private Rectangle drawTileInfo(Graphics2D g, SceneContext sceneContext, Tile tile, Polygon poly, Rectangle dodgeRect) {
        WallObject wallObject;
        GroundObject groundObject;
        SceneTilePaint tilePaint = tile.getSceneTilePaint();
        SceneTileModel tileModel = tile.getSceneTileModel();
        Scene scene = sceneContext.scene;
        int tileX = tile.getSceneLocation().getX();
        int tileY = tile.getSceneLocation().getY();
        int tileZ = tile.getRenderLevel();
        int tileExX = tileX + 40;
        int tileExY = tileY + 40;
        int[] worldPos = sceneContext.sceneToWorld(tileX, tileY, tileZ);
        ArrayList<Object> lines = new ArrayList<Object>();
        Color polyColor = Color.LIGHT_GRAY;
        if (this.mode == 0) {
            void var21_26;
            TileOverride replacement;
            TileOverride replacement2;
            if (tile.getBridge() != null) {
                lines.add("Bridge");
            }
            lines.add("Scene point: " + tileX + ", " + tileY + ", " + tileZ);
            lines.add("World point: " + Arrays.toString(worldPos));
            lines.add(String.format("Region ID: %d (%d, %d)", HDUtils.worldToRegionID(worldPos), worldPos[0] >> 6, worldPos[1] >> 6));
            short overlayId = scene.getOverlayIds()[tileZ][tileExX][tileExY];
            TileOverride overlay = this.tileOverrideManager.getOverrideBeforeReplacements(worldPos, Integer.MIN_VALUE | overlayId);
            StringBuilder replacementPath = new StringBuilder(overlay.toString());
            while ((replacement2 = this.tileOverrideManager.resolveNextReplacement(overlay, tile)) != overlay) {
                replacementPath.append("\n\t\u2937 ").append(replacement2);
                overlay = replacement2;
            }
            lines.add(String.format("Overlay: ID %d -> %s", overlayId, replacementPath));
            lines.add(String.format("GroundMaterial: %s -> %s", new Object[]{overlay.groundMaterial, overlay.groundMaterial.getRandomMaterial(worldPos)}));
            int underlayId = scene.getUnderlayIds()[tileZ][tileExX][tileExY];
            TileOverride tileOverride = this.tileOverrideManager.getOverrideBeforeReplacements(worldPos, underlayId);
            replacementPath = new StringBuilder(tileOverride.toString());
            while ((replacement = this.tileOverrideManager.resolveNextReplacement((TileOverride)var21_26, tile)) != var21_26) {
                replacementPath.append("\n\t\u2937 ").append(replacement);
                TileOverride tileOverride2 = replacement;
            }
            lines.add(String.format("Underlay: ID %d -> %s", underlayId, replacementPath));
            lines.add(String.format("GroundMaterial: %s -> %s", new Object[]{var21_26.groundMaterial, var21_26.groundMaterial.getRandomMaterial(worldPos)}));
            if (tilePaint != null) {
                polyColor = this.client.isKeyPressed(86) ? Color.YELLOW : Color.CYAN;
                lines.add("Tile type: Paint");
                Material material = Material.fromVanillaTexture(tilePaint.getTexture());
                lines.add(String.format("Material: %s (%d)", material.name(), tilePaint.getTexture()));
                lines.add(String.format("HSL: %s", TileInfoOverlay.hslString(tile)));
                TileOverride override = this.tileOverrideManager.getOverride(scene, tile, worldPos, Integer.MIN_VALUE | overlayId, underlayId);
                lines.add("WaterType: " + this.proceduralGenerator.seasonalWaterType(override, tilePaint.getTexture()));
            } else if (tileModel != null) {
                polyColor = Color.ORANGE;
                lines.add("Tile type: Model");
                lines.add(String.format("Face count: %d", tileModel.getFaceX().length));
                HashSet<String> uniqueMaterials = new HashSet<String>();
                int numChars = 0;
                if (tileModel.getTriangleTextureId() != null) {
                    for (int texture : tileModel.getTriangleTextureId()) {
                        String material = String.format("%s (%d)", Material.fromVanillaTexture(texture).name(), texture);
                        boolean unique = uniqueMaterials.add(material);
                        if (!unique) continue;
                        numChars += material.length();
                    }
                }
                ArrayList materials = new ArrayList(uniqueMaterials);
                Collections.sort(materials);
                if (materials.size() <= 1 || numChars < 26) {
                    StringBuilder sb = new StringBuilder("Materials: { ");
                    if (materials.isEmpty()) {
                        sb.append("null");
                    } else {
                        String prefix = "";
                        for (String m : materials) {
                            sb.append(prefix).append(m);
                            prefix = ", ";
                        }
                    }
                    sb.append(" }");
                    lines.add(sb.toString());
                } else {
                    Iterator iter = materials.iterator();
                    lines.add("Materials: { " + (String)iter.next() + ",");
                    while (iter.hasNext()) {
                        lines.add("\t  " + (String)iter.next() + (iter.hasNext() ? "," : " }"));
                    }
                }
                lines.add(String.format("HSL: %s", TileInfoOverlay.hslString(tile)));
            }
        }
        if ((groundObject = tile.getGroundObject()) != null) {
            lines.add(String.format("Ground Object: ID=%s preori=%d%s", this.getIdAndImpostorId(groundObject, groundObject.getRenderable()), HDUtils.getBakedOrientation(groundObject.getConfig()), this.getModelInfo(groundObject.getRenderable())));
            lines.add("Ground Type: " + HDUtils.getObjectType(groundObject.getConfig()));
        }
        if ((wallObject = tile.getWallObject()) != null) {
            if (wallObject.getRenderable1() != null) {
                lines.add(String.format("Wall Object 1: ID=%s bakedOri=%d ori=%d%s", this.getIdAndImpostorId(wallObject, wallObject.getRenderable1()), HDUtils.getBakedOrientation(wallObject.getConfig()), wallObject.getOrientationA(), this.getModelInfo(wallObject.getRenderable1())));
            }
            if (wallObject.getRenderable2() != null) {
                lines.add(String.format("Wall Object 2: ID=%s bakedOri=%d ori=%d%s", this.getIdAndImpostorId(wallObject, wallObject.getRenderable2()), HDUtils.getBakedOrientation(wallObject.getConfig()), wallObject.getOrientationB(), this.getModelInfo(wallObject.getRenderable2())));
            }
            lines.add("Wall Type: " + HDUtils.getObjectType(wallObject.getConfig()));
        }
        GameObject[] gameObjects = tile.getGameObjects();
        for (GameObject gameObject : gameObjects) {
            if (gameObject == null) continue;
            int height = -1;
            int animationId = -1;
            int faceCount = 0;
            Object id = "";
            Renderable renderable = gameObject.getRenderable();
            if (renderable != null) {
                Model model;
                Model model2 = model = renderable instanceof Model ? (Model)renderable : renderable.getModel();
                if (model != null) {
                    faceCount = model.getFaceCount();
                }
                if (renderable instanceof NPC) continue;
                height = renderable.getModelHeight();
                if (renderable instanceof Player) {
                    id = "name=" + ((Player)renderable).getName();
                } else {
                    Animation anim;
                    id = "ID=" + this.getIdAndImpostorId(gameObject, renderable);
                    if (renderable instanceof DynamicObject && (anim = ((DynamicObject)renderable).getAnimation()) != null) {
                        animationId = anim.getId();
                    }
                }
                id = (String)id + " ";
            }
            lines.add(String.format("%s: %spreori=%d ori=%d height=%d anim=%d faces=%d%s", ModelHash.getTypeName(ModelHash.getType(gameObject.getHash())), id, HDUtils.getBakedOrientation(gameObject.getConfig()), gameObject.getModelOrientation(), height, animationId, faceCount, this.getModelInfo(renderable)));
            lines.add("Object Type: " + HDUtils.getObjectType(gameObject.getConfig()));
        }
        for (NPC nPC : this.client.getTopLevelWorldView().npcs()) {
            LocalPoint lp = nPC.getLocalLocation();
            int size = nPC.getComposition().getSize() / 2;
            int x = lp.getSceneX();
            int y = lp.getSceneY();
            if (x - size > tileX || tileX > x + size || y - size > tileY || tileY > y + size) continue;
            lines.add(String.format("NPC: ID=%s name=%s ori=[%d,%d] anim=%d impostor=?%s", nPC.getId(), nPC.getName(), nPC.getOrientation(), nPC.getCurrentOrientation(), nPC.getAnimation(), this.getModelInfo(nPC)));
        }
        for (GraphicsObject graphicsObject : this.client.getGraphicsObjects()) {
            LocalPoint lp = graphicsObject.getLocation();
            if (lp.getSceneX() != tileX || lp.getSceneY() != tileY) continue;
            lines.add(String.format("Graphics Object: ID=%s%s", graphicsObject.getId(), this.getModelInfo(graphicsObject)));
        }
        if (tile.getBridge() != null) {
            polyColor = Color.MAGENTA;
        }
        g.setColor(polyColor);
        g.drawPolygon(poly);
        if (lines.isEmpty()) {
            return null;
        }
        for (int i = 0; i < lines.size(); ++i) {
            String[] stringArray = ((String)lines.get(i)).split("\\n");
            if (stringArray.length <= 1) continue;
            lines.remove(i);
            lines.addAll(i, List.of(stringArray));
        }
        int padding = 4;
        int n = padding * 2;
        FontMetrics fm = g.getFontMetrics();
        int lineHeight = fm.getHeight();
        int totalHeight = lineHeight * lines.size() + padding * 3;
        int space = fm.stringWidth(": ");
        int indent = fm.stringWidth("{ ");
        int leftWidth = 0;
        int rightWidth = 0;
        Function<String, Pair> splitter = line -> {
            int i = line.indexOf(":");
            String left = line;
            String right = "";
            if (left.startsWith("\t")) {
                right = left;
                left = "";
            } else if (i != -1) {
                left = line.substring(0, i);
                right = line.substring(i + 1);
            }
            return Pair.of(left, right);
        };
        Font f = g.getFont();
        for (String string : lines) {
            Pair pair = splitter.apply(string);
            if (((String)pair.getRight()).isEmpty()) {
                int halfWidth = fm.stringWidth(Text.removeTags((String)pair.getLeft())) / 2;
                leftWidth = Math.max(leftWidth, halfWidth);
                rightWidth = Math.max(rightWidth, halfWidth);
                continue;
            }
            leftWidth = Math.max(leftWidth, fm.stringWidth(Text.removeTags((String)pair.getLeft())));
            FontMetrics rfm = fm;
            if (((String)pair.getRight()).contains("<tt>")) {
                rfm = g.getFontMetrics(MONOSPACE_FONT);
            }
            rightWidth = Math.max(rightWidth, rfm.stringWidth(Text.removeTags((String)pair.getRight())));
        }
        Rectangle2D polyBounds = poly.getBounds2D();
        float f2 = (float)polyBounds.getCenterX();
        float centerY = (float)(polyBounds.getCenterY() - polyBounds.getHeight() / 2.0);
        Rectangle bounds = g.getClipBounds();
        int totalWidth = leftWidth + rightWidth + space + n * 2;
        Rectangle rect = new Rectangle((int)HDUtils.clamp(f2 - (float)totalWidth / 2.0f, (float)bounds.x, (float)(bounds.x + bounds.width - totalWidth)), (int)HDUtils.clamp(centerY - (float)totalHeight - (float)padding, (float)(bounds.y + 16), (float)(bounds.y + bounds.height - totalHeight)), totalWidth, totalHeight);
        if (dodgeRect != null && dodgeRect.intersects(rect)) {
            rect.y = dodgeRect.y - rect.height - padding;
        }
        g.setColor(BACKDROP_COLOR);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(Color.WHITE);
        int offsetY = 0;
        for (String string : lines) {
            float y;
            float x;
            boolean dropShadow = true;
            Pair pair = splitter.apply(string);
            offsetY += lineHeight;
            if (((String)pair.getRight()).isEmpty()) {
                x = (float)rect.x + (float)rect.width / 2.0f - (float)fm.stringWidth((String)pair.getLeft()) / 2.0f;
                y = rect.y + padding + offsetY;
            } else {
                boolean indented = ((String)pair.getRight()).startsWith("\t");
                if (((String)pair.getRight()).contains("<tt>")) {
                    g.setFont(MONOSPACE_FONT);
                    dropShadow = false;
                }
                x = rect.x + n + leftWidth - fm.stringWidth((String)pair.getLeft()) + (indented ? indent : 0);
                y = rect.y + padding + offsetY;
            }
            this.drawString(g, string, (int)x, (int)y, dropShadow);
            g.setFont(f);
        }
        return rect;
    }

    private String getIdAndImpostorId(TileObject object, @Nullable Renderable renderable) {
        int impostorId;
        int id;
        return id + (String)((id = object.getId()) == (impostorId = this.getIdOrImpostorId(object, renderable)) ? "" : " -> " + impostorId);
    }

    private int getIdOrImpostorId(TileObject object, @Nullable Renderable renderable) {
        return ModelHash.getUuidId(ModelHash.generateUuid(this.client, object.getHash(), renderable));
    }

    private String getModelInfo(Renderable renderable) {
        Model model;
        if (renderable == null) {
            return " null renderable";
        }
        Model model2 = model = renderable instanceof Model ? (Model)renderable : renderable.getModel();
        if (model == null) {
            return " null model";
        }
        switch (this.mode) {
            case 0: {
                return "  " + (renderable instanceof Model ? "<col=#00ff00>static</col>" : (renderable instanceof DynamicObject || renderable instanceof Actor ? "<col=#ff0000>dynamic</col>" : "<col=#ff0000>maybe dynamic</col>"));
            }
            case 1: {
                String[] colors = (String[])Arrays.stream(model.getFaceColors1()).distinct().sorted().mapToObj(hsl -> {
                    int[] rawhsl = ColorUtils.unpackRawHsl(hsl);
                    return String.format("<col=%s>%5d [%2d %1d %3d] </col>", ColorUtils.srgbToHex(ColorUtils.packedHslToSrgb(hsl)), hsl, rawhsl[0], rawhsl[1], rawhsl[2]);
                }).toArray(String[]::new);
                int columns = HDUtils.clamp((int)Math.round(Math.sqrt((float)colors.length / 5.0f)), 3, 8);
                int rows = (int)Math.ceil((float)colors.length / (float)columns);
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < rows; ++i) {
                    str.append("\n\t<tt>");
                    for (int j = 0; j < columns; ++j) {
                        int idx = i * columns + j;
                        if (idx >= colors.length) continue;
                        str.append(colors[idx]);
                    }
                }
                return "\nFace colors: " + colors.length + str;
            }
        }
        return "";
    }

    public Polygon getCanvasTilePoly(@Nonnull Client client2, Scene scene, Tile tile) {
        if (tile == null) {
            return null;
        }
        Point l = tile.getSceneLocation();
        return this.getCanvasTilePoly(client2, scene, l.getX(), l.getY(), tile.getPlane());
    }

    public Polygon getCanvasTilePoly(@Nonnull Client client2, Scene scene, int ... sceneXYplane) {
        int wx = sceneXYplane[0] * 128;
        int sy = sceneXYplane[1] * 128;
        int ex = (sceneXYplane[0] + 1) * 128;
        int ny = (sceneXYplane[1] + 1) * 128;
        int sw = TileInfoOverlay.getHeight(scene, wx, sy, sceneXYplane[2]);
        int se = TileInfoOverlay.getHeight(scene, ex, sy, sceneXYplane[2]);
        int ne = TileInfoOverlay.getHeight(scene, ex, ny, sceneXYplane[2]);
        int nw = TileInfoOverlay.getHeight(scene, wx, ny, sceneXYplane[2]);
        int[] p1 = this.localToCanvas(client2, wx, sy, sw);
        int[] p2 = this.localToCanvas(client2, ex, sy, se);
        int[] p3 = this.localToCanvas(client2, ex, ny, ne);
        int[] p4 = this.localToCanvas(client2, wx, ny, nw);
        if (p1 == null || p2 == null || p3 == null || p4 == null) {
            return null;
        }
        Polygon poly = new Polygon();
        poly.addPoint(p1[0], p1[1]);
        poly.addPoint(p2[0], p2[1]);
        poly.addPoint(p3[0], p3[1]);
        poly.addPoint(p4[0], p4[1]);
        return poly;
    }

    private static int getHeight(Scene scene, int localX, int localY, int plane) {
        int sceneExX = HDUtils.clamp((localX >> 7) + 40, 0, 183);
        int sceneExY = HDUtils.clamp((localY >> 7) + 40, 0, 183);
        int[][][] tileHeights = scene.getTileHeights();
        int x = localX & 0x7F;
        int y = localY & 0x7F;
        int var8 = x * tileHeights[plane][sceneExX + 1][sceneExY] + (128 - x) * tileHeights[plane][sceneExX][sceneExY] >> 7;
        int var9 = x * tileHeights[plane][sceneExX + 1][sceneExY + 1] + (128 - x) * tileHeights[plane][sceneExX][sceneExY + 1] >> 7;
        return y * var9 + (128 - y) * var8 >> 7;
    }

    private int[] localToCanvas(@Nonnull Client client2, int x, int y, int z) {
        x -= client2.getCameraX();
        y -= client2.getCameraY();
        z -= client2.getCameraZ();
        int cameraPitch = client2.getCameraPitch();
        int cameraYaw = client2.getCameraYaw();
        float pitchSin = (float)Math.sin((double)cameraPitch * 0.0030679615757712823);
        float pitchCos = (float)Math.cos((double)cameraPitch * 0.0030679615757712823);
        float yawSin = (float)Math.sin((double)cameraYaw * 0.0030679615757712823);
        float yawCos = (float)Math.cos((double)cameraYaw * 0.0030679615757712823);
        float x1 = (float)x * yawCos + (float)y * yawSin;
        float y1 = (float)y * yawCos - (float)x * yawSin;
        float y2 = (float)z * pitchCos - y1 * pitchSin;
        float z1 = y1 * pitchCos + (float)z * pitchSin;
        if (z1 >= 1.0f) {
            float scale = client2.getScale();
            float screenX = x1 * scale;
            float screenY = y2 * scale;
            if (this.plugin.orthographicProjection) {
                screenX *= 2.0E-4f;
                screenY *= 2.0E-4f;
            } else {
                screenX /= z1;
                screenY /= z1;
            }
            return new int[]{(int)((screenX += (float)client2.getViewportWidth() / 2.0f) + (float)client2.getViewportXOffset()), (int)((screenY += (float)client2.getViewportHeight() / 2.0f) + (float)client2.getViewportYOffset()), (int)Math.min(2.1474836E9f, z1)};
        }
        return null;
    }

    private static String hslString(Tile tile) {
        int[] hsl = new int[3];
        int rawHsl = HDUtils.getSouthWesternMostTileColor(hsl, tile);
        if (rawHsl == 12345678) {
            return "HIDDEN";
        }
        return rawHsl + " " + Arrays.toString(hsl);
    }

    private void drawAllIds(Graphics2D g, SceneContext ctx) {
        int plane;
        g.setFont(FontManager.getRunescapeSmallFont());
        g.setColor(new Color(255, 255, 255, 127));
        Tile[][][] tiles = ctx.scene.getExtendedTiles();
        for (int z = plane = this.ctrlHeld ? 3 : this.client.getPlane(); z >= 0; --z) {
            for (int x = 0; x < 184; ++x) {
                for (int y = 0; y < 184; ++y) {
                    Tile tile = tiles[z][x][y];
                    if (tile == null) continue;
                    LocalPoint lp = tile.getLocalLocation();
                    int lines = 0;
                    for (int isBridge = 1; isBridge >= 0; --isBridge) {
                        WallObject wallObject;
                        Tile t = tile;
                        if (isBridge == 1 && (t = tile.getBridge()) == null) continue;
                        GroundObject groundObject = t.getGroundObject();
                        if (groundObject != null) {
                            this.drawTileObjectInfo(g, lp, groundObject, groundObject.getRenderable(), lines++);
                        }
                        if ((wallObject = t.getWallObject()) != null) {
                            this.drawTileObjectInfo(g, lp, wallObject, wallObject.getRenderable1(), lines++);
                        }
                        for (GameObject gameObject : t.getGameObjects()) {
                            if (gameObject == null) continue;
                            this.drawTileObjectInfo(g, lp, gameObject, gameObject.getRenderable(), lines++);
                        }
                    }
                }
            }
        }
    }

    private void drawTileObjectInfo(Graphics2D g, LocalPoint lp, TileObject object, Renderable renderable, int line) {
        int type = ModelHash.getType(object.getHash());
        String str = this.zoom > 1.2f ? ModelHash.getTypeName(type) + ": " + this.getIdAndImpostorId(object, renderable) : ModelHash.getTypeNameShort(type) + ": " + this.getIdOrImpostorId(object, renderable);
        int[] p = this.localToCanvas(this.client, lp.getX(), lp.getY(), Perspective.getTileHeight(this.client, lp, object.getPlane()));
        if (p == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        int w = fm.stringWidth(str);
        this.drawString(g, str, p[0] - w / 2, p[1] + line * fm.getHeight(), true);
    }

    private void drawString(Graphics2D g2d, String str, int x, int y, boolean dropShadow) {
        Color origColor = g2d.getColor();
        this.setAntiAliasing(g2d, false);
        String stripped = Text.removeTags(str);
        if (dropShadow) {
            g2d.setColor(Color.BLACK);
            g2d.drawString(stripped, x + 1, y + 1);
            g2d.setColor(origColor);
        }
        if (!str.contains("<col=")) {
            g2d.drawString(stripped, x, y);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        Pattern pattern = Pattern.compile("<col=#?([a-fA-F0-9]{3,8})>(.*?)</col>");
        Matcher m = pattern.matcher(str);
        int end = 0;
        while (m.find()) {
            int b;
            int g;
            int r;
            if (end < m.start()) {
                String s = Text.removeTags(str.substring(end, m.start()));
                g2d.setColor(origColor);
                g2d.drawString(s, x, y);
                x += fm.stringWidth(s);
            }
            end = m.end();
            String hex = m.group(1);
            int i = Integer.parseInt(hex, 16);
            int a = 255;
            if (hex.length() == 3) {
                r = (i >> 8) * 2;
                g = (i >> 4 & 0xF) * 2;
                b = (i & 0xF) * 2;
            } else if (hex.length() == 6) {
                r = i >> 16;
                g = i >> 8 & 0xFF;
                b = i & 0xFF;
            } else if (hex.length() == 8) {
                r = i >> 24;
                g = i >> 16 & 0xFF;
                b = i >> 8 & 0xFF;
                a = i & 0xFF;
            } else {
                g2d.drawString(m.group(0), x, y);
                x += fm.stringWidth(m.group(0));
                continue;
            }
            String withBrackets = m.group(2);
            String withoutBrackets = withBrackets.replaceAll("[\\[\\]]", " ");
            String onlyBrackets = withBrackets.replaceAll("[^\\[\\]]", " ");
            Color c = new Color(r, g, b, a);
            g2d.setColor(c);
            int w = fm.stringWidth(withoutBrackets);
            int h = fm.getHeight();
            g2d.fillRect(x - 2, y - fm.getAscent() + fm.getLeading() - 2, w + 4, h + 2);
            g2d.setColor(this.getContrastColor(c));
            g2d.drawString(withoutBrackets, x, y);
            g2d.drawString(onlyBrackets, x, y - 1);
            x += fm.stringWidth(withoutBrackets);
        }
        g2d.setColor(origColor);
        if (end < str.length()) {
            g2d.drawString(str.substring(end), x, y);
        }
    }

    private Color getContrastColor(Color color) {
        double y = (299.0 * (double)color.getRed() + (double)(587 * color.getGreen()) + (double)(114 * color.getBlue())) / 1000.0;
        return y >= 128.0 ? Color.black : Color.white;
    }

    private void drawLine(Graphics2D g, int x1, int y1, int z1, int x2, int y2, int z2) {
        int cameraPitch = this.client.getCameraPitch();
        int cameraYaw = this.client.getCameraYaw();
        float pitchSin = (float)Math.sin((double)cameraPitch * 0.0030679615757712823);
        float pitchCos = (float)Math.cos((double)cameraPitch * 0.0030679615757712823);
        float yawSin = (float)Math.sin((double)cameraYaw * 0.0030679615757712823);
        float yawCos = (float)Math.cos((double)cameraYaw * 0.0030679615757712823);
        z1 -= this.client.getCameraZ();
        x2 -= this.client.getCameraX();
        y2 -= this.client.getCameraY();
        z2 -= this.client.getCameraZ();
        float ax = (float)(x1 -= this.client.getCameraX()) * yawCos + (float)(y1 -= this.client.getCameraY()) * yawSin;
        float aUnpitchedZ = (float)y1 * yawCos - (float)x1 * yawSin;
        float ay = (float)z1 * pitchCos - aUnpitchedZ * pitchSin;
        float az = aUnpitchedZ * pitchCos + (float)z1 * pitchSin;
        float bx = (float)x2 * yawCos + (float)y2 * yawSin;
        float bUnpitchedZ = (float)y2 * yawCos - (float)x2 * yawSin;
        float by = (float)z2 * pitchCos - bUnpitchedZ * pitchSin;
        float bz = bUnpitchedZ * pitchCos + (float)z2 * pitchSin;
        if (!this.plugin.orthographicProjection) {
            double t;
            if (az < 1.0f && bz < 1.0f) {
                return;
            }
            float vx = bx - ax;
            float vy = by - ay;
            float vz = bz - az;
            if (az < 1.0f) {
                t = (1.0f - az) / vz;
                ax += (float)((double)vx * t);
                ay += (float)((double)vy * t);
                az = 1.0f;
            } else if (bz < 1.0f) {
                t = (1.0f - bz) / vz;
                bx += (float)((double)vx * t);
                by += (float)((double)vy * t);
                bz = 1.0f;
            }
        }
        if (this.plugin.orthographicProjection) {
            ax *= 2.0E-4f;
            ay *= 2.0E-4f;
            bx *= 2.0E-4f;
            by *= 2.0E-4f;
        } else {
            ax /= az;
            ay /= az;
            bx /= bz;
            by /= bz;
        }
        int scale = this.client.getScale();
        ax *= (float)scale;
        ay *= (float)scale;
        bx *= (float)scale;
        by *= (float)scale;
        int w = this.client.getViewportWidth();
        int h = this.client.getViewportHeight();
        float offsetX = (float)this.client.getViewportXOffset() + (float)w / 2.0f;
        float offsetY = (float)this.client.getViewportYOffset() + (float)h / 2.0f;
        float vx = (bx += offsetX) - (ax += offsetX);
        float vy = (by += offsetY) - (ay += offsetY);
        if (ax < 0.0f) {
            ay += -ax / vx * vy;
            ax = 0.0f;
        } else if (ax > (float)w) {
            ay += ((float)w - ax) / vx * vy;
            ax = w;
        }
        if (ay < 0.0f) {
            ax += -ay / vy * vx;
            ay = 0.0f;
        } else if (ay > (float)h) {
            ax += ((float)h - ay) / vy * vx;
            ay = h;
        }
        if (bx < 0.0f) {
            by += -bx / vx * vy;
            bx = 0.0f;
        } else if (bx > (float)w) {
            by += ((float)w - bx) / vx * vy;
            bx = w;
        }
        if (by < 0.0f) {
            bx += -by / vy * vx;
            by = 0.0f;
        } else if (by > (float)h) {
            bx += ((float)h - by) / vy * vx;
            by = h;
        }
        int fromX = Math.round(ax);
        int fromY = Math.round(ay);
        int toX = Math.round(bx);
        int toY = Math.round(by);
        if (fromX == toX && fromY == toY) {
            return;
        }
        g.drawLine(fromX, fromY, toX, toY);
    }

    private void setAntiAliasing(Graphics2D g, boolean state) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, state ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    private AABB toLocalAabb(SceneContext ctx, AABB aabb) {
        return this.toLocalAabb(ctx, aabb, 1.0f);
    }

    private AABB toLocalAabb(SceneContext ctx, AABB aabb, float scale) {
        int x1 = (aabb.minX - this.baseEx[0] - 40) * 128;
        int y1 = (aabb.minY - this.baseEx[1] - 40) * 128;
        int x2 = (aabb.maxX + 1 - this.baseEx[0] - 40) * 128;
        int y2 = (aabb.maxY + 1 - this.baseEx[1] - 40) * 128;
        int minZ = 0;
        int maxZ = 4;
        if (aabb.hasZ()) {
            minZ = HDUtils.clamp(aabb.minZ, 0, 4);
            maxZ = HDUtils.clamp(aabb.maxZ, 0, 4) + 1;
        }
        int z1 = Integer.MAX_VALUE;
        int z2 = Integer.MIN_VALUE;
        for (int i = minZ; i < maxZ; ++i) {
            int sw = TileInfoOverlay.getHeight(ctx.scene, x1, y1, i);
            int nw = TileInfoOverlay.getHeight(ctx.scene, x1, y2, i);
            int ne = TileInfoOverlay.getHeight(ctx.scene, x2, y2, i);
            int se = TileInfoOverlay.getHeight(ctx.scene, x2, y1, i);
            if (sw != -1) {
                z1 = Math.min(z1, sw);
                z2 = Math.max(z2, sw);
            }
            if (nw != -1) {
                z1 = Math.min(z1, nw);
                z2 = Math.max(z2, nw);
            }
            if (ne != -1) {
                z1 = Math.min(z1, ne);
                z2 = Math.max(z2, ne);
            }
            if (se == -1) continue;
            z1 = Math.min(z1, se);
            z2 = Math.max(z2, se);
        }
        if (scale == 1.0f) {
            return new AABB(x1, y1, z1, x2, y2, z2);
        }
        float cx = (float)(x1 + x2) / 2.0f;
        float cy = (float)(y1 + y2) / 2.0f;
        float cz = (float)(z1 + z2) / 2.0f;
        int sx = (int)((float)(x2 - x1) / 2.0f);
        int sy = (int)((float)(y2 - y1) / 2.0f);
        int sz = (int)((float)(z2 - z1) / 2.0f);
        return new AABB(Math.round(cx - (float)sx * scale), Math.round(cy - (float)sy * scale), Math.round(cz - (float)sz * scale), Math.round(cx + (float)sx * scale), Math.round(cy + (float)sy * scale), Math.round(cz + (float)sz * scale));
    }

    private AABB cropAabb(SceneContext ctx, AABB aabb) {
        if (aabb.isPoint()) {
            int sceneExX = aabb.minX - this.baseEx[0];
            int sceneExY = aabb.minY - this.baseEx[1];
            if (sceneExX >= 0 && sceneExY >= 0 && sceneExX < 184 && sceneExY < 184) {
                int minZ = 3;
                int maxZ = 0;
                byte filled = ctx.filledTiles[sceneExX][sceneExY];
                for (int plane = 0; plane < 4; ++plane) {
                    if ((filled & 1 << plane) == 0) continue;
                    minZ = Math.min(minZ, plane);
                    maxZ = Math.max(maxZ, plane);
                }
                return new AABB(aabb.minX, aabb.minY, minZ, aabb.minX, aabb.minY, maxZ);
            }
        }
        return aabb;
    }

    private void drawLocalAabb(Graphics2D g, AABB aabb) {
        this.setAntiAliasing(g, true);
        this.drawLine(g, aabb.minX, aabb.minY, aabb.minZ, aabb.minX, aabb.maxY, aabb.minZ);
        this.drawLine(g, aabb.minX, aabb.maxY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.minZ);
        this.drawLine(g, aabb.maxX, aabb.maxY, aabb.minZ, aabb.maxX, aabb.minY, aabb.minZ);
        this.drawLine(g, aabb.maxX, aabb.minY, aabb.minZ, aabb.minX, aabb.minY, aabb.minZ);
        if (aabb.minZ != aabb.maxZ) {
            this.drawLine(g, aabb.minX, aabb.minY, aabb.maxZ, aabb.minX, aabb.maxY, aabb.maxZ);
            this.drawLine(g, aabb.minX, aabb.maxY, aabb.maxZ, aabb.maxX, aabb.maxY, aabb.maxZ);
            this.drawLine(g, aabb.maxX, aabb.maxY, aabb.maxZ, aabb.maxX, aabb.minY, aabb.maxZ);
            this.drawLine(g, aabb.maxX, aabb.minY, aabb.maxZ, aabb.minX, aabb.minY, aabb.maxZ);
            this.drawLine(g, aabb.minX, aabb.minY, aabb.minZ, aabb.minX, aabb.minY, aabb.maxZ);
            this.drawLine(g, aabb.minX, aabb.maxY, aabb.minZ, aabb.minX, aabb.maxY, aabb.maxZ);
            this.drawLine(g, aabb.maxX, aabb.maxY, aabb.minZ, aabb.maxX, aabb.maxY, aabb.maxZ);
            this.drawLine(g, aabb.maxX, aabb.minY, aabb.minZ, aabb.maxX, aabb.minY, aabb.maxZ);
        }
    }

    private int[] getAabbCanvasCenter(AABB aabb) {
        float[] c = aabb.getCenter();
        return this.localToCanvas(this.client, (int)c[0], (int)c[1], (int)c[2]);
    }

    private void drawLocalAabbLabel(Graphics2D g, AABB aabb, String text, boolean backdrop) {
        int[] p = this.getAabbCanvasCenter(aabb);
        if (p == null) {
            return;
        }
        String[] lines = text.split("\\n");
        Color c = g.getColor();
        FontMetrics fm = g.getFontMetrics();
        int lineHeight = fm.getHeight();
        int totalHeight = lineHeight * lines.length;
        if (backdrop) {
            int totalWidth = 0;
            for (String line : lines) {
                totalWidth = Math.max(totalWidth, fm.stringWidth(line));
            }
            g.setColor(BACKDROP_COLOR);
            int pad = 4;
            g.fillRect(p[0] - totalWidth / 2 - pad, p[1] - totalHeight / 2 - lineHeight / 2 - pad, totalWidth + pad * 2, totalHeight + pad * 2);
        }
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int width = fm.stringWidth(line);
            int px = p[0] - width / 2;
            int py = p[1] - totalHeight / 2 + lineHeight * i + lineHeight / 2;
            g.setColor(Color.BLACK);
            g.drawString(line, px + 1, py + 1);
            g.setColor(c);
            g.drawString(line, px, py);
        }
    }

    private void drawLoadingLines(Graphics2D g) {
        g.setColor(Color.BLUE);
        int min = 2048;
        int max = 11264;
        AABB localAabb = new AABB(min, min, max, max, 0);
        this.drawLocalAabb(g, localAabb);
    }

    private void drawRegionBoxes(Graphics2D g, SceneContext ctx) {
        int baseExX = ctx.getBaseExX();
        int baseExY = ctx.getBaseExY();
        int regionSize = 64;
        for (int x = 0; x < 184; x += regionSize) {
            for (int y = 0; y < 184; y += regionSize) {
                int regionX = (baseExX + x) / regionSize;
                int regionY = (baseExY + y) / regionSize;
                int regionId = regionX << 8 | regionY;
                int worldX = regionX * regionSize;
                int worldY = regionY * regionSize;
                AABB aabb = new AABB(worldX, worldY, worldX + regionSize - 1, worldY + regionSize - 1, this.client.getPlane());
                AABB localAabb = this.toLocalAabb(ctx, aabb, 0.996f);
                g.setColor(TRANSPARENT_YELLOW_50);
                this.drawLocalAabb(g, localAabb);
                g.setColor(TRANSPARENT_YELLOW_100);
                this.drawLocalAabbLabel(g, localAabb, "Region ID\n" + regionId, false);
            }
        }
    }

    private void copyToClipboard(String toCopy) {
        this.copyToClipboard(toCopy, null);
    }

    private void copyToClipboard(String toCopy, @Nullable String description) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection string = new StringSelection(toCopy);
        clipboard.setContents(string, null);
        this.clientThread.invoke(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "117 HD", ColorUtil.wrapWithColorTag("[117 HD] " + (String)(description == null ? "Copied to clipboard: " + toCopy : description), Color.GREEN), "117 HD"));
    }

    @Override
    public MouseEvent mouseClicked(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mousePressed(MouseEvent e) {
        SceneContext sceneContext = this.plugin.getSceneContext();
        if (sceneContext == null) {
            return e;
        }
        if (e.isAltDown()) {
            e.consume();
            if (SwingUtilities.isLeftMouseButton(e)) {
                if (!Arrays.equals(this.selectedAreaAabb, this.hoveredAreaAabb)) {
                    if (this.hoveredAreaAabb[0] != -1) {
                        this.copyToClipboard(this.visibleAreas[this.hoveredAreaAabb[0]].aabbs[this.hoveredAreaAabb[1]].toArgs());
                    }
                    System.arraycopy(this.hoveredAreaAabb, 0, this.selectedAreaAabb, 0, 2);
                    return e;
                }
                if (this.aabbMarkingStage == 0) {
                    System.arraycopy(this.hoveredWorldPoint, 0, this.markedWorldPoints[0], 0, 3);
                } else {
                    this.selections.add(this.pendingSelection);
                    if (this.selections.size() == 1) {
                        this.copyToClipboard(this.pendingSelection.toArgs());
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < this.selections.size(); ++i) {
                            if (i > 0) {
                                sb.append(",\n");
                            }
                            sb.append(this.selections.get(i).toArgs());
                        }
                        this.copyToClipboard(sb.toString(), "Copied " + this.selections.size() + " AABBs to clipboard");
                    }
                    this.pendingSelection = null;
                }
                this.aabbMarkingStage = (this.aabbMarkingStage + 1) % 2;
            } else if (SwingUtilities.isRightMouseButton(e)) {
                this.aabbMarkingStage = 0;
                this.selections.clear();
                this.pendingSelection = null;
            }
        }
        return e;
    }

    @Override
    public MouseEvent mouseReleased(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mouseEntered(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mouseExited(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mouseDragged(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mouseMoved(MouseEvent e) {
        return e;
    }

    @Override
    public MouseWheelEvent mouseWheelMoved(MouseWheelEvent e) {
        if (this.ctrlHeld) {
            e.consume();
            this.targetPlane = HDUtils.clamp(this.targetPlane + e.getWheelRotation(), 0, 3);
        } else if (this.altHeld) {
            e.consume();
            this.selectionIncludeZ = !this.selectionIncludeZ;
        }
        return e;
    }

    public boolean isActive() {
        return this.active;
    }
}

