/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.overlays;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.eventbus.EventBus;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.opengl.shader.ShaderException;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import org.lwjgl.opengl.GL20C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ShadowMapOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(ShadowMapOverlay.class);
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private EventBus eventBus;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private HdPlugin plugin;
    private boolean isActive;

    public ShadowMapOverlay() {
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
        this.setPosition(OverlayPosition.TOP_LEFT);
        this.setResizable(true);
    }

    public void setActive(boolean activate) {
        if (activate == this.isActive) {
            return;
        }
        this.isActive = activate;
        if (activate) {
            this.overlayManager.add(this);
            this.plugin.enableShadowMapOverlay = true;
            this.eventBus.register(this);
        } else {
            this.overlayManager.remove(this);
            this.plugin.enableShadowMapOverlay = false;
            this.eventBus.unregister(this);
        }
        this.clientThread.invoke(() -> {
            try {
                this.plugin.recompilePrograms();
            }
            catch (IOException | ShaderException ex) {
                log.error("Error while recompiling shaders:", ex);
                this.plugin.stopPlugin();
            }
        });
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            GL20C.glUseProgram(this.plugin.glUiProgram);
            int uniBounds = GL20C.glGetUniformLocation(this.plugin.glUiProgram, "shadowMapOverlayDimensions");
            if (uniBounds != -1) {
                GL20C.glUniform4i(uniBounds, 0, 0, 0, 0);
            }
        }
    }

    @Override
    public Dimension render(Graphics2D g) {
        Rectangle bounds = this.getBounds();
        this.clientThread.invoke(() -> {
            int uniBounds;
            if (this.plugin.glUiProgram == 0) {
                return;
            }
            GL20C.glUseProgram(this.plugin.glUiProgram);
            int uniShadowMap = GL20C.glGetUniformLocation(this.plugin.glUiProgram, "shadowMap");
            if (uniShadowMap != -1) {
                GL20C.glUniform1i(uniShadowMap, 2);
            }
            if ((uniBounds = GL20C.glGetUniformLocation(this.plugin.glUiProgram, "shadowMapOverlayDimensions")) != -1) {
                if (this.client.getGameState().getState() < GameState.LOGGED_IN.getState()) {
                    GL20C.glUniform4i(uniBounds, 0, 0, 0, 0);
                } else {
                    int canvasWidth = this.client.getCanvasWidth();
                    int canvasHeight = this.client.getCanvasHeight();
                    float scaleX = 1.0f;
                    float scaleY = 1.0f;
                    if (this.client.isStretchedEnabled()) {
                        Dimension stretchedDims = this.client.getStretchedDimensions();
                        scaleX = (float)stretchedDims.width / (float)canvasWidth;
                        scaleY = (float)stretchedDims.height / (float)canvasHeight;
                    }
                    GL20C.glUniform4i(uniBounds, (int)Math.floor((float)(bounds.x + 1) * scaleX), (int)Math.floor((float)(canvasHeight - bounds.height - bounds.y) * scaleY), (int)Math.ceil((float)(bounds.width - 1) * scaleX), (int)Math.ceil((float)(bounds.height - 1) * scaleY));
                }
            }
            this.plugin.checkGLErrors();
        });
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, bounds.width, bounds.height);
        return this.getPreferredSize() == null ? new Dimension(256, 256) : this.getPreferredSize();
    }
}

