/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.overlays;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.scene.SceneContext;
import net.runelite.client.plugins.rs117.hd.scene.lights.Alignment;
import net.runelite.client.plugins.rs117.hd.scene.lights.Light;
import net.runelite.client.plugins.rs117.hd.scene.lights.LightType;
import net.runelite.client.plugins.rs117.hd.utils.ColorUtils;
import net.runelite.client.plugins.rs117.hd.utils.Mat4;
import net.runelite.client.plugins.rs117.hd.utils.Vector;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ColorUtil;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LightGizmoOverlay
extends Overlay
implements MouseListener,
KeyListener {
    private static final Logger log = LoggerFactory.getLogger(LightGizmoOverlay.class);
    private static final Color ORANGE = Color.decode("#ff9f2c");
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MouseManager mouseManager;
    @Inject
    private KeyManager keyManager;
    @Inject
    private HdPlugin plugin;
    private boolean hideInvisibleLights;
    private boolean hideRadiusRings = true;
    private boolean hideAnimLights;
    private boolean hideLabels;
    private boolean hideInfo = true;
    private boolean toggleBlackColor;
    private boolean liveInfo;
    private boolean showDuplicationInfo;
    private boolean toggleOpacity = true;
    private boolean followMouse;
    private Action action = Action.SELECT;
    private final double[] rawMousePos = new double[2];
    private final double[] rawMousePosPrev = new double[2];
    private final double[] mouseDelta = new double[2];
    private final float[] cameraOrientation = new float[2];
    private Alignment originalLightAlignment = Alignment.CUSTOM;
    private final int[] originalLightPosition = new int[3];
    private final int[] originalLightOffset = new int[3];
    private final int[] currentLightOffset = new int[3];
    private int freezeMode = 0;
    private final boolean[] frozenAxes = new boolean[]{false, true, false};
    private final ArrayList<Light> selections = new ArrayList();
    private final ArrayList<Light> hovers = new ArrayList();
    private boolean isProbablyRotatingCamera;
    private static final int RELATIVE_TO_CAMERA = 0;
    private static final int RELATIVE_TO_ORIGIN = 1;
    private static final int RELATIVE_TO_POSITION = 2;
    private ArrayDeque<Change> history = new ArrayDeque();

    public LightGizmoOverlay() {
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.DYNAMIC);
    }

    public void setActive(boolean activate) {
        if (activate) {
            this.overlayManager.add(this);
            this.mouseManager.registerMouseListener(this);
            this.keyManager.registerKeyListener(this);
        } else {
            this.overlayManager.remove(this);
            this.mouseManager.unregisterMouseListener(this);
            this.keyManager.unregisterKeyListener(this);
            this.action = Action.SELECT;
            this.selections.clear();
        }
    }

    @Override
    public Dimension render(Graphics2D g) {
        boolean isShiftHeld;
        boolean isCtrlHeld;
        boolean wasCameraReoriented;
        SceneContext sceneContext;
        block57: {
            boolean isAltHeld;
            block56: {
                sceneContext = this.plugin.getSceneContext();
                if (sceneContext == null) {
                    return null;
                }
                wasCameraReoriented = this.isProbablyRotatingCamera;
                for (int j = 0; j < 2; ++j) {
                    if (this.cameraOrientation[j] == this.plugin.cameraOrientation[j]) continue;
                    wasCameraReoriented = true;
                    break;
                }
                System.arraycopy(this.plugin.cameraOrientation, 0, this.cameraOrientation, 0, 2);
                isCtrlHeld = this.client.isKeyPressed(82);
                isShiftHeld = this.client.isKeyPressed(81);
                isAltHeld = this.client.isKeyPressed(86);
                java.awt.Point rawMouse = MouseInfo.getPointerInfo().getLocation();
                this.rawMousePos[0] = (float)rawMouse.getX();
                this.rawMousePos[1] = (float)rawMouse.getY();
                if (!wasCameraReoriented) break block56;
                if (this.action != Action.GRAB) break block57;
                assert (!this.selections.isEmpty());
                if (this.mouseDelta[0] == 0.0 && this.mouseDelta[1] == 0.0) break block57;
                Arrays.fill(this.mouseDelta, 0.0);
                Light selection = this.selections.get(0);
                System.arraycopy(selection.offset, 0, this.currentLightOffset, 0, 3);
                break block57;
            }
            if (!isAltHeld) {
                double scalingFactor = isShiftHeld ? 0.1 : 1.0;
                for (int j = 0; j < 2; ++j) {
                    int n = j;
                    this.mouseDelta[n] = this.mouseDelta[n] + (this.rawMousePos[j] - this.rawMousePosPrev[j]) * scalingFactor;
                }
            }
        }
        System.arraycopy(this.rawMousePos, 0, this.rawMousePosPrev, 0, 2);
        java.awt.Point mousePoint = new java.awt.Point((int)Math.round(this.rawMousePos[0]), (int)Math.round(this.rawMousePos[1]));
        SwingUtilities.convertPointFromScreen(mousePoint, this.client.getCanvas());
        int[] mousePos = new int[]{mousePoint.x, mousePoint.y};
        Point mousePosCanvas = this.client.getMouseCanvasPosition();
        if (mousePosCanvas != null && (mousePosCanvas.getX() == -1 || mousePosCanvas.getY() == -1)) {
            mousePosCanvas = null;
        }
        g.setFont(FontManager.getRunescapeSmallFont());
        int innerDotDiameter = 6;
        int innerHandleRingDiameter = 19;
        int outerHandleRingDiameter = 25;
        int hoverDistanceMargin = 5;
        BasicStroke thickLine = new BasicStroke(2.0f);
        BasicStroke thinLine = new BasicStroke(1.0f);
        BasicStroke thinnerLine = new BasicStroke(0.75f);
        BasicStroke thinDashedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f}, 0.0f);
        BasicStroke thinLongDashedLine = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{10.0f}, 0.0f);
        BasicStroke thickDashedLine = new BasicStroke(1.5f, 0, 2, 0.0f, new float[]{3.0f}, 0.0f);
        float[] projectionMatrix = Mat4.identity();
        int viewportWidth = this.client.getViewportWidth();
        int viewportHeight = this.client.getViewportHeight();
        Mat4.mul(projectionMatrix, Mat4.translate(this.client.getViewportXOffset(), this.client.getViewportYOffset(), 0.0f));
        Mat4.mul(projectionMatrix, Mat4.scale(viewportWidth, viewportHeight, 1.0f));
        Mat4.mul(projectionMatrix, Mat4.translate(0.5f, 0.5f, 0.5f));
        Mat4.mul(projectionMatrix, Mat4.scale(0.5f, -0.5f, 0.5f));
        Mat4.mul(projectionMatrix, Mat4.scale(this.client.getScale(), this.client.getScale(), 1.0f));
        Mat4.mul(projectionMatrix, Mat4.perspective(viewportWidth, viewportHeight, 50.0f));
        Mat4.mul(projectionMatrix, Mat4.rotateX(this.plugin.cameraOrientation[1]));
        Mat4.mul(projectionMatrix, Mat4.rotateY(this.plugin.cameraOrientation[0]));
        Mat4.mul(projectionMatrix, Mat4.translate(-this.plugin.cameraPosition[0], -this.plugin.cameraPosition[1], -this.plugin.cameraPosition[2]));
        float[] inverseProjection = null;
        try {
            inverseProjection = Mat4.inverse(projectionMatrix);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Not invertible:\n{}", (Object)Mat4.format(projectionMatrix));
        }
        int numFrozenAxes = 0;
        if (this.freezeMode > 0) {
            for (int i = 0; i < 3; ++i) {
                if (!this.frozenAxes[i]) continue;
                ++numFrozenAxes;
            }
        }
        this.hovers.clear();
        int counter = 0;
        float[] lightToCamera = new float[3];
        ArrayList<Light> lights = sceneContext.lights;
        float[] point = new float[4];
        int selectedIndex = -1;
        for (int i = lights.size() - 1; i >= -1; --i) {
            float d;
            int lightIndex = i;
            if (i == -1 && (lightIndex = selectedIndex) == -1) continue;
            Light l = lights.get(lightIndex);
            if (this.hideInvisibleLights && !l.def.visibleFromOtherPlanes && (l.plane < this.client.getPlane() && l.belowFloor || l.plane > this.client.getPlane() && l.aboveFloor) || this.hideAnimLights && !l.def.animationIds.isEmpty() && !l.parentExists) continue;
            boolean isHovered = !this.hovers.isEmpty() && this.hovers.get(0) == l;
            boolean isSelected = this.selections.contains(l);
            if (i != -1 && isSelected) {
                selectedIndex = i;
                continue;
            }
            if (isSelected && !wasCameraReoriented && inverseProjection != null && this.action == Action.GRAB) {
                int j;
                int j2;
                float[] oldLightPos = new float[4];
                float[] newLightPos = new float[4];
                float radians = (float)((double)l.orientation * 0.0030679615757712823);
                float sin = (float)Math.sin(radians);
                float cos = (float)Math.cos(radians);
                for (int j3 = 0; j3 < 3; ++j3) {
                    oldLightPos[j3] = l.origin[j3];
                }
                float x = this.currentLightOffset[0];
                float z = this.currentLightOffset[2];
                oldLightPos[0] = oldLightPos[0] + (-cos * x - sin * z);
                oldLightPos[1] = oldLightPos[1] + (float)this.currentLightOffset[1];
                oldLightPos[2] = oldLightPos[2] + (-cos * z + sin * x);
                oldLightPos[3] = 1.0f;
                Mat4.projectVec(point, projectionMatrix, oldLightPos);
                if (this.followMouse) {
                    for (j2 = 0; j2 < 2; ++j2) {
                        point[j2] = mousePos[j2];
                    }
                } else {
                    for (j2 = 0; j2 < 2; ++j2) {
                        int n = j2;
                        point[n] = point[n] + (float)this.mouseDelta[j2];
                    }
                }
                if (numFrozenAxes == 0) {
                    Mat4.projectVec(newLightPos, inverseProjection, point);
                    if (point[3] <= 0.0f) {
                        continue;
                    }
                } else {
                    int j4;
                    float[] p1 = this.plugin.cameraPosition;
                    float[] v1 = new float[3];
                    Mat4.projectVec(point, inverseProjection, point);
                    for (j = 0; j < 3; ++j) {
                        v1[j] = point[j] - p1[j];
                    }
                    if (numFrozenAxes == 1) {
                        int j5;
                        float[] n = new float[3];
                        for (j5 = 0; j5 < 3; ++j5) {
                            if (!this.frozenAxes[j5]) continue;
                            n[j5] = 1.0f;
                            break;
                        }
                        if (this.freezeMode == 1) {
                            for (j5 = 0; j5 < 3; ++j5) {
                                oldLightPos[j5] = l.origin[j5];
                            }
                            oldLightPos[3] = 1.0f;
                            Mat4.projectVec(point, projectionMatrix, oldLightPos);
                        }
                        float d2 = Vector.dot(n, oldLightPos);
                        float t = (d2 - Vector.dot(p1, n)) / Vector.dot(v1, n);
                        for (j4 = 0; j4 < 3; ++j4) {
                            newLightPos[j4] = p1[j4] + v1[j4] * t;
                        }
                    } else if (numFrozenAxes == 2) {
                        int axis = 0;
                        for (int j6 = 0; j6 < 3; ++j6) {
                            if (this.frozenAxes[j6]) continue;
                            axis = j6;
                            break;
                        }
                        float[] p2 = new float[3];
                        int[] origin = this.freezeMode == 1 ? l.origin : this.originalLightPosition;
                        for (j4 = 0; j4 < 3; ++j4) {
                            p2[j4] = origin[j4];
                        }
                        float[] v2 = new float[3];
                        v2[axis] = 1.0f;
                        float[] v3 = new float[3];
                        Vector.cross(v3, v1, v2);
                        try {
                            float t2 = -p1[0] * v1[1] * v3[2] + p1[0] * v1[2] * v3[1] + p1[1] * v1[0] * v3[2] - p1[1] * v1[2] * v3[0] - p1[2] * v1[0] * v3[1] + p1[2] * v1[1] * v3[0] + p2[0] * v1[1] * v3[2] - p2[0] * v1[2] * v3[1] - p2[1] * v1[0] * v3[2] + p2[1] * v1[2] * v3[0] + p2[2] * v1[0] * v3[1] - p2[2] * v1[1] * v3[0];
                            t2 /= v1[0] * v2[1] * v3[2] - v1[0] * v2[2] * v3[1] - v1[1] * v2[0] * v3[2] + v1[1] * v2[2] * v3[0] + v1[2] * v2[0] * v3[1] - v1[2] * v2[1] * v3[0];
                            for (int j7 = 0; j7 < 3; ++j7) {
                                newLightPos[j7] = p2[j7] + v2[j7] * t2;
                            }
                        }
                        catch (IllegalArgumentException ex) {
                            log.debug("No solution:", ex);
                        }
                    }
                }
                float gridSize = isCtrlHeld ? 128.0f / (float)(isShiftHeld ? 8 : 1) : 1.0f;
                float[] relativePos = new float[3];
                for (j = 0; j < 3; ++j) {
                    relativePos[j] = newLightPos[j] - (float)l.origin[j];
                }
                x = relativePos[0];
                z = relativePos[2];
                relativePos[0] = -cos * x + sin * z;
                relativePos[2] = -cos * z - sin * x;
                for (j = 0; j < 3; ++j) {
                    l.offset[j] = (int)((float)Math.round(relativePos[j] / gridSize) * gridSize);
                }
                x = l.offset[0];
                z = l.offset[2];
                l.pos[0] = l.origin[0] + (int)(-cos * x - sin * z);
                l.pos[1] = l.origin[1] + l.offset[1];
                l.pos[2] = l.origin[2] + (int)(-cos * z + sin * x);
            }
            for (int j = 0; j < 3; ++j) {
                point[j] = l.pos[j];
            }
            point[3] = 1.0f;
            Vector.subtract(lightToCamera, this.plugin.cameraPosition, point);
            float distanceFromCamera = Vector.length(lightToCamera);
            Mat4.projectVec(point, projectionMatrix, point);
            if (point[3] <= 0.0f) continue;
            int x = Math.round(point[0]);
            int y = Math.round(point[1]);
            int currentDiameter = Math.round((float)(l.radius * 2) / distanceFromCamera * (float)this.client.getScale());
            float definedDiameter = (float)(l.def.radius * 2) / distanceFromCamera * (float)this.client.getScale();
            float fRange = l.def.range / 100.0f;
            int minDiameter = Math.round(definedDiameter * (1.0f - fRange));
            int maxDiameter = Math.round(definedDiameter * (1.0f + fRange));
            if (mousePosCanvas != null && ((d = Vector.length(mousePosCanvas.getX() - x, mousePosCanvas.getY() - y)) <= 17.5f || !this.hideRadiusRings && Math.abs(d - (float)currentDiameter / 2.0f) < 10.0f)) {
                this.hovers.add(l);
            }
            int mainOpacity = this.toggleOpacity ? (l.visible ? 255 : 100) : (l.visible ? 100 : 30);
            int rangeOpacity = 70;
            Color baseColor = this.toggleBlackColor ? Color.BLACK : Color.WHITE;
            Color radiusRingColor = this.alpha(baseColor, mainOpacity);
            Color rangeRingsColor = this.alpha(baseColor, rangeOpacity);
            Color handleRingsColor = radiusRingColor;
            Color textColor = Color.WHITE;
            BasicStroke handleRingsStroke = thinDashedLine;
            if (isSelected) {
                radiusRingColor = rangeRingsColor = ORANGE;
                handleRingsColor = rangeRingsColor;
                handleRingsStroke = thickDashedLine;
            } else if (isHovered) {
                radiusRingColor = Color.YELLOW;
                handleRingsColor = Color.WHITE;
            } else {
                textColor = this.alpha(textColor, mainOpacity);
            }
            this.drawRing(g, x, y, 19, handleRingsColor, handleRingsStroke);
            this.drawRing(g, x, y, 25, handleRingsColor, handleRingsStroke);
            if (!this.hideRadiusRings) {
                this.drawRing(g, x, y, currentDiameter, radiusRingColor, thinnerLine);
                if (l.def.type == LightType.PULSE && (float)Math.abs(currentDiameter) > 0.001f) {
                    this.drawRing(g, x, y, minDiameter, rangeRingsColor, thinLongDashedLine);
                    this.drawRing(g, x, y, maxDiameter, rangeRingsColor, thinLongDashedLine);
                }
            }
            if (isSelected) {
                this.fillOutlinedCircle(g, x, y, 6, ORANGE, handleRingsColor, thinLine);
            } else {
                this.drawCircleOutline(g, x, y, 6, handleRingsColor, thinLine);
            }
            g.setColor(textColor);
            if (this.hideLabels) continue;
            Object info = l.def.description;
            if (this.showDuplicationInfo) {
                int newlines = counter++ % 5 + 1;
                info = (String)info + "\n".repeat(newlines);
                info = (String)info + counter + ": " + l.hash;
                info = (String)info + "\n".repeat(5 - newlines);
            }
            if (!this.hideInfo) {
                info = (String)info + String.format("\nradius: %d", this.liveInfo ? l.radius : l.def.radius);
                info = (String)info + String.format("\nstrength: %.1f", Float.valueOf(this.liveInfo ? l.strength : l.def.strength));
                float[] color = ColorUtils.linearToSrgb(l.def.color);
                info = (String)info + String.format("\ncolor: [%.0f, %.0f, %.0f]", Float.valueOf(color[0] * 255.0f), Float.valueOf(color[1] * 255.0f), Float.valueOf(color[2] * 255.0f));
                info = (String)info + String.format("\norigin: [%d, %d%s, %d]", l.origin[0], -(l.origin[1] + l.def.height), l.def.height == 0 ? "" : " + " + l.def.height, l.origin[2]);
                info = (String)info + String.format("\noffset: [%d, %d, %d]", l.offset[0], -l.offset[1], l.offset[2]);
                info = (String)info + String.format("\norientation: %d", l.orientation);
            }
            this.drawAlignedString((Graphics)g, (String)info, x, y + 25, TextAlignment.CENTER_ON_COLONS);
        }
        if (!this.selections.isEmpty()) {
            switch (this.action) {
                case GRAB: {
                    Light l = this.selections.get(0);
                    int[] lightOrigin = this.freezeMode == 1 ? l.origin : this.originalLightPosition;
                    for (int i = 0; i < 3; ++i) {
                        point[i] = lightOrigin[i];
                    }
                    point[3] = 1.0f;
                    float[] origin = new float[4];
                    Mat4.projectVec(origin, projectionMatrix, point);
                    if (point[3] <= 0.0f) break;
                    if (numFrozenAxes > 0) {
                        Color[] axisColors = new Color[]{new Color(15692684), new Color(10475603), new Color(7711969)};
                        g.setStroke(thickLine);
                        float[] stepAlongAxis = new float[4];
                        for (int i = 0; i < 3; ++i) {
                            if (this.frozenAxes[i]) continue;
                            int stepSize = 1000;
                            int n = i;
                            point[n] = point[n] + (float)stepSize;
                            Mat4.projectVec(stepAlongAxis, projectionMatrix, point);
                            int n2 = i;
                            point[n2] = point[n2] - (float)stepSize;
                            g.setColor(axisColors[i]);
                            this.drawLineSpan(g, origin, stepAlongAxis);
                        }
                    }
                    for (int i = 0; i < 3; ++i) {
                        point[i] = l.pos[i];
                    }
                    point[3] = 1.0f;
                    float[] pos = new float[4];
                    Mat4.projectVec(pos, projectionMatrix, point);
                    if (point[3] <= 0.0f) break;
                    g.setColor(Color.YELLOW);
                    this.drawLineSegment(g, origin, pos);
                    break;
                }
            }
        }
        return null;
    }

    private void drawLineSegment(Graphics2D g, float[] a, float[] b) {
        g.drawLine(Math.round(a[0]), Math.round(a[1]), Math.round(b[0]), Math.round(b[1]));
    }

    private void drawLineSpan(Graphics2D g, float[] a, float[] b) {
        float coord;
        float d;
        float[] bounds;
        int oppositeAxis;
        int edge;
        int axis;
        float[] v = new float[2];
        Vector.subtract(v, b, a);
        if (v[0] == 0.0f && v[1] == 0.0f) {
            return;
        }
        float[] p = new float[2];
        System.arraycopy(a, 0, p, 0, 2);
        Rectangle clipBounds = g.getClipBounds();
        float[][] axisBounds = new float[][]{{0.0f, clipBounds.width}, {0.0f, clipBounds.height}};
        float INF = Float.POSITIVE_INFINITY;
        float EPS = 1.0f;
        float t = Float.POSITIVE_INFINITY;
        int intersectedEdge = -1;
        block0: for (axis = 0; axis < 2; ++axis) {
            if (v[axis] == 0.0f) continue;
            for (edge = 0; edge < 2; ++edge) {
                oppositeAxis = (axis + 1) % 2;
                bounds = axisBounds[oppositeAxis];
                d = (axisBounds[axis][edge] - p[axis]) / v[axis];
                coord = p[oppositeAxis] + v[oppositeAxis] * d;
                if (!(bounds[0] - 1.0f < coord) || !(coord < bounds[1] + 1.0f)) continue;
                t = d;
                intersectedEdge = axis * 2 + edge;
                break block0;
            }
        }
        if (t == Float.POSITIVE_INFINITY) {
            return;
        }
        for (int i = 0; i < 2; ++i) {
            int n = i;
            p[n] = p[n] + v[i] * t;
        }
        t = Float.POSITIVE_INFINITY;
        block3: for (axis = 0; axis < 2; ++axis) {
            if (v[axis] == 0.0f) continue;
            for (edge = 0; edge < 2; ++edge) {
                if (axis * 2 + edge == intersectedEdge || !((bounds = axisBounds[oppositeAxis = (axis + 1) % 2])[0] - 1.0f < (coord = p[oppositeAxis] + v[oppositeAxis] * (d = (axisBounds[axis][edge] - p[axis]) / v[axis]))) || !(coord < bounds[1] + 1.0f)) continue;
                t = d;
                break block3;
            }
        }
        if (t == Float.POSITIVE_INFINITY) {
            return;
        }
        int x1 = Math.round(p[0]);
        int y1 = Math.round(p[1]);
        int x2 = Math.round(p[0] + v[0] * t);
        int y2 = Math.round(p[1] + v[1] * t);
        g.drawLine(x1, y1, x2, y2);
    }

    private void fillCircle(Graphics2D g, int centerX, int centerY, int diameter, Color color) {
        int r = diameter / 2;
        g.setColor(color);
        g.fillOval(centerX - r, centerY - r, diameter, diameter);
    }

    private void drawRing(Graphics2D g, int centerX, int centerY, int diameter, Color strokeColor, Stroke stroke) {
        diameter = (int)Math.ceil((float)diameter / 2.0f) * 2 - 1;
        int r = (int)Math.ceil((float)diameter / 2.0f);
        g.setColor(strokeColor);
        g.setStroke(stroke);
        g.drawOval(centerX - r, centerY - r, diameter, diameter);
    }

    private void fillOutlinedCircle(Graphics2D g, int centerX, int centerY, int diameter, Color fillColor, Color strokeColor, Stroke stroke) {
        this.fillCircle(g, centerX, centerY, diameter - 2, fillColor);
        this.drawCircleOutline(g, centerX, centerY, diameter, strokeColor, stroke);
    }

    private void drawCircleOutline(Graphics2D g, int centerX, int centerY, int diameter, Color strokeColor, Stroke stroke) {
        int r = (int)Math.ceil((float)diameter / 2.0f);
        int s = diameter - 1;
        g.setColor(strokeColor);
        g.setStroke(stroke);
        g.drawRoundRect(centerX - r, centerY - r, s, s, s - 1, s - 1);
    }

    private void drawCenteredString(Graphics g, String text, int centerX, int centerY, TextAlignment alignment) {
        this.drawCenteredString(g, text.split("\\n"), centerX, centerY, alignment);
    }

    private void drawCenteredString(Graphics g, String[] lines, int centerX, int centerY, TextAlignment alignment) {
        FontMetrics metrics = g.getFontMetrics();
        int yOffset = metrics.getAscent() - lines.length * metrics.getHeight() / 2;
        this.drawAlignedString(g, lines, centerX, centerY + yOffset, alignment);
    }

    private void drawAlignedString(Graphics g, String text, int centerX, int topY, TextAlignment alignment) {
        this.drawAlignedString(g, text.split("\\n"), centerX, topY, alignment);
    }

    private void drawAlignedString(Graphics g, String[] lines, int centerX, int topY, TextAlignment alignment) {
        Color color = g.getColor();
        Color shadow = this.alpha(Color.BLACK, color.getAlpha());
        FontMetrics metrics = g.getFontMetrics();
        int fontHeight = metrics.getHeight();
        int yOffset = 0;
        if (alignment == TextAlignment.CENTER_ON_COLONS) {
            int longestLeft = 0;
            int longestRight = 0;
            for (String line : lines) {
                int rightLen;
                String right;
                String left;
                int dotIndex = line.indexOf(":");
                if (dotIndex == -1) {
                    left = line;
                    right = "";
                } else {
                    left = line.substring(0, dotIndex);
                    right = line.substring(dotIndex + 1);
                }
                int leftLen = metrics.stringWidth(left);
                if (leftLen > longestLeft) {
                    longestLeft = leftLen;
                }
                if ((rightLen = metrics.stringWidth(right)) <= longestRight) continue;
                longestRight = rightLen;
            }
            int dotOffset = -metrics.stringWidth(":") / 2;
            for (String line : lines) {
                int dotIndex = line.indexOf(":");
                int xOffset = dotOffset;
                xOffset = dotIndex == -1 ? (xOffset -= metrics.stringWidth(line) / 2) : (xOffset -= metrics.stringWidth(line.substring(0, dotIndex)));
                g.setColor(shadow);
                g.drawString(line, centerX + xOffset + 1, topY + yOffset + 1);
                g.setColor(color);
                g.drawString(line, centerX + xOffset, topY + yOffset);
                yOffset += fontHeight;
            }
        } else {
            int longestLine = 0;
            if (alignment != TextAlignment.CENTER) {
                for (String line : lines) {
                    int length = metrics.stringWidth(line);
                    if (longestLine >= length) continue;
                    longestLine = length;
                }
            }
            for (String line : lines) {
                int xOffset;
                switch (alignment) {
                    case LEFT: {
                        xOffset = -longestLine / 2;
                        break;
                    }
                    case RIGHT: {
                        int length = metrics.stringWidth(line);
                        xOffset = longestLine / 2 - length;
                        break;
                    }
                    case CENTER: {
                        xOffset = -metrics.stringWidth(line) / 2;
                        break;
                    }
                    default: {
                        throw new NotImplementedException("Alignment " + alignment + " has not been implemented");
                    }
                }
                g.setColor(shadow);
                g.drawString(line, centerX + xOffset + 1, topY + yOffset + 1);
                g.setColor(color);
                g.drawString(line, centerX + xOffset, topY + yOffset);
                yOffset += fontHeight;
            }
        }
    }

    private Color alpha(Color rgb, int alpha) {
        if (alpha == 255) {
            return rgb;
        }
        return new Color(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), alpha);
    }

    private boolean applyPendingChange() {
        if (this.action == Action.SELECT || this.selections.isEmpty()) {
            return false;
        }
        this.action = Action.SELECT;
        return true;
    }

    private boolean discardPendingChange() {
        if (this.action == Action.SELECT) {
            if (!this.selections.isEmpty()) {
                this.selections.clear();
            }
            return false;
        }
        if (this.selections.isEmpty()) {
            return false;
        }
        if (this.action == Action.GRAB) {
            Light l = this.selections.get(0);
            l.alignment = this.originalLightAlignment;
            System.arraycopy(this.originalLightOffset, 0, l.offset, 0, 3);
        }
        this.action = Action.SELECT;
        return true;
    }

    @Override
    public MouseEvent mouseClicked(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mousePressed(MouseEvent e) {
        if (SwingUtilities.isMiddleMouseButton(e)) {
            this.isProbablyRotatingCamera = true;
        }
        switch (this.action) {
            case SELECT: {
                if (!SwingUtilities.isLeftMouseButton(e) || !e.isControlDown()) break;
                e.consume();
                this.selections.clear();
                if (!this.hovers.isEmpty()) {
                    this.selections.add(this.hovers.get(0));
                    break;
                }
                this.action = Action.SELECT;
                break;
            }
            case GRAB: {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (!this.applyPendingChange()) break;
                    e.consume();
                    break;
                }
                if (!SwingUtilities.isRightMouseButton(e) || !this.discardPendingChange()) break;
                e.consume();
                break;
            }
        }
        return e;
    }

    @Override
    public MouseEvent mouseReleased(MouseEvent e) {
        if (SwingUtilities.isMiddleMouseButton(e)) {
            this.isProbablyRotatingCamera = false;
        }
        return e;
    }

    @Override
    public MouseEvent mouseEntered(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mouseExited(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mouseDragged(MouseEvent e) {
        return e;
    }

    @Override
    public MouseEvent mouseMoved(MouseEvent e) {
        return e;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!this.selections.isEmpty()) {
            Light l = this.selections.get(0);
            if (e.isControlDown() && e.getKeyCode() == 67) {
                String str = "\n    \"offset\": [ " + l.offset[0] + ", " + -l.offset[1] + ", " + l.offset[2] + " ],";
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection string = new StringSelection(str);
                clipboard.setContents(string, null);
                this.clientThread.invoke(() -> this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "117 HD", ColorUtil.wrapWithColorTag("[117 HD] Copied offset (must remove alignment): " + str.trim(), Color.GREEN), "117 HD"));
            }
            if (this.action == Action.SELECT) {
                switch (e.getKeyCode()) {
                    case 71: {
                        this.action = Action.GRAB;
                        Arrays.fill(this.mouseDelta, 0.0);
                        this.originalLightAlignment = l.alignment;
                        System.arraycopy(l.offset, 0, this.originalLightOffset, 0, 3);
                        System.arraycopy(l.pos, 0, this.originalLightPosition, 0, 3);
                        l.alignment = Alignment.CUSTOM;
                        for (int i = 0; i < 3; ++i) {
                            l.offset[i] = l.pos[i] - l.origin[i];
                        }
                        System.arraycopy(l.offset, 0, this.currentLightOffset, 0, 3);
                        break;
                    }
                    case 83: {
                        this.action = Action.SCALE;
                    }
                }
            } else if (this.action == Action.GRAB) {
                int axis = -1;
                boolean cycleFreezeMode = false;
                switch (e.getKeyCode()) {
                    case 88: {
                        axis = 0;
                        break;
                    }
                    case 89: {
                        axis = 1;
                        break;
                    }
                    case 90: {
                        axis = 2;
                        break;
                    }
                    case 71: {
                        cycleFreezeMode = true;
                    }
                }
                if (axis != -1) {
                    boolean invert = e.isShiftDown();
                    boolean modified = false;
                    for (int i = 0; i < 3; ++i) {
                        boolean shouldFreeze;
                        boolean bl = shouldFreeze = i == axis == invert;
                        if (shouldFreeze != this.frozenAxes[i]) {
                            modified = true;
                        }
                        this.frozenAxes[i] = shouldFreeze;
                    }
                    if (modified) {
                        if (this.freezeMode == 0) {
                            this.freezeMode = 1;
                        }
                        System.arraycopy(this.originalLightOffset, 0, l.offset, 0, 3);
                    } else {
                        cycleFreezeMode = true;
                    }
                }
                if (cycleFreezeMode) {
                    ++this.freezeMode;
                    this.freezeMode %= 3;
                }
            }
            switch (e.getKeyCode()) {
                case 27: {
                    if (!this.discardPendingChange()) break;
                    e.consume();
                    break;
                }
                case 10: {
                    if (!this.applyPendingChange()) break;
                    e.consume();
                    break;
                }
                case 8: {
                    l.alignment = l.def.alignment;
                    System.arraycopy(l.def.offset, 0, l.offset, 0, 3);
                    System.arraycopy(l.offset, 0, this.currentLightOffset, 0, 3);
                    System.arraycopy(l.offset, 0, this.originalLightOffset, 0, 3);
                    Arrays.fill(this.mouseDelta, 0.0);
                }
            }
        }
        if (e.isControlDown()) {
            switch (e.getKeyCode()) {
                case 65: {
                    this.hideAnimLights = !this.hideAnimLights;
                    break;
                }
                case 66: {
                    this.toggleBlackColor = !this.toggleBlackColor;
                    break;
                }
                case 68: {
                    this.showDuplicationInfo = !this.showDuplicationInfo;
                    break;
                }
                case 72: {
                    this.hideInvisibleLights = !this.hideInvisibleLights;
                    break;
                }
                case 73: {
                    this.hideInfo = !this.hideInfo;
                    break;
                }
                case 76: {
                    this.hideLabels = !this.hideLabels;
                    break;
                }
                case 77: {
                    this.followMouse = !this.followMouse;
                    break;
                }
                case 79: {
                    this.toggleOpacity = !this.toggleOpacity;
                    break;
                }
                case 82: {
                    this.hideRadiusRings = !this.hideRadiusRings;
                    break;
                }
                case 85: {
                    this.liveInfo = !this.liveInfo;
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    static enum Action {
        SELECT,
        GRAB,
        SCALE;

    }

    private static enum TextAlignment {
        LEFT,
        RIGHT,
        CENTER,
        CENTER_ON_COLONS;

    }

    static interface Change {
        public void undo();

        public void redo();
    }
}

