/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.overlays;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayDeque;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.overlays.FrameTimer;
import net.runelite.client.plugins.rs117.hd.overlays.FrameTimings;
import net.runelite.client.plugins.rs117.hd.overlays.Timer;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.TitleComponent;

@Singleton
public class FrameTimerOverlay
extends OverlayPanel
implements FrameTimer.Listener {
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private FrameTimer frameTimer;
    private final ArrayDeque<FrameTimings> frames = new ArrayDeque();
    private final StringBuilder sb = new StringBuilder();

    @Inject
    public FrameTimerOverlay(HdPlugin plugin) {
        super(plugin);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.setPosition(OverlayPosition.TOP_RIGHT);
        this.panelComponent.setPreferredSize(new Dimension(215, 200));
    }

    public void setActive(boolean activate) {
        if (activate) {
            this.frameTimer.addTimingsListener(this);
            this.overlayManager.add(this);
        } else {
            this.frameTimer.removeTimingsListener(this);
            this.overlayManager.remove(this);
            this.frames.clear();
        }
    }

    @Override
    public void onFrameCompletion(FrameTimings timings) {
        long now = System.nanoTime();
        while (!this.frames.isEmpty() && !((double)(now - this.frames.peekFirst().frameTimestamp) < 3.0E9)) {
            this.frames.removeFirst();
        }
        this.frames.addLast(timings);
    }

    @Override
    public Dimension render(Graphics2D g) {
        long[] timings = this.getAverageTimings();
        if (timings.length != Timer.values().length) {
            this.panelComponent.getChildren().add(TitleComponent.builder().text("Waiting for data...").build());
        } else {
            long cpuTime = timings[Timer.DRAW_FRAME.ordinal()];
            this.addTiming("CPU", cpuTime, true);
            for (Timer t : Timer.values()) {
                if (t.isGpuTimer || t == Timer.DRAW_FRAME) continue;
                this.addTiming(t, timings);
            }
            long gpuTime = 0L;
            for (Timer t : Timer.values()) {
                if (!t.isGpuTimer) continue;
                gpuTime += timings[t.ordinal()];
            }
            this.addTiming("GPU", gpuTime, true);
            for (Timer t : Timer.values()) {
                if (!t.isGpuTimer) continue;
                this.addTiming(t, timings);
            }
            this.panelComponent.getChildren().add(LineComponent.builder().leftFont(FontManager.getRunescapeBoldFont()).left("Estimated bottleneck:").rightFont(FontManager.getRunescapeBoldFont()).right(cpuTime > gpuTime ? "CPU" : "GPU").build());
            this.panelComponent.getChildren().add(LineComponent.builder().leftFont(FontManager.getRunescapeBoldFont()).left("Estimated FPS:").rightFont(FontManager.getRunescapeBoldFont()).right(String.format("%.1f FPS", 1.0 / ((double)Math.max(cpuTime, gpuTime) / 1.0E9))).build());
        }
        return super.render(g);
    }

    private long[] getAverageTimings() {
        if (this.frames.isEmpty()) {
            return new long[0];
        }
        long[] timers = new long[Timer.values().length];
        for (FrameTimings frame : this.frames) {
            for (int i = 0; i < frame.timers.length; ++i) {
                int n = i;
                timers[n] = timers[n] + frame.timers[i];
            }
        }
        int i = 0;
        while (i < timers.length) {
            int n = i++;
            timers[n] = timers[n] / (long)this.frames.size();
        }
        return timers;
    }

    private void addTiming(Timer timer, long[] timings) {
        this.addTiming(timer.name, timings[timer.ordinal()], false);
    }

    private void addTiming(String name, long nanos, boolean bold) {
        if (nanos == 0L) {
            return;
        }
        String result = "~0 ms";
        if ((double)nanos < -100000.0 || (double)nanos > 3000.0) {
            result = this.sb.append((double)Math.round((double)nanos / 1000.0) / 1000.0).append(" ms").toString();
            this.sb.setLength(0);
        }
        Font font = bold ? FontManager.getRunescapeBoldFont() : FontManager.getRunescapeFont();
        this.panelComponent.getChildren().add(LineComponent.builder().left(name + ":").leftFont(font).right(result).rightFont(font).build());
    }
}

