/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.opengl.shader;

import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.runelite.client.plugins.rs117.hd.opengl.shader.Shader;
import net.runelite.client.plugins.rs117.hd.opengl.shader.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaderException
extends Exception {
    private static final Logger log = LoggerFactory.getLogger(ShaderException.class);
    private static final Pattern NVIDIA_ERROR_REGEX = Pattern.compile("^(\\d+)\\((\\d+)\\) : (.*)$", 8);

    public static ShaderException compileError(String error, Template template, Shader.Unit ... units) {
        StringBuilder sb = new StringBuilder();
        if (template.includeType == Template.IncludeType.GLSL) {
            Matcher m = NVIDIA_ERROR_REGEX.matcher(error);
            if (m.find()) {
                try {
                    sb.append(String.format("Compile error when compiling shader%s: %s\n", units.length == 1 ? "" : "s", Arrays.stream(units).map(u -> u.filename).collect(Collectors.joining(", "))));
                    int offset = 0;
                    do {
                        if (m.start() > offset) {
                            sb.append(error, offset, m.start());
                        }
                        offset = m.end();
                        int index = Integer.parseInt(m.group(1));
                        int lineNumber = Integer.parseInt(m.group(2));
                        String errorString = m.group(3);
                        String include = template.includeList.get(index);
                        sb.append(String.format("%s line %d - %s", include, lineNumber, errorString));
                    } while (m.find());
                }
                catch (Exception ex) {
                    log.error("Error while parsing shader compilation error:", ex);
                }
            } else {
                sb.append("Compile error while compiling shader").append(units.length == 1 ? "" : "s").append(": ").append(Arrays.stream(units).map(u -> u.filename).collect(Collectors.joining(", "))).append("\n").append(error).append("Included sources: [\n");
                for (int j = 0; j < template.includeList.size(); ++j) {
                    String s = String.valueOf(j);
                    sb.append("  ").append(String.join((CharSequence)"", Collections.nCopies(1 + (int)Math.log10(template.includeList.size()) - s.length(), " "))).append(s).append(": ").append(template.includeList.get(j)).append("\n");
                }
                sb.append("]");
            }
        }
        return new ShaderException(sb.toString());
    }

    public ShaderException(String message) {
        super(message);
    }
}

