/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.opengl.shader;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.runelite.client.plugins.rs117.hd.opengl.shader.ShaderException;
import net.runelite.client.plugins.rs117.hd.opengl.shader.Template;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.ResourcePath;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL43C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shader {
    private static final Logger log = LoggerFactory.getLogger(Shader.class);
    public static final boolean DUMP_SHADERS = Props.has("rlhd.dump-shaders");
    @VisibleForTesting
    final List<Unit> units = new ArrayList<Unit>();

    public Shader add(int type, String name) {
        this.units.add(new Unit(type, name));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compile(Template template) throws ShaderException, IOException {
        int program = GL43C.glCreateProgram();
        int[] shaders = new int[this.units.size()];
        int i = 0;
        boolean ok = false;
        ResourcePath dumpPath = null;
        if (DUMP_SHADERS) {
            dumpPath = ResourcePath.path("shader-dumps").mkdirs();
        }
        try {
            while (i < shaders.length) {
                Unit unit = this.units.get(i);
                int shader = GL43C.glCreateShader(unit.type);
                if (shader == 0) {
                    throw new ShaderException("Unable to create shader of type " + unit.type);
                }
                String source = template.load(unit.filename);
                if (DUMP_SHADERS) {
                    dumpPath.resolve(unit.filename).writeString(source);
                }
                GL43C.glShaderSource(shader, (CharSequence)source);
                GL43C.glCompileShader(shader);
                if (GL43C.glGetShaderi(shader, 35713) != 1) {
                    String err = GL43C.glGetShaderInfoLog(shader);
                    GL43C.glDeleteShader(shader);
                    throw ShaderException.compileError(err, template, unit);
                }
                GL43C.glAttachShader(program, shader);
                shaders[i++] = shader;
            }
            GL43C.glLinkProgram(program);
            if (GL43C.glGetProgrami(program, 35714) == 0) {
                String err = GL43C.glGetProgramInfoLog(program);
                throw ShaderException.compileError(err, template, this.units.toArray(new Unit[0]));
            }
            ok = true;
            if (DUMP_SHADERS) {
                int[] numFormats = new int[]{0};
                GL43C.glGetIntegerv(34814, numFormats);
                if (numFormats[0] < 1) {
                    log.error("OpenGL driver does not support any binary formats");
                } else {
                    int[] size = new int[]{0};
                    GL43C.glGetProgramiv(program, 34625, size);
                    int[] format = new int[]{0};
                    ByteBuffer binary = BufferUtils.createByteBuffer(size[0]);
                    GL43C.glGetProgramBinary(program, size, format, binary);
                    String shaderName = this.units.stream().map(Unit::getFilename).collect(Collectors.joining(" + ")) + ".bin";
                    dumpPath.resolve(shaderName).writeByteBuffer(binary);
                }
            }
        }
        finally {
            while (i > 0) {
                int shader = shaders[--i];
                GL43C.glDetachShader(program, shader);
                GL43C.glDeleteShader(shader);
            }
            if (!ok) {
                GL43C.glDeleteProgram(program);
            }
        }
        return program;
    }

    @VisibleForTesting
    static class Unit {
        public final int type;
        public final String filename;

        public Unit(int type, String filename) {
            this.type = type;
            this.filename = filename;
        }

        public int getType() {
            return this.type;
        }

        public String getFilename() {
            return this.filename;
        }
    }
}

