/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.opengl.compute;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.Scene;
import net.runelite.client.plugins.rs117.hd.HdPlugin;
import net.runelite.client.plugins.rs117.hd.HdPluginConfig;
import net.runelite.client.plugins.rs117.hd.opengl.shader.ShaderException;
import net.runelite.client.plugins.rs117.hd.opengl.shader.Template;
import net.runelite.client.plugins.rs117.hd.utils.buffer.GLBuffer;
import net.runelite.client.util.OSType;
import net.runelite.rlawt.AWTContext;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.APPLEGLSharing;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLContextCallbackI;
import org.lwjgl.opencl.CLImageFormat;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class OpenCLManager {
    private static final Logger log = LoggerFactory.getLogger(OpenCLManager.class);
    private static final String KERNEL_NAME_PASSTHROUGH = "passthroughModel";
    private static final String KERNEL_NAME_SORT = "sortModel";
    private static final int SHARED_SIZE = 43;
    @Inject
    private HdPlugin plugin;
    @Inject
    private HdPluginConfig config;
    private boolean initialized;
    private long device;
    private long context;
    private long commandQueue;
    private long passthroughProgram;
    private long[] sortingPrograms;
    private long passthroughKernel;
    private long[] sortingKernels;
    private long tileHeightMap;

    public void startUp(AWTContext awtContext) {
        CL.create();
        this.initialized = true;
        if (OSType.getOSType() == OSType.MacOS) {
            this.initContextMacOS(awtContext);
        } else {
            this.initContext(awtContext);
        }
        log.debug("Device CL_DEVICE_MAX_WORK_GROUP_SIZE: {}", (Object)this.getMaxWorkGroupSize());
        this.initQueue();
    }

    public void shutDown() {
        if (!this.initialized) {
            return;
        }
        try {
            if (this.tileHeightMap != 0L) {
                CL10.clReleaseMemObject(this.tileHeightMap);
            }
            this.tileHeightMap = 0L;
            this.destroyPrograms();
            if (this.commandQueue != 0L) {
                CL10.clReleaseCommandQueue(this.commandQueue);
            }
            this.commandQueue = 0L;
            if (this.context != 0L) {
                CL10.clReleaseContext(this.context);
            }
            this.context = 0L;
            if (this.device != 0L) {
                CL12.clReleaseDevice(this.device);
            }
            this.device = 0L;
        }
        finally {
            CL.destroy();
            this.initialized = false;
        }
    }

    private void initContext(AWTContext awtContext) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pi = stack.mallocInt(1);
            OpenCLManager.checkCLError(CL10.clGetPlatformIDs(null, pi));
            if (pi.get(0) == 0) {
                throw new RuntimeException("No OpenCL platforms found.");
            }
            PointerBuffer platforms = stack.mallocPointer(pi.get(0));
            OpenCLManager.checkCLError(CL10.clGetPlatformIDs(platforms, (IntBuffer)null));
            PointerBuffer ctxProps = stack.mallocPointer(7);
            if (OSType.getOSType() == OSType.Windows) {
                ctxProps.put(4228L).put(0L).put(8200L).put(awtContext.getGLContext()).put(8203L).put(awtContext.getWGLHDC()).put(0L).flip();
            } else if (OSType.getOSType() == OSType.Linux) {
                ctxProps.put(4228L).put(0L).put(8200L).put(awtContext.getGLContext()).put(8202L).put(awtContext.getGLXDisplay()).put(0L).flip();
            } else {
                throw new RuntimeException("unsupported platform");
            }
            if (platforms.limit() == 0) {
                throw new RuntimeException("Unable to find compute platform");
            }
            IntBuffer errcode_ret = stack.callocInt(1);
            for (int p = 0; p < platforms.limit(); ++p) {
                try {
                    long platform = platforms.get(p);
                    ctxProps.put(1, platform);
                    log.debug("Platform index {}:", (Object)p);
                    log.debug("\tprofile: {}", (Object)OpenCLManager.getPlatformInfoStringUTF8(platform, 2304));
                    log.debug("\tversion: {}", (Object)OpenCLManager.getPlatformInfoStringUTF8(platform, 2305));
                    log.debug("\tname: {}", (Object)OpenCLManager.getPlatformInfoStringUTF8(platform, 2306));
                    log.debug("\tvendor: {}", (Object)OpenCLManager.getPlatformInfoStringUTF8(platform, 2307));
                    log.debug("\textensions: {}", (Object)OpenCLManager.getPlatformInfoStringUTF8(platform, 2308));
                    int returnCode = CL10.clGetDeviceIDs(platform, -1L, null, pi);
                    if (returnCode == -31) {
                        log.debug("\tno devices");
                        continue;
                    }
                    OpenCLManager.checkCLError(returnCode);
                    PointerBuffer devices = stack.mallocPointer(pi.get(0));
                    OpenCLManager.checkCLError(CL10.clGetDeviceIDs(platform, -1L, devices, (IntBuffer)null));
                    for (int d = 0; d < devices.capacity(); ++d) {
                        long device = devices.get(d);
                        long deviceType = OpenCLManager.getDeviceInfoLong(device, 4096);
                        log.debug("\tdevice index {}:", (Object)d);
                        log.debug("\t\tCL_DEVICE_NAME: {}", (Object)OpenCLManager.getDeviceInfoStringUTF8(device, 4139));
                        log.debug("\t\tCL_DEVICE_VENDOR: {}", (Object)OpenCLManager.getDeviceInfoStringUTF8(device, 4140));
                        log.debug("\t\tCL_DRIVER_VERSION: {}", (Object)OpenCLManager.getDeviceInfoStringUTF8(device, 4141));
                        log.debug("\t\tCL_DEVICE_PROFILE: {}", (Object)OpenCLManager.getDeviceInfoStringUTF8(device, 4142));
                        log.debug("\t\tCL_DEVICE_VERSION: {}", (Object)OpenCLManager.getDeviceInfoStringUTF8(device, 4143));
                        log.debug("\t\tCL_DEVICE_EXTENSIONS: {}", (Object)OpenCLManager.getDeviceInfoStringUTF8(device, 4144));
                        log.debug("\t\tCL_DEVICE_TYPE: {}", (Object)deviceType);
                        log.debug("\t\tCL_DEVICE_VENDOR_ID: {}", (Object)OpenCLManager.getDeviceInfoInt(device, 4097));
                        log.debug("\t\tCL_DEVICE_MAX_COMPUTE_UNITS: {}", (Object)OpenCLManager.getDeviceInfoInt(device, 4098));
                        log.debug("\t\tCL_DEVICE_MAX_WORK_ITEM_DIMENSIONS: {}", (Object)OpenCLManager.getDeviceInfoInt(device, 4099));
                        log.debug("\t\tCL_DEVICE_MAX_WORK_GROUP_SIZE: {}", (Object)OpenCLManager.getDeviceInfoPointer(device, 4100));
                        log.debug("\t\tCL_DEVICE_MAX_CLOCK_FREQUENCY: {}", (Object)OpenCLManager.getDeviceInfoInt(device, 4108));
                        log.debug("\t\tCL_DEVICE_ADDRESS_BITS: {}", (Object)OpenCLManager.getDeviceInfoInt(device, 4109));
                        log.debug("\t\tCL_DEVICE_AVAILABLE: {}", (Object)(OpenCLManager.getDeviceInfoInt(device, 4135) != 0 ? 1 : 0));
                        log.debug("\t\tCL_DEVICE_COMPILER_AVAILABLE: {}", (Object)(OpenCLManager.getDeviceInfoInt(device, 4136) != 0 ? 1 : 0));
                        if (deviceType != 4L) continue;
                        CLCapabilities platformCaps = CL.createPlatformCapabilities(platform);
                        CLCapabilities deviceCaps = CL.createDeviceCapabilities(device, platformCaps);
                        if (!deviceCaps.cl_khr_gl_sharing && !deviceCaps.cl_APPLE_gl_sharing || this.context != 0L) continue;
                        try {
                            CLContextCallback callback = CLContextCallback.create((errinfo, private_info, cb, user_data) -> log.error("[LWJGL] cl_context_callback: {}", (Object)MemoryUtil.memUTF8(errinfo)));
                            long context = CL10.clCreateContext(ctxProps, device, (CLContextCallbackI)callback, 0L, errcode_ret);
                            OpenCLManager.checkCLError(errcode_ret);
                            this.device = device;
                            this.context = context;
                            continue;
                        }
                        catch (Exception ex) {
                            log.error("Error while creating context:", ex);
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    log.error("Error while checking platform:", ex);
                }
            }
            if (this.context == 0L) {
                throw new RuntimeException("Unable to create suitable compute context");
            }
        }
    }

    private void initContextMacOS(AWTContext awtContext) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer ctxProps = stack.mallocPointer(3);
            ctxProps.put(0x10000000L).put(awtContext.getCGLShareGroup()).put(0L).flip();
            IntBuffer errcode_ret = stack.callocInt(1);
            PointerBuffer devices = stack.mallocPointer(0);
            long context = CL10.clCreateContext(ctxProps, devices, (CLContextCallbackI)CLContextCallback.create((errinfo, private_info, cb, user_data) -> log.error("[LWJGL] cl_context_callback: {}", (Object)MemoryUtil.memUTF8(errinfo))), 0L, errcode_ret);
            OpenCLManager.checkCLError(errcode_ret);
            PointerBuffer deviceBuf = stack.mallocPointer(1);
            OpenCLManager.checkCLError(APPLEGLSharing.clGetGLContextInfoAPPLE(context, awtContext.getGLContext(), 0x10000002, deviceBuf, null));
            long device = deviceBuf.get(0);
            log.debug("Got macOS CLGL compute device {}", (Object)device);
            this.context = context;
            this.device = device;
        }
    }

    public int getMaxWorkGroupSize() {
        long[] maxWorkGroupSize = new long[1];
        CL10.clGetDeviceInfo(this.device, 4100, maxWorkGroupSize, null);
        return (int)maxWorkGroupSize[0];
    }

    private void initQueue() {
        long[] l = new long[1];
        CL10.clGetDeviceInfo(this.device, 4138, l, null);
        this.commandQueue = CL10.clCreateCommandQueue(this.context, this.device, l[0] & 1L, (int[])null);
        log.debug("Created command_queue {}, properties {}", (Object)this.commandQueue, (Object)(l[0] & 1L));
    }

    private long compileProgram(MemoryStack stack, String programSource) throws ShaderException {
        log.trace("Compiling program:\n {}", (Object)programSource);
        IntBuffer errcode_ret = stack.callocInt(1);
        long program = CL10.clCreateProgramWithSource(this.context, programSource, errcode_ret);
        OpenCLManager.checkCLError(errcode_ret);
        int err = CL10.clBuildProgram(program, this.device, (CharSequence)"", null, 0L);
        if (err != 0) {
            throw new ShaderException(OpenCLManager.getProgramBuildInfoStringASCII(program, this.device, 4483));
        }
        log.debug("Build status: {}", (Object)OpenCLManager.getProgramBuildInfoInt(program, this.device, 4481));
        log.debug("Binary type: {}", (Object)OpenCLManager.getProgramBuildInfoInt(program, this.device, 4484));
        log.debug("Build options: {}", (Object)OpenCLManager.getProgramBuildInfoStringASCII(program, this.device, 4482));
        log.debug("Build log: {}", (Object)OpenCLManager.getProgramBuildInfoStringASCII(program, this.device, 4483));
        return program;
    }

    private long getKernel(MemoryStack stack, long program, String kernelName) {
        IntBuffer errcode_ret = stack.callocInt(1);
        long kernel = CL10.clCreateKernel(program, (CharSequence)kernelName, errcode_ret);
        OpenCLManager.checkCLError(errcode_ret);
        log.debug("Loaded kernel {} for program {}", (Object)kernelName, (Object)program);
        return kernel;
    }

    public void initPrograms() throws ShaderException, IOException {
        try (MemoryStack stack = MemoryStack.stackPush();){
            Template template = new Template().define("UNDO_VANILLA_SHADING", this.plugin.configUndoVanillaShading).define("LEGACY_GREY_COLORS", this.plugin.configLegacyGreyColors).addIncludePath(OpenCLManager.class);
            this.passthroughProgram = this.compileProgram(stack, template.load("comp_unordered.cl"));
            this.passthroughKernel = this.getKernel(stack, this.passthroughProgram, KERNEL_NAME_PASSTHROUGH);
            this.sortingPrograms = new long[this.plugin.numSortingBins];
            this.sortingKernels = new long[this.plugin.numSortingBins];
            for (int i = 0; i < this.plugin.numSortingBins; ++i) {
                int faceCount = this.plugin.modelSortingBinFaceCounts[i];
                int threadCount = this.plugin.modelSortingBinThreadCounts[i];
                int facesPerThread = (int)Math.ceil((float)faceCount / (float)threadCount);
                this.sortingPrograms[i] = this.compileProgram(stack, template.copy().define("THREAD_COUNT", threadCount).define("FACES_PER_THREAD", facesPerThread).load("comp.cl"));
                this.sortingKernels[i] = this.getKernel(stack, this.sortingPrograms[i], KERNEL_NAME_SORT);
            }
        }
    }

    public void destroyPrograms() {
        if (this.passthroughKernel != 0L) {
            CL10.clReleaseKernel(this.passthroughKernel);
        }
        this.passthroughKernel = 0L;
        if (this.passthroughProgram != 0L) {
            CL10.clReleaseProgram(this.passthroughProgram);
        }
        this.passthroughProgram = 0L;
        if (this.sortingKernels != null) {
            for (long kernel : this.sortingKernels) {
                if (kernel == 0L) continue;
                CL10.clReleaseKernel(kernel);
            }
        }
        this.sortingKernels = null;
        if (this.sortingPrograms != null) {
            for (long program : this.sortingPrograms) {
                if (program == 0L) continue;
                CL10.clReleaseProgram(program);
            }
        }
        this.sortingPrograms = null;
    }

    public void uploadTileHeights(Scene scene) {
        if (this.tileHeightMap != 0L) {
            CL10.clReleaseMemObject(this.tileHeightMap);
        }
        this.tileHeightMap = 0L;
        int TILEHEIGHT_BUFFER_SIZE = 270848;
        ShortBuffer tileBuffer = BufferUtils.createShortBuffer(270848);
        int[][][] tileHeights = scene.getTileHeights();
        for (int z = 0; z < 4; ++z) {
            for (int y = 0; y < 184; ++y) {
                for (int x = 0; x < 184; ++x) {
                    int h = tileHeights[z][x][y];
                    assert ((h & 7) == 0);
                    tileBuffer.put((short)(h >>= 3));
                }
            }
        }
        tileBuffer.flip();
        try (MemoryStack stack = MemoryStack.stackPush();){
            CLImageFormat imageFormat = CLImageFormat.calloc(stack);
            imageFormat.image_channel_order(4272);
            imageFormat.image_channel_data_type(4312);
            IntBuffer errcode_ret = stack.callocInt(1);
            this.tileHeightMap = CL10.clCreateImage3D(this.context, 36L, imageFormat, 184L, 184L, 4L, 0L, 0L, tileBuffer, errcode_ret);
            OpenCLManager.checkCLError(errcode_ret);
        }
    }

    public void compute(GLBuffer uniformBufferCamera, int numPassthroughModels, int[] numSortingBinModels, GLBuffer modelPassthroughBuffer, GLBuffer[] modelSortingBuffers, GLBuffer stagingBufferVertices, GLBuffer stagingBufferUvs, GLBuffer stagingBufferNormals, GLBuffer renderBufferVertices, GLBuffer renderBufferUvs, GLBuffer renderBufferNormals) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer glBuffers = stack.mallocPointer(8 + modelSortingBuffers.length).put(uniformBufferCamera.clBuffer).put(modelPassthroughBuffer.clBuffer).put(stagingBufferVertices.clBuffer).put(stagingBufferUvs.clBuffer).put(stagingBufferNormals.clBuffer).put(renderBufferVertices.clBuffer).put(renderBufferUvs.clBuffer).put(renderBufferNormals.clBuffer);
            for (GLBuffer buffer : modelSortingBuffers) {
                glBuffers.put(buffer.clBuffer);
            }
            glBuffers.flip();
            PointerBuffer acquireEvent = stack.mallocPointer(1);
            CL10GL.clEnqueueAcquireGLObjects(this.commandQueue, glBuffers, null, acquireEvent);
            PointerBuffer computeEvents = stack.mallocPointer(1 + modelSortingBuffers.length);
            if (numPassthroughModels > 0) {
                CL10.clSetKernelArg1p(this.passthroughKernel, 0, modelPassthroughBuffer.clBuffer);
                CL10.clSetKernelArg1p(this.passthroughKernel, 1, stagingBufferVertices.clBuffer);
                CL10.clSetKernelArg1p(this.passthroughKernel, 2, stagingBufferUvs.clBuffer);
                CL10.clSetKernelArg1p(this.passthroughKernel, 3, stagingBufferNormals.clBuffer);
                CL10.clSetKernelArg1p(this.passthroughKernel, 4, renderBufferVertices.clBuffer);
                CL10.clSetKernelArg1p(this.passthroughKernel, 5, renderBufferUvs.clBuffer);
                CL10.clSetKernelArg1p(this.passthroughKernel, 6, renderBufferNormals.clBuffer);
                CL10.clEnqueueNDRangeKernel(this.commandQueue, this.passthroughKernel, 1, null, stack.pointers((long)numPassthroughModels * 6L), stack.pointers(6L), acquireEvent, computeEvents);
                computeEvents.position(computeEvents.position() + 1);
            }
            for (int i = 0; i < numSortingBinModels.length; ++i) {
                int numModels = numSortingBinModels[i];
                if (numModels == 0) continue;
                int faceCount = this.plugin.modelSortingBinFaceCounts[i];
                int threadCount = this.plugin.modelSortingBinThreadCounts[i];
                long kernel = this.sortingKernels[i];
                CL10.clSetKernelArg(kernel, 0, (long)(43 + faceCount) * 4L);
                CL10.clSetKernelArg1p(kernel, 1, modelSortingBuffers[i].clBuffer);
                CL10.clSetKernelArg1p(kernel, 2, stagingBufferVertices.clBuffer);
                CL10.clSetKernelArg1p(kernel, 3, stagingBufferUvs.clBuffer);
                CL10.clSetKernelArg1p(kernel, 4, stagingBufferNormals.clBuffer);
                CL10.clSetKernelArg1p(kernel, 5, renderBufferVertices.clBuffer);
                CL10.clSetKernelArg1p(kernel, 6, renderBufferUvs.clBuffer);
                CL10.clSetKernelArg1p(kernel, 7, renderBufferNormals.clBuffer);
                CL10.clSetKernelArg1p(kernel, 8, uniformBufferCamera.clBuffer);
                CL10.clSetKernelArg1p(kernel, 9, this.tileHeightMap);
                CL10.clEnqueueNDRangeKernel(this.commandQueue, kernel, 1, null, stack.pointers((long)numModels * (long)threadCount), stack.pointers((long)threadCount), acquireEvent, computeEvents);
                computeEvents.position(computeEvents.position() + 1);
            }
            if (computeEvents.position() == 0) {
                CL10GL.clEnqueueReleaseGLObjects(this.commandQueue, glBuffers, null, null);
            } else {
                computeEvents.flip();
                CL10GL.clEnqueueReleaseGLObjects(this.commandQueue, glBuffers, computeEvents, null);
            }
        }
    }

    public void finish() {
        if (this.commandQueue != 0L) {
            CL10.clFinish(this.commandQueue);
        }
    }

    private static String getPlatformInfoStringUTF8(long cl_platform_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            OpenCLManager.checkCLError(CL10.clGetPlatformInfo(cl_platform_id, param_name, (ByteBuffer)null, pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            OpenCLManager.checkCLError(CL10.clGetPlatformInfo(cl_platform_id, param_name, buffer, null));
            String string = MemoryUtil.memUTF8(buffer, bytes - 1);
            return string;
        }
    }

    private static long getDeviceInfoLong(long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            LongBuffer pl = stack.mallocLong(1);
            OpenCLManager.checkCLError(CL10.clGetDeviceInfo(cl_device_id, param_name, pl, null));
            long l = pl.get(0);
            return l;
        }
    }

    private static int getDeviceInfoInt(long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pl = stack.mallocInt(1);
            OpenCLManager.checkCLError(CL10.clGetDeviceInfo(cl_device_id, param_name, pl, null));
            int n = pl.get(0);
            return n;
        }
    }

    private static long getDeviceInfoPointer(long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            OpenCLManager.checkCLError(CL10.clGetDeviceInfo(cl_device_id, param_name, pp, null));
            long l = pp.get(0);
            return l;
        }
    }

    private static String getDeviceInfoStringUTF8(long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            OpenCLManager.checkCLError(CL10.clGetDeviceInfo(cl_device_id, param_name, (ByteBuffer)null, pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            OpenCLManager.checkCLError(CL10.clGetDeviceInfo(cl_device_id, param_name, buffer, null));
            String string = MemoryUtil.memUTF8(buffer, bytes - 1);
            return string;
        }
    }

    private static int getProgramBuildInfoInt(long cl_program_id, long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pl = stack.mallocInt(1);
            OpenCLManager.checkCLError(CL10.clGetProgramBuildInfo(cl_program_id, cl_device_id, param_name, pl, null));
            int n = pl.get(0);
            return n;
        }
    }

    private static String getProgramBuildInfoStringASCII(long cl_program_id, long cl_device_id, int param_name) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            OpenCLManager.checkCLError(CL10.clGetProgramBuildInfo(cl_program_id, cl_device_id, param_name, (ByteBuffer)null, pp));
            int bytes = (int)pp.get(0);
            ByteBuffer buffer = stack.malloc(bytes);
            OpenCLManager.checkCLError(CL10.clGetProgramBuildInfo(cl_program_id, cl_device_id, param_name, buffer, null));
            String string = MemoryUtil.memASCII(buffer, bytes - 1);
            return string;
        }
    }

    private static void checkCLError(IntBuffer errcode) {
        OpenCLManager.checkCLError(errcode.get(errcode.position()));
    }

    private static void checkCLError(int errcode) {
        if (errcode != 0) {
            throw new RuntimeException(String.format("OpenCL error [%d]", errcode));
        }
    }

    public void recreateCLBuffer(GLBuffer glBuffer, long clFlags) {
        if (glBuffer.clBuffer != 0L) {
            CL10.clReleaseMemObject(glBuffer.clBuffer);
        }
        if (glBuffer.size == 0L) {
            glBuffer.clBuffer = 0L;
        } else {
            assert (glBuffer.size > 0L) : "Size <= 0 should not reach this point";
            glBuffer.clBuffer = CL10GL.clCreateFromGLBuffer(this.context, clFlags, glBuffer.glBufferId, (IntBuffer)null);
        }
    }

    static {
        Configuration.OPENCL_EXPLICIT_INIT.set(true);
    }
}

