/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd.data.materials;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.scene.GroundMaterialManager;
import net.runelite.client.plugins.rs117.hd.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroundMaterial {
    private static final Logger log = LoggerFactory.getLogger(GroundMaterial.class);
    public static final GroundMaterial NONE = new GroundMaterial("NONE", Material.NONE);
    public static final GroundMaterial DIRT = new GroundMaterial("DIRT", Material.DIRT_1, Material.DIRT_2);
    public static final GroundMaterial UNDERWATER_GENERIC = new GroundMaterial("UNDERWATER_GENERIC", Material.DIRT_1, Material.DIRT_2);
    public String name;
    public Material[] materials;

    public GroundMaterial(String name, Material ... materials) {
        this.name = name;
        this.materials = materials;
    }

    public Material getRandomMaterial(int ... worldPos) {
        long hash = 0L;
        for (int coord : worldPos) {
            hash = hash * 31L + (long)coord;
        }
        long seed = (hash ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;
        seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        int r = (int)(seed >>> 17);
        return this.materials[r % this.materials.length];
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public Material[] getMaterials() {
        return this.materials;
    }

    public static class JsonAdapter
    extends TypeAdapter<GroundMaterial> {
        private static final Logger log = LoggerFactory.getLogger(JsonAdapter.class);

        @Override
        public GroundMaterial read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            if (in.peek() == JsonToken.STRING) {
                String name = in.nextString();
                for (GroundMaterial groundMaterial : GroundMaterialManager.GROUND_MATERIALS) {
                    if (!name.equals(groundMaterial.name)) continue;
                    return groundMaterial;
                }
                log.warn("No ground material exists with the name '{}' at {}", name, GsonUtils.location(in), new Throwable());
            } else {
                log.warn("Unexpected type {} at {}", new Object[]{in.peek(), GsonUtils.location(in), new Throwable()});
            }
            return null;
        }

        @Override
        public void write(JsonWriter out, GroundMaterial groundMaterial) throws IOException {
            if (groundMaterial == null) {
                out.nullValue();
            } else {
                out.value(groundMaterial.name);
            }
        }
    }
}

