/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.rs117.hd;

import com.google.gson.Gson;
import com.google.inject.Provides;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.Actor;
import net.runelite.api.BufferProvider;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.IntProjection;
import net.runelite.api.Model;
import net.runelite.api.Projection;
import net.runelite.api.Renderable;
import net.runelite.api.Scene;
import net.runelite.api.SceneTileModel;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.Texture;
import net.runelite.api.TextureProvider;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.hooks.DrawCallbacks;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDependency;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.PluginInstantiationException;
import net.runelite.client.plugins.PluginManager;
import net.runelite.client.plugins.entityhider.EntityHiderPlugin;
import net.runelite.client.plugins.rs117.hd.HdPluginConfig;
import net.runelite.client.plugins.rs117.hd.config.AntiAliasingMode;
import net.runelite.client.plugins.rs117.hd.config.ColorFilter;
import net.runelite.client.plugins.rs117.hd.config.SeasonalHemisphere;
import net.runelite.client.plugins.rs117.hd.config.SeasonalTheme;
import net.runelite.client.plugins.rs117.hd.config.ShadingMode;
import net.runelite.client.plugins.rs117.hd.config.ShadowMode;
import net.runelite.client.plugins.rs117.hd.config.UIScalingMode;
import net.runelite.client.plugins.rs117.hd.config.VanillaShadowMode;
import net.runelite.client.plugins.rs117.hd.data.WaterType;
import net.runelite.client.plugins.rs117.hd.data.materials.Material;
import net.runelite.client.plugins.rs117.hd.model.ModelHasher;
import net.runelite.client.plugins.rs117.hd.model.ModelOffsets;
import net.runelite.client.plugins.rs117.hd.model.ModelPusher;
import net.runelite.client.plugins.rs117.hd.opengl.compute.ComputeMode;
import net.runelite.client.plugins.rs117.hd.opengl.compute.OpenCLManager;
import net.runelite.client.plugins.rs117.hd.opengl.shader.Shader;
import net.runelite.client.plugins.rs117.hd.opengl.shader.ShaderException;
import net.runelite.client.plugins.rs117.hd.opengl.shader.Template;
import net.runelite.client.plugins.rs117.hd.overlays.FrameTimer;
import net.runelite.client.plugins.rs117.hd.overlays.Timer;
import net.runelite.client.plugins.rs117.hd.scene.AreaManager;
import net.runelite.client.plugins.rs117.hd.scene.EnvironmentManager;
import net.runelite.client.plugins.rs117.hd.scene.FishingSpotReplacer;
import net.runelite.client.plugins.rs117.hd.scene.GroundMaterialManager;
import net.runelite.client.plugins.rs117.hd.scene.LightManager;
import net.runelite.client.plugins.rs117.hd.scene.ModelOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.ProceduralGenerator;
import net.runelite.client.plugins.rs117.hd.scene.SceneContext;
import net.runelite.client.plugins.rs117.hd.scene.SceneUploader;
import net.runelite.client.plugins.rs117.hd.scene.TextureManager;
import net.runelite.client.plugins.rs117.hd.scene.TileOverrideManager;
import net.runelite.client.plugins.rs117.hd.scene.areas.Area;
import net.runelite.client.plugins.rs117.hd.scene.lights.Light;
import net.runelite.client.plugins.rs117.hd.scene.model_overrides.ModelOverride;
import net.runelite.client.plugins.rs117.hd.utils.ColorUtils;
import net.runelite.client.plugins.rs117.hd.utils.DeveloperTools;
import net.runelite.client.plugins.rs117.hd.utils.FileWatcher;
import net.runelite.client.plugins.rs117.hd.utils.HDUtils;
import net.runelite.client.plugins.rs117.hd.utils.Mat4;
import net.runelite.client.plugins.rs117.hd.utils.ModelHash;
import net.runelite.client.plugins.rs117.hd.utils.PopupUtils;
import net.runelite.client.plugins.rs117.hd.utils.Props;
import net.runelite.client.plugins.rs117.hd.utils.ResourcePath;
import net.runelite.client.plugins.rs117.hd.utils.buffer.GLBuffer;
import net.runelite.client.plugins.rs117.hd.utils.buffer.GpuIntBuffer;
import net.runelite.client.ui.ClientUI;
import net.runelite.client.ui.DrawManager;
import net.runelite.client.util.LinkBrowser;
import net.runelite.client.util.OSType;
import net.runelite.rlawt.AWTContext;
import org.lwjgl.BufferUtils;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43C;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.system.Callback;
import org.lwjgl.system.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="117 HD", description="GPU renderer with a suite of graphical enhancements", tags={"hd", "high", "detail", "graphics", "shaders", "textures", "gpu", "shadows", "lights"}, conflicts={"GPU"})
@PluginDependency(value=EntityHiderPlugin.class)
public class HdPlugin
extends Plugin
implements DrawCallbacks {
    private static final Logger log = LoggerFactory.getLogger(HdPlugin.class);
    public static final String DISCORD_URL = "https://discord.gg/GfEm5vU2cF";
    public static final String RUNELITE_URL = "https://runelite.net";
    public static final String AMD_DRIVER_URL = "https://www.amd.com/en/support";
    public static final String INTEL_DRIVER_URL = "https://www.intel.com/content/www/us/en/support/detect.html";
    public static final String NVIDIA_DRIVER_URL = "https://www.nvidia.com/en-us/geforce/drivers/";
    public static final int TEXTURE_UNIT_BASE = 33984;
    public static final int TEXTURE_UNIT_UI = 33984;
    public static final int TEXTURE_UNIT_GAME = 33985;
    public static final int TEXTURE_UNIT_SHADOW_MAP = 33986;
    public static final int TEXTURE_UNIT_TILE_HEIGHT_MAP = 33987;
    public static final int UNIFORM_BLOCK_CAMERA = 0;
    public static final int UNIFORM_BLOCK_MATERIALS = 1;
    public static final int UNIFORM_BLOCK_WATER_TYPES = 2;
    public static final int UNIFORM_BLOCK_LIGHTS = 3;
    public static final float NEAR_PLANE = 50.0f;
    public static final int MAX_FACE_COUNT = 12144;
    public static final int MAX_DISTANCE = 184;
    public static final int GROUND_MIN_Y = 350;
    public static final int MAX_FOG_DEPTH = 100;
    public static final int SCALAR_BYTES = 4;
    public static final int VERTEX_SIZE = 4;
    public static final int UV_SIZE = 4;
    public static final int NORMAL_SIZE = 4;
    public static final float ORTHOGRAPHIC_ZOOM = 2.0E-4f;
    public static float BUFFER_GROWTH_MULTIPLIER = 2.0f;
    private static final float COLOR_FILTER_FADE_DURATION = 3000.0f;
    private static final int[] eightIntWrite = new int[8];
    private static final int[] RENDERBUFFER_FORMATS_SRGB = new int[]{35905, 35907};
    private static final int[] RENDERBUFFER_FORMATS_SRGB_WITH_ALPHA = new int[]{35907};
    private static final int[] RENDERBUFFER_FORMATS_LINEAR = new int[]{32849, 32856, 6407, 6408};
    private static final int[] RENDERBUFFER_FORMATS_LINEAR_WITH_ALPHA = new int[]{32856, 6408};
    @Inject
    private Client client;
    @Inject
    private ClientUI clientUI;
    @Inject
    private ClientThread clientThread;
    @Inject
    private DrawManager drawManager;
    @Inject
    private PluginManager pluginManager;
    @Inject
    private OpenCLManager openCLManager;
    @Inject
    private TextureManager textureManager;
    @Inject
    private AreaManager areaManager;
    @Inject
    private LightManager lightManager;
    @Inject
    private EnvironmentManager environmentManager;
    @Inject
    private GroundMaterialManager groundMaterialManager;
    @Inject
    private TileOverrideManager tileOverrideManager;
    @Inject
    private ModelOverrideManager modelOverrideManager;
    @Inject
    private ProceduralGenerator proceduralGenerator;
    @Inject
    private SceneUploader sceneUploader;
    @Inject
    private ModelPusher modelPusher;
    @Inject
    private ModelHasher modelHasher;
    @Inject
    private FishingSpotReplacer fishingSpotReplacer;
    @Inject
    private DeveloperTools developerTools;
    @Inject
    private FrameTimer frameTimer;
    @Inject
    public HdPluginConfig config;
    private Gson gson;
    public GLCapabilities glCaps;
    private Canvas canvas;
    private AWTContext awtContext;
    private Callback debugCallback;
    private ComputeMode computeMode = ComputeMode.OPENGL;
    private static final String LINUX_VERSION_HEADER = "#version 420\n#extension GL_ARB_compute_shader : require\n#extension GL_ARB_shader_storage_buffer_object : require\n#extension GL_ARB_explicit_attrib_location : require\n";
    private static final String WINDOWS_VERSION_HEADER = "#version 430\n";
    private static final Shader PROGRAM = new Shader().add(35633, "vert.glsl").add(36313, "geom.glsl").add(35632, "frag.glsl");
    private static final Shader SHADOW_PROGRAM_FAST = new Shader().add(35633, "shadow_vert.glsl").add(35632, "shadow_frag.glsl");
    private static final Shader SHADOW_PROGRAM_DETAILED = new Shader().add(35633, "shadow_vert.glsl").add(36313, "shadow_geom.glsl").add(35632, "shadow_frag.glsl");
    private static final Shader COMPUTE_PROGRAM = new Shader().add(37305, "comp.glsl");
    private static final Shader UNORDERED_COMPUTE_PROGRAM = new Shader().add(37305, "comp_unordered.glsl");
    private static final Shader UI_PROGRAM = new Shader().add(35633, "vertui.glsl").add(35632, "fragui.glsl");
    private static final ResourcePath SHADER_PATH = Props.getPathOrDefault("rlhd.shader-path", () -> ResourcePath.path(HdPlugin.class, new String[0])).chroot();
    public int glSceneProgram;
    public int glUiProgram;
    public int glShadowProgram;
    public int glModelPassthroughComputeProgram;
    public int[] glModelSortingComputePrograms = new int[0];
    private int interfaceTexture;
    private int interfacePbo;
    private int vaoUiHandle;
    private int vboUiHandle;
    private int vaoSceneHandle;
    private int fboSceneHandle;
    private int rboSceneColorHandle;
    private int rboSceneDepthHandle;
    private int shadowMapResolution;
    private int fboShadowMap;
    private int texShadowMap;
    private int texTileHeightMap;
    private final GLBuffer hStagingBufferVertices = new GLBuffer();
    private final GLBuffer hStagingBufferUvs = new GLBuffer();
    private final GLBuffer hStagingBufferNormals = new GLBuffer();
    private final GLBuffer hRenderBufferVertices = new GLBuffer();
    private final GLBuffer hRenderBufferUvs = new GLBuffer();
    private final GLBuffer hRenderBufferNormals = new GLBuffer();
    private int numPassthroughModels;
    private GpuIntBuffer modelPassthroughBuffer;
    private final GLBuffer hModelPassthroughBuffer = new GLBuffer();
    public int numSortingBins;
    public int maxComputeThreadCount;
    public int[] modelSortingBinFaceCounts;
    public int[] modelSortingBinThreadCounts;
    private int[] numModelsToSort;
    private GpuIntBuffer[] modelSortingBuffers;
    private GLBuffer[] hModelSortingBuffers;
    private final GLBuffer hUniformBufferCamera = new GLBuffer();
    private final GLBuffer hUniformBufferMaterials = new GLBuffer();
    private final GLBuffer hUniformBufferWaterTypes = new GLBuffer();
    private final GLBuffer hUniformBufferLights = new GLBuffer();
    private ByteBuffer uniformBufferCamera;
    private ByteBuffer uniformBufferLights;
    @Nullable
    private SceneContext sceneContext;
    private SceneContext nextSceneContext;
    private int dynamicOffsetVertices;
    private int dynamicOffsetUvs;
    private int renderBufferOffset;
    private int lastCanvasWidth;
    private int lastCanvasHeight;
    private int lastStretchedCanvasWidth;
    private int lastStretchedCanvasHeight;
    private AntiAliasingMode lastAntiAliasingMode;
    private int numSamples;
    private int viewportOffsetX;
    private int viewportOffsetY;
    private int viewportWidth;
    private int viewportHeight;
    private int uniColorBlindnessIntensity;
    private int uniUiColorBlindnessIntensity;
    private int uniUseFog;
    private int uniFogColor;
    private int uniFogDepth;
    private int uniDrawDistance;
    private int uniExpandedMapLoadingChunks;
    private int uniWaterColorLight;
    private int uniWaterColorMid;
    private int uniWaterColorDark;
    private int uniAmbientStrength;
    private int uniAmbientColor;
    private int uniLightStrength;
    private int uniLightColor;
    private int uniUnderglowStrength;
    private int uniUnderglowColor;
    private int uniGroundFogStart;
    private int uniGroundFogEnd;
    private int uniGroundFogOpacity;
    private int uniLightningBrightness;
    private int uniSaturation;
    private int uniContrast;
    private int uniLightDir;
    private int uniShadowMaxBias;
    private int uniShadowsEnabled;
    private int uniUnderwaterEnvironment;
    private int uniUnderwaterCaustics;
    private int uniUnderwaterCausticsColor;
    private int uniUnderwaterCausticsStrength;
    private int uniCameraPos;
    private int uniColorFilter;
    private int uniColorFilterPrevious;
    private int uniColorFilterFade;
    private int uniShadowLightProjectionMatrix;
    private int uniShadowElapsedTime;
    private int uniShadowCameraPos;
    private int uniPointLightsCount;
    private int uniProjectionMatrix;
    private int uniLightProjectionMatrix;
    private int uniShadowMap;
    private int uniUiTexture;
    private int uniTexSourceDimensions;
    private int uniTexTargetDimensions;
    private int uniUiAlphaOverlay;
    private int uniTextureArray;
    private int uniElapsedTime;
    private int uniBlockMaterials;
    private int uniBlockWaterTypes;
    private int uniBlockPointLights;
    public boolean configGroundTextures;
    public boolean configGroundBlending;
    public boolean configModelTextures;
    public boolean configTzhaarHD;
    public boolean configProjectileLights;
    public boolean configNpcLights;
    public boolean configHideFakeShadows;
    public boolean configLegacyGreyColors;
    public boolean configModelBatching;
    public boolean configModelCaching;
    public boolean configShadowsEnabled;
    public boolean configExpandShadowDraw;
    public boolean configUseFasterModelHashing;
    public boolean configUndoVanillaShading;
    public boolean configPreserveVanillaNormals;
    public int configMaxDynamicLights;
    public ShadowMode configShadowMode;
    public SeasonalTheme configSeasonalTheme;
    public SeasonalHemisphere configSeasonalHemisphere;
    public VanillaShadowMode configVanillaShadowMode;
    public ColorFilter configColorFilter = ColorFilter.NONE;
    public ColorFilter configColorFilterPrevious;
    public boolean useLowMemoryMode;
    public boolean enableDetailedTimers;
    public boolean enableShadowMapOverlay;
    public boolean enableFreezeFrame;
    public boolean orthographicProjection;
    private boolean isActive;
    private boolean lwjglInitialized;
    private boolean hasLoggedIn;
    private boolean redrawPreviousFrame;
    private boolean isInChambersOfXeric;
    private boolean isInHouse;
    private Scene skipScene;
    private int previousPlane;
    private final ConcurrentHashMap.KeySetView<String, ?> pendingConfigChanges = ConcurrentHashMap.newKeySet();
    private final Map<Long, ModelOffsets> frameModelInfoMap = new HashMap<Long, ModelOffsets>();
    public final float[] cameraPosition = new float[3];
    public final float[] cameraOrientation = new float[2];
    public final int[] cameraFocalPoint = new int[2];
    public final int[] cameraShift = new int[2];
    public double elapsedTime;
    public double elapsedClientTime;
    public float deltaTime;
    public float deltaClientTime;
    private long lastFrameTimeMillis;
    private double lastFrameClientTime;
    private int gameTicksUntilSceneReload = 0;
    private long colorFilterChangedAt;

    @Provides
    HdPluginConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(HdPluginConfig.class);
    }

    @Override
    protected void startUp() {
        this.gson = this.injector.getInstance(Gson.class).newBuilder().setLenient().create();
        this.clientThread.invoke(() -> {
            try {
                int maxComputeThreadCount;
                boolean isUnsupportedGpu;
                boolean isFallbackGpu;
                if (!this.textureManager.vanillaTexturesAvailable()) {
                    return false;
                }
                this.renderBufferOffset = 0;
                this.rboSceneDepthHandle = 0;
                this.rboSceneColorHandle = 0;
                this.fboSceneHandle = 0;
                this.fboShadowMap = 0;
                this.numPassthroughModels = 0;
                this.numModelsToSort = null;
                this.elapsedTime = 0.0;
                this.elapsedClientTime = 0.0;
                this.deltaTime = 0.0f;
                this.deltaClientTime = 0.0f;
                this.lastFrameTimeMillis = 0L;
                this.lastFrameClientTime = 0.0;
                AWTContext.loadNatives();
                this.canvas = this.client.getCanvas();
                Object object = this.canvas.getTreeLock();
                synchronized (object) {
                    if (!this.canvas.isValid()) {
                        return false;
                    }
                    this.awtContext = new AWTContext(this.canvas);
                    this.awtContext.configurePixelFormat(0, 0, 0);
                }
                this.awtContext.createGLContext();
                this.canvas.setIgnoreRepaint(true);
                Configuration.SHARED_LIBRARY_EXTRACT_DIRECTORY.set("lwjgl-rl");
                this.glCaps = GL.createCapabilities();
                this.useLowMemoryMode = this.config.lowMemoryMode();
                BUFFER_GROWTH_MULTIPLIER = this.useLowMemoryMode ? 1.333f : 2.0f;
                String glRenderer = GL43C.glGetString(7937);
                String arch = System.getProperty("sun.arch.data.model", "Unknown");
                if (glRenderer == null) {
                    glRenderer = "Unknown";
                }
                log.info("Using device: {}", (Object)glRenderer);
                log.info("Using driver: {}", (Object)GL43C.glGetString(7938));
                log.info("Client is {}-bit", (Object)arch);
                log.info("Low memory mode: {}", (Object)this.useLowMemoryMode);
                this.computeMode = OSType.getOSType() == OSType.MacOS ? ComputeMode.OPENCL : ComputeMode.OPENGL;
                List<String> fallbackDevices = List.of("GDI Generic", "D3D12 (Microsoft Basic Render Driver)", "softpipe");
                boolean bl = isFallbackGpu = fallbackDevices.contains(glRenderer) && !Props.has("rlhd.allowFallbackGpu");
                boolean bl2 = isFallbackGpu || (this.computeMode == ComputeMode.OPENGL ? !this.glCaps.OpenGL43 : !this.glCaps.OpenGL31) ? true : (isUnsupportedGpu = false);
                if (isUnsupportedGpu) {
                    log.error("The GPU is lacking OpenGL {} support. Stopping the plugin...", (Object)(this.computeMode == ComputeMode.OPENGL ? "4.3" : "3.1"));
                    this.displayUnsupportedGpuMessage(isFallbackGpu, glRenderer);
                    this.stopPlugin();
                    return true;
                }
                this.lwjglInitialized = true;
                this.checkGLErrors();
                if (log.isDebugEnabled() && this.glCaps.glDebugMessageControl != 0L) {
                    this.debugCallback = GLUtil.setupDebugMessageCallback();
                    if (this.debugCallback != null) {
                        GL43C.glDebugMessageControl(33350, 33361, 4352, 131185, false);
                        GL43C.glDebugMessageControl(33350, 33360, 4352, 131154, false);
                    }
                }
                this.updateCachedConfigs();
                this.developerTools.activate();
                this.modelPassthroughBuffer = new GpuIntBuffer();
                if (this.computeMode == ComputeMode.OPENCL) {
                    this.openCLManager.startUp(this.awtContext);
                    maxComputeThreadCount = this.openCLManager.getMaxWorkGroupSize();
                } else {
                    maxComputeThreadCount = GL43C.glGetInteger(37099);
                }
                this.initModelSortingBins(maxComputeThreadCount);
                this.setupSyncMode();
                this.initVaos();
                this.initBuffers();
                this.textureManager.startUp();
                this.initPrograms();
                this.initShaderHotswapping();
                this.initInterfaceTexture();
                this.initShadowMapFbo();
                this.checkGLErrors();
                this.client.setDrawCallbacks(this);
                this.client.setGpuFlags(7 | (this.config.removeVertexSnapping() ? 8 : 0));
                this.client.setExpandedMapLoading(this.getExpandedMapLoadingChunks());
                this.client.resizeCanvas();
                this.lastCanvasHeight = 0;
                this.lastCanvasWidth = 0;
                this.lastStretchedCanvasHeight = 0;
                this.lastStretchedCanvasWidth = 0;
                this.lastAntiAliasingMode = null;
                this.areaManager.startUp();
                this.groundMaterialManager.startUp();
                this.tileOverrideManager.startUp();
                this.modelOverrideManager.startUp();
                this.modelPusher.startUp();
                this.lightManager.startUp();
                this.environmentManager.startUp();
                this.fishingSpotReplacer.startUp();
                this.isActive = true;
                this.hasLoggedIn = this.client.getGameState().getState() > GameState.LOGGING_IN.getState();
                this.redrawPreviousFrame = false;
                this.skipScene = null;
                this.isInHouse = false;
                this.isInChambersOfXeric = false;
                if (this.client.getGameState() == GameState.LOGGED_IN) {
                    this.client.setGameState(GameState.LOADING);
                }
                this.checkGLErrors();
                this.clientThread.invokeLater(this::displayUpdateMessage);
            }
            catch (Throwable err) {
                log.error("Error while starting 117HD", err);
                this.stopPlugin();
            }
            return true;
        });
    }

    @Override
    protected void shutDown() {
        this.isActive = false;
        FileWatcher.destroy();
        this.clientThread.invoke(() -> {
            Scene scene = this.client.getScene();
            if (scene != null) {
                scene.setMinLevel(0);
            }
            this.client.setGpuFlags(0);
            this.client.setDrawCallbacks(null);
            this.client.setUnlockedFps(false);
            this.client.setExpandedMapLoading(0);
            this.developerTools.deactivate();
            this.modelPusher.shutDown();
            this.tileOverrideManager.shutDown();
            this.groundMaterialManager.shutDown();
            this.modelOverrideManager.shutDown();
            this.lightManager.shutDown();
            this.environmentManager.shutDown();
            this.fishingSpotReplacer.shutDown();
            this.areaManager.shutDown();
            if (this.lwjglInitialized) {
                this.lwjglInitialized = false;
                this.waitUntilIdle();
                this.textureManager.shutDown();
                this.destroyBuffers();
                this.destroyInterfaceTexture();
                this.destroyPrograms();
                this.destroyVaos();
                this.destroySceneFbo();
                this.destroyShadowMapFbo();
                this.destroyTileHeightMap();
                this.destroyModelSortingBins();
                this.openCLManager.shutDown();
            }
            if (this.awtContext != null) {
                this.awtContext.destroy();
            }
            this.awtContext = null;
            if (this.debugCallback != null) {
                this.debugCallback.free();
            }
            this.debugCallback = null;
            if (this.sceneContext != null) {
                this.sceneContext.destroy();
            }
            this.sceneContext = null;
            HdPlugin hdPlugin = this;
            synchronized (hdPlugin) {
                if (this.nextSceneContext != null) {
                    this.nextSceneContext.destroy();
                }
                this.nextSceneContext = null;
            }
            if (this.modelPassthroughBuffer != null) {
                this.modelPassthroughBuffer.destroy();
            }
            this.modelPassthroughBuffer = null;
            this.client.resizeCanvas();
            if (this.client.getGameState() == GameState.LOGGED_IN) {
                this.client.setGameState(GameState.LOADING);
            }
        });
    }

    public void stopPlugin() {
        SwingUtilities.invokeLater(() -> {
            try {
                this.pluginManager.setPluginEnabled(this, false);
                this.pluginManager.stopPlugin(this);
            }
            catch (PluginInstantiationException ex) {
                log.error("Error while stopping 117HD:", ex);
            }
        });
        this.shutDown();
    }

    public void restartPlugin() {
        SwingUtilities.invokeLater(() -> this.clientThread.invokeLater(() -> {
            this.shutDown();
            this.clientThread.invokeLater(this::startUp);
        }));
    }

    public void toggleFreezeFrame() {
        this.clientThread.invoke(() -> {
            boolean bl = this.enableFreezeFrame = !this.enableFreezeFrame;
            if (this.enableFreezeFrame) {
                this.redrawPreviousFrame = true;
            }
        });
    }

    private String generateFetchCases(String array, int from, int to) {
        int length = to - from;
        if (length <= 1) {
            return array + "[" + from + "]";
        }
        int middle = from + length / 2;
        return "i < " + middle + " ? " + this.generateFetchCases(array, from, middle) + " : " + this.generateFetchCases(array, middle, to);
    }

    private String generateGetter(String type, int arrayLength) {
        boolean isAppleM1;
        StringBuilder include = new StringBuilder();
        boolean bl = isAppleM1 = OSType.getOSType() == OSType.MacOS && System.getProperty("os.arch").equals("aarch64");
        if (this.config.macosIntelWorkaround() && !isAppleM1) {
            include.append(type).append(" ").append("get").append(type).append("(int i) { return ").append(this.generateFetchCases(type + "Array", 0, arrayLength)).append("; }\n");
        } else {
            include.append("#define get").append(type).append("(i) ").append(type).append("Array[i]\n");
        }
        return include.toString();
    }

    private void initPrograms() throws ShaderException, IOException {
        String versionHeader = OSType.getOSType() == OSType.Linux ? LINUX_VERSION_HEADER : WINDOWS_VERSION_HEADER;
        Template template = new Template().addInclude("VERSION_HEADER", versionHeader).define("UI_SCALING_MODE", this.config.uiScalingMode().getMode()).define("COLOR_BLINDNESS", this.config.colorBlindness()).define("APPLY_COLOR_FILTER", this.configColorFilter != ColorFilter.NONE).define("MATERIAL_CONSTANTS", () -> {
            StringBuilder include = new StringBuilder();
            for (Material m : Material.values()) {
                include.append("#define MAT_").append(m.name().toUpperCase()).append(" getMaterial(").append(this.textureManager.getMaterialIndex(m, m.vanillaTextureIndex)).append(")\n");
            }
            return include.toString();
        }).define("MATERIAL_COUNT", Material.values().length).define("MATERIAL_GETTER", () -> this.generateGetter("Material", Material.values().length)).define("WATER_TYPE_COUNT", WaterType.values().length).define("WATER_TYPE_GETTER", () -> this.generateGetter("WaterType", WaterType.values().length)).define("LIGHT_COUNT", Math.max(1, this.configMaxDynamicLights)).define("LIGHT_GETTER", () -> this.generateGetter("PointLight", this.configMaxDynamicLights)).define("NORMAL_MAPPING", this.config.normalMapping()).define("PARALLAX_OCCLUSION_MAPPING", this.config.parallaxOcclusionMapping()).define("SHADOW_MODE", this.configShadowMode).define("SHADOW_TRANSPARENCY", this.config.enableShadowTransparency()).define("VANILLA_COLOR_BANDING", this.config.vanillaColorBanding()).define("UNDO_VANILLA_SHADING", this.configUndoVanillaShading).define("LEGACY_GREY_COLORS", this.configLegacyGreyColors).define("DISABLE_DIRECTIONAL_SHADING", this.config.shadingMode() != ShadingMode.DEFAULT).define("FLAT_SHADING", this.config.flatShading()).define("SHADOW_MAP_OVERLAY", this.enableShadowMapOverlay).define("WIREFRAME", this.config.wireframe()).addIncludePath(SHADER_PATH);
        this.glSceneProgram = PROGRAM.compile(template);
        this.glUiProgram = UI_PROGRAM.compile(template);
        switch (this.configShadowMode) {
            case FAST: {
                this.glShadowProgram = SHADOW_PROGRAM_FAST.compile(template);
                break;
            }
            case DETAILED: {
                this.glShadowProgram = SHADOW_PROGRAM_DETAILED.compile(template);
            }
        }
        if (this.computeMode == ComputeMode.OPENCL) {
            this.openCLManager.initPrograms();
        } else {
            this.glModelPassthroughComputeProgram = UNORDERED_COMPUTE_PROGRAM.compile(template);
            this.glModelSortingComputePrograms = new int[this.numSortingBins];
            for (int i = 0; i < this.numSortingBins; ++i) {
                int faceCount = this.modelSortingBinFaceCounts[i];
                int threadCount = this.modelSortingBinThreadCounts[i];
                int facesPerThread = (int)Math.ceil((float)faceCount / (float)threadCount);
                this.glModelSortingComputePrograms[i] = COMPUTE_PROGRAM.compile(template.copy().define("THREAD_COUNT", threadCount).define("FACES_PER_THREAD", facesPerThread));
            }
        }
        this.initUniforms();
        GL43C.glUseProgram(this.glSceneProgram);
        GL43C.glUniform1i(this.uniTextureArray, 1);
        GL43C.glUniform1i(this.uniShadowMap, 2);
        GL43C.glBindVertexArray(this.vaoSceneHandle);
        GL43C.glValidateProgram(this.glSceneProgram);
        if (GL43C.glGetProgrami(this.glSceneProgram, 35715) == 0) {
            String err = GL43C.glGetProgramInfoLog(this.glSceneProgram);
            throw new ShaderException(err);
        }
        GL43C.glUseProgram(this.glUiProgram);
        GL43C.glUniform1i(this.uniUiTexture, 0);
        GL43C.glUseProgram(0);
    }

    private void initUniforms() {
        this.uniProjectionMatrix = GL43C.glGetUniformLocation(this.glSceneProgram, "projectionMatrix");
        this.uniLightProjectionMatrix = GL43C.glGetUniformLocation(this.glSceneProgram, "lightProjectionMatrix");
        this.uniShadowMap = GL43C.glGetUniformLocation(this.glSceneProgram, "shadowMap");
        this.uniSaturation = GL43C.glGetUniformLocation(this.glSceneProgram, "saturation");
        this.uniContrast = GL43C.glGetUniformLocation(this.glSceneProgram, "contrast");
        this.uniUseFog = GL43C.glGetUniformLocation(this.glSceneProgram, "useFog");
        this.uniFogColor = GL43C.glGetUniformLocation(this.glSceneProgram, "fogColor");
        this.uniFogDepth = GL43C.glGetUniformLocation(this.glSceneProgram, "fogDepth");
        this.uniWaterColorLight = GL43C.glGetUniformLocation(this.glSceneProgram, "waterColorLight");
        this.uniWaterColorMid = GL43C.glGetUniformLocation(this.glSceneProgram, "waterColorMid");
        this.uniWaterColorDark = GL43C.glGetUniformLocation(this.glSceneProgram, "waterColorDark");
        this.uniDrawDistance = GL43C.glGetUniformLocation(this.glSceneProgram, "drawDistance");
        this.uniExpandedMapLoadingChunks = GL43C.glGetUniformLocation(this.glSceneProgram, "expandedMapLoadingChunks");
        this.uniAmbientStrength = GL43C.glGetUniformLocation(this.glSceneProgram, "ambientStrength");
        this.uniAmbientColor = GL43C.glGetUniformLocation(this.glSceneProgram, "ambientColor");
        this.uniLightStrength = GL43C.glGetUniformLocation(this.glSceneProgram, "lightStrength");
        this.uniLightColor = GL43C.glGetUniformLocation(this.glSceneProgram, "lightColor");
        this.uniUnderglowStrength = GL43C.glGetUniformLocation(this.glSceneProgram, "underglowStrength");
        this.uniUnderglowColor = GL43C.glGetUniformLocation(this.glSceneProgram, "underglowColor");
        this.uniGroundFogStart = GL43C.glGetUniformLocation(this.glSceneProgram, "groundFogStart");
        this.uniGroundFogEnd = GL43C.glGetUniformLocation(this.glSceneProgram, "groundFogEnd");
        this.uniGroundFogOpacity = GL43C.glGetUniformLocation(this.glSceneProgram, "groundFogOpacity");
        this.uniLightningBrightness = GL43C.glGetUniformLocation(this.glSceneProgram, "lightningBrightness");
        this.uniPointLightsCount = GL43C.glGetUniformLocation(this.glSceneProgram, "pointLightsCount");
        this.uniColorBlindnessIntensity = GL43C.glGetUniformLocation(this.glSceneProgram, "colorBlindnessIntensity");
        this.uniLightDir = GL43C.glGetUniformLocation(this.glSceneProgram, "lightDir");
        this.uniShadowMaxBias = GL43C.glGetUniformLocation(this.glSceneProgram, "shadowMaxBias");
        this.uniShadowsEnabled = GL43C.glGetUniformLocation(this.glSceneProgram, "shadowsEnabled");
        this.uniUnderwaterEnvironment = GL43C.glGetUniformLocation(this.glSceneProgram, "underwaterEnvironment");
        this.uniUnderwaterCaustics = GL43C.glGetUniformLocation(this.glSceneProgram, "underwaterCaustics");
        this.uniUnderwaterCausticsColor = GL43C.glGetUniformLocation(this.glSceneProgram, "underwaterCausticsColor");
        this.uniUnderwaterCausticsStrength = GL43C.glGetUniformLocation(this.glSceneProgram, "underwaterCausticsStrength");
        this.uniCameraPos = GL43C.glGetUniformLocation(this.glSceneProgram, "cameraPos");
        this.uniTextureArray = GL43C.glGetUniformLocation(this.glSceneProgram, "textureArray");
        this.uniElapsedTime = GL43C.glGetUniformLocation(this.glSceneProgram, "elapsedTime");
        if (this.configColorFilter != ColorFilter.NONE) {
            this.uniColorFilter = GL43C.glGetUniformLocation(this.glSceneProgram, "colorFilter");
            this.uniColorFilterPrevious = GL43C.glGetUniformLocation(this.glSceneProgram, "colorFilterPrevious");
            this.uniColorFilterFade = GL43C.glGetUniformLocation(this.glSceneProgram, "colorFilterFade");
        }
        this.uniUiTexture = GL43C.glGetUniformLocation(this.glUiProgram, "uiTexture");
        this.uniTexTargetDimensions = GL43C.glGetUniformLocation(this.glUiProgram, "targetDimensions");
        this.uniTexSourceDimensions = GL43C.glGetUniformLocation(this.glUiProgram, "sourceDimensions");
        this.uniUiColorBlindnessIntensity = GL43C.glGetUniformLocation(this.glUiProgram, "colorBlindnessIntensity");
        this.uniUiAlphaOverlay = GL43C.glGetUniformLocation(this.glUiProgram, "alphaOverlay");
        this.uniBlockMaterials = GL43C.glGetUniformBlockIndex(this.glSceneProgram, "MaterialUniforms");
        this.uniBlockWaterTypes = GL43C.glGetUniformBlockIndex(this.glSceneProgram, "WaterTypeUniforms");
        this.uniBlockPointLights = GL43C.glGetUniformBlockIndex(this.glSceneProgram, "PointLightUniforms");
        if (this.computeMode == ComputeMode.OPENGL) {
            for (int sortingProgram : this.glModelSortingComputePrograms) {
                int uniBlockCamera = GL43C.glGetUniformBlockIndex(sortingProgram, "CameraUniforms");
                GL43C.glUniformBlockBinding(sortingProgram, uniBlockCamera, 0);
            }
        }
        switch (this.configShadowMode) {
            case DETAILED: {
                int uniShadowBlockMaterials = GL43C.glGetUniformBlockIndex(this.glShadowProgram, "MaterialUniforms");
                int uniShadowTextureArray = GL43C.glGetUniformLocation(this.glShadowProgram, "textureArray");
                GL43C.glUseProgram(this.glShadowProgram);
                GL43C.glUniform1i(uniShadowTextureArray, 1);
                GL43C.glUniformBlockBinding(this.glShadowProgram, uniShadowBlockMaterials, 1);
                this.uniShadowElapsedTime = GL43C.glGetUniformLocation(this.glShadowProgram, "elapsedTime");
                this.uniShadowCameraPos = GL43C.glGetUniformLocation(this.glShadowProgram, "cameraPos");
            }
            case FAST: {
                this.uniShadowLightProjectionMatrix = GL43C.glGetUniformLocation(this.glShadowProgram, "lightProjectionMatrix");
            }
        }
        this.initCameraUniformBuffer();
        this.initLightsUniformBuffer();
    }

    private void destroyPrograms() {
        if (this.glSceneProgram != 0) {
            GL43C.glDeleteProgram(this.glSceneProgram);
        }
        this.glSceneProgram = 0;
        if (this.glUiProgram != 0) {
            GL43C.glDeleteProgram(this.glUiProgram);
        }
        this.glUiProgram = 0;
        if (this.glShadowProgram != 0) {
            GL43C.glDeleteProgram(this.glShadowProgram);
        }
        this.glShadowProgram = 0;
        if (this.computeMode == ComputeMode.OPENGL) {
            if (this.glModelPassthroughComputeProgram != 0) {
                GL43C.glDeleteProgram(this.glModelPassthroughComputeProgram);
            }
            this.glModelPassthroughComputeProgram = 0;
            if (this.glModelSortingComputePrograms != null) {
                for (int program : this.glModelSortingComputePrograms) {
                    GL43C.glDeleteProgram(program);
                }
            }
            this.glModelSortingComputePrograms = null;
        } else {
            this.openCLManager.destroyPrograms();
        }
    }

    public void recompilePrograms() throws ShaderException, IOException {
        if (this.glSceneProgram == 0) {
            return;
        }
        this.destroyPrograms();
        this.initPrograms();
    }

    private void initModelSortingBins(int maxThreadCount) {
        int i;
        this.maxComputeThreadCount = maxThreadCount;
        int[] targetFaceCounts = new int[]{128, 512, 2048, 4096, 12144};
        int numBins = 0;
        int[] binFaceCounts = new int[targetFaceCounts.length];
        int[] binThreadCounts = new int[targetFaceCounts.length];
        int faceCount = 0;
        for (int targetFaceCount : targetFaceCounts) {
            int threadCount;
            if (faceCount >= targetFaceCount) continue;
            int facesPerThread = 1;
            while ((threadCount = (int)Math.ceil((float)targetFaceCount / (float)facesPerThread)) > maxThreadCount) {
                ++facesPerThread;
            }
            binFaceCounts[numBins] = faceCount = threadCount * facesPerThread;
            binThreadCounts[numBins] = threadCount;
            ++numBins;
        }
        this.numSortingBins = numBins;
        this.modelSortingBinFaceCounts = Arrays.copyOf(binFaceCounts, numBins);
        this.modelSortingBinThreadCounts = Arrays.copyOf(binThreadCounts, numBins);
        this.numModelsToSort = new int[numBins];
        this.modelSortingBuffers = new GpuIntBuffer[this.numSortingBins];
        for (i = 0; i < this.numSortingBins; ++i) {
            this.modelSortingBuffers[i] = new GpuIntBuffer();
        }
        this.hModelSortingBuffers = new GLBuffer[this.numSortingBins];
        for (i = 0; i < this.numSortingBins; ++i) {
            this.hModelSortingBuffers[i] = new GLBuffer();
            this.initGlBuffer(this.hModelSortingBuffers[i], 34962, 35040, 4);
        }
        log.debug("Spreading model sorting across {} bins: {}", (Object)numBins, (Object)this.modelSortingBinFaceCounts);
    }

    private void destroyModelSortingBins() {
        this.redrawPreviousFrame = false;
        this.numSortingBins = 0;
        this.modelSortingBinFaceCounts = null;
        this.modelSortingBinThreadCounts = null;
        this.numModelsToSort = null;
        if (this.modelSortingBuffers != null) {
            for (GpuIntBuffer gpuIntBuffer : this.modelSortingBuffers) {
                gpuIntBuffer.destroy();
            }
        }
        this.modelSortingBuffers = null;
        if (this.hModelSortingBuffers != null) {
            for (GLBuffer gLBuffer : this.hModelSortingBuffers) {
                this.destroyGlBuffer(gLBuffer);
            }
        }
        this.hModelSortingBuffers = null;
    }

    private void initVaos() {
        this.vaoSceneHandle = GL43C.glGenVertexArrays();
        this.vaoUiHandle = GL43C.glGenVertexArrays();
        this.vboUiHandle = GL43C.glGenBuffers();
        GL43C.glBindVertexArray(this.vaoUiHandle);
        FloatBuffer vboUiData = BufferUtils.createFloatBuffer(20).put(new float[]{1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, -1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f}).flip();
        GL43C.glBindBuffer(34962, this.vboUiHandle);
        GL43C.glBufferData(34962, vboUiData, 35044);
        GL43C.glVertexAttribPointer(0, 3, 5126, false, 20, 0L);
        GL43C.glEnableVertexAttribArray(0);
        GL43C.glVertexAttribPointer(1, 2, 5126, false, 20, 12L);
        GL43C.glEnableVertexAttribArray(1);
    }

    private void updateSceneVao(GLBuffer vertexBuffer, GLBuffer uvBuffer, GLBuffer normalBuffer) {
        GL43C.glBindVertexArray(this.vaoSceneHandle);
        GL43C.glEnableVertexAttribArray(0);
        GL43C.glBindBuffer(34962, vertexBuffer.glBufferId);
        GL43C.glVertexAttribPointer(0, 3, 5126, false, 16, 0L);
        GL43C.glEnableVertexAttribArray(1);
        GL43C.glBindBuffer(34962, vertexBuffer.glBufferId);
        GL43C.glVertexAttribIPointer(1, 1, 5124, 16, 12L);
        GL43C.glEnableVertexAttribArray(2);
        GL43C.glBindBuffer(34962, uvBuffer.glBufferId);
        GL43C.glVertexAttribPointer(2, 4, 5126, false, 0, 0L);
        GL43C.glEnableVertexAttribArray(3);
        GL43C.glBindBuffer(34962, normalBuffer.glBufferId);
        GL43C.glVertexAttribPointer(3, 4, 5126, false, 0, 0L);
    }

    private void destroyVaos() {
        if (this.vaoSceneHandle != 0) {
            GL43C.glDeleteVertexArrays(this.vaoSceneHandle);
        }
        this.vaoSceneHandle = 0;
        if (this.vboUiHandle != 0) {
            GL43C.glDeleteBuffers(this.vboUiHandle);
        }
        this.vboUiHandle = 0;
        if (this.vaoUiHandle != 0) {
            GL43C.glDeleteVertexArrays(this.vaoUiHandle);
        }
        this.vaoUiHandle = 0;
    }

    private void initBuffers() {
        this.initGlBuffer(this.hUniformBufferCamera, 35345, 35048, 4);
        this.initGlBuffer(this.hUniformBufferMaterials, 35345, 35044, 4);
        this.initGlBuffer(this.hUniformBufferWaterTypes, 35345, 35044, 4);
        this.initGlBuffer(this.hUniformBufferLights, 35345, 35040, 4);
        GL43C.glBindBufferBase(35345, 0, this.hUniformBufferCamera.glBufferId);
        GL43C.glBindBufferBase(35345, 1, this.hUniformBufferMaterials.glBufferId);
        GL43C.glBindBufferBase(35345, 2, this.hUniformBufferWaterTypes.glBufferId);
        GL43C.glBindBufferBase(35345, 3, this.hUniformBufferLights.glBufferId);
        this.initGlBuffer(this.hStagingBufferVertices, 34962, 35040, 4);
        this.initGlBuffer(this.hStagingBufferUvs, 34962, 35040, 4);
        this.initGlBuffer(this.hStagingBufferNormals, 34962, 35040, 4);
        this.initGlBuffer(this.hRenderBufferVertices, 34962, 35040, 2);
        this.initGlBuffer(this.hRenderBufferUvs, 34962, 35040, 2);
        this.initGlBuffer(this.hRenderBufferNormals, 34962, 35040, 2);
        this.initGlBuffer(this.hModelPassthroughBuffer, 34962, 35040, 4);
    }

    private void initGlBuffer(GLBuffer glBuffer, int target, int glUsage, int clUsage) {
        glBuffer.glBufferId = GL43C.glGenBuffers();
        this.updateBuffer(glBuffer, target, 1L, glUsage, (long)clUsage);
    }

    private void destroyBuffers() {
        this.destroyGlBuffer(this.hUniformBufferCamera);
        this.destroyGlBuffer(this.hUniformBufferMaterials);
        this.destroyGlBuffer(this.hUniformBufferWaterTypes);
        this.destroyGlBuffer(this.hUniformBufferLights);
        this.destroyGlBuffer(this.hStagingBufferVertices);
        this.destroyGlBuffer(this.hStagingBufferUvs);
        this.destroyGlBuffer(this.hStagingBufferNormals);
        this.destroyGlBuffer(this.hRenderBufferVertices);
        this.destroyGlBuffer(this.hRenderBufferUvs);
        this.destroyGlBuffer(this.hRenderBufferNormals);
        this.destroyGlBuffer(this.hModelPassthroughBuffer);
        this.uniformBufferCamera = null;
        this.uniformBufferLights = null;
    }

    private void destroyGlBuffer(GLBuffer glBuffer) {
        glBuffer.size = -1L;
        if (glBuffer.glBufferId != 0) {
            GL43C.glDeleteBuffers(glBuffer.glBufferId);
            glBuffer.glBufferId = 0;
        }
        if (glBuffer.clBuffer != 0L) {
            CL10.clReleaseMemObject(glBuffer.clBuffer);
            glBuffer.clBuffer = 0L;
        }
    }

    private void initInterfaceTexture() {
        this.interfacePbo = GL43C.glGenBuffers();
        this.interfaceTexture = GL43C.glGenTextures();
        GL43C.glBindTexture(3553, this.interfaceTexture);
        GL43C.glTexParameteri(3553, 10242, 33071);
        GL43C.glTexParameteri(3553, 10243, 33071);
        GL43C.glTexParameteri(3553, 10241, 9729);
        GL43C.glTexParameteri(3553, 10240, 9729);
        GL43C.glBindTexture(3553, 0);
    }

    private void destroyInterfaceTexture() {
        if (this.interfacePbo != 0) {
            GL43C.glDeleteBuffers(this.interfacePbo);
            this.interfacePbo = 0;
        }
        if (this.interfaceTexture != 0) {
            GL43C.glDeleteTextures(this.interfaceTexture);
            this.interfaceTexture = 0;
        }
    }

    private void initCameraUniformBuffer() {
        int size = 32;
        this.uniformBufferCamera = BufferUtils.createByteBuffer(size);
        this.updateBuffer(this.hUniformBufferCamera, 35345, size, 35048, 4L);
        GL43C.glBindBuffer(35345, 0);
    }

    public void updateMaterialUniformBuffer(ByteBuffer buffer) {
        this.updateBuffer(this.hUniformBufferMaterials, 35345, buffer, 35044, 4L);
    }

    public void updateWaterTypeUniformBuffer(ByteBuffer buffer) {
        this.updateBuffer(this.hUniformBufferWaterTypes, 35345, buffer, 35044, 4L);
    }

    private void initLightsUniformBuffer() {
        this.uniformBufferLights = BufferUtils.createByteBuffer(Math.max(1, this.configMaxDynamicLights) * 8 * 4);
        this.updateBuffer(this.hUniformBufferLights, 35345, this.uniformBufferLights, 35040, 4L);
    }

    private void initSceneFbo(int width, int height, AntiAliasingMode antiAliasingMode) {
        boolean alpha;
        int defaultFramebuffer = this.awtContext.getFramebuffer(false);
        GL43C.glBindFramebuffer(36160, defaultFramebuffer);
        int forcedAASamples = GL43C.glGetInteger(32937);
        int maxSamples = GL43C.glGetInteger(36183);
        this.numSamples = forcedAASamples != 0 ? forcedAASamples : Math.min(antiAliasingMode.getSamples(), maxSamples);
        boolean sRGB = false;
        int defaultColorAttachment = defaultFramebuffer == 0 ? 1026 : 36064;
        int alphaBits = GL43C.glGetFramebufferAttachmentParameteri(36160, defaultColorAttachment, 33301);
        this.checkGLErrors();
        boolean bl = alpha = alphaBits > 0;
        int[] desiredFormats = sRGB ? (alpha ? RENDERBUFFER_FORMATS_SRGB_WITH_ALPHA : RENDERBUFFER_FORMATS_SRGB) : (alpha ? RENDERBUFFER_FORMATS_LINEAR_WITH_ALPHA : RENDERBUFFER_FORMATS_LINEAR);
        int[] resolution = this.applyDpiScaling(width, height);
        this.fboSceneHandle = GL43C.glGenFramebuffers();
        GL43C.glBindFramebuffer(36160, this.fboSceneHandle);
        this.rboSceneColorHandle = GL43C.glGenRenderbuffers();
        GL43C.glBindRenderbuffer(36161, this.rboSceneColorHandle);
        this.clearGLErrors();
        for (int format : desiredFormats) {
            GL43C.glRenderbufferStorageMultisample(36161, this.numSamples, format, resolution[0], resolution[1]);
            if (GL43C.glGetError() != 0) continue;
            GL43C.glFramebufferRenderbuffer(36160, 36064, 36161, this.rboSceneColorHandle);
            this.checkGLErrors();
            this.rboSceneDepthHandle = GL43C.glGenRenderbuffers();
            GL43C.glBindRenderbuffer(36161, this.rboSceneDepthHandle);
            GL43C.glRenderbufferStorageMultisample(36161, this.numSamples, 35056, resolution[0], resolution[1]);
            GL43C.glFramebufferRenderbuffer(36160, 36096, 36161, this.rboSceneDepthHandle);
            this.checkGLErrors();
            GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
            GL43C.glBindRenderbuffer(36161, 0);
            return;
        }
        throw new RuntimeException("No supported " + (sRGB ? "sRGB" : "linear") + " formats");
    }

    private void destroySceneFbo() {
        if (this.fboSceneHandle != 0) {
            GL43C.glDeleteFramebuffers(this.fboSceneHandle);
            this.fboSceneHandle = 0;
        }
        if (this.rboSceneColorHandle != 0) {
            GL43C.glDeleteRenderbuffers(this.rboSceneColorHandle);
            this.rboSceneColorHandle = 0;
        }
        if (this.rboSceneDepthHandle != 0) {
            GL43C.glDeleteRenderbuffers(this.rboSceneDepthHandle);
            this.rboSceneDepthHandle = 0;
        }
    }

    private void initShadowMapFbo() {
        GL43C.glActiveTexture(33986);
        if (this.configShadowsEnabled) {
            this.fboShadowMap = GL43C.glGenFramebuffers();
            GL43C.glBindFramebuffer(36160, this.fboShadowMap);
            this.texShadowMap = GL43C.glGenTextures();
            GL43C.glBindTexture(3553, this.texShadowMap);
            this.shadowMapResolution = this.config.shadowResolution().getValue();
            int maxResolution = GL43C.glGetInteger(3379);
            if (maxResolution < this.shadowMapResolution) {
                log.info("Capping shadow resolution from {} to {}", (Object)this.shadowMapResolution, (Object)maxResolution);
                this.shadowMapResolution = maxResolution;
            }
            GL43C.glTexImage2D(3553, 0, 33190, this.shadowMapResolution, this.shadowMapResolution, 0, 6402, 5126, 0L);
            GL43C.glTexParameteri(3553, 10241, 9728);
            GL43C.glTexParameteri(3553, 10240, 9728);
            GL43C.glTexParameteri(3553, 10242, 33069);
            GL43C.glTexParameteri(3553, 10243, 33069);
            float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            GL43C.glTexParameterfv(3553, 4100, color);
            GL43C.glFramebufferTexture2D(36160, 36096, 3553, this.texShadowMap, 0);
            GL43C.glDrawBuffer(0);
            GL43C.glReadBuffer(0);
            GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
        } else {
            this.initDummyShadowMap();
        }
        GL43C.glActiveTexture(33984);
    }

    private void initDummyShadowMap() {
        this.texShadowMap = GL43C.glGenTextures();
        GL43C.glBindTexture(3553, this.texShadowMap);
        GL43C.glTexImage2D(3553, 0, 6402, 1, 1, 0, 6402, 5126, 0L);
        GL43C.glTexParameteri(3553, 10241, 9728);
        GL43C.glTexParameteri(3553, 10240, 9728);
        GL43C.glTexParameteri(3553, 10242, 33069);
        GL43C.glTexParameteri(3553, 10243, 33069);
        GL43C.glBindTexture(3553, 0);
    }

    private void destroyShadowMapFbo() {
        if (this.texShadowMap != 0) {
            GL43C.glDeleteTextures(this.texShadowMap);
        }
        this.texShadowMap = 0;
        if (this.fboShadowMap != 0) {
            GL43C.glDeleteFramebuffers(this.fboShadowMap);
        }
        this.fboShadowMap = 0;
    }

    private void initTileHeightMap(Scene scene) {
        int TILE_HEIGHT_BUFFER_SIZE = 270848;
        ShortBuffer tileBuffer = ByteBuffer.allocateDirect(270848).order(ByteOrder.nativeOrder()).asShortBuffer();
        int[][][] tileHeights = scene.getTileHeights();
        for (int z = 0; z < 4; ++z) {
            for (int y = 0; y < 184; ++y) {
                for (int x = 0; x < 184; ++x) {
                    int h = tileHeights[z][x][y];
                    assert ((h & 7) == 0);
                    tileBuffer.put((short)(h >>= 3));
                }
            }
        }
        tileBuffer.flip();
        GL43C.glActiveTexture(33987);
        this.texTileHeightMap = GL43C.glGenTextures();
        GL43C.glBindTexture(32879, this.texTileHeightMap);
        GL43C.glTexParameteri(32879, 10241, 9728);
        GL43C.glTexParameteri(32879, 10240, 9728);
        GL43C.glTexParameteri(32879, 10242, 33071);
        GL43C.glTexParameteri(32879, 10243, 33071);
        GL43C.glTexImage3D(32879, 0, 33331, 184, 184, 4, 0, 36244, 5122, tileBuffer);
        GL43C.glActiveTexture(33984);
    }

    private void destroyTileHeightMap() {
        if (this.texTileHeightMap != 0) {
            GL43C.glDeleteTextures(this.texTileHeightMap);
        }
        this.texTileHeightMap = 0;
    }

    @Override
    public void drawScene(double cameraX, double cameraY, double cameraZ, double cameraPitch, double cameraYaw, int plane) {
        if (this.sceneContext == null) {
            return;
        }
        this.frameTimer.begin(Timer.DRAW_FRAME);
        this.frameTimer.begin(Timer.DRAW_SCENE);
        Scene scene = this.client.getScene();
        scene.setDrawDistance(this.getDrawDistance());
        boolean updateUniforms = true;
        if (this.sceneContext.enableAreaHiding) {
            LocalPoint lp = this.client.getLocalPlayer().getLocalLocation();
            int[] worldPos = new int[]{this.sceneContext.scene.getBaseX() + lp.getSceneX(), this.sceneContext.scene.getBaseY() + lp.getSceneY(), this.client.getPlane()};
            Area newArea = null;
            for (Area area : this.sceneContext.possibleAreas) {
                if (!area.containsPoint(worldPos)) continue;
                newArea = area;
                break;
            }
            if (newArea != this.sceneContext.currentArea) {
                this.client.setGameState(GameState.LOADING);
                updateUniforms = false;
                this.redrawPreviousFrame = true;
            }
        }
        this.viewportOffsetX = this.client.getViewportXOffset();
        this.viewportOffsetY = this.client.getViewportYOffset();
        this.viewportWidth = this.client.getViewportWidth();
        this.viewportHeight = this.client.getViewportHeight();
        if (!this.enableFreezeFrame) {
            if (!this.redrawPreviousFrame) {
                this.renderBufferOffset = this.sceneContext.staticVertexCount;
                IntBuffer staticUnordered = this.sceneContext.staticUnorderedModelBuffer.getBuffer();
                this.modelPassthroughBuffer.ensureCapacity(staticUnordered.limit()).put(staticUnordered);
                staticUnordered.rewind();
                this.numPassthroughModels += staticUnordered.limit() / 8;
            }
            if (updateUniforms) {
                this.cameraPosition[0] = (float)cameraX;
                this.cameraPosition[1] = (float)cameraY;
                this.cameraPosition[2] = (float)cameraZ;
                this.cameraOrientation[0] = (float)cameraYaw;
                this.cameraOrientation[1] = (float)cameraPitch;
                if (this.sceneContext.scene == scene) {
                    this.cameraFocalPoint[0] = this.client.getOculusOrbFocalPointX();
                    this.cameraFocalPoint[1] = this.client.getOculusOrbFocalPointY();
                    Arrays.fill(this.cameraShift, 0);
                    try {
                        this.frameTimer.begin(Timer.UPDATE_ENVIRONMENT);
                        this.environmentManager.update(this.sceneContext);
                        this.frameTimer.end(Timer.UPDATE_ENVIRONMENT);
                        this.frameTimer.begin(Timer.UPDATE_LIGHTS);
                        this.lightManager.update(this.sceneContext);
                        this.frameTimer.end(Timer.UPDATE_LIGHTS);
                    }
                    catch (Exception ex) {
                        log.error("Error while updating environment or lights:", ex);
                        this.stopPlugin();
                        return;
                    }
                } else {
                    this.cameraShift[0] = this.cameraFocalPoint[0] - this.client.getOculusOrbFocalPointX();
                    this.cameraShift[1] = this.cameraFocalPoint[1] - this.client.getOculusOrbFocalPointY();
                    this.cameraPosition[0] = this.cameraPosition[0] + (float)this.cameraShift[0];
                    this.cameraPosition[2] = this.cameraPosition[2] + (float)this.cameraShift[1];
                }
                this.uniformBufferCamera.clear().putFloat(this.cameraOrientation[0]).putFloat(this.cameraOrientation[1]).putInt(this.client.getCenterX()).putInt(this.client.getCenterY()).putInt(this.client.getScale()).putFloat(this.cameraPosition[0]).putFloat(this.cameraPosition[1]).putFloat(this.cameraPosition[2]).flip();
                GL43C.glBindBuffer(35345, this.hUniformBufferCamera.glBufferId);
                GL43C.glBufferSubData(35345, 0L, this.uniformBufferCamera);
            }
        }
        if (this.sceneContext.scene == scene && updateUniforms) {
            this.uniformBufferLights.clear();
            assert (this.sceneContext.numVisibleLights <= this.configMaxDynamicLights);
            for (int i = 0; i < this.sceneContext.numVisibleLights; ++i) {
                Light light = this.sceneContext.lights.get(i);
                this.uniformBufferLights.putFloat(light.pos[0] + this.cameraShift[0]);
                this.uniformBufferLights.putFloat(light.pos[1]);
                this.uniformBufferLights.putFloat(light.pos[2] + this.cameraShift[1]);
                this.uniformBufferLights.putFloat(light.radius * light.radius);
                this.uniformBufferLights.putFloat(light.color[0] * light.strength);
                this.uniformBufferLights.putFloat(light.color[1] * light.strength);
                this.uniformBufferLights.putFloat(light.color[2] * light.strength);
                this.uniformBufferLights.putFloat(0.0f);
            }
            this.uniformBufferLights.flip();
            if (this.configMaxDynamicLights > 0) {
                GL43C.glBindBuffer(35345, this.hUniformBufferLights.glBufferId);
                GL43C.glBufferSubData(35345, 0L, this.uniformBufferLights);
                GL43C.glBindBuffer(35345, 0);
            }
        }
    }

    @Override
    public void postDrawScene() {
        int i;
        if (this.sceneContext == null) {
            return;
        }
        this.frameTimer.end(Timer.DRAW_SCENE);
        this.frameTimer.begin(Timer.UPLOAD_GEOMETRY);
        if (!this.redrawPreviousFrame) {
            this.sceneContext.stagingBufferVertices.flip();
            this.sceneContext.stagingBufferUvs.flip();
            this.sceneContext.stagingBufferNormals.flip();
            this.updateBuffer(this.hStagingBufferVertices, 34962, this.dynamicOffsetVertices * 4, this.sceneContext.stagingBufferVertices.getBuffer(), 35040, 4L);
            this.updateBuffer(this.hStagingBufferUvs, 34962, this.dynamicOffsetUvs * 4, this.sceneContext.stagingBufferUvs.getBuffer(), 35040, 4L);
            this.updateBuffer(this.hStagingBufferNormals, 34962, this.dynamicOffsetVertices * 4, this.sceneContext.stagingBufferNormals.getBuffer(), 35040, 4L);
            this.sceneContext.stagingBufferVertices.clear();
            this.sceneContext.stagingBufferUvs.clear();
            this.sceneContext.stagingBufferNormals.clear();
            this.modelPassthroughBuffer.flip();
            this.updateBuffer(this.hModelPassthroughBuffer, 34962, this.modelPassthroughBuffer.getBuffer(), 35040, 4L);
            this.modelPassthroughBuffer.clear();
            for (i = 0; i < this.modelSortingBuffers.length; ++i) {
                GpuIntBuffer buffer = this.modelSortingBuffers[i];
                buffer.flip();
                this.updateBuffer(this.hModelSortingBuffers[i], 34962, buffer.getBuffer(), 35040, 4L);
                buffer.clear();
            }
            this.updateBuffer(this.hRenderBufferVertices, 34962, (long)this.renderBufferOffset * 16L, 35040, 2L);
            this.updateBuffer(this.hRenderBufferUvs, 34962, (long)this.renderBufferOffset * 16L, 35040, 2L);
            this.updateBuffer(this.hRenderBufferNormals, 34962, (long)this.renderBufferOffset * 16L, 35040, 2L);
            this.updateSceneVao(this.hRenderBufferVertices, this.hRenderBufferUvs, this.hRenderBufferNormals);
        }
        this.frameTimer.end(Timer.UPLOAD_GEOMETRY);
        this.frameTimer.begin(Timer.COMPUTE);
        if (this.computeMode == ComputeMode.OPENCL) {
            this.openCLManager.compute(this.hUniformBufferCamera, this.numPassthroughModels, this.numModelsToSort, this.hModelPassthroughBuffer, this.hModelSortingBuffers, this.hStagingBufferVertices, this.hStagingBufferUvs, this.hStagingBufferNormals, this.hRenderBufferVertices, this.hRenderBufferUvs, this.hRenderBufferNormals);
        } else {
            GL43C.glBindBufferBase(37074, 1, this.hStagingBufferVertices.glBufferId);
            GL43C.glBindBufferBase(37074, 2, this.hStagingBufferUvs.glBufferId);
            GL43C.glBindBufferBase(37074, 3, this.hStagingBufferNormals.glBufferId);
            GL43C.glBindBufferBase(37074, 4, this.hRenderBufferVertices.glBufferId);
            GL43C.glBindBufferBase(37074, 5, this.hRenderBufferUvs.glBufferId);
            GL43C.glBindBufferBase(37074, 6, this.hRenderBufferNormals.glBufferId);
            GL43C.glUseProgram(this.glModelPassthroughComputeProgram);
            GL43C.glBindBufferBase(37074, 0, this.hModelPassthroughBuffer.glBufferId);
            GL43C.glDispatchCompute(this.numPassthroughModels, 1, 1);
            for (i = 0; i < this.numModelsToSort.length; ++i) {
                if (this.numModelsToSort[i] == 0) continue;
                GL43C.glUseProgram(this.glModelSortingComputePrograms[i]);
                GL43C.glBindBufferBase(37074, 0, this.hModelSortingBuffers[i].glBufferId);
                GL43C.glDispatchCompute(this.numModelsToSort[i], 1, 1);
            }
        }
        this.frameTimer.end(Timer.COMPUTE);
        this.checkGLErrors();
        if (!this.redrawPreviousFrame) {
            this.numPassthroughModels = 0;
            Arrays.fill(this.numModelsToSort, 0);
        }
    }

    @Override
    public void drawScenePaint(Scene scene, SceneTilePaint paint, int plane, int tileX, int tileY) {
        if (this.redrawPreviousFrame || paint.getBufferLen() <= 0) {
            return;
        }
        int vertexCount = paint.getBufferLen();
        ++this.numPassthroughModels;
        this.modelPassthroughBuffer.ensureCapacity(16).getBuffer().put(paint.getBufferOffset()).put(paint.getUvBufferOffset()).put(vertexCount / 3).put(this.renderBufferOffset).put(0).put(tileX * 128).put(0).put(tileY * 128);
        this.renderBufferOffset += vertexCount;
    }

    public void initShaderHotswapping() {
        SHADER_PATH.watch("\\.(glsl|cl)$", path -> {
            log.info("Recompiling shaders: {}", path);
            this.clientThread.invoke(() -> {
                try {
                    this.waitUntilIdle();
                    this.recompilePrograms();
                }
                catch (IOException | ShaderException ex) {
                    log.error("Error while recompiling shaders:", ex);
                    this.stopPlugin();
                }
            });
        });
    }

    @Override
    public void drawSceneTileModel(Scene scene, SceneTileModel model, int tileX, int tileY) {
        if (this.redrawPreviousFrame || model.getBufferLen() <= 0) {
            return;
        }
        int localX = tileX * 128;
        boolean localY = false;
        int localZ = tileY * 128;
        GpuIntBuffer b = this.modelPassthroughBuffer;
        b.ensureCapacity(16);
        IntBuffer buffer = b.getBuffer();
        int bufferLength = model.getBufferLen();
        boolean underwaterTerrain = (bufferLength & 1) == 1;
        bufferLength >>= 1;
        if (underwaterTerrain) {
            ++this.numPassthroughModels;
            buffer.put(model.getBufferOffset() + (bufferLength /= 2));
            buffer.put(model.getUvBufferOffset() + bufferLength);
            buffer.put(bufferLength / 3);
            buffer.put(this.renderBufferOffset);
            buffer.put(0);
            buffer.put(localX).put(0).put(localZ);
            this.renderBufferOffset += bufferLength;
        }
        ++this.numPassthroughModels;
        buffer.put(model.getBufferOffset());
        buffer.put(model.getUvBufferOffset());
        buffer.put(bufferLength / 3);
        buffer.put(this.renderBufferOffset);
        buffer.put(0);
        buffer.put(localX).put(0).put(localZ);
        this.renderBufferOffset += bufferLength;
    }

    private void prepareInterfaceTexture(int canvasWidth, int canvasHeight) {
        this.frameTimer.begin(Timer.UPLOAD_UI);
        if (canvasWidth != this.lastCanvasWidth || canvasHeight != this.lastCanvasHeight) {
            this.lastCanvasWidth = canvasWidth;
            this.lastCanvasHeight = canvasHeight;
            GL43C.glBindBuffer(35052, this.interfacePbo);
            GL43C.glBufferData(35052, (long)(canvasWidth * canvasHeight) * 4L, 35040);
            GL43C.glBindBuffer(35052, 0);
            GL43C.glBindTexture(3553, this.interfaceTexture);
            GL43C.glTexImage2D(3553, 0, 6408, canvasWidth, canvasHeight, 0, 32993, 5121, 0L);
            GL43C.glBindTexture(3553, 0);
        }
        BufferProvider bufferProvider = this.client.getBufferProvider();
        int[] pixels = bufferProvider.getPixels();
        int width = bufferProvider.getWidth();
        int height = bufferProvider.getHeight();
        GL43C.glBindBuffer(35052, this.interfacePbo);
        ByteBuffer mappedBuffer = GL43C.glMapBuffer(35052, 35001);
        if (mappedBuffer == null) {
            log.error("Unable to map interface PBO. Skipping UI...");
        } else {
            mappedBuffer.asIntBuffer().put(pixels, 0, width * height);
            GL43C.glUnmapBuffer(35052);
            GL43C.glBindTexture(3553, this.interfaceTexture);
            GL43C.glTexSubImage2D(3553, 0, 0, 0, width, height, 32993, 33639, 0L);
        }
        GL43C.glBindBuffer(35052, 0);
        GL43C.glBindTexture(3553, 0);
        this.frameTimer.end(Timer.UPLOAD_UI);
    }

    @Override
    public void draw(int overlayColor) {
        GameState gameState = this.client.getGameState();
        if (gameState == GameState.STARTING) {
            this.frameTimer.end(Timer.DRAW_FRAME);
            return;
        }
        if (this.lastFrameTimeMillis > 0L) {
            this.deltaTime = (float)((double)(System.currentTimeMillis() - this.lastFrameTimeMillis) / 1000.0);
            if (this.deltaTime > 300.0f) {
                log.debug("Restarting the plugin after probable OS suspend ({} second delta)", (Object)Float.valueOf(this.deltaTime));
                this.restartPlugin();
                return;
            }
            if (Math.abs(this.deltaTime) > 10.0f) {
                this.deltaTime = 0.016666668f;
            }
            this.elapsedTime += (double)this.deltaTime;
            this.deltaClientTime = (float)(this.elapsedClientTime - this.lastFrameClientTime);
        }
        this.lastFrameTimeMillis = System.currentTimeMillis();
        this.lastFrameClientTime = this.elapsedClientTime;
        int canvasWidth = this.client.getCanvasWidth();
        int canvasHeight = this.client.getCanvasHeight();
        try {
            this.prepareInterfaceTexture(canvasWidth, canvasHeight);
        }
        catch (Exception ex) {
            log.warn("prepareInterfaceTexture exception", ex);
            this.restartPlugin();
            return;
        }
        if (this.renderBufferOffset > 0) {
            this.hasLoggedIn = true;
        }
        TextureProvider textureProvider = this.client.getTextureProvider();
        if (this.hasLoggedIn && this.sceneContext != null && textureProvider != null && this.client.getGameState().getState() >= GameState.LOADING.getState()) {
            int stretchedCanvasHeight;
            int renderWidthOff = this.viewportOffsetX;
            int renderHeightOff = this.viewportOffsetY;
            int renderCanvasHeight = canvasHeight;
            int renderViewportHeight = this.viewportHeight;
            int renderViewportWidth = this.viewportWidth;
            if (this.client.isStretchedEnabled()) {
                Dimension dim = this.client.getStretchedDimensions();
                renderCanvasHeight = dim.height;
                double scaleFactorY = dim.getHeight() / (double)canvasHeight;
                double scaleFactorX = dim.getWidth() / (double)canvasWidth;
                boolean padding = true;
                renderViewportHeight = (int)Math.ceil(scaleFactorY * (double)renderViewportHeight) + 2;
                renderViewportWidth = (int)Math.ceil(scaleFactorX * (double)renderViewportWidth) + 2;
                renderHeightOff = (int)Math.floor(scaleFactorY * (double)renderHeightOff) - 1;
                renderWidthOff = (int)Math.floor(scaleFactorX * (double)renderWidthOff) - 1;
            }
            int[] dpiViewport = this.applyDpiScaling(renderWidthOff, renderCanvasHeight - renderViewportHeight - renderHeightOff, renderViewportWidth, renderViewportHeight);
            if (this.computeMode == ComputeMode.OPENCL) {
                this.openCLManager.finish();
            } else {
                GL43C.glMemoryBarrier(8192);
            }
            GL43C.glBindVertexArray(this.vaoSceneHandle);
            float[] lightViewMatrix = Mat4.rotateX(this.environmentManager.currentSunAngles[0]);
            Mat4.mul(lightViewMatrix, Mat4.rotateY((float)Math.PI - this.environmentManager.currentSunAngles[1]));
            float[] lightProjectionMatrix = Mat4.identity();
            if (this.configShadowsEnabled && this.fboShadowMap != 0 && this.environmentManager.currentDirectionalStrength > 0.0f) {
                this.frameTimer.begin(Timer.RENDER_SHADOWS);
                GL43C.glViewport(0, 0, this.shadowMapResolution, this.shadowMapResolution);
                GL43C.glBindFramebuffer(36160, this.fboShadowMap);
                GL43C.glClearDepthf(1.0f);
                GL43C.glClear(256);
                GL43C.glDepthFunc(515);
                GL43C.glUseProgram(this.glShadowProgram);
                int camX = this.cameraFocalPoint[0];
                int camY = this.cameraFocalPoint[1];
                int drawDistanceSceneUnits = Math.min(this.config.shadowDistance().getValue(), this.getDrawDistance()) * 128 / 2;
                int east = Math.min(camX + drawDistanceSceneUnits, 13312);
                int west = Math.max(camX - drawDistanceSceneUnits, 0);
                int north = Math.min(camY + drawDistanceSceneUnits, 13312);
                int south = Math.max(camY - drawDistanceSceneUnits, 0);
                int width = east - west;
                int height = north - south;
                int depthScale = 10000;
                int maxDrawDistance = 90;
                float maxScale = 0.7f;
                float minScale = 0.4f;
                float scaleMultiplier = 1.0f - (float)this.getDrawDistance() / 63.0f;
                float scale = HDUtils.lerp(0.7f, 0.4f, scaleMultiplier);
                Mat4.mul(lightProjectionMatrix, Mat4.scale(scale, scale, scale));
                Mat4.mul(lightProjectionMatrix, Mat4.orthographic(width, height, 10000.0f));
                Mat4.mul(lightProjectionMatrix, lightViewMatrix);
                Mat4.mul(lightProjectionMatrix, Mat4.translate(-((float)width / 2.0f + (float)west), 0.0f, -((float)height / 2.0f + (float)south)));
                GL43C.glUniformMatrix4fv(this.uniShadowLightProjectionMatrix, false, lightProjectionMatrix);
                if (this.configShadowMode == ShadowMode.DETAILED) {
                    GL43C.glUniform1f(this.uniShadowElapsedTime, (float)(this.elapsedTime % 65536.0));
                    GL43C.glUniform3fv(this.uniShadowCameraPos, this.cameraPosition);
                }
                GL43C.glEnable(2884);
                GL43C.glEnable(2929);
                GL43C.glDrawArrays(4, 0, this.renderBufferOffset);
                GL43C.glDisable(2884);
                GL43C.glDisable(2929);
                GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
                GL43C.glUseProgram(0);
                this.frameTimer.end(Timer.RENDER_SHADOWS);
            }
            GL43C.glUseProgram(this.glSceneProgram);
            AntiAliasingMode antiAliasingMode = this.config.antiAliasingMode();
            Dimension stretchedDimensions = this.client.getStretchedDimensions();
            int stretchedCanvasWidth = this.client.isStretchedEnabled() ? stretchedDimensions.width : canvasWidth;
            int n = stretchedCanvasHeight = this.client.isStretchedEnabled() ? stretchedDimensions.height : canvasHeight;
            if (this.lastAntiAliasingMode != antiAliasingMode || this.lastStretchedCanvasWidth != stretchedCanvasWidth || this.lastStretchedCanvasHeight != stretchedCanvasHeight) {
                this.lastAntiAliasingMode = antiAliasingMode;
                this.lastStretchedCanvasWidth = stretchedCanvasWidth;
                this.lastStretchedCanvasHeight = stretchedCanvasHeight;
                this.destroySceneFbo();
                try {
                    this.initSceneFbo(stretchedCanvasWidth, stretchedCanvasHeight, antiAliasingMode);
                }
                catch (Exception ex) {
                    log.error("Error while initializing scene FBO:", ex);
                    this.stopPlugin();
                    return;
                }
            }
            float[] fogColor = ColorUtils.linearToSrgb(this.environmentManager.currentFogColor);
            float fogDepth = 0.0f;
            switch (this.config.fogDepthMode()) {
                case USER_DEFINED: {
                    fogDepth = this.config.fogDepth();
                    break;
                }
                case DYNAMIC: {
                    fogDepth = this.environmentManager.currentFogDepth;
                }
            }
            GL43C.glUniform1i(this.uniUseFog, (fogDepth *= (float)Math.min(this.getDrawDistance(), 90) / 10.0f) > 0.0f ? 1 : 0);
            GL43C.glUniform1f(this.uniFogDepth, fogDepth);
            GL43C.glUniform3fv(this.uniFogColor, fogColor);
            GL43C.glUniform1f(this.uniDrawDistance, this.getDrawDistance());
            GL43C.glUniform1i(this.uniExpandedMapLoadingChunks, this.sceneContext.expandedMapLoadingChunks);
            GL43C.glUniform1f(this.uniColorBlindnessIntensity, (float)this.config.colorBlindnessIntensity() / 100.0f);
            float[] waterColorHsv = ColorUtils.srgbToHsv(this.environmentManager.currentWaterColor);
            float lightBrightnessMultiplier = 0.8f;
            float midBrightnessMultiplier = 0.45f;
            float darkBrightnessMultiplier = 0.05f;
            float[] waterColorLight = ColorUtils.linearToSrgb(ColorUtils.hsvToSrgb(new float[]{waterColorHsv[0], waterColorHsv[1], waterColorHsv[2] * lightBrightnessMultiplier}));
            float[] waterColorMid = ColorUtils.linearToSrgb(ColorUtils.hsvToSrgb(new float[]{waterColorHsv[0], waterColorHsv[1], waterColorHsv[2] * midBrightnessMultiplier}));
            float[] waterColorDark = ColorUtils.linearToSrgb(ColorUtils.hsvToSrgb(new float[]{waterColorHsv[0], waterColorHsv[1], waterColorHsv[2] * darkBrightnessMultiplier}));
            GL43C.glUniform3fv(this.uniWaterColorLight, waterColorLight);
            GL43C.glUniform3fv(this.uniWaterColorMid, waterColorMid);
            GL43C.glUniform3fv(this.uniWaterColorDark, waterColorDark);
            float brightness = (float)this.config.brightness() / 20.0f;
            GL43C.glUniform1f(this.uniAmbientStrength, this.environmentManager.currentAmbientStrength * brightness);
            GL43C.glUniform3fv(this.uniAmbientColor, this.environmentManager.currentAmbientColor);
            GL43C.glUniform1f(this.uniLightStrength, this.environmentManager.currentDirectionalStrength * brightness);
            GL43C.glUniform3fv(this.uniLightColor, this.environmentManager.currentDirectionalColor);
            GL43C.glUniform1f(this.uniUnderglowStrength, this.environmentManager.currentUnderglowStrength);
            GL43C.glUniform3fv(this.uniUnderglowColor, this.environmentManager.currentUnderglowColor);
            GL43C.glUniform1f(this.uniGroundFogStart, this.environmentManager.currentGroundFogStart);
            GL43C.glUniform1f(this.uniGroundFogEnd, this.environmentManager.currentGroundFogEnd);
            GL43C.glUniform1f(this.uniGroundFogOpacity, this.config.groundFog() ? this.environmentManager.currentGroundFogOpacity : 0.0f);
            GL43C.glUniform1i(this.uniPointLightsCount, this.sceneContext.numVisibleLights);
            GL43C.glUniform1f(this.uniLightningBrightness, this.environmentManager.getLightningBrightness());
            GL43C.glUniform1f(this.uniSaturation, (float)this.config.saturation() / 100.0f);
            GL43C.glUniform1f(this.uniContrast, (float)this.config.contrast() / 100.0f);
            GL43C.glUniform1i(this.uniUnderwaterEnvironment, this.environmentManager.isUnderwater() ? 1 : 0);
            GL43C.glUniform1i(this.uniUnderwaterCaustics, this.config.underwaterCaustics() ? 1 : 0);
            GL43C.glUniform3fv(this.uniUnderwaterCausticsColor, this.environmentManager.currentUnderwaterCausticsColor);
            GL43C.glUniform1f(this.uniUnderwaterCausticsStrength, this.environmentManager.currentUnderwaterCausticsStrength);
            GL43C.glUniform1f(this.uniElapsedTime, (float)(this.elapsedTime % 65536.0));
            GL43C.glUniform3fv(this.uniCameraPos, this.cameraPosition);
            GL43C.glUniform3f(this.uniLightDir, -lightViewMatrix[2], -lightViewMatrix[6], -lightViewMatrix[10]);
            float shadowPixelsPerTile = (float)this.shadowMapResolution / (float)this.config.shadowDistance().getValue();
            float maxBias = 26.0f * (float)Math.pow(0.925f, 0.4f * shadowPixelsPerTile - 10.0f) + 13.0f;
            GL43C.glUniform1f(this.uniShadowMaxBias, maxBias / 10000.0f);
            GL43C.glUniform1i(this.uniShadowsEnabled, this.configShadowsEnabled ? 1 : 0);
            if (this.configColorFilter != ColorFilter.NONE) {
                GL43C.glUniform1i(this.uniColorFilter, this.configColorFilter.ordinal());
                GL43C.glUniform1i(this.uniColorFilterPrevious, this.configColorFilterPrevious.ordinal());
                long timeSinceChange = System.currentTimeMillis() - this.colorFilterChangedAt;
                GL43C.glUniform1f(this.uniColorFilterFade, HDUtils.clamp((float)timeSinceChange / 3000.0f, 0.0f, 1.0f));
            }
            float[] projectionMatrix = Mat4.scale(this.client.getScale(), this.client.getScale(), 1.0f);
            if (this.orthographicProjection) {
                Mat4.mul(projectionMatrix, Mat4.scale(2.0E-4f, 2.0E-4f, -1.0f));
                Mat4.mul(projectionMatrix, Mat4.orthographic(this.viewportWidth, this.viewportHeight, 40000.0f));
            } else {
                Mat4.mul(projectionMatrix, Mat4.perspective(this.viewportWidth, this.viewportHeight, 50.0f));
            }
            Mat4.mul(projectionMatrix, Mat4.rotateX(this.cameraOrientation[1]));
            Mat4.mul(projectionMatrix, Mat4.rotateY(this.cameraOrientation[0]));
            Mat4.mul(projectionMatrix, Mat4.translate(-this.cameraPosition[0], -this.cameraPosition[1], -this.cameraPosition[2]));
            GL43C.glUniformMatrix4fv(this.uniProjectionMatrix, false, projectionMatrix);
            GL43C.glUniformMatrix4fv(this.uniLightProjectionMatrix, false, lightProjectionMatrix);
            GL43C.glUniformBlockBinding(this.glSceneProgram, this.uniBlockMaterials, 1);
            GL43C.glUniformBlockBinding(this.glSceneProgram, this.uniBlockWaterTypes, 2);
            GL43C.glUniformBlockBinding(this.glSceneProgram, this.uniBlockPointLights, 3);
            GL43C.glBindFramebuffer(36009, this.fboSceneHandle);
            this.glToggle(32925, this.numSamples > 1);
            GL43C.glViewport(dpiViewport[0], dpiViewport[1], dpiViewport[2], dpiViewport[3]);
            this.frameTimer.begin(Timer.CLEAR_SCENE);
            GL43C.glClearColor(fogColor[0], fogColor[1], fogColor[2], 1.0f);
            GL43C.glClearDepthf(0.0f);
            GL43C.glClear(16640);
            this.frameTimer.end(Timer.CLEAR_SCENE);
            this.frameTimer.begin(Timer.RENDER_SCENE);
            GL43C.glEnable(2884);
            GL43C.glCullFace(1029);
            GL43C.glEnable(3042);
            GL43C.glBlendFuncSeparate(770, 771, 1, 1);
            GL43C.glBindVertexArray(this.vaoSceneHandle);
            if (this.sceneContext.staticCustomTilesVertexCount > 0) {
                if (this.sceneContext.staticGapFillerTilesVertexCount > 0) {
                    GL43C.glDisable(2929);
                    GL43C.glDrawArrays(4, this.sceneContext.staticGapFillerTilesOffset, this.sceneContext.staticGapFillerTilesVertexCount);
                }
                GL43C.glEnable(2929);
                GL43C.glDepthFunc(516);
                GL43C.glDepthMask(true);
                GL43C.glDrawArrays(4, this.sceneContext.staticCustomTilesOffset, this.sceneContext.staticCustomTilesVertexCount);
                GL43C.glDepthMask(false);
                GL43C.glDrawArrays(4, this.sceneContext.staticVertexCount, this.renderBufferOffset - this.sceneContext.staticVertexCount);
            } else {
                GL43C.glDisable(2929);
                GL43C.glDrawArrays(4, 0, this.renderBufferOffset);
            }
            this.frameTimer.end(Timer.RENDER_SCENE);
            GL43C.glDisable(3042);
            GL43C.glDisable(2884);
            GL43C.glDisable(32925);
            GL43C.glDisable(2929);
            GL43C.glDepthMask(true);
            GL43C.glUseProgram(0);
            int[] dimensions = this.applyDpiScaling(stretchedCanvasWidth, stretchedCanvasHeight);
            GL43C.glBindFramebuffer(36008, this.fboSceneHandle);
            GL43C.glBindFramebuffer(36009, this.awtContext.getFramebuffer(false));
            GL43C.glBlitFramebuffer(0, 0, dimensions[0], dimensions[1], 0, 0, dimensions[0], dimensions[1], 16384, 9728);
            GL43C.glBindFramebuffer(36008, this.awtContext.getFramebuffer(false));
        } else {
            GL43C.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            GL43C.glClear(16384);
        }
        this.drawUi(overlayColor, canvasHeight, canvasWidth);
        try {
            this.frameTimer.begin(Timer.SWAP_BUFFERS);
            this.awtContext.swapBuffers();
            this.frameTimer.end(Timer.SWAP_BUFFERS);
            this.drawManager.processDrawComplete(this::screenshot);
        }
        catch (RuntimeException ex) {
            if (!this.canvas.isValid()) {
                return;
            }
            log.error("Unable to swap buffers:", ex);
        }
        GL43C.glBindFramebuffer(36160, this.awtContext.getFramebuffer(false));
        this.frameTimer.end(Timer.DRAW_FRAME);
        this.frameTimer.endFrameAndReset();
        this.frameModelInfoMap.clear();
        this.checkGLErrors();
        if (!this.pendingConfigChanges.isEmpty()) {
            SwingUtilities.invokeLater(this::processPendingConfigChanges);
        }
    }

    private void drawUi(int overlayColor, int canvasHeight, int canvasWidth) {
        this.frameTimer.begin(Timer.RENDER_UI);
        if (this.client.getGameState().getState() < GameState.LOADING.getState()) {
            overlayColor = 0;
        }
        GL43C.glEnable(3042);
        GL43C.glBlendFunc(1, 771);
        GL43C.glBindTexture(3553, this.interfaceTexture);
        GL43C.glUseProgram(this.glUiProgram);
        GL43C.glUniform2i(this.uniTexSourceDimensions, canvasWidth, canvasHeight);
        GL43C.glUniform1f(this.uniUiColorBlindnessIntensity, (float)this.config.colorBlindnessIntensity() / 100.0f);
        GL43C.glUniform4fv(this.uniUiAlphaOverlay, ColorUtils.srgba(overlayColor));
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            this.glDpiAwareViewport(0, 0, dim.width, dim.height);
            GL43C.glUniform2i(this.uniTexTargetDimensions, dim.width, dim.height);
        } else {
            this.glDpiAwareViewport(0, 0, canvasWidth, canvasHeight);
            GL43C.glUniform2i(this.uniTexTargetDimensions, canvasWidth, canvasHeight);
        }
        int function = this.config.uiScalingMode() == UIScalingMode.LINEAR ? 9729 : 9728;
        GL43C.glTexParameteri(3553, 10241, function);
        GL43C.glTexParameteri(3553, 10240, function);
        GL43C.glBindVertexArray(this.vaoUiHandle);
        GL43C.glDrawArrays(6, 0, 4);
        this.frameTimer.end(Timer.RENDER_UI);
        GL43C.glBindTexture(3553, 0);
        GL43C.glBindVertexArray(0);
        GL43C.glUseProgram(0);
        GL43C.glBlendFunc(770, 771);
        GL43C.glDisable(3042);
    }

    private Image screenshot() {
        int width = this.client.getCanvasWidth();
        int height = this.client.getCanvasHeight();
        if (this.client.isStretchedEnabled()) {
            Dimension dim = this.client.getStretchedDimensions();
            width = dim.width;
            height = dim.height;
        }
        GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
        AffineTransform t = graphicsConfiguration.getDefaultTransform();
        width = this.getScaledValue(t.getScaleX(), width);
        height = this.getScaledValue(t.getScaleY(), height);
        ByteBuffer buffer = BufferUtils.createByteBuffer(width * height * 4);
        GL43C.glReadBuffer(this.awtContext.getBufferMode());
        GL43C.glReadPixels(0, 0, width, height, 6408, 5121, buffer);
        BufferedImage image = new BufferedImage(width, height, 1);
        int[] pixels = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = buffer.get() & 0xFF;
                int g = buffer.get() & 0xFF;
                int b = buffer.get() & 0xFF;
                buffer.get();
                pixels[(height - y - 1) * width + x] = r << 16 | g << 8 | b;
            }
        }
        return image;
    }

    @Override
    public void animate(Texture texture, int diff) {
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.renderBufferOffset = 0;
            this.hasLoggedIn = false;
            this.environmentManager.reset();
        }
    }

    public void reuploadScene() {
        assert (this.client.isClientThread()) : "Loading a scene is unsafe while the client can modify it";
        if (this.client.getGameState().getState() < GameState.LOGGED_IN.getState()) {
            return;
        }
        Scene scene = this.client.getScene();
        this.loadScene(scene);
        if (this.skipScene == scene) {
            this.skipScene = null;
        }
        this.swapScene(scene);
    }

    @Override
    public void loadScene(Scene scene) {
        if (!this.isActive) {
            return;
        }
        if (this.skipScene != scene && HDUtils.sceneIntersects(scene, this.getExpandedMapLoadingChunks(), this.areaManager.getArea("THE_GAUNTLET"))) {
            this.reloadSceneNextGameTick();
            this.skipScene = scene;
            return;
        }
        if (this.useLowMemoryMode) {
            return;
        }
        this.loadSceneInternal(scene);
    }

    public boolean isLoadingScene() {
        return this.nextSceneContext != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadSceneInternal(Scene scene) {
        if (this.nextSceneContext != null) {
            this.nextSceneContext.destroy();
        }
        this.nextSceneContext = null;
        try {
            SceneContext context;
            boolean reuseBuffers = this.client.isClientThread();
            SceneContext sceneContext = context = new SceneContext(this.client, scene, this.getExpandedMapLoadingChunks(), reuseBuffers, this.sceneContext);
            synchronized (sceneContext) {
                this.nextSceneContext = context;
                this.proceduralGenerator.generateSceneData(context);
                this.environmentManager.loadSceneEnvironments(context);
                this.sceneUploader.upload(context);
            }
        }
        catch (OutOfMemoryError oom) {
            log.error("Ran out of memory while loading scene (32-bit: {}, low memory mode: {}, cache size: {})", HDUtils.is32Bit(), this.useLowMemoryMode, this.config.modelCacheSizeMiB(), oom);
            this.displayOutOfMemoryMessage();
            this.stopPlugin();
        }
        catch (Throwable ex) {
            log.error("Error while loading scene:", ex);
            this.stopPlugin();
        }
    }

    @Override
    public synchronized void swapScene(Scene scene) {
        if (this.skipScene == scene) {
            this.redrawPreviousFrame = true;
            return;
        }
        if (this.nextSceneContext == null) {
            this.loadSceneInternal(scene);
            if (this.nextSceneContext == null) {
                return;
            }
        }
        if (this.computeMode == ComputeMode.OPENCL) {
            this.openCLManager.uploadTileHeights(scene);
        } else {
            this.initTileHeightMap(scene);
        }
        this.lightManager.loadSceneLights(this.nextSceneContext, this.sceneContext);
        this.fishingSpotReplacer.despawnRuneLiteObjects();
        if (this.sceneContext != null) {
            this.sceneContext.destroy();
        }
        this.sceneContext = this.nextSceneContext;
        this.nextSceneContext = null;
        assert (this.sceneContext != null);
        this.sceneUploader.prepareBeforeSwap(this.sceneContext);
        this.sceneContext.staticUnorderedModelBuffer.flip();
        this.dynamicOffsetVertices = this.sceneContext.getVertexOffset();
        this.dynamicOffsetUvs = this.sceneContext.getUvOffset();
        this.sceneContext.stagingBufferVertices.flip();
        this.sceneContext.stagingBufferUvs.flip();
        this.sceneContext.stagingBufferNormals.flip();
        this.updateBuffer(this.hStagingBufferVertices, 34962, this.sceneContext.stagingBufferVertices.getBuffer(), 35040, 4L);
        this.updateBuffer(this.hStagingBufferUvs, 34962, this.sceneContext.stagingBufferUvs.getBuffer(), 35040, 4L);
        this.updateBuffer(this.hStagingBufferNormals, 34962, this.sceneContext.stagingBufferNormals.getBuffer(), 35040, 4L);
        this.sceneContext.stagingBufferVertices.clear();
        this.sceneContext.stagingBufferUvs.clear();
        this.sceneContext.stagingBufferNormals.clear();
        if (this.sceneContext.intersects(this.areaManager.getArea("PLAYER_OWNED_HOUSE"))) {
            if (!this.isInHouse) {
                this.reloadSceneIn(7);
                this.isInHouse = true;
            }
            this.isInChambersOfXeric = false;
        } else {
            if (this.isInHouse) {
                this.abortSceneReload();
                this.isInHouse = false;
            }
            this.isInChambersOfXeric = this.sceneContext.intersects(this.areaManager.getArea("CHAMBERS_OF_XERIC"));
        }
    }

    public void reloadSceneNextGameTick() {
        this.reloadSceneIn(1);
    }

    public void reloadSceneIn(int gameTicks) {
        assert (gameTicks > 0) : "A value <= 0 will not reload the scene";
        if (gameTicks > this.gameTicksUntilSceneReload) {
            this.gameTicksUntilSceneReload = gameTicks;
        }
    }

    public void abortSceneReload() {
        this.gameTicksUntilSceneReload = 0;
    }

    private void updateCachedConfigs() {
        this.configShadowMode = this.config.shadowMode();
        this.configShadowsEnabled = this.configShadowMode != ShadowMode.OFF;
        this.configGroundTextures = this.config.groundTextures();
        this.configGroundBlending = this.config.groundBlending();
        this.configModelTextures = this.config.modelTextures();
        this.configTzhaarHD = this.config.hdTzHaarReskin();
        this.configProjectileLights = this.config.projectileLights();
        this.configNpcLights = this.config.npcLights();
        this.configVanillaShadowMode = this.config.vanillaShadowMode();
        this.configHideFakeShadows = this.configVanillaShadowMode != VanillaShadowMode.SHOW;
        this.configLegacyGreyColors = this.config.legacyGreyColors();
        this.configModelBatching = this.config.modelBatching();
        this.configModelCaching = this.config.modelCaching();
        this.configMaxDynamicLights = this.config.maxDynamicLights().getValue();
        this.configExpandShadowDraw = this.config.expandShadowDraw();
        this.configUseFasterModelHashing = this.config.fasterModelHashing();
        this.configUndoVanillaShading = this.config.shadingMode() != ShadingMode.VANILLA;
        this.configPreserveVanillaNormals = this.config.preserveVanillaNormals();
        this.configSeasonalTheme = this.config.seasonalTheme();
        this.configSeasonalHemisphere = this.config.seasonalHemisphere();
        ColorFilter newColorFilter = this.config.colorFilter();
        if (newColorFilter != this.configColorFilter) {
            this.configColorFilterPrevious = this.configColorFilter;
            this.configColorFilter = newColorFilter;
            this.colorFilterChangedAt = System.currentTimeMillis();
        }
        if (this.configColorFilter == ColorFilter.CEL_SHADING) {
            this.configGroundTextures = false;
            this.configModelTextures = false;
        }
        if (this.configSeasonalTheme == SeasonalTheme.AUTOMATIC) {
            ZonedDateTime time = ZonedDateTime.now(ZoneOffset.UTC);
            if (this.configSeasonalHemisphere == SeasonalHemisphere.NORTHERN) {
                switch (time.getMonth()) {
                    case SEPTEMBER: 
                    case OCTOBER: 
                    case NOVEMBER: {
                        this.configSeasonalTheme = SeasonalTheme.AUTUMN;
                        break;
                    }
                    case DECEMBER: 
                    case JANUARY: 
                    case FEBRUARY: {
                        this.configSeasonalTheme = SeasonalTheme.WINTER;
                        break;
                    }
                    default: {
                        this.configSeasonalTheme = SeasonalTheme.SUMMER;
                        break;
                    }
                }
            } else {
                switch (time.getMonth()) {
                    case MARCH: 
                    case APRIL: 
                    case MAY: {
                        this.configSeasonalTheme = SeasonalTheme.AUTUMN;
                        break;
                    }
                    case JUNE: 
                    case JULY: 
                    case AUGUST: {
                        this.configSeasonalTheme = SeasonalTheme.WINTER;
                        break;
                    }
                    default: {
                        this.configSeasonalTheme = SeasonalTheme.SUMMER;
                    }
                }
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!(this.isActive && event.getGroup().equals("hd") && this.pluginManager.isPluginEnabled(this))) {
            return;
        }
        this.pendingConfigChanges.add(event.getKey());
    }

    private void processPendingConfigChanges() {
        this.clientThread.invoke(() -> {
            if (this.pendingConfigChanges.isEmpty()) {
                return;
            }
            try {
                HdPlugin hdPlugin = this;
                synchronized (hdPlugin) {
                    this.updateCachedConfigs();
                    log.debug("Processing {} pending config changes: {}", (Object)this.pendingConfigChanges.size(), (Object)this.pendingConfigChanges);
                    boolean recompilePrograms = false;
                    boolean recreateShadowMapFbo = false;
                    boolean reloadTexturesAndMaterials = false;
                    boolean reloadEnvironments = false;
                    boolean reloadModelOverrides = false;
                    boolean reloadTileOverrides = false;
                    boolean reloadScene = false;
                    boolean clearModelCache = false;
                    boolean resizeModelCache = false;
                    Iterator<String> iterator = this.pendingConfigChanges.iterator();
                    block77: while (iterator.hasNext()) {
                        String key;
                        switch (key = iterator.next()) {
                            case "seasonalTheme": 
                            case "seasonalHemisphere": 
                            case "groundBlending": 
                            case "groundTextures": {
                                reloadTileOverrides = true;
                                break;
                            }
                            case "colorFilter": {
                                if (this.configColorFilter != ColorFilter.CEL_SHADING && this.configColorFilterPrevious != ColorFilter.CEL_SHADING) break;
                                clearModelCache = true;
                                reloadScene = true;
                                break;
                            }
                        }
                        switch (key) {
                            case "expandedMapLoadingChunks": {
                                this.client.setExpandedMapLoading(this.getExpandedMapLoadingChunks());
                            }
                            case "hideUnrelatedAreas": {
                                if (this.client.getGameState() != GameState.LOGGED_IN) break;
                                this.client.setGameState(GameState.LOADING);
                                break;
                            }
                            case "colorBlindMode": 
                            case "macosIntelWorkaround": 
                            case "maxDynamicLights": 
                            case "normalMapping": 
                            case "parallaxOcclusionMappingToggle": 
                            case "uiScalingMode": 
                            case "vanillaColorBanding": 
                            case "colorFilter": 
                            case "wireframe": {
                                recompilePrograms = true;
                                break;
                            }
                            case "shadowMode": 
                            case "enableShadowTransparency": {
                                recompilePrograms = true;
                            }
                            case "shadowResolution": {
                                recreateShadowMapFbo = true;
                                break;
                            }
                            case "environmentalLighting": {
                                reloadEnvironments = true;
                                break;
                            }
                            case "seasonalTheme": 
                            case "seasonalHemisphere": {
                                reloadEnvironments = true;
                                reloadModelOverrides = true;
                            }
                            case "anisotropicFilteringLevel": 
                            case "groundTextures": 
                            case "objectTextures": 
                            case "textureResolution": 
                            case "hdInfernalTexture": {
                                reloadTexturesAndMaterials = true;
                            }
                            case "groundBlending": 
                            case "experimentalFillGapsInTerrain2": 
                            case "tzhaarHD": {
                                clearModelCache = true;
                                reloadScene = true;
                                break;
                            }
                            case "vanillaShadowMode": {
                                reloadModelOverrides = true;
                                reloadScene = true;
                                break;
                            }
                            case "reduceOverExposure": 
                            case "experimentalPreserveVanillaNormals": 
                            case "experimentalShadingMode": 
                            case "experimentalFlatShading": {
                                recompilePrograms = true;
                                clearModelCache = true;
                                reloadScene = true;
                                break;
                            }
                            case "fpsTarget": 
                            case "unlockFps": 
                            case "vsyncMode": {
                                this.setupSyncMode();
                                break;
                            }
                            case "modelCacheSizeMiBv2": 
                            case "useModelCaching": {
                                resizeModelCache = true;
                                break;
                            }
                            case "lowMemoryMode": 
                            case "removeVertexSnapping": {
                                this.restartPlugin();
                                return;
                            }
                            case "replaceFishingSpots": {
                                reloadModelOverrides = true;
                                this.fishingSpotReplacer.despawnRuneLiteObjects();
                                this.clientThread.invokeLater(this.fishingSpotReplacer::update);
                                continue block77;
                            }
                        }
                    }
                    if (reloadTexturesAndMaterials || recompilePrograms) {
                        this.waitUntilIdle();
                    }
                    if (reloadTexturesAndMaterials) {
                        this.textureManager.reloadTextures();
                        recompilePrograms = true;
                        clearModelCache = true;
                    } else if (reloadModelOverrides) {
                        this.modelOverrideManager.reload();
                        clearModelCache = true;
                    }
                    if (reloadTileOverrides) {
                        this.tileOverrideManager.reload(false);
                        reloadScene = true;
                    }
                    if (recompilePrograms) {
                        this.recompilePrograms();
                    }
                    if (resizeModelCache) {
                        this.modelPusher.shutDown();
                        this.modelPusher.startUp();
                    } else if (clearModelCache) {
                        this.modelPusher.clearModelCache();
                    }
                    if (reloadScene) {
                        this.reuploadScene();
                    }
                    if (recreateShadowMapFbo) {
                        this.destroyShadowMapFbo();
                        this.initShadowMapFbo();
                    }
                    if (!reloadEnvironments) return;
                    this.environmentManager.triggerTransition();
                    return;
                }
            }
            catch (Throwable ex) {
                log.error("Error while changing settings:", ex);
                this.stopPlugin();
                return;
            }
            finally {
                this.pendingConfigChanges.clear();
            }
        });
    }

    private void setupSyncMode() {
        int swapInterval;
        boolean unlockFps = this.config.unlockFps();
        this.client.setUnlockedFps(unlockFps);
        HdPluginConfig.SyncMode syncMode = unlockFps ? this.config.syncMode() : HdPluginConfig.SyncMode.OFF;
        switch (syncMode) {
            case ON: {
                swapInterval = 1;
                break;
            }
            case ADAPTIVE: {
                swapInterval = -1;
                break;
            }
            default: {
                swapInterval = 0;
            }
        }
        int actualSwapInterval = this.awtContext.setSwapInterval(swapInterval);
        if (actualSwapInterval != swapInterval) {
            log.info("unsupported swap interval {}, got {}", (Object)swapInterval, (Object)actualSwapInterval);
        }
        this.client.setUnlockedFpsTarget(actualSwapInterval == 0 ? this.config.fpsTarget() : 0);
        this.checkGLErrors();
    }

    @Override
    public boolean tileInFrustum(Scene scene, int pitchSin, int pitchCos, int yawSin, int yawCos, int cameraX, int cameraY, int cameraZ, int plane, int tileExX, int tileExY) {
        int depthLevel;
        if (this.sceneContext == null) {
            return false;
        }
        if (this.orthographicProjection) {
            return true;
        }
        int[][][] tileHeights = scene.getTileHeights();
        int x = (tileExX - 40 << 7) + 64;
        int z = (tileExY - 40 << 7) + 64;
        int y = Math.max(Math.max(tileHeights[plane][tileExX][tileExY], tileHeights[plane][tileExX][tileExY + 1]), Math.max(tileHeights[plane][tileExX + 1][tileExY], tileHeights[plane][tileExX + 1][tileExY + 1])) + 350;
        if (this.sceneContext.scene == scene && (depthLevel = this.sceneContext.underwaterDepthLevels[plane][tileExX][tileExY]) > 0) {
            y += ProceduralGenerator.DEPTH_LEVEL_SLOPE[depthLevel - 1] - 350;
        }
        x -= (int)this.cameraPosition[0];
        y -= (int)this.cameraPosition[1];
        z -= (int)this.cameraPosition[2];
        int radius = 96;
        int zoom = this.configShadowsEnabled && this.configExpandShadowDraw ? this.client.get3dZoom() / 2 : this.client.get3dZoom();
        int Rasterizer3D_clipMidX2 = this.client.getRasterizer3D_clipMidX2();
        int Rasterizer3D_clipNegativeMidX = this.client.getRasterizer3D_clipNegativeMidX();
        int Rasterizer3D_clipNegativeMidY = this.client.getRasterizer3D_clipNegativeMidY();
        int var11 = yawCos * z - yawSin * x >> 16;
        int var12 = pitchSin * y + pitchCos * var11 >> 16;
        int var13 = pitchCos * radius >> 16;
        int depth = var12 + var13;
        if ((float)depth > 50.0f) {
            int rx = z * yawSin + yawCos * x >> 16;
            int var16 = (rx - radius) * zoom;
            int var17 = (rx + radius) * zoom;
            if (var16 < Rasterizer3D_clipMidX2 * depth && var17 > Rasterizer3D_clipNegativeMidX * depth) {
                int ry = pitchCos * y - var11 * pitchSin >> 16;
                int ybottom = pitchSin * radius >> 16;
                int var20 = (ry + ybottom) * zoom;
                return var20 > Rasterizer3D_clipNegativeMidY * depth;
            }
        }
        return false;
    }

    private boolean isOutsideViewport(Model model, int pitchSin, int pitchCos, int yawSin, int yawCos, int x, int y, int z) {
        int yheight;
        int ybottom;
        int ry;
        int var20;
        int var17;
        int rx;
        int var16;
        if (this.sceneContext == null) {
            return true;
        }
        if (this.orthographicProjection) {
            return false;
        }
        int XYZMag = model.getXYZMag();
        int bottomY = model.getBottomY();
        int zoom = this.configShadowsEnabled && this.configExpandShadowDraw ? this.client.get3dZoom() / 2 : this.client.get3dZoom();
        int modelHeight = model.getModelHeight();
        int Rasterizer3D_clipMidX2 = this.client.getRasterizer3D_clipMidX2();
        int Rasterizer3D_clipNegativeMidX = this.client.getRasterizer3D_clipNegativeMidX();
        int Rasterizer3D_clipNegativeMidY = this.client.getRasterizer3D_clipNegativeMidY();
        int Rasterizer3D_clipMidY2 = this.client.getRasterizer3D_clipMidY2();
        int var11 = yawCos * z - yawSin * x >> 16;
        int var12 = pitchSin * y + pitchCos * var11 >> 16;
        int var13 = pitchCos * XYZMag >> 16;
        int depth = var12 + var13;
        if ((float)depth > 50.0f && (var16 = ((rx = z * yawSin + yawCos * x >> 16) - XYZMag) * zoom) / depth < Rasterizer3D_clipMidX2 && (var17 = (rx + XYZMag) * zoom) / depth > Rasterizer3D_clipNegativeMidX && (var20 = ((ry = pitchCos * y - var11 * pitchSin >> 16) + (ybottom = (pitchCos * bottomY >> 16) + (yheight = pitchSin * XYZMag >> 16))) * zoom) / depth > Rasterizer3D_clipNegativeMidY) {
            int ytop = (pitchCos * modelHeight >> 16) + yheight;
            int var22 = (ry - ytop) * zoom;
            return var22 / depth >= Rasterizer3D_clipMidY2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Projection projection, @Nullable Scene scene, Renderable renderable, int orientation, int x, int y, int z, long hash) {
        int faceCount;
        IntProjection p;
        Model offsetModel;
        Model model;
        boolean inArea;
        if (this.sceneContext == null) {
            return;
        }
        if (this.sceneContext.currentArea != null && renderable instanceof Actor && !(inArea = this.sceneContext.currentArea.containsPoint(this.sceneContext.scene.getBaseX() + (x >> 7), this.sceneContext.scene.getBaseY() + (z >> 7), this.client.getPlane()))) {
            return;
        }
        if (this.enableDetailedTimers) {
            this.frameTimer.begin(Timer.GET_MODEL);
        }
        try {
            if (renderable instanceof Model) {
                model = (Model)renderable;
                offsetModel = model.getUnskewedModel();
                if (offsetModel == null) {
                    offsetModel = model;
                }
            } else {
                offsetModel = model = renderable.getModel();
            }
            if (model == null || model.getFaceCount() == 0) {
                return;
            }
        }
        catch (Exception ex) {
            return;
        }
        finally {
            if (this.enableDetailedTimers) {
                this.frameTimer.end(Timer.GET_MODEL);
            }
        }
        if (model != renderable) {
            renderable.setModelHeight(model.getModelHeight());
        }
        model.calculateBoundsCylinder();
        if (projection instanceof IntProjection && this.isOutsideViewport(model, (p = (IntProjection)projection).getPitchSin(), p.getPitchCos(), p.getYawSin(), p.getYawCos(), x - p.getCameraX(), y - p.getCameraY(), z - p.getCameraZ())) {
            return;
        }
        this.client.checkClickbox(projection, model, orientation, x, y, z, hash);
        if (this.redrawPreviousFrame) {
            return;
        }
        if (this.enableDetailedTimers) {
            this.frameTimer.begin(Timer.DRAW_RENDERABLE);
        }
        HdPlugin.eightIntWrite[3] = this.renderBufferOffset;
        HdPlugin.eightIntWrite[4] = orientation;
        HdPlugin.eightIntWrite[5] = x;
        HdPlugin.eightIntWrite[6] = y;
        HdPlugin.eightIntWrite[7] = z;
        int plane = ModelHash.getPlane(hash);
        if (this.sceneContext.id == (offsetModel.getSceneId() & 0xFFFF)) {
            assert (model == renderable);
            faceCount = Math.min(12144, offsetModel.getFaceCount());
            int vertexOffset = offsetModel.getBufferOffset();
            int uvOffset = offsetModel.getUvBufferOffset();
            boolean hillskew = offsetModel != model;
            HdPlugin.eightIntWrite[0] = vertexOffset;
            HdPlugin.eightIntWrite[1] = uvOffset;
            HdPlugin.eightIntWrite[2] = faceCount;
            eightIntWrite[4] = eightIntWrite[4] | ((hillskew ? 1 : 0) << 26 | plane << 24);
        } else {
            if (this.enableDetailedTimers) {
                this.frameTimer.begin(Timer.MODEL_BATCHING);
            }
            ModelOffsets modelOffsets = null;
            long batchHash = 0L;
            if (this.configModelBatching || this.configModelCaching) {
                this.modelHasher.setModel(model);
                if (this.configModelBatching && offsetModel.getSceneId() != -1) {
                    batchHash = this.modelHasher.vertexHash;
                    modelOffsets = this.frameModelInfoMap.get(batchHash);
                }
            }
            if (this.enableDetailedTimers) {
                this.frameTimer.end(Timer.MODEL_BATCHING);
            }
            if (modelOffsets != null && modelOffsets.faceCount == model.getFaceCount()) {
                faceCount = modelOffsets.faceCount;
                HdPlugin.eightIntWrite[0] = modelOffsets.vertexOffset;
                HdPlugin.eightIntWrite[1] = modelOffsets.uvOffset;
                HdPlugin.eightIntWrite[2] = modelOffsets.faceCount;
            } else {
                if (this.enableDetailedTimers) {
                    this.frameTimer.begin(Timer.MODEL_PUSHING);
                }
                int uuid = ModelHash.generateUuid(this.client, hash, renderable);
                int[] worldPos = this.sceneContext.localToWorld(x, z, plane);
                ModelOverride modelOverride = this.modelOverrideManager.getOverride(uuid, worldPos);
                if (modelOverride.hide) {
                    return;
                }
                int vertexOffset = this.dynamicOffsetVertices + this.sceneContext.getVertexOffset();
                int uvOffset = this.dynamicOffsetUvs + this.sceneContext.getUvOffset();
                int preOrientation = 0;
                if (ModelHash.getType(hash) == 2) {
                    int tileExX = (x >> 7) + 40;
                    int tileExY = (z >> 7) + 40;
                    if (0 <= tileExX && tileExX < 184 && 0 <= tileExY && tileExY < 184) {
                        int config;
                        Tile tile = this.sceneContext.scene.getExtendedTiles()[plane][tileExX][tileExY];
                        if (tile != null && (config = this.sceneContext.getObjectConfig(tile, hash)) != -1) {
                            preOrientation = HDUtils.getBakedOrientation(config);
                        } else if (plane > 0 && (tile = this.sceneContext.scene.getExtendedTiles()[plane - 1][tileExX][tileExY]) != null && tile.getBridge() != null && (config = this.sceneContext.getObjectConfig(tile, hash)) != -1) {
                            preOrientation = HDUtils.getBakedOrientation(config);
                        }
                    }
                }
                this.modelPusher.pushModel(this.sceneContext, null, uuid, model, modelOverride, preOrientation, true);
                faceCount = this.sceneContext.modelPusherResults[0];
                if (this.sceneContext.modelPusherResults[1] == 0) {
                    uvOffset = -1;
                }
                if (this.enableDetailedTimers) {
                    this.frameTimer.end(Timer.MODEL_PUSHING);
                }
                HdPlugin.eightIntWrite[0] = vertexOffset;
                HdPlugin.eightIntWrite[1] = uvOffset;
                HdPlugin.eightIntWrite[2] = faceCount;
                if (this.configModelBatching) {
                    this.frameModelInfoMap.put(batchHash, new ModelOffsets(faceCount, vertexOffset, uvOffset));
                }
            }
        }
        if (this.enableDetailedTimers) {
            this.frameTimer.end(Timer.DRAW_RENDERABLE);
        }
        if (eightIntWrite[0] == -1) {
            return;
        }
        this.bufferForTriangles(faceCount).ensureCapacity(8).put(eightIntWrite);
        this.renderBufferOffset += faceCount * 3;
    }

    private GpuIntBuffer bufferForTriangles(int triangles) {
        for (int i = 0; i < this.numSortingBins; ++i) {
            if (this.modelSortingBinFaceCounts[i] < triangles) continue;
            int n = i;
            this.numModelsToSort[n] = this.numModelsToSort[n] + 1;
            return this.modelSortingBuffers[i];
        }
        throw new IllegalStateException("Ran into a model with more triangles than the plugin supports (" + triangles + " > 12144)");
    }

    private int getScaledValue(double scale, int value) {
        return (int)((double)value * scale + 0.5);
    }

    private int[] applyDpiScaling(int ... coordinates) {
        GraphicsConfiguration graphicsConfiguration = this.clientUI.getGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return coordinates;
        }
        AffineTransform t = graphicsConfiguration.getDefaultTransform();
        for (int i = 0; i < coordinates.length; ++i) {
            coordinates[i] = this.getScaledValue(i % 2 == 0 ? t.getScaleX() : t.getScaleY(), coordinates[i]);
        }
        return coordinates;
    }

    private void glDpiAwareViewport(int ... xywh) {
        this.applyDpiScaling(xywh);
        GL43C.glViewport(xywh[0], xywh[1], xywh[2], xywh[3]);
    }

    public int getDrawDistance() {
        return HDUtils.clamp(this.config.drawDistance(), 0, 184);
    }

    private int getExpandedMapLoadingChunks() {
        if (this.useLowMemoryMode) {
            return 0;
        }
        return this.config.expandedMapLoadingChunks();
    }

    private void logBufferResize(GLBuffer glBuffer, long newSize) {
        if (!log.isTraceEnabled()) {
            return;
        }
        log.trace("Buffer resize: {} {}", (Object)glBuffer, (Object)String.format("%.2f MB -> %.2f MB", (double)glBuffer.size / 1000000.0, (double)newSize / 1000000.0));
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull ByteBuffer data, int usage, long clFlags) {
        GL43C.glBindBuffer(target, glBuffer.glBufferId);
        long size = data.remaining();
        if (size > glBuffer.size) {
            size = HDUtils.ceilPow2(size);
            this.logBufferResize(glBuffer, size);
            glBuffer.size = size;
            GL43C.glBufferData(target, size, usage);
            if (this.computeMode == ComputeMode.OPENCL) {
                this.openCLManager.recreateCLBuffer(glBuffer, clFlags);
            }
        }
        GL43C.glBufferSubData(target, 0L, data);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull IntBuffer data, int usage, long clFlags) {
        this.updateBuffer(glBuffer, target, 0, data, usage, clFlags);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, int offset, @Nonnull IntBuffer data, int usage, long clFlags) {
        long size = 4L * (long)(offset + data.remaining());
        if (size > glBuffer.size) {
            size = HDUtils.ceilPow2(size);
            this.logBufferResize(glBuffer, size);
            if (offset > 0) {
                int oldBuffer = glBuffer.glBufferId;
                glBuffer.glBufferId = GL43C.glGenBuffers();
                GL43C.glBindBuffer(target, glBuffer.glBufferId);
                GL43C.glBufferData(target, size, usage);
                GL43C.glBindBuffer(36662, oldBuffer);
                GL43C.glCopyBufferSubData(36662, target, 0L, 0L, (long)offset * 4L);
                GL43C.glDeleteBuffers(oldBuffer);
            } else {
                GL43C.glBindBuffer(target, glBuffer.glBufferId);
                GL43C.glBufferData(target, size, usage);
            }
            glBuffer.size = size;
            if (this.computeMode == ComputeMode.OPENCL) {
                this.openCLManager.recreateCLBuffer(glBuffer, clFlags);
            }
        } else {
            GL43C.glBindBuffer(target, glBuffer.glBufferId);
        }
        GL43C.glBufferSubData(target, (long)offset * 4L, data);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, @Nonnull FloatBuffer data, int usage, long clFlags) {
        this.updateBuffer(glBuffer, target, 0, data, usage, clFlags);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, int offset, @Nonnull FloatBuffer data, int usage, long clFlags) {
        long size = 4L * (long)(offset + data.remaining());
        if (size > glBuffer.size) {
            size = HDUtils.ceilPow2(size);
            this.logBufferResize(glBuffer, size);
            if (offset > 0) {
                int oldBuffer = glBuffer.glBufferId;
                glBuffer.glBufferId = GL43C.glGenBuffers();
                GL43C.glBindBuffer(target, glBuffer.glBufferId);
                GL43C.glBufferData(target, size, usage);
                GL43C.glBindBuffer(36662, oldBuffer);
                GL43C.glCopyBufferSubData(36662, target, 0L, 0L, (long)offset * 4L);
                GL43C.glDeleteBuffers(oldBuffer);
            } else {
                GL43C.glBindBuffer(target, glBuffer.glBufferId);
                GL43C.glBufferData(target, size, usage);
            }
            glBuffer.size = size;
            if (this.computeMode == ComputeMode.OPENCL) {
                this.openCLManager.recreateCLBuffer(glBuffer, clFlags);
            }
        } else {
            GL43C.glBindBuffer(target, glBuffer.glBufferId);
        }
        GL43C.glBufferSubData(target, (long)offset * 4L, data);
    }

    private void updateBuffer(@Nonnull GLBuffer glBuffer, int target, long size, int usage, long clFlags) {
        if (size > glBuffer.size) {
            size = HDUtils.ceilPow2(size);
            this.logBufferResize(glBuffer, size);
            glBuffer.size = size;
            GL43C.glBindBuffer(target, glBuffer.glBufferId);
            GL43C.glBufferData(target, size, usage);
            if (this.computeMode == ComputeMode.OPENCL) {
                this.openCLManager.recreateCLBuffer(glBuffer, clFlags);
            }
        }
    }

    @Subscribe(priority=-1.0f)
    public void onBeforeRender(BeforeRender beforeRender) {
        if (this.client.getScene() == null) {
            return;
        }
        this.client.getScene().setMinLevel(this.isInChambersOfXeric ? this.client.getPlane() : this.client.getScene().getMinLevel());
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        this.elapsedClientTime += (double)0.02f;
        if (!this.enableFreezeFrame && this.skipScene != this.client.getScene()) {
            this.redrawPreviousFrame = false;
        }
    }

    @Subscribe
    public void onGameTick(GameTick gameTick) {
        int plane;
        if (!this.isActive) {
            return;
        }
        if (this.gameTicksUntilSceneReload > 0) {
            if (this.gameTicksUntilSceneReload == 1) {
                this.reuploadScene();
            }
            --this.gameTicksUntilSceneReload;
        }
        this.fishingSpotReplacer.update();
        if (this.isInHouse && this.previousPlane != (plane = this.client.getPlane())) {
            this.reloadSceneNextGameTick();
            this.previousPlane = plane;
        }
    }

    private void waitUntilIdle() {
        if (this.computeMode == ComputeMode.OPENCL) {
            this.openCLManager.finish();
        }
        GL43C.glFinish();
    }

    private void glToggle(int target, boolean enable) {
        if (enable) {
            GL43C.glEnable(target);
        } else {
            GL43C.glDisable(target);
        }
    }

    public void clearGLErrors() {
        while (GL43C.glGetError() != 0) {
        }
    }

    public void checkGLErrors() {
        if (!log.isDebugEnabled()) {
            return;
        }
        int err;
        while ((err = GL43C.glGetError()) != 0) {
            String errStr;
            switch (err) {
                case 1280: {
                    errStr = "INVALID_ENUM";
                    break;
                }
                case 1281: {
                    errStr = "INVALID_VALUE";
                    break;
                }
                case 1282: {
                    errStr = "INVALID_OPERATION";
                    break;
                }
                case 1286: {
                    errStr = "INVALID_FRAMEBUFFER_OPERATION";
                    break;
                }
                default: {
                    errStr = String.valueOf(err);
                }
            }
            log.debug("glGetError:", new Exception(errStr));
        }
        return;
    }

    private void displayUpdateMessage() {
        int messageId = 1;
        if (this.config.getPluginUpdateMessage() >= messageId) {
            return;
        }
    }

    private void displayUnsupportedGpuMessage(boolean isGenericGpu, String glRenderer) {
        String hint32Bit = "";
        if (HDUtils.is32Bit()) {
            hint32Bit = "&nbsp;\u2022 Install the 64-bit version of RuneLite from <a href=\"https://runelite.net\">the official website</a>. You are currently using 32-bit.<br>";
        }
        String driverLinks = "<br>Links to drivers for each graphics card vendor:<br>&nbsp;\u2022 <a href=\"https://www.amd.com/en/support\">AMD drivers</a><br>&nbsp;\u2022 <a href=\"https://www.intel.com/content/www/us/en/support/detect.html\">Intel drivers</a><br>&nbsp;\u2022 <a href=\"https://www.nvidia.com/en-us/geforce/drivers/\">Nvidia drivers</a><br>";
        String errorMessage = (String)(isGenericGpu ? "Your graphics driver appears to be broken.<br><br>Some things to try:<br>&nbsp;\u2022 Reinstall the drivers for <b>both</b> your processor's integrated graphics <b>and</b> your graphics card.<br>" : "Your GPU is currently not supported by 117 HD.<br><br>GPU name: " + glRenderer + "<br><br>Your computer might not be letting RuneLite access your most powerful GPU.<br>To find out if your system is supported, try the following steps:<br>&nbsp;\u2022 Reinstall the drivers for your graphics card. You can find a link below.<br>") + hint32Bit + "&nbsp;\u2022 Tell your machine to use your high performance GPU for RuneLite.<br>&nbsp;\u2022 If you are on a desktop PC, make sure your monitor is plugged into your graphics card instead of<br>&nbsp;&nbsp;&nbsp;&nbsp;your motherboard. The graphics card's display outputs are usually lower down behind the computer.<br>" + driverLinks + "<br>If the issue persists even after <b>all of the above</b>, please join our <a href=\"https://discord.gg/GfEm5vU2cF\">Discord server</a>, and click the <br>\"Open logs folder\" button below, find the file named \"client\" or \"client.log\", then drag and drop<br>that file into one of our support channels.";
        PopupUtils.displayPopupMessage(this.client, "117 HD Error", errorMessage, new String[]{"Open logs folder", "Ok, let me try that..."}, i -> {
            if (i == 0) {
                LinkBrowser.open(RuneLite.LOGS_DIR.toString());
                return false;
            }
            return true;
        });
    }

    private void displayOutOfMemoryMessage() {
        String errorMessage;
        if (HDUtils.is32Bit()) {
            String lowMemoryModeHint = this.useLowMemoryMode ? "" : "If you are unable to install 64-bit RuneLite, you can instead turn on <b>Low Memory Mode</b> in the<br>Miscellaneous section of 117 HD settings.<br>";
            errorMessage = "The plugin ran out of memory because you are using the 32-bit version of RuneLite.<br>We would recommend installing the 64-bit version from <a href=\"https://runelite.net\">RuneLite's website</a> if possible.<br><br>" + lowMemoryModeHint + "<br>If you need further assistance, please join our <a href=\"https://discord.gg/GfEm5vU2cF\">Discord</a> server, and click the \"Open logs folder\"<br>button below, find the file named \"client\" or \"client.log\", then drag and drop that file into one of<br>our support channels.";
        } else {
            errorMessage = "The plugin ran out of memory. Try " + (String)(this.useLowMemoryMode ? "" : "reducing your model cache size from " + this.config.modelCacheSizeMiB() + " or ") + "closing other programs.<br><br>If the issue persists, please join our <a href=\"https://discord.gg/GfEm5vU2cF\">Discord</a> server, and click the \"Open logs folder\" button<br>below, find the file named \"client\" or \"client.log\", then drag and drop that file into one of our<br>support channels.";
        }
        PopupUtils.displayPopupMessage(this.client, "117 HD Error", errorMessage, new String[]{"Open logs folder", "Ok, let me try that..."}, i -> {
            if (i == 0) {
                LinkBrowser.open(RuneLite.LOGS_DIR.toString());
                return false;
            }
            return true;
        });
    }

    public Gson getGson() {
        return this.gson;
    }

    @Nullable
    public SceneContext getSceneContext() {
        return this.sceneContext;
    }

    public boolean isActive() {
        return this.isActive;
    }
}

