/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.lootingbagdebug;

import com.google.inject.Provides;
import java.util.Arrays;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.events.ScriptPreFired;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetUtil;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.lootingbagdebug.LootingBagDebugConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Looting Bag Debug", description="Debug plugin for looting bag bank deposit (localhost only)", tags={"debug", "looting", "bag", "bank"}, developerPlugin=true)
public class LootingBagDebugPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LootingBagDebugPlugin.class);
    private static final int BANK_INTERFACE = 12;
    private static final int BANK_INVENTORY_INTERFACE = 15;
    private static final int LOOTING_BAG_INTERFACE = 81;
    private static final Set<Integer> LOOTING_BAG_SCRIPTS = Set.of(Integer.valueOf(487), Integer.valueOf(492), Integer.valueOf(493), Integer.valueOf(2276), Integer.valueOf(3743), Integer.valueOf(3744), Integer.valueOf(10001), Integer.valueOf(10576));
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private LootingBagDebugConfig config;
    private boolean isLocalhost = false;

    @Provides
    LootingBagDebugConfig provideConfig(ConfigManager configManager) {
        return configManager.getConfig(LootingBagDebugConfig.class);
    }

    @Override
    protected void startUp() {
        log.info("[LootingBagDebug] Plugin started - checking for localhost connection");
        this.checkLocalhost();
    }

    @Override
    protected void shutDown() {
        log.info("[LootingBagDebug] Plugin stopped");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGED_IN || event.getGameState() == GameState.LOADING) {
            this.checkLocalhost();
        }
    }

    private void checkLocalhost() {
        this.clientThread.invokeLater(() -> {
            if (this.client.getGameState() != GameState.LOGGED_IN) {
                return false;
            }
            World[] worlds = this.client.getWorldList();
            if (worlds == null || worlds.length == 0) {
                return false;
            }
            int currentWorldId = this.client.getWorld();
            for (World world : worlds) {
                if (world == null || world.getId() != currentWorldId) continue;
                String address = world.getAddress();
                boolean bl = this.isLocalhost = address != null && (address.contains("localhost") || address.contains("127.0.0.1") || address.contains("0.0.0.0") || address.startsWith("192.168.") || address.startsWith("10.") || address.contains("local"));
                if (this.isLocalhost) {
                    log.info("[LootingBagDebug] Connected to LOCAL server: {} - Debug logging ENABLED", (Object)address);
                } else {
                    log.info("[LootingBagDebug] Connected to: {} - Debug logging DISABLED (not localhost)", (Object)address);
                }
                return true;
            }
            this.isLocalhost = true;
            log.info("[LootingBagDebug] Could not determine server address - assuming localhost for dev");
            return true;
        });
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        boolean isBankClick;
        if (!this.isLocalhost) {
            return;
        }
        Widget widget = event.getWidget();
        int interfaceId = widget != null ? WidgetUtil.componentToInterface(widget.getId()) : -1;
        boolean bl = isBankClick = interfaceId == 12 || interfaceId == 15 || interfaceId == 81;
        if (this.config.logAllClicks() || this.config.logBankClicks() && isBankClick) {
            log.info("=== MENU CLICK ===");
            log.info("[MenuClick] Option: '{}', Target: '{}'", (Object)event.getMenuOption(), (Object)event.getMenuTarget());
            log.info("[MenuClick] Action: {}, ItemId: {}, Id: {}", new Object[]{event.getMenuAction(), event.getItemId(), event.getId()});
            log.info("[MenuClick] Param0 (slot): {}, Param1 (interfaceHash): {}", (Object)event.getParam0(), (Object)event.getParam1());
            if (widget != null && this.config.logWidgetDetails()) {
                this.logWidgetDetails(widget);
            }
            log.info("==================");
        }
    }

    private void logWidgetDetails(Widget widget) {
        int fullId = widget.getId();
        int interfaceId = WidgetUtil.componentToInterface(fullId);
        int componentId = WidgetUtil.componentToId(fullId);
        log.info("[Widget] Full ID: {} (Interface: {}, Component: {})", fullId, interfaceId, componentId);
        log.info("[Widget] Index: {}, ItemId: {}, ItemQuantity: {}", widget.getIndex(), widget.getItemId(), widget.getItemQuantity());
        log.info("[Widget] HasListener: {}, Type: {}, ContentType: {}", widget.hasListener(), widget.getType(), widget.getContentType());
        log.info("[Widget] Actions: {}", (Object)Arrays.toString(widget.getActions()));
        Object[] onOpListener = widget.getOnOpListener();
        if (onOpListener != null && onOpListener.length > 0) {
            log.info("[Widget] OnOpListener: {} (first element: {})", (Object)onOpListener.length, onOpListener[0]);
        } else {
            log.info("[Widget] OnOpListener: null/empty");
        }
        Widget parent = widget.getParent();
        if (parent != null) {
            int parentId = parent.getId();
            log.info("[Widget] Parent: {} (Interface: {}, Component: {})", parentId, WidgetUtil.componentToInterface(parentId), WidgetUtil.componentToId(parentId));
        }
        if (widget.getIndex() != -1) {
            log.info("[Widget] This is a dynamic child at index {}", (Object)widget.getIndex());
        }
    }

    @Subscribe
    public void onScriptPreFired(ScriptPreFired event) {
        if (!this.isLocalhost || !this.config.logScripts()) {
            return;
        }
        int scriptId = event.getScriptId();
        if (LOOTING_BAG_SCRIPTS.contains(scriptId)) {
            log.info(">>> SCRIPT PRE-FIRED: {}", (Object)scriptId);
            if (event.getScriptEvent() != null) {
                Widget source = event.getScriptEvent().getSource();
                Object[] args = event.getScriptEvent().getArguments();
                if (source != null) {
                    int sourceId = source.getId();
                    log.info("[Script {}] Source Widget: {} (Interface: {}, Component: {})", scriptId, sourceId, WidgetUtil.componentToInterface(sourceId), WidgetUtil.componentToId(sourceId));
                }
                if (args != null && args.length > 0) {
                    log.info("[Script {}] Args: {}", (Object)scriptId, (Object)Arrays.toString(args));
                }
            }
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (!this.isLocalhost || !this.config.logScripts()) {
            return;
        }
        int scriptId = event.getScriptId();
        if (LOOTING_BAG_SCRIPTS.contains(scriptId)) {
            log.info("<<< SCRIPT POST-FIRED: {}", (Object)scriptId);
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded event) {
        if (!this.isLocalhost) {
            return;
        }
        int groupId = event.getGroupId();
        if (groupId == 15 || groupId == 81) {
            log.info("=== WIDGET LOADED: Interface {} ===", (Object)groupId);
            this.clientThread.invokeLater(() -> {
                int[] componentsToCheck;
                int[] nArray;
                if (groupId == 15) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = 3;
                    nArray2[1] = 6;
                    nArray = nArray2;
                    nArray2[2] = 10;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = 5;
                    nArray = nArray3;
                    nArray3[1] = 6;
                }
                for (int compId : componentsToCheck = nArray) {
                    Widget[] dynChildren;
                    Widget widget = this.client.getWidget(groupId, compId);
                    if (widget == null) continue;
                    log.info("[Interface {} Component {}]", (Object)groupId, (Object)compId);
                    log.info("  - Hidden: {}, HasListener: {}", (Object)widget.isHidden(), (Object)widget.hasListener());
                    log.info("  - Actions: {}", (Object)Arrays.toString(widget.getActions()));
                    Object[] onOpListener = widget.getOnOpListener();
                    if (onOpListener != null && onOpListener.length > 0) {
                        log.info("  - OnOpListener[0]: {}", onOpListener[0]);
                    }
                    if ((dynChildren = widget.getDynamicChildren()) == null || dynChildren.length <= 0) continue;
                    log.info("  - Dynamic Children: {}", (Object)dynChildren.length);
                    Widget firstChild = dynChildren[0];
                    if (firstChild == null) continue;
                    log.info("  - First Child: hasListener={}, actions={}", (Object)firstChild.hasListener(), (Object)Arrays.toString(firstChild.getActions()));
                    Object[] childOnOp = firstChild.getOnOpListener();
                    if (childOnOp == null || childOnOp.length <= 0) continue;
                    log.info("  - First Child OnOpListener[0]: {}", childOnOp[0]);
                }
                return true;
            });
        }
    }
}

