/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.plugins.constructionremove;

import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.VarbitChanged;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Construction Remove", description="Adds Remove option to built construction objects in build mode", tags={"construction", "poh", "house", "build", "remove"}, enabledByDefault=true)
public class ConstructionRemovePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ConstructionRemovePlugin.class);
    private static final int BUILD_MODE_VARPBIT = 2176;
    @Inject
    private Client client;
    private boolean inBuildMode = false;

    @Override
    protected void startUp() throws Exception {
        log.info("Construction Remove plugin started!");
    }

    @Override
    protected void shutDown() throws Exception {
        log.info("Construction Remove plugin stopped!");
        this.inBuildMode = false;
    }

    @Subscribe
    public void onVarbitChanged(VarbitChanged event) {
        int varbitId = event.getVarbitId();
        if (varbitId == 2176) {
            boolean newBuildMode;
            boolean bl = newBuildMode = event.getValue() == 1;
            if (this.inBuildMode != newBuildMode) {
                this.inBuildMode = newBuildMode;
                log.info("Build mode changed to: {}", (Object)this.inBuildMode);
            }
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        boolean isGameObjectAction;
        if (this.client.getVarbitValue(2176) != 1) {
            return;
        }
        MenuEntry entry = event.getMenuEntry();
        if (entry == null) {
            return;
        }
        MenuAction type = entry.getType();
        boolean bl = isGameObjectAction = type == MenuAction.GAME_OBJECT_FIRST_OPTION || type == MenuAction.GAME_OBJECT_SECOND_OPTION || type == MenuAction.GAME_OBJECT_THIRD_OPTION || type == MenuAction.GAME_OBJECT_FOURTH_OPTION || type == MenuAction.GAME_OBJECT_FIFTH_OPTION || type == MenuAction.EXAMINE_OBJECT;
        if (!isGameObjectAction) {
            return;
        }
        String target = entry.getTarget();
        if (target == null || target.isEmpty()) {
            return;
        }
        MenuEntry[] entries = this.client.getMenuEntries();
        if (entries != null) {
            for (MenuEntry e : entries) {
                if (e == null || !target.equals(e.getTarget())) continue;
                String option = e.getOption();
                if ("Remove".equals(option)) {
                    return;
                }
                if (!"Build".equals(option)) continue;
                return;
            }
        }
        this.client.createMenuEntry(-1).setOption("Remove").setTarget(target).setType(MenuAction.GAME_OBJECT_FIFTH_OPTION).setIdentifier(entry.getIdentifier()).setParam0(entry.getParam0()).setParam1(entry.getParam1());
        log.debug("Added Remove option for object: {} (id: {})", (Object)target, (Object)entry.getIdentifier());
    }
}

