/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.game;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.ItemComposition;
import net.runelite.http.api.item.ItemPrice;
import net.runelite.http.api.item.ItemStats;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemClient {
    private static final Logger log = LoggerFactory.getLogger(ItemClient.class);
    private final OkHttpClient client;
    private final HttpUrl apiBase;
    private final HttpUrl staticBase;
    private final Gson gson;
    private final Gson statsGson;
    private final Client rsClient;
    private static final TypeAdapter<Integer> LENIENT_INT_ADAPTER = new TypeAdapter<Integer>(){

        @Override
        public void write(JsonWriter out, Integer value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(value);
            }
        }

        @Override
        public Integer read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            double value = in.nextDouble();
            return (int)Math.round(value);
        }
    };

    @Inject
    private ItemClient(OkHttpClient client2, @Named(value="runelite.api.base") HttpUrl apiBase, @Named(value="runelite.static.base") HttpUrl staticBase, Gson gson, Client rsClient) {
        this.client = client2;
        this.apiBase = apiBase;
        this.staticBase = staticBase;
        this.gson = gson;
        this.rsClient = rsClient;
        this.statsGson = new GsonBuilder().registerTypeAdapter(Integer.TYPE, LENIENT_INT_ADAPTER).registerTypeAdapter((Type)((Object)Integer.class), LENIENT_INT_ADAPTER).create();
    }

    public ItemPrice[] getPrices() throws IOException {
        ItemPrice[] serverPrices = this.fetchPricesFromServer();
        if (serverPrices != null && serverPrices.length > 0) {
            return serverPrices;
        }
        log.info("Server prices unavailable, generating from local cache");
        return this.generatePricesFromCache();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemPrice[] fetchPricesFromServer() throws IOException {
        HttpUrl.Builder urlBuilder = this.apiBase.newBuilder().addPathSegment("item").addPathSegment("prices.js");
        HttpUrl url = urlBuilder.build();
        log.debug("Fetching prices from: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.warn("Error fetching prices from server: {}", (Object)response);
                ItemPrice[] itemPriceArray = null;
                return itemPriceArray;
            }
            InputStream in = response.body().byteStream();
            ItemPrice[] prices = this.gson.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), ItemPrice[].class);
            log.info("Loaded {} item prices from server", (Object)(prices != null ? prices.length : 0));
            ItemPrice[] itemPriceArray = prices;
            return itemPriceArray;
        }
        catch (JsonParseException ex) {
            log.warn("Failed to parse server prices", ex);
            return null;
        }
        catch (Exception ex) {
            log.debug("Could not connect to price server: {}", (Object)ex.getMessage());
            return null;
        }
    }

    private ItemPrice[] generatePricesFromCache() {
        if (this.rsClient.getGameState().getState() < GameState.LOGIN_SCREEN.getState()) {
            log.debug("Client not ready, deferring price load");
            return null;
        }
        int itemCount = this.rsClient.getItemCount();
        log.debug("Generating prices from cache for {} items", (Object)itemCount);
        ArrayList<ItemPrice> prices = new ArrayList<ItemPrice>();
        for (int itemId = 0; itemId < itemCount; ++itemId) {
            try {
                int price;
                ItemComposition comp = this.rsClient.getItemDefinition(itemId);
                if (comp == null || comp.getName() == null || comp.getName().equals("null") || comp.getNote() != -1 || comp.getPlaceholderTemplateId() != -1) continue;
                int haPrice = comp.getHaPrice();
                int n = price = haPrice > 0 ? haPrice : comp.getPrice();
                if (price <= 0) continue;
                ItemPrice itemPrice = new ItemPrice();
                itemPrice.setId(itemId);
                itemPrice.setName(comp.getName());
                itemPrice.setPrice(price);
                itemPrice.setWikiPrice(price);
                prices.add(itemPrice);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        log.info("Generated {} item prices from cache", (Object)prices.size());
        return prices.toArray(new ItemPrice[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<Integer, ItemStats> getStats() throws IOException {
        HttpUrl.Builder urlBuilder = this.staticBase.newBuilder().addPathSegment("item").addPathSegment("stats.ids.min.json");
        HttpUrl url = urlBuilder.build();
        log.debug("Built URI: {}", (Object)url);
        Request request = new Request.Builder().url(url).build();
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                log.warn("Error looking up item stats: {}", (Object)response);
                Map<Integer, ItemStats> map = null;
                return map;
            }
            InputStream in = response.body().byteStream();
            Type typeToken = new TypeToken<Map<Integer, ItemStats>>(){}.getType();
            Map map = (Map)this.statsGson.fromJson((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), typeToken);
            return map;
        }
        catch (JsonParseException ex) {
            throw new IOException(ex);
        }
    }
}

