/*
 * Decompiled with CFR 0.152.
 */
package net.runelite.client.config;

import java.util.function.Predicate;
import net.runelite.api.Client;
import net.runelite.api.WorldType;

public enum RuneScapeProfileType {
    STANDARD(client2 -> true),
    BETA(client2 -> client2.getWorldType().contains((Object)WorldType.NOSAVE_MODE) || client2.getWorldType().contains((Object)WorldType.BETA_WORLD)),
    QUEST_SPEEDRUNNING(client2 -> client2.getWorldType().contains((Object)WorldType.QUEST_SPEEDRUNNING)),
    DEADMAN(client2 -> client2.getWorldType().contains((Object)WorldType.DEADMAN)),
    PVP_ARENA(client2 -> client2.getWorldType().contains((Object)WorldType.PVP_ARENA)),
    TRAILBLAZER_LEAGUE,
    DEADMAN_REBORN,
    SHATTERED_RELICS_LEAGUE,
    TRAILBLAZER_RELOADED_LEAGUE(client2 -> client2.getWorldType().contains((Object)WorldType.SEASONAL));

    private final Predicate<Client> test;

    private RuneScapeProfileType() {
        this(client2 -> false);
    }

    public static RuneScapeProfileType getCurrent(Client client2) {
        RuneScapeProfileType[] types = RuneScapeProfileType.values();
        for (int i = types.length - 1; i >= 0; --i) {
            RuneScapeProfileType type = types[i];
            if (!types[i].test.test(client2)) continue;
            return type;
        }
        return STANDARD;
    }

    public Predicate<Client> getTest() {
        return this.test;
    }

    private RuneScapeProfileType(Predicate<Client> test) {
        this.test = test;
    }
}

