/*
 * Decompiled with CFR 0.152.
 */
package org.exaltedrs.launcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import javax.net.ssl.HttpsURLConnection;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ExaltedLauncher {
    private static final String VERSION_URL = "https://exaltedrs.org/version.json";
    private static final String LAUNCHER_VERSION = "1.0.0";
    private static final Path CLIENT_DIR = Paths.get(System.getProperty("user.home"), ".exalted");
    private static final Path CLIENT_JAR = CLIENT_DIR.resolve("exalted-client.jar");
    private static final Path VERSION_FILE = CLIENT_DIR.resolve("client-version.txt");
    private JFrame frame;
    private JProgressBar progressBar;
    private JLabel statusLabel;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new ExaltedLauncher().start());
    }

    private void start() {
        this.createUI();
        new Thread(() -> {
            try {
                this.checkAndUpdate();
                this.launchClient();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.showError("Update Failed", e.getMessage());
            }
        }).start();
    }

    private void createUI() {
        this.frame = new JFrame("Exalted Launcher");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setSize(400, 150);
        this.frame.setLocationRelativeTo(null);
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.statusLabel = new JLabel("Checking for updates...", 0);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setStringPainted(true);
        panel.add((Component)this.statusLabel, "North");
        panel.add((Component)this.progressBar, "Center");
        this.frame.add(panel);
        this.frame.setVisible(true);
    }

    private void checkAndUpdate() throws Exception {
        Files.createDirectories(CLIENT_DIR, new FileAttribute[0]);
        String currentVersion = this.getCurrentVersion();
        VersionInfo remoteVersion = this.fetchVersionInfo();
        this.updateStatus("Current version: " + currentVersion);
        if (this.needsUpdate(currentVersion, remoteVersion)) {
            this.updateStatus("Downloading update v" + remoteVersion.version + "...");
            this.downloadClient(remoteVersion);
            this.saveVersion(remoteVersion.version);
            this.updateStatus("Update complete!");
        } else {
            this.updateStatus("Client is up to date!");
        }
        Thread.sleep(500L);
    }

    private String getCurrentVersion() {
        try {
            if (Files.exists(VERSION_FILE, new LinkOption[0])) {
                return Files.readString(VERSION_FILE).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "0.0.0";
    }

    private VersionInfo fetchVersionInfo() throws Exception {
        URL url = new URL(VERSION_URL);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setRequestProperty("User-Agent", "ExaltedLauncher/1.0.0");
        if (conn.getResponseCode() != 200) {
            throw new IOException("Server returned: " + conn.getResponseCode());
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
            String line;
            StringBuilder json = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
            VersionInfo versionInfo = this.parseVersionInfo(json.toString());
            return versionInfo;
        }
    }

    private VersionInfo parseVersionInfo(String json) {
        VersionInfo info = new VersionInfo();
        info.version = this.extractValue(json, "version");
        info.clientUrl = this.extractValue(json, "clientUrl");
        info.sha256 = this.extractValue(json, "sha256");
        info.updateMessage = this.extractValue(json, "updateMessage");
        return info;
    }

    private String extractValue(String json, String key) {
        String search = "\"" + key + "\": \"";
        int start = json.indexOf(search);
        if (start == -1) {
            search = "\"" + key + "\":\"";
            start = json.indexOf(search);
        }
        if (start == -1) {
            return "";
        }
        int end = json.indexOf("\"", start += search.length());
        if (end == -1) {
            return "";
        }
        return json.substring(start, end);
    }

    private boolean needsUpdate(String current, VersionInfo remote) {
        if (!Files.exists(CLIENT_JAR, new LinkOption[0])) {
            return true;
        }
        if (current.equals("0.0.0")) {
            return true;
        }
        String[] c = current.split("\\.");
        String[] r = remote.version.split("\\.");
        for (int i = 0; i < Math.min(c.length, r.length); ++i) {
            int cv = Integer.parseInt(c[i]);
            int rv = Integer.parseInt(r[i]);
            if (rv > cv) {
                return true;
            }
            if (rv >= cv) continue;
            return false;
        }
        return r.length > c.length;
    }

    private void downloadClient(VersionInfo info) throws Exception {
        URL url = new URL(info.clientUrl);
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
        conn.setRequestProperty("User-Agent", "ExaltedLauncher/1.0.0");
        long fileSize = conn.getContentLengthLong();
        Path tempFile = CLIENT_DIR.resolve("exalted-client.jar.tmp");
        try (InputStream in = conn.getInputStream();
             OutputStream out = Files.newOutputStream(tempFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            int read;
            byte[] buffer = new byte[8192];
            long downloaded = 0L;
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                int progress = (int)((downloaded += (long)read) * 100L / fileSize);
                this.updateProgress(progress);
            }
        }
        if (!info.sha256.isEmpty()) {
            this.updateStatus("Verifying download...");
            String downloadedHash = this.calculateSHA256(tempFile);
            if (!downloadedHash.equalsIgnoreCase(info.sha256)) {
                Files.deleteIfExists(tempFile);
                throw new SecurityException("Downloaded file failed integrity check!");
            }
        }
        Files.move(tempFile, CLIENT_JAR, StandardCopyOption.REPLACE_EXISTING);
    }

    private String calculateSHA256(Path file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            int read;
            byte[] buffer = new byte[8192];
            while ((read = fis.read(buffer)) != -1) {
                digest.update(buffer, 0, read);
            }
        }
        byte[] hash = digest.digest();
        StringBuilder hexString = new StringBuilder();
        for (byte b : hash) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    private void saveVersion(String version) throws IOException {
        Files.writeString(VERSION_FILE, (CharSequence)version, new OpenOption[0]);
    }

    private void launchClient() {
        try {
            this.updateStatus("Launching Exalted...");
            Thread.sleep(500L);
            ProcessBuilder pb = new ProcessBuilder("java", "-jar", CLIENT_JAR.toString());
            pb.start();
            System.exit(0);
        }
        catch (Exception e) {
            this.showError("Launch Failed", "Could not start the client: " + e.getMessage());
        }
    }

    private void updateStatus(String message) {
        SwingUtilities.invokeLater(() -> this.statusLabel.setText(message));
    }

    private void updateProgress(int percent) {
        SwingUtilities.invokeLater(() -> {
            this.progressBar.setValue(percent);
            this.progressBar.setString(percent + "%");
        });
    }

    private void showError(String title, String message) {
        SwingUtilities.invokeLater(() -> {
            JOptionPane.showMessageDialog(this.frame, message, title, 0);
            System.exit(1);
        });
    }

    private static class VersionInfo {
        String version;
        String clientUrl;
        String sha256;
        String updateMessage;

        private VersionInfo() {
        }
    }
}

